/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Util {
    public static final String SPACES = "                                                                     ";

    public static String toSemicolonList(byte[] bytes) {
        StringBuffer str = new StringBuffer("");
        int b = 0;
        while (b < bytes.length) {
            str.append(String.valueOf(Byte.toString(bytes[b])) + (b < bytes.length - 1 ? ";" : ""));
            ++b;
        }
        return str.toString();
    }

    public static String toSemicolonList(String[] bytes) {
        StringBuffer str = new StringBuffer("");
        int b = 0;
        while (b < bytes.length) {
            str.append(String.valueOf(bytes[b]) + (b < bytes.length - 1 ? ";" : ""));
            ++b;
        }
        return str.toString();
    }

    public static String toSemicolonList(Vector bytes) {
        StringBuffer str = new StringBuffer("");
        int b = 0;
        while (b < bytes.size()) {
            str.append(bytes.elementAt(b) + (b < bytes.size() - 1 ? ";" : ""));
            ++b;
        }
        return str.toString();
    }

    public static byte[] fromByteList(String str) {
        Vector V = Util.parseSemicolons(str, true);
        if (V.size() > 0) {
            byte[] bytes = new byte[V.size()];
            int b = 0;
            while (b < V.size()) {
                bytes[b] = Byte.parseByte((String)V.elementAt(b));
                ++b;
            }
            return bytes;
        }
        return new byte[0];
    }

    public static long absDiff(long x, long y) {
        long d = x - y;
        if (d < 0L) {
            return d * -1L;
        }
        return d;
    }

    public static String repeat(String str1, int times) {
        if (times <= 0) {
            return "";
        }
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < times) {
            str.append(str1);
            ++i;
        }
        return str.toString();
    }

    public static String endWithAPeriod(String str) {
        if (str.length() == 0) {
            return str;
        }
        int x = str.length() - 1;
        while (x >= 0 && (Character.isWhitespace(str.charAt(x)) || x > 0 && str.charAt(x) != '^' && str.charAt(x - 1) == '^' && --x >= 0)) {
            --x;
        }
        if (x < 0) {
            return str;
        }
        if (str.charAt(x) == '.' || str.charAt(x) == '!' || str.charAt(x) == '?') {
            return String.valueOf(str.trim()) + " ";
        }
        return String.valueOf(str.substring(0, x + 1)) + ". " + str.substring(x + 1).trim();
    }

    public static String startWithAorAn(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (!(str.toUpperCase().startsWith("A ") || str.toUpperCase().startsWith("AN ") || str.toUpperCase().startsWith("THE ") || str.toUpperCase().startsWith("SOME "))) {
            if ("aeiouAEIOU".indexOf(str.charAt(0)) >= 0) {
                return "an " + str;
            }
            return "a " + str;
        }
        return str;
    }

    public static int getParmInt(String text, String key, int defaultValue) {
        int x = text.toUpperCase().indexOf(key.toUpperCase());
        while (x >= 0) {
            if (x == 0 || !Character.isLetter(text.charAt(x - 1))) {
                while (x < text.length() && text.charAt(x) != '=' && !Character.isDigit(text.charAt(x))) {
                    if (text.charAt(x) == '+' || text.charAt(x) == '-') {
                        return defaultValue;
                    }
                    ++x;
                }
                if (x < text.length() && text.charAt(x) == '=') {
                    while (x < text.length() && !Character.isDigit(text.charAt(x))) {
                        ++x;
                    }
                    if (x < text.length()) {
                        text = text.substring(x);
                        x = 0;
                        while (x < text.length() && Character.isDigit(text.charAt(x))) {
                            ++x;
                        }
                        return Util.s_int(text.substring(0, x));
                    }
                }
                x = -1;
                continue;
            }
            x = text.toUpperCase().indexOf(key.toUpperCase(), x + 1);
        }
        return defaultValue;
    }

    public static boolean isVowel(char c) {
        return "aeiou".indexOf(Character.toLowerCase(c)) >= 0;
    }

    public static int getParmPlus(String text, String key) {
        int x = text.toUpperCase().indexOf(key.toUpperCase());
        while (x >= 0) {
            if (x == 0 || !Character.isLetter(text.charAt(x - 1))) {
                while (x < text.length() && text.charAt(x) != '+' && text.charAt(x) != '-') {
                    if (text.charAt(x) == '=') {
                        return 0;
                    }
                    ++x;
                }
                if (x < text.length()) {
                    char pm = text.charAt(x);
                    while (x < text.length() && !Character.isDigit(text.charAt(x))) {
                        ++x;
                    }
                    if (x < text.length()) {
                        text = text.substring(x);
                        x = 0;
                        while (x < text.length() && Character.isDigit(text.charAt(x))) {
                            ++x;
                        }
                        if (pm == '+') {
                            return Util.s_int(text.substring(0, x));
                        }
                        return -Util.s_int(text.substring(0, x));
                    }
                }
                x = -1;
                continue;
            }
            x = text.toUpperCase().indexOf(key.toUpperCase(), x + 1);
        }
        return 0;
    }

    public static double getParmDoublePlus(String text, String key) {
        int x = text.toUpperCase().indexOf(key.toUpperCase());
        while (x >= 0) {
            if (x == 0 || !Character.isLetter(text.charAt(x - 1))) {
                while (x < text.length() && text.charAt(x) != '+' && text.charAt(x) != '-') {
                    if (text.charAt(x) == '=') {
                        return 0.0;
                    }
                    ++x;
                }
                if (x < text.length()) {
                    char pm = text.charAt(x);
                    while (x < text.length() && !Character.isDigit(text.charAt(x)) && text.charAt(x) != '.') {
                        ++x;
                    }
                    if (x < text.length()) {
                        text = text.substring(x);
                        x = 0;
                        while (x < text.length() && (Character.isDigit(text.charAt(x)) || text.charAt(x) == '.')) {
                            ++x;
                        }
                        if (text.substring(0, x).indexOf(".") < 0) {
                            if (pm == '+') {
                                return new Integer(Util.s_int(text.substring(0, x))).doubleValue();
                            }
                            return new Integer(-Util.s_int(text.substring(0, x))).doubleValue();
                        }
                        if (pm == '+') {
                            return Util.s_double(text.substring(0, x));
                        }
                        return -Util.s_double(text.substring(0, x));
                    }
                }
                x = -1;
                continue;
            }
            x = text.toUpperCase().indexOf(key.toUpperCase(), x + 1);
        }
        return 0.0;
    }

    public static double getParmDouble(String text, String key, double defaultValue) {
        int x = text.toUpperCase().indexOf(key.toUpperCase());
        while (x >= 0) {
            if (x == 0 || !Character.isLetter(text.charAt(x - 1))) {
                while (x < text.length() && text.charAt(x) != '=') {
                    ++x;
                }
                if (x < text.length()) {
                    while (x < text.length() && !Character.isDigit(text.charAt(x)) && text.charAt(x) != '.') {
                        ++x;
                    }
                    if (x < text.length()) {
                        text = text.substring(x);
                        x = 0;
                        while (x < text.length() && (Character.isDigit(text.charAt(x)) || text.charAt(x) == '.')) {
                            ++x;
                        }
                        if (text.substring(0, x).indexOf(".") < 0) {
                            return new Long(Util.s_long(text.substring(0, x))).doubleValue();
                        }
                        return Util.s_double(text.substring(0, x));
                    }
                }
                x = -1;
                continue;
            }
            x = text.toUpperCase().indexOf(key.toUpperCase(), x + 1);
        }
        return defaultValue;
    }

    public static String getParmStr(String text, String key, String defaultVal) {
        int x = text.toUpperCase().indexOf(key.toUpperCase());
        while (x >= 0) {
            if (x == 0 || !Character.isLetter(text.charAt(x - 1))) {
                while (x < text.length() && text.charAt(x) != '=') {
                    if (text.charAt(x) == '+' || text.charAt(x) == '-') {
                        return defaultVal;
                    }
                    ++x;
                }
                if (x < text.length()) {
                    boolean endWithQuote = false;
                    while (x < text.length() && !Character.isLetterOrDigit(text.charAt(x))) {
                        if (text.charAt(x) == '\"') {
                            endWithQuote = true;
                            ++x;
                            break;
                        }
                        ++x;
                    }
                    if (x < text.length()) {
                        text = text.substring(x);
                        x = 0;
                        while (x < text.length() && (Character.isLetterOrDigit(text.charAt(x)) || endWithQuote && text.charAt(x) != '\"')) {
                            ++x;
                        }
                        return text.substring(0, x).trim();
                    }
                }
                x = -1;
                continue;
            }
            x = text.toUpperCase().indexOf(key.toUpperCase(), x + 1);
        }
        return defaultVal;
    }

    public static String[] toStringArray(Vector V) {
        if (V == null || V.size() == 0) {
            String[] s = new String[]{};
            return s;
        }
        String[] s = new String[V.size()];
        int v = 0;
        while (v < V.size()) {
            s[v] = V.elementAt(v).toString();
            ++v;
        }
        return s;
    }

    public static long[] toLongArray(Vector V) {
        if (V == null || V.size() == 0) {
            long[] s = new long[]{};
            return s;
        }
        long[] s = new long[V.size()];
        int v = 0;
        while (v < V.size()) {
            s[v] = Util.s_long(V.elementAt(v).toString());
            ++v;
        }
        return s;
    }

    public static int[] toIntArray(Vector V) {
        if (V == null || V.size() == 0) {
            int[] s = new int[]{};
            return s;
        }
        int[] s = new int[V.size()];
        int v = 0;
        while (v < V.size()) {
            s[v] = Util.s_int(V.elementAt(v).toString());
            ++v;
        }
        return s;
    }

    public static String[] toStringArray(HashSet V) {
        if (V == null || V.size() == 0) {
            String[] s = new String[]{};
            return s;
        }
        String[] s = new String[V.size()];
        int v = 0;
        Iterator i = V.iterator();
        while (i.hasNext()) {
            s[v++] = i.next().toString();
        }
        return s;
    }

    public static String toStringList(String[] V) {
        if (V == null || V.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        int v = 0;
        while (v < V.length) {
            s.append(", " + V[v]);
            ++v;
        }
        if (s.length() == 0) {
            return "";
        }
        return s.toString().substring(2);
    }

    public static String toStringList(long[] V) {
        if (V == null || V.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        int v = 0;
        while (v < V.length) {
            s.append(", " + V[v]);
            ++v;
        }
        if (s.length() == 0) {
            return "";
        }
        return s.toString().substring(2);
    }

    public static String toStringList(int[] V) {
        if (V == null || V.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        int v = 0;
        while (v < V.length) {
            s.append(", " + V[v]);
            ++v;
        }
        if (s.length() == 0) {
            return "";
        }
        return s.toString().substring(2);
    }

    public static String toStringList(Vector V) {
        if (V == null || V.size() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        int v = 0;
        while (v < V.size()) {
            s.append(", " + V.elementAt(v).toString());
            ++v;
        }
        if (s.length() == 0) {
            return "";
        }
        return s.toString().substring(2);
    }

    public static String toStringList(HashSet V) {
        if (V == null || V.size() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        Iterator i = V.iterator();
        while (i.hasNext()) {
            s.append(", " + i.next().toString());
        }
        if (s.length() == 0) {
            return "";
        }
        return s.toString().substring(2);
    }

    public static Vector makeVector(String[] O) {
        Vector<String> V = new Vector<String>();
        if (O != null) {
            int s = 0;
            while (s < O.length) {
                V.addElement(O[s]);
                ++s;
            }
        }
        return V;
    }

    public static Vector makeVector() {
        return new Vector();
    }

    public static Vector makeVector(Object O) {
        Vector<Object> V = new Vector<Object>();
        V.addElement(O);
        return V;
    }

    public static Vector makeVector(Object O, Object O2) {
        Vector<Object> V = new Vector<Object>();
        V.addElement(O);
        V.addElement(O2);
        return V;
    }

    public static Vector makeVector(Object O, Object O2, Object O3) {
        Vector<Object> V = new Vector<Object>();
        V.addElement(O);
        V.addElement(O2);
        V.addElement(O3);
        return V;
    }

    public static Vector makeVector(Object O, Object O2, Object O3, Object O4) {
        Vector<Object> V = new Vector<Object>();
        V.addElement(O);
        V.addElement(O2);
        V.addElement(O3);
        V.addElement(O4);
        return V;
    }

    public static HashSet makeHashSet() {
        return new HashSet();
    }

    public static HashSet makeHashSet(Object O) {
        HashSet<Object> H = new HashSet<Object>();
        H.add(O);
        return H;
    }

    public static HashSet makeHashSet(Object O, Object O2) {
        HashSet<Object> H = new HashSet<Object>();
        H.add(O);
        H.add(O2);
        return H;
    }

    public static HashSet makeHashSet(Object O, Object O2, Object O3) {
        HashSet<Object> H = new HashSet<Object>();
        H.add(O);
        H.add(O2);
        H.add(O3);
        return H;
    }

    public static HashSet makeHashSet(Object O, Object O2, Object O3, Object O4) {
        HashSet<Object> H = new HashSet<Object>();
        H.add(O);
        H.add(O2);
        H.add(O3);
        H.add(O4);
        return H;
    }

    public static String[] toStringArray(Hashtable V) {
        if (V == null || V.size() == 0) {
            String[] s = new String[]{};
            return s;
        }
        String[] s = new String[V.size()];
        int v = 0;
        Enumeration e = V.keys();
        while (e.hasMoreElements()) {
            String KEY = (String)e.nextElement();
            s[v] = (String)V.get(KEY);
            ++v;
        }
        return s;
    }

    public static void addToVector(Vector from, Vector to) {
        if (from != null) {
            int i = 0;
            while (i < from.size()) {
                to.addElement(from.elementAt(i));
                ++i;
            }
        }
    }

    public static String toStringList(Hashtable V) {
        if (V == null || V.size() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        Enumeration e = V.keys();
        while (e.hasMoreElements()) {
            String KEY = (String)e.nextElement();
            s.append(String.valueOf(KEY) + "=" + (String)V.get(KEY) + "/");
        }
        return s.toString();
    }

    public static String replaceAll(String str, String thisStr, String withThisStr) {
        if (str == null || thisStr == null || withThisStr == null || str.length() == 0 || thisStr.length() == 0) {
            return str;
        }
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) == thisStr.charAt(0) && str.substring(i).startsWith(thisStr)) {
                str = String.valueOf(str.substring(0, i)) + withThisStr + str.substring(i + thisStr.length());
            }
            --i;
        }
        return str;
    }

    public static String replaceAllIgnoreCase(String str, String thisStr, String withThisStr) {
        if (str == null || thisStr == null || withThisStr == null || str.length() == 0 || thisStr.length() == 0) {
            return str;
        }
        int i = str.length() - 1;
        while (i >= 0) {
            if (Character.toUpperCase(str.charAt(i)) == Character.toUpperCase(thisStr.charAt(0)) && str.substring(i).toUpperCase().startsWith(thisStr.toUpperCase())) {
                boolean isUpperCase = Character.isUpperCase(str.charAt(i));
                if (withThisStr.length() > 0) {
                    withThisStr = String.valueOf(isUpperCase ? Character.toUpperCase(withThisStr.charAt(0)) : Character.toLowerCase(withThisStr.charAt(0))) + withThisStr.substring(1);
                }
                str = String.valueOf(str.substring(0, i)) + withThisStr + str.substring(i + thisStr.length());
            }
            --i;
        }
        return str;
    }

    public static String replaceFirst(String str, String thisStr, String withThisStr) {
        if (str == null || thisStr == null || withThisStr == null || str.length() == 0 || thisStr.length() == 0) {
            return str;
        }
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) == thisStr.charAt(0) && str.substring(i).startsWith(thisStr)) {
                str = String.valueOf(str.substring(0, i)) + withThisStr + str.substring(i + thisStr.length());
                return str;
            }
            --i;
        }
        return str;
    }

    public static boolean isInteger(String INT) {
        if (INT.length() == 0) {
            return false;
        }
        if (INT.startsWith("-") && INT.length() > 1) {
            INT = INT.substring(1);
        }
        int i = 0;
        while (i < INT.length()) {
            if (!Character.isDigit(INT.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDouble(String DBL) {
        if (DBL.length() == 0) {
            return false;
        }
        if (DBL.startsWith("-") && DBL.length() > 1) {
            DBL = DBL.substring(1);
        }
        boolean alreadyDot = false;
        int i = 0;
        while (i < DBL.length()) {
            if (!Character.isDigit(DBL.charAt(i))) {
                if (DBL.charAt(i) == '.') {
                    if (alreadyDot) {
                        return false;
                    }
                    alreadyDot = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return alreadyDot;
    }

    public static String capitalizeAndLower(String name) {
        return (String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1).toLowerCase()).trim();
    }

    public static String capitalizeFirstLetter(String name) {
        return (String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1)).trim();
    }

    public static boolean s_bool(String BOOL) {
        return Boolean.valueOf(BOOL);
    }

    public static int s_int(String INT) {
        int sint = 0;
        try {
            sint = Integer.parseInt(INT);
        }
        catch (Exception e) {
            return 0;
        }
        return sint;
    }

    public static int s0_int(String INT) {
        int sint = 0;
        while (INT.length() > 0 && INT.startsWith("0")) {
            INT = INT.substring(1);
        }
        try {
            sint = Integer.parseInt(INT);
        }
        catch (Exception e) {
            return 0;
        }
        return sint;
    }

    public static String lastWordIn(String thisStr) {
        int x = thisStr.lastIndexOf(32);
        if (x >= 0) {
            return thisStr.substring(x + 1);
        }
        return thisStr;
    }

    public static String removeColors(String s) {
        StringBuffer str = new StringBuffer(s);
        int colorStart = -1;
        int i = 0;
        while (i < str.length()) {
            block0 : switch (str.charAt(i)) {
                case 'm': {
                    if (colorStart < 0) break;
                    str.delete(colorStart, i + 1);
                    colorStart = -1;
                    break;
                }
                case '\u001b': {
                    colorStart = i;
                    break;
                }
                case '^': {
                    if (i + 1 < str.length()) {
                        int tagStart = i;
                        char c = str.charAt(i + 1);
                        if (c == '<' || c == '&') {
                            i += 2;
                            while (i < str.length() - 1) {
                                if (c == '<' && (str.charAt(i) != '^' || str.charAt(i + 1) != '>') || c == '&' && str.charAt(i) != ';') {
                                    if (++i < str.length() - 1) continue;
                                    i = tagStart;
                                    str.delete(i, i + 2);
                                    --i;
                                    break block0;
                                }
                                if (c == '<') {
                                    str.delete(tagStart, i + 2);
                                } else {
                                    str.delete(tagStart, i + 1);
                                }
                                i = tagStart - 1;
                                break block0;
                            }
                            break;
                        }
                        str.delete(i, i + 2);
                        --i;
                        break;
                    }
                    str.delete(i, i + 2);
                    --i;
                }
            }
            ++i;
        }
        return str.toString();
    }

    public static String returnTime(long millis, long ticks) {
        String avg = "";
        if (ticks > 0L) {
            avg = ", Average=" + millis / ticks + "ms";
        }
        if (millis < 1000L) {
            return String.valueOf(millis) + "ms" + avg;
        }
        long seconds = millis / 1000L;
        millis -= seconds * 1000L;
        if (seconds < 60L) {
            return String.valueOf(seconds) + "s " + millis + "ms" + avg;
        }
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        if (minutes < 60L) {
            return String.valueOf(minutes) + "m " + seconds + "s " + millis + "ms" + avg;
        }
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        if (hours < 24L) {
            return String.valueOf(hours) + "h " + minutes + "m " + seconds + "s " + millis + "ms" + avg;
        }
        long days = hours / 24L;
        return String.valueOf(days) + "d " + (hours -= days * 24L) + "h " + minutes + "m " + seconds + "s " + millis + "ms" + avg;
    }

    public static Vector copyVector(Vector V) {
        Vector V2 = new Vector();
        int v = 0;
        while (v < V.size()) {
            Object h = V.elementAt(v);
            if (h instanceof Vector) {
                V2.addElement(Util.copyVector((Vector)h));
            } else {
                V2.addElement(h);
            }
            ++v;
        }
        return V2;
    }

    public static int numBits(String s) {
        int i = 0;
        int num = 0;
        boolean in = false;
        char c = '\u0000';
        int fc = 0;
        int lc = 0;
        s = s.trim();
        while (i < s.length()) {
            boolean white;
            c = s.charAt(i);
            boolean bl = white = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (white && in && (fc == 39 && lc != 39 || fc == 96 && lc != 96)) {
                white = false;
            }
            if (white && in) {
                ++num;
                c = '\u0000';
                lc = 0;
                fc = 0;
                in = false;
            } else if (!white) {
                if (!in) {
                    in = true;
                    fc = c;
                    lc = 0;
                } else {
                    lc = c;
                }
            }
            ++i;
        }
        if (in) {
            return num + 1;
        }
        return num;
    }

    public static String cleanBit(String s) {
        while (s.startsWith(" ")) {
            s = s.substring(1);
        }
        while (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((s.startsWith("'") || s.startsWith("`")) && ((s = s.substring(1)).endsWith("'") || s.endsWith("`"))) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getCleanBit(String s, int which) {
        return Util.cleanBit(Util.getBit(s, which));
    }

    public static String getPastBitClean(String s, int which) {
        return Util.cleanBit(Util.getPastBit(s, which));
    }

    public static String getPastBit(String s, int which) {
        int i = 0;
        int w = 0;
        boolean in = false;
        s = s.trim();
        String t = "";
        char c = '\u0000';
        int lc = 0;
        int fc = 0;
        while (i < s.length()) {
            boolean white;
            c = s.charAt(i);
            boolean bl = white = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (white && in && (fc == 39 && lc != 39 || fc == 96 && lc != 96)) {
                white = false;
            }
            if (white && in) {
                if (w == which) {
                    if (((s = s.substring(i + 1)).trim().startsWith("'") || s.trim().startsWith("`")) && (s.trim().startsWith("'") || s.trim().startsWith("`"))) {
                        s = s.trim().substring(1, s.length() - 1);
                    }
                    return s;
                }
                ++w;
                in = false;
                c = '\u0000';
                lc = 0;
                fc = 0;
            } else if (!white) {
                if (!in) {
                    t = "";
                    fc = c;
                    lc = 0;
                    in = true;
                } else {
                    lc = c;
                }
                t = String.valueOf(t) + c;
            }
            ++i;
        }
        return "";
    }

    public static String getBit(String s, int which) {
        int i = 0;
        int w = 0;
        boolean in = false;
        s = s.trim();
        String t = "";
        char c = '\u0000';
        int lc = 0;
        int fc = 0;
        while (i < s.length()) {
            boolean white;
            c = s.charAt(i);
            boolean bl = white = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (white && in && (fc == 39 && lc != 39 || fc == 96 && lc != 96)) {
                white = false;
            }
            if (white && in) {
                if (w == which) {
                    return t;
                }
                ++w;
                in = false;
                c = '\u0000';
                lc = 0;
                fc = 0;
            } else if (!white) {
                if (!in) {
                    t = "";
                    fc = c;
                    lc = 0;
                    in = true;
                } else {
                    lc = c;
                }
                t = String.valueOf(t) + c;
            }
            ++i;
        }
        if (in) {
            return t;
        }
        return "";
    }

    public static long s_long(String LONG) {
        long slong = 0L;
        try {
            slong = Long.parseLong(LONG);
        }
        catch (Exception e) {
            return 0L;
        }
        return slong;
    }

    public static double s_double(String DOUBLE) {
        double sdouble = 0.0;
        try {
            sdouble = Double.parseDouble(DOUBLE);
        }
        catch (Exception e) {
            return 0.0;
        }
        return sdouble;
    }

    public static String combine(Vector commands, int startAt, int endAt) {
        StringBuffer Combined = new StringBuffer("");
        if (commands != null) {
            int commandIndex = startAt;
            while (commandIndex < endAt) {
                Combined.append(String.valueOf((String)commands.elementAt(commandIndex)) + " ");
                ++commandIndex;
            }
        }
        return Combined.toString().trim();
    }

    public static String combineWithQuotes(Vector commands, int startAt, int endAt) {
        StringBuffer Combined = new StringBuffer("");
        if (commands != null) {
            int commandIndex = startAt;
            while (commandIndex < endAt) {
                String s = (String)commands.elementAt(commandIndex);
                if (s.indexOf(" ") >= 0) {
                    s = "\"" + s + "\"";
                }
                Combined.append(String.valueOf(s) + " ");
                ++commandIndex;
            }
        }
        return Combined.toString().trim();
    }

    public static String combineAfterIndexWithQuotes(Vector commands, String match) {
        StringBuffer Combined = new StringBuffer("");
        if (commands != null) {
            int commandIndex = 0;
            while (commandIndex < 0) {
                String s = (String)commands.elementAt(commandIndex);
                if (s.indexOf(" ") >= 0) {
                    s = "\"" + s + "\"";
                }
                Combined.append(String.valueOf(s) + " ");
                ++commandIndex;
            }
        }
        return Combined.toString().trim();
    }

    public static String combineWithQuotes(Vector commands, int startAt) {
        StringBuffer Combined = new StringBuffer("");
        if (commands != null) {
            int commandIndex = startAt;
            while (commandIndex < commands.size()) {
                String s = (String)commands.elementAt(commandIndex);
                if (s.indexOf(" ") >= 0) {
                    s = "\"" + s + "\"";
                }
                Combined.append(String.valueOf(s) + " ");
                ++commandIndex;
            }
        }
        return Combined.toString().trim();
    }

    public static String combine(Vector commands, int startAt) {
        StringBuffer Combined = new StringBuffer("");
        if (commands != null) {
            int commandIndex = startAt;
            while (commandIndex < commands.size()) {
                Combined.append(String.valueOf((String)commands.elementAt(commandIndex)) + " ");
                ++commandIndex;
            }
        }
        return Combined.toString().trim();
    }

    public static Vector parse(String str) {
        return Util.parse(str, -1);
    }

    public static Vector paramParse(String str) {
        Vector commands = Util.parse(str);
        int i = 0;
        while (i < commands.size()) {
            String prev;
            String s = (String)commands.elementAt(i);
            if (s.startsWith("=") && s.length() > 1 && i > 0) {
                prev = (String)commands.elementAt(i - 1);
                commands.setElementAt(String.valueOf(prev) + s, i - 1);
                commands.removeElementAt(i);
                --i;
            } else if (s.endsWith("=") && s.length() > 1 && i < commands.size() - 1) {
                String next = (String)commands.elementAt(i + 1);
                commands.setElementAt(String.valueOf(s) + next, i);
                commands.removeElementAt(i + 1);
            } else if (s.equals("=") && i > 0 && i < commands.size() - 1) {
                prev = (String)commands.elementAt(i - 1);
                String next = (String)commands.elementAt(i + 1);
                commands.setElementAt(String.valueOf(prev) + "=" + next, i - 1);
                commands.removeElementAt(i);
                commands.removeElementAt(i + 1);
                --i;
            }
            ++i;
        }
        return commands;
    }

    public static Vector parse(String str, int upTo) {
        Vector<String> commands = new Vector<String>();
        if (str == null) {
            return commands;
        }
        str = str.trim();
        while (!str.equals("")) {
            int spaceIndex = str.indexOf(" ");
            int strIndex = str.indexOf("\"");
            String CMD = "";
            if (strIndex >= 0 && (strIndex < spaceIndex || spaceIndex < 0)) {
                int endStrIndex = str.indexOf("\"", strIndex + 1);
                if (endStrIndex > strIndex) {
                    CMD = str.substring(strIndex + 1, endStrIndex).trim();
                    str = str.substring(endStrIndex + 1).trim();
                } else {
                    CMD = str.substring(strIndex + 1).trim();
                    str = "";
                }
            } else if (spaceIndex >= 0) {
                CMD = str.substring(0, spaceIndex).trim();
                str = str.substring(spaceIndex + 1).trim();
            } else {
                CMD = str.trim();
                str = "";
            }
            if (CMD.equals("")) continue;
            commands.addElement(CMD);
            if (upTo < 0 || commands.size() < upTo) continue;
            if (str.length() <= 0) break;
            commands.addElement(str);
            break;
        }
        return commands;
    }

    public static String stripBadHTMLTags(String s) {
        StringBuffer buf = new StringBuffer(s);
        Vector<Character> quotes = new Vector<Character>();
        int i = -1;
        int start = -1;
        StringBuffer bit = null;
        String lastTag = null;
        block6: while (++i < buf.length()) {
            switch (buf.charAt(i)) {
                case '<': {
                    if (quotes.size() > 0) continue block6;
                    bit = new StringBuffer("");
                    lastTag = null;
                    start = i;
                    break;
                }
                case '>': {
                    if (bit != null) {
                        lastTag = bit.toString();
                    }
                    if (quotes.size() == 0 && start >= 0 && i - start > 0 && lastTag != null && lastTag.trim().equalsIgnoreCase("FONT")) {
                        int distance = i - start + 1;
                        buf.delete(start, i + 1);
                        i -= distance;
                    }
                    bit = null;
                    lastTag = null;
                    start = -1;
                    break;
                }
                case ' ': {
                    if (bit == null) continue block6;
                    lastTag = bit.toString();
                    bit = null;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (start < 0) continue block6;
                    if (quotes.size() > 0 && ((Character)quotes.lastElement()).charValue() == buf.charAt(i)) {
                        quotes.removeElementAt(quotes.size() - 1);
                        break;
                    }
                    quotes.addElement(new Character(buf.charAt(i)));
                    break;
                }
                default: {
                    if (bit == null) continue block6;
                    bit.append(buf.charAt(i));
                }
            }
        }
        return buf.toString();
    }

    public static Vector parseCommas(String s, boolean ignoreNulls) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf(",");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            if (!ignoreNulls || s2.length() > 0) {
                V.addElement(s2);
            }
            x = s.indexOf(",");
        }
        if (!ignoreNulls || s.trim().length() > 0) {
            V.addElement(s.trim());
        }
        return V;
    }

    public static Vector parsePipes(String s, boolean ignoreNulls) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf("|");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            if (!ignoreNulls || s2.length() > 0) {
                V.addElement(s2);
            }
            x = s.indexOf("|");
        }
        if (!ignoreNulls || s.trim().length() > 0) {
            V.addElement(s.trim());
        }
        return V;
    }

    public static Vector parseSquiggles(String s) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf("~");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            V.addElement(s2);
            x = s.indexOf("~");
        }
        return V;
    }

    public static Vector parseSentences(String s) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf(".");
        while (x >= 0) {
            String s2 = s.substring(0, x + 1);
            s = s.substring(x + 1);
            V.addElement(s2);
            x = s.indexOf(".");
        }
        return V;
    }

    public static Vector parseSquiggleDelimited(String s, boolean ignoreNulls) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf("~");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            if (s2.length() > 0 || !ignoreNulls) {
                V.addElement(s2);
            }
            x = s.indexOf("~");
        }
        if (s.length() > 0 || !ignoreNulls) {
            V.addElement(s);
        }
        return V;
    }

    public static Vector parseSemicolons(String s, boolean ignoreNulls) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf(";");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            if (!ignoreNulls || s2.length() > 0) {
                V.addElement(s2);
            }
            x = s.indexOf(";");
        }
        if (!ignoreNulls || s.trim().length() > 0) {
            V.addElement(s.trim());
        }
        return V;
    }

    public static int abs(int val) {
        if (val >= 0) {
            return val;
        }
        return val * -1;
    }

    public static long abs(long val) {
        if (val >= 0L) {
            return val;
        }
        return val * -1L;
    }

    public static Vector parseSpaces(String s, boolean ignoreNulls) {
        Vector<String> V = new Vector<String>();
        if (s == null || s.length() == 0) {
            return V;
        }
        int x = s.indexOf(" ");
        while (x >= 0) {
            String s2 = s.substring(0, x).trim();
            s = s.substring(x + 1).trim();
            if (!ignoreNulls || s2.length() > 0) {
                V.addElement(s2);
            }
            x = s.indexOf(" ");
        }
        if (!ignoreNulls || s.trim().length() > 0) {
            V.addElement(s.trim());
        }
        return V;
    }

    public static int lengthMinusColors(String thisStr) {
        int size = 0;
        int i = 0;
        while (i < thisStr.length()) {
            if (thisStr.charAt(i) == '^') {
                if (++i + 1 < thisStr.length()) {
                    int tagStart = i;
                    char c = thisStr.charAt(i);
                    if (c == '<' || c == '&') {
                        while (i < thisStr.length() - 1) {
                            if (c == '<' && (thisStr.charAt(i) != '^' || thisStr.charAt(i + 1) != '>') || c == '&' && thisStr.charAt(i) != ';') {
                                if (++i < thisStr.length() - 1) continue;
                                i = tagStart + 1;
                            } else {
                                ++i;
                            }
                            break;
                        }
                    }
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public static String convertToRoman(int i) {
        int y;
        int x;
        String Roman = "";
        String[] Hundreds = new String[]{"C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "P"};
        String[] Tens = new String[]{"X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "C"};
        String[] Ones = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (i > 1000) {
            Roman = "Y";
            i %= 1000;
        }
        if (i >= 100) {
            x = i % 100;
            y = Math.round((i - x) / 100);
            if (y > 0) {
                Roman = String.valueOf(Roman) + Hundreds[y - 1];
            }
            i = x;
        }
        if (i >= 10 && (y = Math.round((i - (x = i % 10)) / 10)) > 0) {
            Roman = String.valueOf(Roman) + Tens[y - 1];
        }
        if ((i %= 10) > 0) {
            Roman = String.valueOf(Roman) + Ones[i - 1];
        }
        return Roman;
    }

    public static String padLeft(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr).substring(0, thisMuch);
        }
        return String.valueOf(SPACES.substring(0, thisMuch - lenMinusColors)) + thisStr;
    }

    public static String padLeft(String thisStr, String colorPrefix, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return String.valueOf(colorPrefix) + Util.removeColors(thisStr).substring(0, thisMuch);
        }
        return String.valueOf(SPACES.substring(0, thisMuch - lenMinusColors)) + colorPrefix + thisStr;
    }

    public static String padRight(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr).substring(0, thisMuch);
        }
        return String.valueOf(thisStr) + SPACES.substring(0, thisMuch - lenMinusColors);
    }

    public static String limit(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr).substring(0, thisMuch);
        }
        return thisStr;
    }

    public static String padRight(String thisStr, String colorSuffix, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return String.valueOf(Util.removeColors(thisStr).substring(0, thisMuch)) + colorSuffix;
        }
        return String.valueOf(thisStr) + colorSuffix + SPACES.substring(0, thisMuch - lenMinusColors);
    }

    public static String padRightPreserve(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr);
        }
        return String.valueOf(thisStr) + SPACES.substring(0, thisMuch - lenMinusColors);
    }

    public static String centerPreserve(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr);
        }
        int left = (thisMuch - lenMinusColors) / 2;
        int right = left + left + lenMinusColors < thisMuch ? left + 1 : left;
        return String.valueOf(SPACES.substring(0, left)) + thisStr + SPACES.substring(0, right);
    }

    public static String padLeftPreserve(String thisStr, int thisMuch) {
        int lenMinusColors = Util.lengthMinusColors(thisStr);
        if (lenMinusColors > thisMuch) {
            return Util.removeColors(thisStr);
        }
        return String.valueOf(SPACES.substring(0, thisMuch - lenMinusColors)) + thisStr;
    }

    public static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() == 0) {
            return false;
        }
        if (s.length() > 1 && s.startsWith("-")) {
            s = s.substring(1);
        }
        int i = 0;
        while (i < s.length()) {
            if ("0123456789.,".indexOf(s.charAt(i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double div(double a, double b) {
        return a / b;
    }

    public static double div(double a, int b) {
        return a / new Integer(b).doubleValue();
    }

    public static double div(int a, double b) {
        return new Integer(a).doubleValue() / b;
    }

    public static double div(double a, long b) {
        return a / new Long(b).doubleValue();
    }

    public static double div(long a, double b) {
        return new Long(a).doubleValue() / b;
    }

    public static double mul(double a, double b) {
        return a * b;
    }

    public static double mul(double a, int b) {
        return a * new Integer(b).doubleValue();
    }

    public static double mul(int a, double b) {
        return new Integer(a).doubleValue() * b;
    }

    public static double mul(double a, long b) {
        return a * new Long(b).doubleValue();
    }

    public static double mul(long a, double b) {
        return new Long(a).doubleValue() * b;
    }

    public static long mul(long a, long b) {
        return a * b;
    }

    public static int mul(int a, int b) {
        return a * b;
    }

    public static double div(long a, long b) {
        return new Long(a).doubleValue() / new Long(b).doubleValue();
    }

    public static double div(int a, int b) {
        return new Integer(a).doubleValue() / new Integer(b).doubleValue();
    }

    public static int pow(int x, int y) {
        return (int)Math.round(Math.pow(new Integer(x).doubleValue(), new Integer(y).doubleValue()));
    }

    public static int squared(int x) {
        return (int)Math.round(Math.pow(new Integer(x).doubleValue(), new Integer(x).doubleValue()));
    }

    public static boolean bset(int num, int bitmask) {
        return (num & bitmask) == bitmask;
    }

    public static boolean bset(long num, long bitmask) {
        return (num & bitmask) == bitmask;
    }

    public static boolean bset(long num, int bitmask) {
        return (num & (long)bitmask) == (long)bitmask;
    }

    public static int setb(int num, int bitmask) {
        return num | bitmask;
    }

    public static boolean banyset(int num, int bitmask) {
        return (num & bitmask) > 0;
    }

    public static boolean banyset(long num, long bitmask) {
        return (num & bitmask) > 0L;
    }

    public static boolean banyset(long num, int bitmask) {
        return (num & (long)bitmask) > 0L;
    }

    public static long setb(long num, int bitmask) {
        return num | (long)bitmask;
    }

    public static long setb(long num, long bitmask) {
        return num | bitmask;
    }

    public static int unsetb(int num, int bitmask) {
        if (Util.bset(num, bitmask)) {
            num -= bitmask;
        }
        return num;
    }

    public static long unsetb(long num, long bitmask) {
        if (Util.bset(num, bitmask)) {
            num -= bitmask;
        }
        return num;
    }

    public static long unsetb(long num, int bitmask) {
        if (Util.bset(num, bitmask)) {
            num -= (long)bitmask;
        }
        return num;
    }

    public static boolean isSet(int number, int bitnumber) {
        return (number & Util.pow(2, bitnumber)) == Util.pow(2, bitnumber);
    }

    public static boolean isSet(long number, int bitnumber) {
        return (number & (long)Util.pow(2, bitnumber)) == (long)Util.pow(2, bitnumber);
    }

    public static String sameCase(String str, char c) {
        if (Character.isUpperCase(c)) {
            return str.toUpperCase();
        }
        return str.toLowerCase();
    }

    public static Vector denumerate(Enumeration e) {
        Vector V = new Vector();
        while (e.hasMoreElements()) {
            V.addElement(e.nextElement());
        }
        return V;
    }
}

