/*
 * Decompiled with CFR 0.152.
 */
package de.jave.util;

import de.jave.io.IOTools;
import de.jave.util.FileListEntry;
import de.jave.util.RecentFileOpenListener;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public class RecentFileList
implements ActionListener {
    private int maxSize = 5;
    private int size = 0;
    private FileListEntry first = null;
    private FileListEntry last = null;
    private Menu menu;
    protected RecentFileOpenListener listener;

    public void setRecentFileOpenListener(RecentFileOpenListener recentFileOpenListener) {
        this.listener = recentFileOpenListener;
    }

    public void add(File file) {
        this.delete(file);
        FileListEntry fileListEntry = new FileListEntry(file);
        fileListEntry.next = this.first;
        fileListEntry.prev = null;
        if (fileListEntry.next == null) {
            this.last = fileListEntry;
        }
        if (fileListEntry.next != null) {
            fileListEntry.next.prev = fileListEntry;
        }
        if (this.first != null) {
            this.first.prev = fileListEntry;
        }
        this.first = fileListEntry;
        ++this.size;
        if (this.size > this.maxSize) {
            this.delete(this.last.file);
        } else {
            this.updateMenu();
        }
    }

    public void delete(File file) {
        FileListEntry fileListEntry = this.first;
        while (fileListEntry != null) {
            if (file.equals(fileListEntry.file)) {
                if (fileListEntry.next != null) {
                    fileListEntry.next.prev = fileListEntry.prev;
                } else {
                    this.last = fileListEntry.prev;
                }
                if (fileListEntry.prev != null) {
                    fileListEntry.prev.next = fileListEntry.next;
                } else {
                    this.first = fileListEntry.next;
                }
                --this.size;
                this.updateMenu();
                return;
            }
            fileListEntry = fileListEntry.next;
        }
    }

    public void setMaxSize(int n) {
        if (this.maxSize > 9) {
            this.maxSize = 9;
        }
        while (this.size > n) {
            this.delete(this.last.file);
        }
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void check() {
        Vector<File> vector = new Vector<File>(this.size);
        FileListEntry fileListEntry = this.first;
        while (fileListEntry != null) {
            if (!fileListEntry.file.exists()) {
                vector.addElement(fileListEntry.file);
            }
            fileListEntry = fileListEntry.next;
        }
        int n = 0;
        while (n < vector.size()) {
            this.delete((File)vector.elementAt(n));
            ++n;
        }
    }

    public File[] getFiles() {
        File[] fileArray = new File[this.size];
        int n = 0;
        FileListEntry fileListEntry = this.first;
        while (fileListEntry != null) {
            fileArray[n++] = fileListEntry.file;
            fileListEntry = fileListEntry.next;
        }
        return fileArray;
    }

    public int getSize() {
        return this.size;
    }

    public File getFile(int n) {
        boolean bl = false;
        FileListEntry fileListEntry = this.first;
        int n2 = 0;
        while (n2 < n) {
            fileListEntry = fileListEntry.next;
            ++n2;
        }
        return fileListEntry.file;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        FileListEntry fileListEntry = this.first;
        int n = 0;
        stringBuffer.append("-- " + this.size + " Eint\u00e4ge in der History\n");
        while (fileListEntry != null) {
            stringBuffer.append(++n + " " + fileListEntry.file.toString() + "\n");
            fileListEntry = fileListEntry.next;
        }
        return stringBuffer.toString();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void setMenu(Menu menu) {
        if (this.menu != null) {
            this.menu.removeAll();
        }
        this.menu = menu;
        this.updateMenu();
    }

    private void updateMenu() {
        if (this.menu == null) {
            return;
        }
        this.menu.removeAll();
        File[] fileArray = this.getFiles();
        if (fileArray.length == 0) {
            MenuItem menuItem = new MenuItem("none");
            menuItem.setEnabled(false);
            this.menu.add(menuItem);
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            MenuItem menuItem = new MenuItem(n + " " + IOTools.getDisplayFilename(fileArray[n].toString(), 25));
            menuItem.addActionListener(this);
            this.menu.add(menuItem);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listener == null) {
            return;
        }
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        int n = this.menu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            File file;
            boolean bl;
            if (this.menu.getItem(n2) == menuItem && !(bl = this.listener.openRecentFile(file = this.getFile(n2)))) {
                this.delete(file);
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        RecentFileList recentFileList = new RecentFileList();
        Frame frame = new Frame();
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Ui");
        recentFileList.setMenu(menu);
        menuBar.add(menu);
        frame.setMenuBar(menuBar);
        frame.pack();
        frame.show();
        recentFileList.add(new File("Hallo1.txt"));
        recentFileList.add(new File("Hallo2.txt"));
        recentFileList.add(new File("Hallo2.txt"));
        recentFileList.add(new File("Hallo3.txt"));
        recentFileList.add(new File("Hallo4.txt"));
        recentFileList.add(new File("Hallo5.txt"));
        recentFileList.add(new File("Hallo6.txt"));
        recentFileList.add(new File("Hallo7.txt"));
        recentFileList.delete(new File("Hallo4.txt"));
        recentFileList.print();
    }
}

