/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.AsciiPacker;
import de.jave.javeplayer.JaveMovieFrame;
import de.jave.javeplayer.JavePlayerTools;
import de.jave.javeplayer.ZIPTool;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JaveMovieFile {
    protected String fileName = null;
    protected Vector frames = new Vector(200);
    protected String authorName;
    protected String authorEmail;
    protected String software;
    protected String date;
    protected String title;
    protected int defaultDuration = 66;
    protected boolean modified = false;

    public JaveMovieFile(String string) {
        this();
        this.fileName = string;
    }

    public JaveMovieFile() {
    }

    public void setDefaultDuration(int n) {
        this.defaultDuration = n;
    }

    public int getDefaultDuration() {
        return this.defaultDuration;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String string) {
        if (JaveMovieFile.isEquivalent(string, this.date)) {
            return;
        }
        this.date = string;
        this.modified = true;
    }

    public void setTitle(String string) {
        if (JaveMovieFile.isEquivalent(string, this.title)) {
            return;
        }
        this.title = string;
        this.modified = true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String string) {
        if (JaveMovieFile.isEquivalent(string, this.software)) {
            return;
        }
        this.software = string;
        this.modified = true;
    }

    public String getAuthor() {
        return this.authorName;
    }

    public void setAuthor(String string) {
        if (JaveMovieFile.isEquivalent(string, this.authorName)) {
            return;
        }
        this.authorName = string;
        this.modified = true;
    }

    public String getEMail() {
        return this.authorEmail;
    }

    public void setEMail(String string) {
        if (JaveMovieFile.isEquivalent(string, this.authorEmail)) {
            return;
        }
        this.authorEmail = string;
        this.modified = true;
    }

    protected static final boolean isEquivalent(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null || string2.length() == 0;
        }
        return string.equals(string2);
    }

    public void load() throws Exception {
        this.frames = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = ZIPTool.openPossiblyZipped(ZIPTool.toUrl(this.fileName));
            if (bufferedReader == null) {
                throw new IOException("Unable to open file " + this.fileName);
            }
            int n = 0;
            int n2 = this.defaultDuration;
            Color color = Color.black;
            Color color2 = Color.white;
            JaveMovieFrame javeMovieFrame = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n3;
                if (string.startsWith("J:")) {
                    String string3;
                    if (javeMovieFrame != null) {
                        this.frames.addElement(javeMovieFrame);
                    }
                    javeMovieFrame = new JaveMovieFrame();
                    javeMovieFrame.setDuration(n2);
                    javeMovieFrame.setForeground(color);
                    javeMovieFrame.setBackground(color2);
                    ++n;
                    if (string.length() == 2) {
                        javeMovieFrame.setContent(string2);
                        continue;
                    }
                    char c = string.charAt(2);
                    if (c >= '0' && c <= '9') {
                        try {
                            int n4 = 2;
                            n3 = string.indexOf(32, n4 + 1);
                            int n5 = string.indexOf(32, n3 + 1);
                            int n6 = string.indexOf(32, n5 + 1);
                            int n7 = string.indexOf(32, n6 + 1);
                            String string4 = string.substring(n4, n3);
                            String string5 = string.substring(n3 + 1, n5);
                            String string6 = string.substring(n5 + 1, n6);
                            String string7 = null;
                            string7 = n7 != -1 ? string.substring(n6 + 1, n7) : string.substring(n6 + 1);
                            int n8 = Integer.parseInt(string4);
                            int n9 = Integer.parseInt(string5);
                            int n10 = Integer.parseInt(string6);
                            int n11 = Integer.parseInt(string7);
                            String string8 = null;
                            string8 = n7 == -1 ? string2 : string.substring(n7 + 1);
                            string2 = string8;
                            javeMovieFrame.setContent(string8);
                            javeMovieFrame.setScrollX(n8);
                            javeMovieFrame.setScrollY(n9);
                            javeMovieFrame.setCursorX(n10);
                            javeMovieFrame.setCursorY(n11);
                        }
                        catch (Exception exception) {
                            System.err.println("Warning: Error in format of Jave Movie." + exception);
                        }
                        continue;
                    }
                    string2 = string3 = string.substring(2);
                    javeMovieFrame.setContent(string3);
                    continue;
                }
                if (string.startsWith("S:")) {
                    if (javeMovieFrame == null) continue;
                    try {
                        int n12 = 2;
                        int n13 = string.indexOf(32, n12 + 1);
                        n3 = string.indexOf(32, n13 + 1);
                        String string9 = string.substring(n12, n13);
                        String string10 = string.substring(n13 + 1, n3);
                        String string11 = string.substring(n3 + 1);
                        int n14 = Integer.parseInt(string9);
                        int n15 = Integer.parseInt(string10);
                        javeMovieFrame.setSelection(string11);
                        javeMovieFrame.setSelectionX(n14);
                        javeMovieFrame.setSelectionY(n15);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of Jave Movie.");
                    }
                    continue;
                }
                if (string.startsWith("T:")) {
                    if (javeMovieFrame == null) continue;
                    String string12 = string.substring(2);
                    javeMovieFrame.setTool(string12);
                    continue;
                }
                if (string.startsWith("A:")) {
                    if (javeMovieFrame == null) continue;
                    String string13 = string.substring(2);
                    javeMovieFrame.setAction(string13);
                    continue;
                }
                if (string.startsWith("+:")) {
                    if (javeMovieFrame == null) continue;
                    try {
                        int n16 = Integer.parseInt(string.substring(2));
                        javeMovieFrame.setDuration(n16);
                        n2 = n16;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Warning: Error in format of Jave Movie:  " + string);
                    }
                    continue;
                }
                if (string.startsWith("|:")) {
                    if (javeMovieFrame == null) continue;
                    int n17 = string.indexOf(32, 2);
                    try {
                        int n18 = Integer.parseInt(string.substring(2, n17));
                        n3 = Integer.parseInt(string.substring(n17 + 1));
                        javeMovieFrame.setCursorX(n18);
                        javeMovieFrame.setCursorY(n3);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of Jave Movie: " + string);
                    }
                    continue;
                }
                if (string.startsWith("^:")) {
                    if (javeMovieFrame == null) continue;
                    int n19 = string.indexOf(32, 2);
                    try {
                        int n20 = Integer.parseInt(string.substring(2, n19));
                        n3 = Integer.parseInt(string.substring(n19 + 1));
                        javeMovieFrame.setScrollX(n20);
                        javeMovieFrame.setScrollY(n3);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of Jave Movie: " + string);
                    }
                    continue;
                }
                if (string.startsWith("@:")) {
                    if (this.authorEmail != null || string.length() <= 2) continue;
                    this.authorEmail = string.substring(2);
                    continue;
                }
                if (string.startsWith("N:")) {
                    if (this.authorName != null || string.length() <= 2) continue;
                    this.authorName = string.substring(2);
                    continue;
                }
                if (string.startsWith("!:")) {
                    if (this.title != null || string.length() <= 2) continue;
                    this.title = string.substring(2);
                    continue;
                }
                if (string.startsWith("D:")) {
                    if (this.date != null || string.length() <= 2) continue;
                    this.date = string.substring(2);
                    continue;
                }
                if (string.startsWith("C:")) {
                    if (javeMovieFrame == null) continue;
                    try {
                        int n21 = string.indexOf(32, 2);
                        color2 = JavePlayerTools.hexToColor(string.substring(2, n21));
                        color = JavePlayerTools.hexToColor(string.substring(n21 + 1));
                        if (javeMovieFrame == null) continue;
                        javeMovieFrame.setForeground(color);
                        javeMovieFrame.setBackground(color2);
                    }
                    catch (Exception exception) {
                        System.err.println("Warning: Error in format of Jave Movie: " + string);
                    }
                    continue;
                }
                if (string.startsWith("*:")) {
                    if (this.software != null || string.length() <= 2) continue;
                    this.software = string.substring(2);
                    continue;
                }
                if (!string.startsWith("#") || javeMovieFrame == null) continue;
                javeMovieFrame.setSoundTrigger(true);
            }
            if (javeMovieFrame != null) {
                this.frames.addElement(javeMovieFrame);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Error loading Jave movie: File not found: '" + this.fileName + "'");
        }
        catch (IOException iOException) {
            throw new Exception("Error loading Jave movie: Wrong file format.");
        }
        this.modified = false;
    }

    public void add(JaveMovieFrame javeMovieFrame) {
        this.frames.addElement(javeMovieFrame);
        this.modified = true;
    }

    public void insertFrame(JaveMovieFrame javeMovieFrame, int n) {
        this.frames.insertElementAt(javeMovieFrame, n);
        this.modified = true;
    }

    public void setFrameAt(JaveMovieFrame javeMovieFrame, int n) {
        this.frames.setElementAt(javeMovieFrame, n);
        this.modified = true;
    }

    public void deleteFrame(int n) {
        this.frames.removeElementAt(n);
        this.modified = true;
    }

    public void moveFrameRight(int n) {
        Object e = this.frames.elementAt(n);
        this.frames.removeElementAt(n);
        this.frames.insertElementAt(e, n + 1);
        this.modified = true;
    }

    public void moveFrameLeft(int n) {
        this.moveFrameRight(n - 1);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.modified = true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save() throws Exception {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
            int n = this.defaultDuration;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            Color color = null;
            Color color2 = null;
            if (this.title != null) {
                bufferedWriter.write("!:");
                bufferedWriter.write(this.title.trim());
                bufferedWriter.newLine();
            }
            if (this.software != null) {
                bufferedWriter.write("*:");
                bufferedWriter.write(this.software.trim());
                bufferedWriter.newLine();
            }
            if (this.date != null) {
                bufferedWriter.write("D:");
                bufferedWriter.write(this.date.trim());
                bufferedWriter.newLine();
            }
            if (this.authorName != null) {
                bufferedWriter.write("N:");
                bufferedWriter.write(this.authorName.trim());
                bufferedWriter.newLine();
            }
            if (this.authorEmail != null) {
                bufferedWriter.write("@:");
                bufferedWriter.write(this.authorEmail.trim());
                bufferedWriter.newLine();
            }
            int n6 = 0;
            while (n6 < this.frames.size()) {
                String string;
                String string2;
                int n7;
                JaveMovieFrame javeMovieFrame = (JaveMovieFrame)this.frames.elementAt(n6);
                char[][] cArray = javeMovieFrame.getContent();
                bufferedWriter.write("J:");
                bufferedWriter.write(AsciiPacker.encodeOptimized(cArray));
                bufferedWriter.newLine();
                char[][] cArray2 = javeMovieFrame.getSelection();
                if (cArray2 != null) {
                    bufferedWriter.write("S:");
                    bufferedWriter.write(String.valueOf(javeMovieFrame.getSelectionX()));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(String.valueOf(javeMovieFrame.getSelectionY()));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(AsciiPacker.encodeOptimized(cArray2));
                    bufferedWriter.newLine();
                }
                int n8 = javeMovieFrame.getCursorX();
                int n9 = javeMovieFrame.getCursorY();
                if (n8 != n2 || n9 != n3) {
                    bufferedWriter.write("|:");
                    bufferedWriter.write(String.valueOf(n8));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(String.valueOf(n9));
                    bufferedWriter.newLine();
                    n2 = n8;
                    n3 = n9;
                }
                int n10 = javeMovieFrame.getScrollX();
                int n11 = javeMovieFrame.getScrollY();
                if (n10 != n4 || n11 != n5) {
                    bufferedWriter.write("^:");
                    bufferedWriter.write(String.valueOf(n10));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(String.valueOf(n11));
                    bufferedWriter.newLine();
                    n4 = n10;
                    n5 = n11;
                }
                if ((n7 = javeMovieFrame.getDuration()) != n) {
                    bufferedWriter.write("+:");
                    bufferedWriter.write(String.valueOf(n7));
                    bufferedWriter.newLine();
                    n = n7;
                }
                Color color3 = javeMovieFrame.getForeground();
                Color color4 = javeMovieFrame.getBackground();
                if (!color3.equals(color) || !color4.equals(color2)) {
                    bufferedWriter.write("C:");
                    bufferedWriter.write(JavePlayerTools.colorToHex(color4));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(JavePlayerTools.colorToHex(color3));
                    bufferedWriter.newLine();
                    color = color3;
                    color2 = color4;
                }
                if ((string2 = javeMovieFrame.getTool()) != null) {
                    bufferedWriter.write("T:");
                    bufferedWriter.write(string2.trim());
                    bufferedWriter.newLine();
                }
                if ((string = javeMovieFrame.getAction()) != null) {
                    bufferedWriter.write("A:");
                    bufferedWriter.write(string.trim());
                    bufferedWriter.newLine();
                }
                ++n6;
            }
            bufferedWriter.close();
            this.modified = false;
        }
        catch (IOException iOException) {
            throw new Exception("Error saving Jave movie: " + iOException);
        }
    }

    public JaveMovieFrame getFrame(int n) {
        return (JaveMovieFrame)this.frames.elementAt(n);
    }

    public int getFrameCount() {
        if (this.frames == null) {
            return 0;
        }
        return this.frames.size();
    }
}

