/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.Selection;
import de.jave.jave.Tool;
import de.jave.text.TextTools;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class SelectionTool
extends Tool
implements ActionListener,
ItemListener,
Runnable {
    protected Thread blinkThread;
    protected boolean shallStop;
    protected Point location1;
    protected Point point1;
    protected Point location2;
    protected int mode = 1;
    protected boolean movedByCursor = false;
    protected boolean resizedByCursor = false;
    protected int keySelectionAnchorH = 5;
    protected int keySelectionAnchorV = 3;
    protected boolean selectionMoved = false;
    protected boolean selectionResized = false;
    public static final int NONE = 1;
    public static final int MOVE = 0;
    public static final int N_RESIZE = 2;
    public static final int S_RESIZE = 3;
    public static final int W_RESIZE = 4;
    public static final int E_RESIZE = 5;
    public static final int NE_RESIZE = 6;
    public static final int NW_RESIZE = 7;
    public static final int SE_RESIZE = 8;
    public static final int SW_RESIZE = 9;
    protected static final int SELECT = 10;
    protected static final int SELECT_PLUS = 11;
    protected static final int SELECT_MINUS = 12;
    protected static final String[] MODE_STR = new String[]{"MOVE", "NONE", "N_RESIZE", "S_RESIZE", "W_RESIZE", "E_RESIZE", "NE_RESIZE", "NW_RESIZE", "SE_RESIZE", "SW_RESIZE", "SELECT", "SELECT_PLUS", "SELECT_MINUS"};
    protected Checkbox cbMix;
    protected Checkbox cb3d;
    protected static final boolean DEFAULT_MIX = false;
    protected static final boolean DEFAULT_3D = true;
    protected Choice chSelectionLayer;
    protected Checkbox cbCollision;
    protected int dx;
    protected int dy;
    protected int gdx;
    protected int gdy;

    public SelectionTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public boolean containsLocation(Point point) {
        return this.plate.hasSelection() && this.plate.selection.contains(point);
    }

    public Component createOptionsComponent() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2, 2, 2));
        this.cb3d = new Checkbox("3D View", true);
        this.cb3d.addItemListener(this);
        this.cbMix = new Checkbox("Mix", false);
        this.cbMix.addItemListener(this);
        this.chSelectionLayer = new Choice();
        this.chSelectionLayer.addItemListener(this);
        int n = 0;
        while (n < Selection.STR_LAYER.length) {
            this.chSelectionLayer.addItem(Selection.STR_LAYER[n]);
            ++n;
        }
        this.chSelectionLayer.select(1);
        this.cbCollision = new Checkbox("Collision", false);
        panel.add(new Label("Layer:", 2));
        panel.add(this.chSelectionLayer);
        panel.add(this.cbCollision);
        panel.add(this.cb3d);
        panel.add(this.cbMix);
        this.cbMix.setEnabled(this.chSelectionLayer.getSelectedIndex() == 2);
        return panel;
    }

    public String getName() {
        return "Selection";
    }

    public String getIconName() {
        return "selection";
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        if (this.cbMix != null) {
            this.setMixMode(this.cbMix.getState());
        } else {
            this.setMixMode(false);
        }
        this.blinkThread = new Thread(this);
        this.shallStop = false;
        this.blinkThread.setPriority(1);
        this.blinkThread.start();
    }

    public void putAside(boolean bl) {
        this.shallStop = true;
        if (!bl && this.plate.hasSelection()) {
            this.plate.dropSelection();
            this.plate.saveCurrentState("drop selection");
        }
        this.point1 = null;
        this.location1 = null;
        this.location2 = null;
    }

    public void prepareForSave() {
        if (this.plate.hasSelection()) {
            this.dropSelection();
        }
    }

    public void run() {
        int n = 600;
        long l = System.currentTimeMillis();
        while (!this.shallStop) {
            long l2 = l;
            while (l2 - l < (long)n) {
                try {
                    Thread.currentThread();
                    Thread.sleep((long)n - (l2 - l));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis();
            }
            l = l2;
            if (!this.plate.hasSelection()) continue;
            this.repaintCursor();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.plate.requestFocus();
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.location1 != null && this.location2 != null) {
            Rectangle rectangle = Tool.getRectangleFor(this.location1, this.location2);
            this.showStatus("(" + rectangle.x + "," + rectangle.y + ") -> (" + (rectangle.x + rectangle.width) + "," + rectangle.y + rectangle.height + ") = (" + rectangle.width + "," + rectangle.height + ")");
            graphics.setColor(JaveGlobalRessources.colorTool);
            Point point = this.getScreenPointFor(rectangle.x, rectangle.y);
            graphics.drawRect(point.x, point.y, rectangle.width * this.plate.charWidth, rectangle.height * this.plate.charHeight);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getSource() == this.cbMix) {
            this.setMixMode(this.cbMix.getState());
        }
        if (!this.plate.hasSelection()) {
            return;
        }
        this.cbMix.setEnabled(this.chSelectionLayer.getSelectedIndex() == 2);
        this.synchronizeToSelection();
        this.plate.requestFocus();
    }

    public void synchronizeToSelection() {
        Selection selection = this.plate.getSelection();
        if (selection == null) {
            this.setCursor(JaveGlobalRessources.cursorSelection);
            return;
        }
        selection.setLayer(this.chSelectionLayer.getSelectedIndex());
        selection.set3dView(this.cb3d.getState());
        this.repaintAll();
    }

    protected void selectionCanceled() {
        this.mode = 1;
        this.location1 = null;
        this.repaintCursor();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.plate.hasSelection()) {
            if (Tool.shiftDown) {
                this.setCursor(JaveGlobalRessources.cursorSelectionPlus);
            } else if (Tool.controlDown) {
                this.setCursor(JaveGlobalRessources.cursorSelectionMinus);
            }
        }
        if (!(n != 27 || this.plate.hasSelection() && this.mode != 11 && this.mode != 12)) {
            this.selectionCanceled();
            return;
        }
        if (!this.plate.hasSelection()) {
            return;
        }
        if (Tool.altDown && n == 38) {
            this.chSelectionLayer.select((this.chSelectionLayer.getSelectedIndex() + 1) % 3);
            this.itemStateChanged(null);
            return;
        }
        if (Tool.altDown && n == 40) {
            int n2 = this.chSelectionLayer.getSelectedIndex() - 1;
            if (n2 < 0) {
                n2 = 2;
            }
            this.chSelectionLayer.select(n2);
            this.itemStateChanged(null);
            return;
        }
        if (n == 127) {
            this.jave.doSelectionDelete();
            this.jave.switchToTextTool();
            return;
        }
        if (n == 82 && keyEvent.isShiftDown()) {
            this.jave.doCrop();
            return;
        }
        if (!(Tool.controlDown || Tool.shiftDown || n != 38 && n != 40 && n != 37 && n != 39)) {
            Rectangle rectangle = this.plate.getSelectionRegion();
            this.dropSelection();
            int n3 = 0;
            int n4 = 0;
            if (n == 38 || n == 40) {
                n3 = this.keySelectionAnchorH == 4 ? rectangle.x : rectangle.x + rectangle.width - 1;
                n4 = n == 38 ? rectangle.y : rectangle.y + rectangle.height;
            } else {
                n4 = this.keySelectionAnchorV == 2 ? rectangle.y : rectangle.y + rectangle.height - 1;
                n3 = n == 37 ? rectangle.x : rectangle.x + rectangle.width;
            }
            boolean bl = true;
            if (n3 >= this.plate.getDocumentWidth()) {
                bl = false;
                n3 = this.plate.getDocumentWidth() - 1;
            }
            if (n4 >= this.plate.getDocumentHeight()) {
                bl = false;
                n4 = this.plate.getDocumentHeight() - 1;
            }
            if (!bl) {
                this.beep();
            }
            this.jave.switchToTextTool(n3, n4);
            return;
        }
        if (n == 10 || n == 27) {
            Rectangle rectangle = this.plate.getSelectionRegion();
            this.dropSelection();
            this.jave.switchToTextTool(rectangle.x, rectangle.y);
            return;
        }
        if (Tool.shiftDown && (n == 38 || n == 40 || n == 37 || n == 39)) {
            Rectangle rectangle = this.plate.getSelectionRegion();
            switch (n) {
                case 38: {
                    if (rectangle.height == 1) {
                        this.plate.getSelection().resizeByCursorN_UP();
                        this.keySelectionAnchorV = 2;
                        break;
                    }
                    if (this.keySelectionAnchorV == 2) {
                        this.plate.getSelection().resizeByCursorN_UP();
                        break;
                    }
                    this.plate.getSelection().resizeByCursorS_UP();
                    break;
                }
                case 40: {
                    if (rectangle.height == 1) {
                        this.plate.getSelection().resizeByCursorS_DOWN();
                        this.keySelectionAnchorV = 3;
                        break;
                    }
                    if (this.keySelectionAnchorV == 2) {
                        this.plate.getSelection().resizeByCursorN_DOWN();
                        break;
                    }
                    this.plate.getSelection().resizeByCursorS_DOWN();
                    this.keySelectionAnchorV = 3;
                    break;
                }
                case 37: {
                    if (rectangle.width == 1) {
                        this.plate.getSelection().resizeByCursorW_LEFT();
                        this.keySelectionAnchorH = 4;
                        break;
                    }
                    if (this.keySelectionAnchorH == 4) {
                        this.plate.getSelection().resizeByCursorW_LEFT();
                        break;
                    }
                    this.plate.getSelection().resizeByCursorE_LEFT();
                    break;
                }
                case 39: {
                    if (rectangle.width == 1) {
                        this.plate.getSelection().resizeByCursorE_RIGHT();
                        this.keySelectionAnchorH = 5;
                        break;
                    }
                    if (this.keySelectionAnchorH == 4) {
                        this.plate.getSelection().resizeByCursorW_RIGHT();
                        break;
                    }
                    this.plate.getSelection().resizeByCursorE_RIGHT();
                }
            }
            this.plate.repaint();
            this.resizedByCursor = true;
            return;
        }
        switch (n) {
            case 38: {
                this.moveSelectionByCursor(0, -1);
                break;
            }
            case 40: {
                this.moveSelectionByCursor(0, 1);
                break;
            }
            case 37: {
                this.moveSelectionByCursor(-1, 0);
                break;
            }
            case 39: {
                this.moveSelectionByCursor(1, 0);
            }
        }
    }

    protected void moveSelectionByCursor(int n, int n2) {
        Point point = this.plate.moveSelection(n, n2, this.cbCollision.getState());
        Rectangle rectangle = this.plate.getSelectionRegion();
        Point point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Point point3 = this.plate.ensureVisible(point2.x, point2.y);
        Selection selection = this.plate.getSelection();
        selection.move(point3.x, point3.y);
        this.movedByCursor = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.movedByCursor) {
            this.movedByCursor = false;
            this.saveCurrentState("move selection");
        }
        if (this.resizedByCursor) {
            this.resizedByCursor = false;
            this.saveCurrentState("resize selection");
        }
        if (this.mode == 11 || this.mode == 12) {
            this.mode = 1;
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
        }
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void keyTyped(char c, KeyEvent keyEvent) {
        if (Tool.controlDown && c != '@' && c != '~' && c != '|' && c != '\\') {
            return;
        }
        if (this.plate.hasSelection()) {
            Rectangle rectangle = this.plate.getSelectionRegion();
            this.jave.doSelectionDelete();
            this.jave.switchToTextTool(c, rectangle.x, rectangle.y);
            return;
        }
    }

    protected void dropSelection() {
        this.plate.dropSelection();
        this.mode = 1;
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.saveCurrentState("drop selection");
        this.repaintAll();
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        this.location2 = null;
        this.location1 = point2;
        this.point1 = point;
        if (mouseEvent.isMetaDown()) {
            this.location1 = null;
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
        }
        if (this.plate.hasSelection() && Tool.shiftDown) {
            this.mode = 11;
            this.selectionMousePressedStarted(point2);
            return;
        }
        if (this.plate.hasSelection() && Tool.controlDown) {
            this.mode = 12;
            this.selectionMousePressedStarted(point2);
            return;
        }
        if (this.plate.hasSelection() && (mouseEvent.isMetaDown() || !this.plate.selectionContains(point2))) {
            this.dropSelection();
            this.mode = 10;
            this.selectionMousePressedStarted(point2);
            return;
        }
        if (point2 == null) {
            return;
        }
        if (this.plate.hasSelection()) {
            Selection selection = this.plate.getSelection();
            int n = selection.getPlace(point);
            if (n == 1) {
                this.mode = 0;
            } else if (n == 0) {
                this.mode = 10;
                this.selectionMousePressedStarted(point2);
            } else if (n == 2) {
                this.mode = 2;
            } else if (n == 4) {
                this.mode = 3;
            } else if (n == 3) {
                this.mode = 4;
            } else if (n == 5) {
                this.mode = 5;
            } else if (n == 7) {
                this.mode = 7;
            } else if (n == 6) {
                this.mode = 6;
            } else if (n == 9) {
                this.mode = 9;
            } else if (n == 8) {
                this.mode = 8;
            }
        } else {
            this.mode = 10;
            this.selectionMousePressedStarted(point2);
        }
    }

    protected void selectionMousePressedStarted(Point point) {
        this.location1 = point;
    }

    protected void selectionMouseDragged(Point point) {
        if (point.equals(this.location2)) {
            return;
        }
        this.location2 = point;
        this.repaintCursor();
    }

    protected void selectionMouseReleasedFinished(Point point) {
        Rectangle rectangle = Tool.getRectangleFor(this.location1, point);
        this.dx = 0;
        this.dy = 0;
        this.location1 = null;
        if (this.mode == 10) {
            CharacterPlate characterPlate = this.plate.cut(rectangle);
            this.plate.getSelection().set(rectangle, characterPlate);
            this.jave.updateSelectionMenu();
            this.synchronizeToSelection();
            this.repaintAll();
            this.plate.saveCurrentState("select");
        } else if (this.mode == 11) {
            boolean bl = this.plate.getSelection().add(rectangle);
            if (!bl) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                this.plate.saveCurrentState("modify selection");
            }
        } else if (this.mode == 12) {
            boolean bl = this.plate.getSelection().remove(rectangle);
            if (!bl) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                if (this.plate.hasSelection()) {
                    this.plate.saveCurrentState("modify selection");
                } else {
                    this.plate.saveCurrentState("drop selection");
                    this.jave.switchToTextTool();
                }
            }
        }
        this.mode = 1;
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 != null) {
            this.showStatus("(" + point2.x + "," + point2.y + ")");
        }
        if (this.mode == 11) {
            if (this.location1 == null || point2 == null || mouseEvent.isMetaDown()) {
                this.mode = 1;
                this.location1 = null;
                return;
            }
            this.selectionMouseReleasedFinished(point2);
            return;
        }
        if (this.mode == 12) {
            if (this.location1 == null || point2 == null || mouseEvent.isMetaDown()) {
                this.mode = 1;
                this.location1 = null;
                return;
            }
            this.selectionMouseReleasedFinished(point2);
            return;
        }
        if (this.plate.hasSelection()) {
            this.dx = 0;
            this.dy = 0;
            this.gdx = 0;
            this.gdy = 0;
            this.location1 = null;
            this.point1 = null;
            if (this.selectionResized) {
                this.plate.saveCurrentState("resize selection");
                this.selectionResized = false;
            }
            if (this.selectionMoved) {
                this.plate.saveCurrentState("move selection");
                this.selectionMoved = false;
            }
            return;
        }
        if (mouseEvent.isMetaDown() && this.location2 != null) {
            this.location2 = null;
            this.location1 = null;
            this.repaintCursor();
            return;
        }
        if (this.location1 == null || point2 == null || mouseEvent.isMetaDown()) {
            return;
        }
        if (!(GfxTools.distance(point, this.point1) >= 3.0)) {
            int n = point2.x;
            int n2 = point2.y;
            this.location1 = null;
            this.location2 = null;
            this.jave.switchToTextTool(n, n2);
            return;
        }
        this.selectionMouseReleasedFinished(point2);
    }

    public void mouseClicked(Point point, Point point2, MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.plate.hasSelection()) {
            Selection selection = this.plate.getSelection();
            if (selection.contains(point2) && selection.isTextbox()) {
                char[][] cArray = selection.getContent().getContent();
                char[][] cArray2 = new char[cArray.length - 2][cArray[0].length - 2];
                int n = 0;
                while (n < cArray2.length) {
                    int n2 = 0;
                    while (n2 < cArray2[0].length) {
                        cArray2[n][n2] = cArray[n + 1][n2 + 1];
                        ++n2;
                    }
                    ++n;
                }
                this.jave.editTextBox(TextTools.toString(cArray2), selection.getLocation(), selection.getTextboxStyle());
            }
            return;
        }
        if (mouseEvent.isMetaDown() || !this.plate.selectionContains(point2)) {
            if (this.plate.hasSelection()) {
                this.dropSelection();
            }
            if (point2 != null) {
                this.jave.switchToTextTool(point2.x, point2.y);
            }
            return;
        }
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.mode == 1 || mouseEvent.isMetaDown()) {
            return;
        }
        if (this.mode == 12 || this.mode == 11) {
            this.selectionMouseDragged(point2);
            return;
        }
        if (this.plate.hasSelection()) {
            if (point2 == null || this.point1 == null) {
                return;
            }
            int n = (point.x - this.point1.x) / this.plate.charWidth;
            int n2 = (point.y - this.point1.y) / this.plate.charHeight;
            if (n != this.dx || n2 != this.dy) {
                if (this.mode == 0) {
                    int n3 = n - this.dx;
                    int n4 = n2 - this.dy;
                    while (n3 < 0 && this.gdx > 0) {
                        ++n3;
                        --this.gdx;
                    }
                    while (n3 > 0 && this.gdx < 0) {
                        --n3;
                        ++this.gdx;
                    }
                    while (n4 < 0 && this.gdy > 0) {
                        ++n4;
                        --this.gdy;
                    }
                    while (n4 > 0 && this.gdy < 0) {
                        --n4;
                        ++this.gdy;
                    }
                    Point point3 = this.plate.moveSelection(n3, n4, this.cbCollision.getState());
                    Point point4 = this.plate.ensureVisible(point2.x, point2.y);
                    Selection selection = this.plate.getSelection();
                    selection.move(point4.x, point4.y);
                    this.gdx += n3 - point3.x;
                    this.gdy += n4 - point3.y;
                    this.selectionMoved = true;
                } else {
                    this.resize(n - this.dx, n2 - this.dy);
                    this.selectionResized = true;
                }
                this.dx = n;
                this.dy = n2;
                StringBuffer stringBuffer = new StringBuffer("[");
                if (this.dx > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(this.dx);
                stringBuffer.append(',');
                if (this.dy > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(this.dy);
                stringBuffer.append(']');
                this.showStatus(stringBuffer.toString());
            }
            return;
        }
        if (point2 == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintAll();
            }
            return;
        }
        this.selectionMouseDragged(point2);
    }

    protected void resize(int n, int n2) {
        Selection selection = this.plate.getSelection();
        switch (this.mode) {
            case 2: {
                selection.resizeTextboxN(n2);
                break;
            }
            case 3: {
                selection.resizeTextboxS(n2);
                break;
            }
            case 4: {
                selection.resizeTextboxW(n);
                break;
            }
            case 5: {
                selection.resizeTextboxE(n);
                break;
            }
            case 6: {
                selection.resizeTextboxN(n2);
                selection.resizeTextboxE(n);
                break;
            }
            case 7: {
                selection.resizeTextboxN(n2);
                selection.resizeTextboxW(n);
                break;
            }
            case 8: {
                selection.resizeTextboxS(n2);
                selection.resizeTextboxE(n);
                break;
            }
            case 9: {
                selection.resizeTextboxS(n2);
                selection.resizeTextboxW(n);
            }
        }
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
        super.mouseMoved(point, point2, mouseEvent);
        if (this.plate.hasSelection() && point2 != null) {
            Selection selection = this.plate.getSelection();
            int n = selection.getPlace(point);
            if (n == 1) {
                if (Tool.shiftDown) {
                    this.setCursor(JaveGlobalRessources.cursorSelectionPlus);
                } else if (Tool.controlDown) {
                    this.setCursor(JaveGlobalRessources.cursorSelectionMinus);
                } else if (selection.contains(point2)) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    this.setCursor(JaveGlobalRessources.cursorSelection);
                }
            } else if (n == 0) {
                if (Tool.shiftDown) {
                    this.setCursor(JaveGlobalRessources.cursorSelectionPlus);
                } else if (Tool.controlDown) {
                    this.setCursor(JaveGlobalRessources.cursorSelectionMinus);
                } else {
                    this.setCursor(JaveGlobalRessources.cursorSelection);
                }
            } else if (n == 2) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (n == 4) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (n == 3) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (n == 5) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (n == 7) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (n == 6) {
                this.setCursor(Cursor.getPredefinedCursor(7));
            } else if (n == 9) {
                this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (n == 8) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            }
        } else if (this.plate.hasSelection()) {
            if (Tool.shiftDown) {
                this.setCursor(JaveGlobalRessources.cursorSelectionPlus);
            } else if (Tool.controlDown) {
                this.setCursor(JaveGlobalRessources.cursorSelectionMinus);
            } else {
                this.setCursor(JaveGlobalRessources.cursorSelection);
            }
        } else {
            this.setCursor(JaveGlobalRessources.cursorSelection);
        }
    }
}

