/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GTextArea;
import de.jave.jave.Jave;
import de.jave.jave.ResultConverter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ResultDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    protected static final ResultConverter[] CONVERTERS = new ResultConverter[]{new ResultConverter("plain text", "", "", "", false), new ResultConverter("HTML", "<pre>", "", "</pre>", true), new ResultConverter("JavaDoc comment", "/**\n", "* ", "\n*/", true), new ResultConverter("Java comment", "/*\n", "", "\n*/", false), new ResultConverter("Shell comment", "", "# ", "", false), new ResultConverter("C++ comment", "", "// ", "", false), new ResultConverter("C comment", "/*\n", "", "\n*/", false), new ResultConverter("HTML comment", "<!--\n", "", "\n-->", false), new ResultConverter("Modula2 comment", "(*\n", "", "\n*)", false), new ResultConverter("TeX comment", "", "% ", "", false), new ResultConverter("TeX text", "\\begin{verbatim}", "", "\\end{verbatim}", false)};
    protected GTextArea taText;
    protected Button bClipboard;
    protected Button bClose;
    protected Button bTrim;
    protected Choice chComment;
    protected int mode;
    protected String original;

    public ResultDialog(Jave jave, String string, Font font) {
        super(jave, "Result Output", false);
        this.original = string;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.taText = new GTextArea(string, 24, 85, 1);
        if (font != null) {
            this.taText.setFont(font);
        }
        this.taText.setEditable(false);
        this.add((Component)this.taText, "Center");
        this.taText.selectAll();
        Panel panel = new Panel();
        panel.add(new Label("Format:", 2));
        this.chComment = new Choice();
        int n = 0;
        while (n < CONVERTERS.length) {
            this.chComment.addItem(CONVERTERS[n].getName());
            ++n;
        }
        this.chComment.select(0);
        this.mode = 0;
        this.chComment.addItemListener(this);
        panel.add(this.chComment);
        this.bTrim = new Button("Trim");
        this.bTrim.addActionListener(this);
        panel.add(this.bTrim);
        this.bClipboard = new Button("Copy to System Clipboard");
        panel.add(this.bClipboard);
        if (jave.getSystemCapabilities().canUseSystemClipboard) {
            this.bClipboard.addActionListener(this);
        } else {
            this.bClipboard.setEnabled(false);
        }
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        panel.add(this.bClose);
        this.add((Component)panel, "South");
        this.pack();
        this.show();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            this.dispose();
        }
        if (object == this.bClipboard) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.taText.getText());
            clipboard.setContents(stringSelection, stringSelection);
        } else if (object == this.bTrim) {
            this.trim();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chComment) {
            this.setCommentMode(this.chComment.getSelectedIndex());
        }
    }

    protected void setCommentMode(int n) {
        this.mode = n;
        this.taText.setText(CONVERTERS[n].convert(this.original));
        this.taText.selectAll();
    }

    protected void trim() {
        this.taText.setText(this.original);
        this.taText.trim();
        this.taText.selectAll();
        this.original = this.taText.getText();
        this.setCommentMode(this.mode);
    }
}

