/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.CharField;
import de.jave.gui.GGridLayout2;
import de.jave.gui.Gap;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.RectangleAlgorithm;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class RectangleStylePanel
extends Panel
implements ItemListener,
TextListener,
ItemSelectable {
    protected Choice chMode;
    protected CharField[] charFields;
    protected Plate plate;
    transient ItemListener itemListener;
    protected static final String USER_DEFINED = "User Defined";

    public RectangleStylePanel(Plate plate) {
        this.plate = plate;
        this.chMode = new Choice();
        int n = 0;
        while (n < RectangleAlgorithm.RECTANGLE_STYLES.length) {
            this.chMode.addItem(RectangleAlgorithm.RECTANGLE_STYLES[n]);
            ++n;
        }
        this.chMode.addItem(USER_DEFINED);
        this.chMode.select(0);
        this.chMode.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        panel.add(new Label("Style:"));
        panel.add(this.chMode);
        char[] cArray = RectangleAlgorithm.getCharsForStyle(0);
        this.charFields = new CharField[8];
        int n2 = 0;
        while (n2 < 8) {
            this.charFields[n2] = new CharField(cArray[n2]);
            this.charFields[n2].setFont(JaveGlobalRessources.FONT_DEFAULT);
            this.charFields[n2].addTextListener(this);
            ++n2;
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GGridLayout2(3, 0, 0, 0));
        panel2.add(this.charFields[0]);
        panel2.add(this.charFields[1]);
        panel2.add(this.charFields[2]);
        panel2.add(this.charFields[3]);
        panel2.add(new Gap(55, 5));
        panel2.add(this.charFields[4]);
        panel2.add(this.charFields[5]);
        panel2.add(this.charFields[6]);
        panel2.add(this.charFields[7]);
        this.setLayout(new BorderLayout(2, 3));
        this.add((Component)panel, "North");
        this.add((Component)panel2, "South");
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public boolean isUnderLineStyle() {
        return this.charFields[1].getChar() == '_';
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.chMode.getSelectedIndex();
        if (n == 7) {
            char c = this.plate.getMouseChar();
            int n2 = 0;
            while (n2 < 8) {
                this.charFields[n2].setChar(c);
                this.charFields[n2].setEditable(false);
                ++n2;
            }
        } else {
            char[] cArray = RectangleAlgorithm.getCharsForStyle(n);
            int n3 = 0;
            while (n3 < 8) {
                this.charFields[n3].setChar(cArray[n3]);
                this.charFields[n3].setEditable(true);
                ++n3;
            }
        }
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, null, 1));
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.chMode.select(USER_DEFINED);
        RectangleAlgorithm.setUserDefinedChars(this.getCurrentChars());
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, null, 1));
        }
    }

    public void setStyle(int n) {
        if (n < 0 || n >= this.chMode.getItemCount()) {
            System.err.println("WARNING: No such style in RectangleStylePanel: " + n);
            return;
        }
        this.chMode.select(n);
        this.itemStateChanged(null);
    }

    public char[] getCurrentChars() {
        char[] cArray = new char[8];
        int n = 0;
        while (n < 8) {
            cArray[n] = this.charFields[n].getChar();
            ++n;
        }
        return cArray;
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.getCurrentChars()};
    }
}

