/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.PixelPlate;
import java.awt.Rectangle;

public class RectangleAlgorithm {
    private static final char[][] RECTANGLE_CHARACTERS = new char[][]{{'+', '-', '+', '|', '|', '+', '-', '+'}, {' ', '_', ' ', '|', '|', '|', '_', '|'}, {'.', '-', '.', '|', '|', '`', '-', '\''}, {'\\', '-', '/', '|', '|', '/', '-', '\\'}, {'/', '-', '\\', '|', '|', '\\', '-', '/'}, {'O', '-', 'O', '|', '|', 'O', '-', 'O'}, {')', '-', '(', '|', '|', ')', '-', '('}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}};
    private static char[] userDefinedChars = new char[]{'+', '-', '+', '|', '|', '+', '-', '+'};
    public static final String[] RECTANGLE_STYLES = new String[]{"Normal", "Underscore", "Round", "Style 1", "Style 2", "Style 3", "Style 4", "Characters"};
    public static final int CHARACTERS = 7;

    public static void setUserDefinedChars(char[] cArray) {
        userDefinedChars = cArray;
    }

    public static char[] getCharsForStyle(int n) {
        if (n < 0 || n >= RECTANGLE_CHARACTERS.length) {
            return userDefinedChars;
        }
        return RECTANGLE_CHARACTERS[n];
    }

    public static int getRectangleStyle(char[][] cArray) {
        if (cArray == null) {
            return -1;
        }
        int n = cArray.length;
        int n2 = cArray[0].length;
        if (n2 < 3 || n < 3) {
            return -1;
        }
        char c = cArray[0][0];
        char c2 = cArray[0][1];
        char c3 = cArray[0][n2 - 2];
        char c4 = cArray[0][n2 - 1];
        char c5 = cArray[1][0];
        char c6 = cArray[1][n2 - 1];
        char c7 = cArray[n - 2][0];
        char c8 = cArray[n - 2][n2 - 1];
        char c9 = cArray[n - 1][0];
        char c10 = cArray[n - 1][1];
        char c11 = cArray[n - 1][n2 - 2];
        char c12 = cArray[n - 1][n2 - 1];
        if (c2 != c3 || c5 != c7 || c6 != c8 || c10 != c11) {
            return -1;
        }
        if (c2 == ' ' || c5 == ' ' || c6 == ' ' || c10 == ' ') {
            return -1;
        }
        char[] cArray2 = new char[]{c, c2, c4, c5, c6, c9, c10, c12};
        int n3 = 0;
        while (n3 <= RECTANGLE_CHARACTERS.length) {
            char[] cArray3 = RectangleAlgorithm.getCharsForStyle(n3);
            boolean bl = true;
            int n4 = 0;
            while (bl && n4 < cArray3.length) {
                bl = cArray3[n4] == cArray2[n4];
                ++n4;
            }
            if (bl) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static void drawRectangle(CharacterPlate characterPlate, Rectangle rectangle, int n) {
        RectangleAlgorithm.drawRectangle(characterPlate, rectangle, RectangleAlgorithm.getCharsForStyle(n));
    }

    public static void drawRectangle(CharacterPlate characterPlate, Rectangle rectangle, char[] cArray) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = n + 1;
        while (n5 <= n3 - 1) {
            characterPlate.set(n5, n2, cArray[1]);
            characterPlate.set(n5, n4, cArray[6]);
            ++n5;
        }
        int n6 = n2 + 1;
        while (n6 <= n4 - 1) {
            characterPlate.set(n, n6, cArray[3]);
            characterPlate.set(n3, n6, cArray[4]);
            ++n6;
        }
        characterPlate.set(n, n2, cArray[0]);
        characterPlate.set(n3, n2, cArray[2]);
        characterPlate.set(n, n4, cArray[5]);
        characterPlate.set(n3, n4, cArray[7]);
    }

    public static void drawRectangle(PixelPlate pixelPlate, Rectangle rectangle, char[] cArray) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = n + 1;
        while (n5 <= n3 - 1) {
            pixelPlate.set(n5, n2, cArray[1]);
            pixelPlate.set(n5, n4, cArray[6]);
            ++n5;
        }
        int n6 = n2 + 1;
        while (n6 <= n4 - 1) {
            pixelPlate.set(n, n6, cArray[3]);
            pixelPlate.set(n3, n6, cArray[4]);
            ++n6;
        }
        pixelPlate.set(n, n2, cArray[0]);
        pixelPlate.set(n3, n2, cArray[2]);
        pixelPlate.set(n, n4, cArray[5]);
        pixelPlate.set(n3, n4, cArray[7]);
    }
}

