/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.BezierAlgorithm;
import de.jave.jave.CharacterDrawable;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Filter;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class PixelPlate
implements CharacterDrawable,
JaveConfigurationLoadable {
    protected char[][] pixels;
    protected CharacterPlate plate;
    protected int width;
    protected int height;
    protected int originX;
    protected int originY;
    protected static char[] rules;
    protected static char[] rulesThick;
    protected static final char[] TWO_BY_TWO_CHARS;
    protected static final char[] THREE_BY_TWO_CHARS;
    public static final int MODE_PIXEL = 0;
    public static final int MODE_CHAR = 1;
    public static final int MODE_DOT = 2;
    public static final int MODE_FELTPEN = 3;
    public static final int MODE_TWO_BY_TWO = 4;
    public static final int MODE_THICK_THIN = 5;
    public static final int MODE_THREE_BY_TWO = 13;
    public static final int MODE_FELTPEN_8 = 6;
    public static final int MODE_FELTPEN_M = 7;
    public static final int MODE_FELTPEN_X = 8;
    public static final int MODE_FELTPEN_O = 9;
    public static final int MODE_FELTPEN_DOLLAR = 10;
    public static final int MODE_FELTPEN_COLON = 11;
    public static final int MODE_FELTPEN_EXCLAM = 12;
    public static final String[] FELTPEN_CHARS;
    public static final int DEFAULT_FELTPEN_CHAR_INDEX = 4;
    public static int[] FELTPEN_GRADIENT_MODES;
    protected static final int CONVERTER_RAW = 0;
    protected static final int CONVERTER_LINE = 1;
    protected static final int CONVERTER_THICK = 2;
    protected static final int CONVERTER_TWO_BY_TWO = 3;
    protected static final int CONVERTER_DOT = 4;
    protected static final int CONVERTER_THREE_BY_TWO = 5;
    protected int raster;
    protected int rasterX;
    protected int rasterY;
    protected int converter;
    protected int pencilSize;
    protected char character;
    protected static boolean initialized;
    protected int configIndex;
    protected char feltPenChar;
    protected static final char[] DOT_TABLE;
    protected static final char[][] RULES_TABLE;
    protected static final char[][] RULES_THICK_TABLE;

    protected PixelPlate(int n) {
        this.configIndex = n;
    }

    public PixelPlate(int n, int n2, int n3, int n4) {
        this.originX = n;
        this.originY = n2;
        this.width = n3;
        this.height = n4;
        this.pixels = new char[n4][n3];
        this.setMode(0);
        this.character = (char)88;
    }

    public PixelPlate(char[][] cArray, int n, int n2) {
        this.originX = n;
        this.originY = n2;
        this.pixels = cArray;
        this.width = cArray[0].length;
        this.height = cArray.length;
        this.setMode(0);
        this.character = (char)88;
    }

    public void setMode(int n) {
        switch (n) {
            case 0: {
                this.setMode(0, ' ', 1);
                return;
            }
            case 1: {
                this.setMode(1, ' ', 1);
                return;
            }
            case 6: {
                this.setMode(3, '8', 1);
                return;
            }
            case 7: {
                this.setMode(3, 'M', 1);
                return;
            }
            case 10: {
                this.setMode(3, '$', 1);
                return;
            }
            case 11: {
                this.setMode(3, ':', 1);
                return;
            }
            case 12: {
                this.setMode(3, '!', 1);
                return;
            }
            case 4: {
                this.setMode(4, ' ', 1);
                return;
            }
            case 13: {
                this.setMode(13, ' ', 1);
                return;
            }
            case 5: {
                this.setMode(3, '8', 0);
                return;
            }
            case 2: {
                this.setMode(2, ' ', 1);
                return;
            }
        }
    }

    public void setMode(int n, char c, int n2) {
        this.feltPenChar = c;
        switch (n) {
            case 0: {
                this.rasterX = 3;
                this.rasterY = 4;
                this.converter = 1;
                this.pencilSize = 1;
                break;
            }
            case 1: {
                this.rasterX = 1;
                this.rasterY = 1;
                this.converter = 0;
                this.pencilSize = 1;
                break;
            }
            case 2: {
                this.rasterX = 1;
                this.rasterY = 2;
                this.converter = 4;
                this.pencilSize = 1;
                break;
            }
            case 3: {
                this.rasterX = 3;
                this.rasterY = 4;
                this.converter = 2;
                this.pencilSize = n2 + 1;
                break;
            }
            case 4: {
                this.rasterX = 2;
                this.rasterY = 2;
                this.converter = 3;
                this.pencilSize = 1;
                break;
            }
            case 13: {
                this.rasterX = 2;
                this.rasterY = 3;
                this.converter = 5;
                this.pencilSize = 1;
            }
        }
    }

    public static void init() {
        Filter.init();
        PixelPlate.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new PixelPlate(0));
        JaveConfigurationFileLoader.initConfigFile(frame, new PixelPlate(1));
        initialized = true;
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public String getConfigurationFileName() {
        if (this.configIndex == 0) {
            return "./config/convert.txt";
        }
        return "./config/convert_thick.txt";
    }

    public void setDefaultConfiguration() {
        if (this.configIndex == 0) {
            rules = new char[4096];
            int n = 0;
            while (n < RULES_TABLE.length) {
                PixelPlate.rules[PixelPlate.RULES_TABLE[n][0]] = RULES_TABLE[n][1];
                ++n;
            }
        } else {
            rulesThick = new char[4096];
            int n = 0;
            while (n < RULES_THICK_TABLE.length) {
                PixelPlate.rulesThick[PixelPlate.RULES_THICK_TABLE[n][0]] = RULES_THICK_TABLE[n][1];
                ++n;
            }
        }
    }

    public void loadConfiguration(File file) throws Exception {
        if (this.configIndex == 0) {
            rules = PixelPlate.loadRules(file);
        } else {
            rulesThick = PixelPlate.loadRules(file);
        }
    }

    protected static char[] loadRules(File file) throws Exception {
        char[] cArray = new char[4096];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = '\u0000';
            ++n;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = new String[4];
        int n2 = 0;
        int n3 = 0;
        while (stringArray != null) {
            String string = bufferedReader.readLine();
            ++n3;
            while (string != null && (string.length() < 3 || string.charAt(0) == '#')) {
                string = bufferedReader.readLine();
                ++n3;
            }
            if (string == null) break;
            stringArray[0] = string;
            int n4 = 1;
            while (n4 < stringArray.length) {
                stringArray[n4] = bufferedReader.readLine();
                ++n3;
                if (stringArray[n4] == null) {
                    stringArray = null;
                    break;
                }
                ++n4;
            }
            if (stringArray == null) continue;
            char[] cArray2 = new char[12];
            char c = stringArray[3].charAt(8);
            boolean bl = false;
            int n5 = 0;
            while (n5 < 3) {
                int n6 = 0;
                while (n6 < 4) {
                    cArray2[n5 * 4 + n6] = stringArray[n6].length() <= n5 ? 46 : stringArray[n6].charAt(n5);
                    ++n6;
                }
                ++n5;
            }
            PixelPlate.addRule(n3 - 4, n2++, cArray2, c, cArray);
        }
        bufferedReader.close();
        int n7 = 0;
        int n8 = 0;
        n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != '\u0000') {
                ++n7;
            } else {
                ++n8;
            }
            ++n2;
        }
        return cArray;
    }

    public void setSize(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return;
        }
        char[][] cArray = this.pixels;
        this.pixels = new char[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.pixels[n3][n4] = n3 < this.height && n4 < this.width ? cArray[n3][n4] : (char)'\u0000';
                ++n4;
            }
            ++n3;
        }
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getVirtualWidth() {
        return this.width * this.rasterX;
    }

    public int getHeight() {
        return this.height;
    }

    public int getVirtualHeight() {
        return this.height * this.rasterY;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public void removeNoise(int n) {
        int n2;
        int n3;
        int n4 = this.width * this.rasterX;
        int n5 = this.height * this.rasterY;
        boolean[][] blArray = new boolean[n5][n4];
        int n6 = 0;
        while (n6 < n4) {
            n3 = 0;
            while (n3 < n5) {
                blArray[n3][n6] = false;
                n2 = 0;
                if (n3 - 1 >= 0 && this.isSet(n6, n3 - 1)) {
                    ++n2;
                }
                if (n2 <= n) {
                    if (n3 - 1 >= 0 && n6 + 1 < n4 && this.isSet(n6 + 1, n3 - 1)) {
                        ++n2;
                    }
                    if (n2 <= n) {
                        if (n6 + 1 < n4 && this.isSet(n6 + 1, n3)) {
                            ++n2;
                        }
                        if (n2 <= n) {
                            if (n3 + 1 < n5 && n6 + 1 < n4 && this.isSet(n6 + 1, n3 + 1)) {
                                ++n2;
                            }
                            if (n2 <= n) {
                                if (n3 + 1 < n5 && this.isSet(n6, n3 + 1)) {
                                    ++n2;
                                }
                                if (n2 <= n) {
                                    if (n3 + 1 < n5 && n6 - 1 >= 0 && this.isSet(n6 - 1, n3 + 1)) {
                                        ++n2;
                                    }
                                    if (n2 <= n) {
                                        if (n6 - 1 >= 0 && this.isSet(n6 - 1, n3)) {
                                            ++n2;
                                        }
                                        if (n2 <= n) {
                                            if (n3 - 1 >= 0 && n6 - 1 >= 0 && this.isSet(n6 - 1, n3 - 1)) {
                                                ++n2;
                                            }
                                            if (n2 <= n) {
                                                blArray[n3][n6] = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++n3;
            }
            ++n6;
        }
        n3 = 0;
        while (n3 < n4) {
            n2 = 0;
            while (n2 < n5) {
                if (blArray[n2][n3]) {
                    this.setInternal(n3, n2, false);
                }
                ++n2;
            }
            ++n3;
        }
    }

    public void setCharacter(char c) {
        this.character = c;
    }

    public char getCharacter() {
        return this.character;
    }

    public void clear() {
        if (this.height == 0) {
            return;
        }
        int n = 0;
        while (n < this.width) {
            this.pixels[0][n] = '\u0000';
            ++n;
        }
        int n2 = 1;
        while (n2 < this.height) {
            System.arraycopy(this.pixels[0], 0, this.pixels[n2], 0, this.width);
            ++n2;
        }
    }

    public void drawArc(Point2d point2d, double d, double d2, double d3, double d4) {
        int n = this.getPhysicalX(point2d.x);
        int n2 = this.getPhysicalY(point2d.y);
        int n3 = this.getPhysicalX(d);
        int n4 = this.getPhysicalY(d2);
        this.drawArc(n, n2, n3, n4, d3, d4);
    }

    protected void drawArc(int n, int n2, int n3, int n4, double d, double d2) {
        double d3;
        double d4;
        if (n3 == 0 || n4 == 0) {
            this.set(n, n2, n, n, n2, n2);
            return;
        }
        if (d2 < 0.0) {
            d += d2;
            d2 = -d2;
        }
        if ((d %= 360.0) + d2 >= 270.0 && d <= 360.0 || d + d2 >= 630.0 && d <= 720.0) {
            d4 = d - 270.0;
            d3 = (d + d2) % 360.0;
            d3 = d3 < 270.0 ? 90.0 : (d3 %= 270.0);
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d4 > 90.0) {
                d4 = 90.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                this.drawArcSE(n, n2, n3, n4, 0.0, d3);
                this.drawArcSE(n, n2, n3, n4, d4, 90.0);
            } else {
                this.drawArcSE(n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 180.0 && d <= 270.0 || d + d2 >= 540.0 && d <= 630.0) {
            d4 = d - 180.0;
            d3 = (d + d2) % 360.0;
            d3 = d3 < 180.0 ? 90.0 : (d3 %= 180.0);
            if (d4 < 0.0 || d4 > 90.0) {
                d4 = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                this.drawArcSW(n, n2, n3, n4, 0.0, d3);
                this.drawArcSW(n, n2, n3, n4, d4, 90.0);
            } else {
                this.drawArcSW(n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 90.0 && d <= 180.0 || d + d2 >= 450.0 && d <= 540.0) {
            d4 = d - 90.0;
            if (d < 90.0) {
                d4 = 0.0;
            } else if (d > 180.0) {
                d4 = 0.0;
            }
            d3 = (d + d2) % 360.0;
            d3 = d3 > 180.0 ? 90.0 : (d3 < 90.0 ? 90.0 : (d3 %= 90.0));
            if (d3 < d4) {
                this.drawArcNW(n, n2, n3, n4, 0.0, d3);
                this.drawArcNW(n, n2, n3, n4, d4, 90.0);
            } else {
                this.drawArcNW(n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 0.0 && d <= 90.0 || d + d2 >= 360.0 && d <= 450.0) {
            d4 = d;
            d3 = (d + d2) % 360.0;
            if (d4 > 90.0) {
                d4 = 0.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                this.drawArcNE(n, n2, n3, n4, 0.0, d3);
                this.drawArcNE(n, n2, n3, n4, d4, 90.0);
            } else {
                this.drawArcNE(n, n2, n3, n4, d4, d3);
            }
        }
    }

    protected void drawArcSE(int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n;
        int n6 = n + n3;
        int n7 = n2;
        int n8 = n2 + n4;
        if (d > 0.0) {
            n5 = n + (int)((double)n3 * Math.sin(d / 180.0 * Math.PI));
            n8 = n2 + (int)((double)n4 * Math.cos(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n6 = n + (int)((double)n3 * Math.sin(d2 / 180.0 * Math.PI));
            n7 = n2 + (int)((double)n4 * Math.cos(d2 / 180.0 * Math.PI));
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        this.set(n + n9, n2 + n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    this.set(n + n9, n2 + n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
            this.set(n + n9, n2, n5, n6, n7, n8);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        this.set(n + n16, n2 + n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    this.set(n + n16, n2 + n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            this.set(n, n2 + n15, n5, n6, n7, n8);
        }
    }

    protected void drawArcSW(int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n - n3;
        int n6 = n;
        int n7 = n2;
        int n8 = n2 + n4;
        if (d > 0.0) {
            n5 = n - (int)((double)n3 * Math.cos(d / 180.0 * Math.PI));
            n7 = n2 + (int)((double)n4 * Math.sin(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n6 = n - (int)((double)n3 * Math.cos(d2 / 180.0 * Math.PI));
            n8 = n2 + (int)((double)n4 * Math.sin(d2 / 180.0 * Math.PI));
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        this.set(n - n9, n2 + n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    this.set(n - n9, n2 + n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
            this.set(n - n9, n2, n5, n6, n7, n8);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        this.set(n - n16, n2 + n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    this.set(n - n16, n2 + n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            this.set(n, n2 + n15, n5, n6, n7, n8);
        }
    }

    protected void drawArcNW(int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n - n3;
        int n6 = n;
        int n7 = n2 - n4;
        int n8 = n2;
        if (d > 0.0) {
            n6 = n - (int)((double)n3 * Math.sin(d / 180.0 * Math.PI));
            n7 = n2 - (int)((double)n4 * Math.cos(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n5 = n - (int)((double)n3 * Math.sin(d2 / 180.0 * Math.PI));
            n8 = n2 - (int)((double)n4 * Math.cos(d2 / 180.0 * Math.PI));
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        this.set(n - n9, n2 - n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    this.set(n - n9, n2 - n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        this.set(n - n16, n2 - n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    this.set(n - n16, n2 - n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            this.set(n, n2 - n15, n5, n6, n7, n8);
        }
    }

    protected void drawArcNE(int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n;
        int n6 = n + n3;
        int n7 = n2 - n4;
        int n8 = n2;
        if (d > 0.0) {
            n6 = n + (int)((double)n3 * Math.cos(d / 180.0 * Math.PI));
            n8 = n2 - (int)((double)n4 * Math.sin(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n5 = n + (int)((double)n3 * Math.cos(d2 / 180.0 * Math.PI));
            n7 = n2 - (int)((double)n4 * Math.sin(d2 / 180.0 * Math.PI));
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        this.set(n + n9, n2 - n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    this.set(n + n9, n2 - n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        this.set(n + n16, n2 - n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    this.set(n + n16, n2 - n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            this.set(n, n2 - n15, n5, n6, n7, n8);
        }
    }

    protected final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n3 && n2 < n5 || n2 > n6 && n > n4 || n < n3 - 1 || n > n4 + 1 || n2 < n5 - 1 || n2 > n6 + 1) {
            return;
        }
        this.set(n, n2);
    }

    public void drawBezier(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        Point2d[] point2dArray = new Point2d[]{point2d, point2d2, point2d3};
        Point2d[] point2dArray2 = BezierAlgorithm.getPolyLineForBezier(point2dArray, 0.15);
        int n = 0;
        while (n < point2dArray2.length - 1) {
            this.drawLine(point2dArray2[n].x, point2dArray2[n].y, point2dArray2[n + 1].x, point2dArray2[n + 1].y);
            ++n;
        }
    }

    public int getPhysicalX(double d) {
        return (int)(d * (double)this.rasterX);
    }

    public int getPhysicalY(double d) {
        return (int)(d * (double)this.rasterY);
    }

    public void drawEllipse(double d, double d2, double d3, double d4) {
        int n = this.getPhysicalX(d);
        int n2 = this.getPhysicalY(d2);
        int n3 = this.getPhysicalX(d3);
        int n4 = this.getPhysicalY(d4);
        this.drawEllipse(n, n2, n3, n4);
    }

    public void fillEllipse(double d, double d2, double d3, double d4) {
        int n = this.getPhysicalX(d);
        int n2 = this.getPhysicalY(d2);
        int n3 = this.getPhysicalX(d3);
        int n4 = this.getPhysicalY(d4);
        this.fillEllipse(n, n2, n3, n4);
    }

    protected void drawEllipse(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            this.drawLine(n, n2 - n4, n, n2 + n4);
            return;
        }
        if (n4 == 0) {
            this.drawLine(n - n3, n2, n + n3, n2 + n4);
            return;
        }
        if (n4 <= n3) {
            int n5 = 0;
            int n6 = n4;
            int n7 = 0;
            int n8 = n3 * n3;
            int n9 = -n8 / 2;
            int n10 = n8 / n4;
            do {
                if (n9 <= 0) {
                    do {
                        this.set(n + n5, n2 + n6);
                        this.set(n - n5, n2 + n6);
                        this.set(n + n5, n2 - n6);
                        this.set(n - n5, n2 - n6);
                        ++n5;
                    } while ((n9 += (n7 += n4)) <= 0);
                } else {
                    this.set(n + n5, n2 + n6);
                    this.set(n - n5, n2 + n6);
                    this.set(n + n5, n2 - n6);
                    this.set(n - n5, n2 - n6);
                }
                n9 -= (n8 -= n10);
            } while (--n6 != 0);
            this.set(n + n5, n2);
            this.set(n - n5, n2);
        } else {
            int n11 = 0;
            int n12 = n3;
            int n13 = 0;
            int n14 = n4 * n4;
            int n15 = -n14 / 2;
            int n16 = n14 / n3;
            do {
                if (n15 <= 0) {
                    do {
                        this.set(n + n12, n2 + n11);
                        this.set(n - n12, n2 + n11);
                        this.set(n + n12, n2 - n11);
                        this.set(n - n12, n2 - n11);
                        ++n11;
                    } while ((n15 += (n13 += n3)) <= 0);
                } else {
                    this.set(n + n12, n2 + n11);
                    this.set(n - n12, n2 + n11);
                    this.set(n + n12, n2 - n11);
                    this.set(n - n12, n2 - n11);
                }
                n15 -= (n14 -= n16);
            } while (--n12 != 0);
            this.set(n, n2 + n11);
            this.set(n, n2 - n11);
        }
    }

    protected void fillEllipse(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            this.drawLine(n, n2 - n4, n, n2 + n4);
            return;
        }
        if (n4 == 0) {
            this.drawLine(n - n3, n2, n + n3, n2 + n4);
            return;
        }
        this.drawEllipse(n, n2, n3, n4);
        int n5 = this.pencilSize;
        if (n4 <= n3) {
            int n6 = 0;
            int n7 = n4;
            int n8 = 0;
            int n9 = n3 * n3;
            int n10 = -n9 / 2;
            int n11 = n9 / n4;
            do {
                int n12;
                if (n10 <= 0) {
                    do {
                        n12 = n2 - n7;
                        while (n12 <= n2 + n7) {
                            this.set(n + n6, n12);
                            this.set(n - n6, n12);
                            ++n12;
                        }
                        ++n6;
                    } while ((n10 += (n8 += n4)) <= 0);
                } else {
                    n12 = n2 - n7;
                    while (n12 <= n2 + n7) {
                        this.set(n + n6, n12);
                        this.set(n - n6, n12);
                        ++n12;
                    }
                }
                n10 -= (n9 -= n11);
            } while (--n7 != 0);
        } else {
            int n13 = 0;
            int n14 = n3;
            int n15 = 0;
            int n16 = n4 * n4;
            int n17 = -n16 / 2;
            int n18 = n16 / n3;
            do {
                int n19;
                if (n17 <= 0) {
                    do {
                        n19 = n - n14;
                        while (n19 <= n + n14) {
                            this.set(n19, n2 + n13);
                            this.set(n19, n2 - n13);
                            ++n19;
                        }
                        ++n13;
                    } while ((n17 += (n15 += n3)) <= 0);
                } else {
                    n19 = n - n14;
                    while (n19 <= n + n14) {
                        this.set(n19, n2 + n13);
                        this.set(n19, n2 - n13);
                        ++n19;
                    }
                }
                n17 -= (n16 -= n18);
            } while (--n14 != 0);
        }
        this.pencilSize = n5;
    }

    public void paintBackground(Graphics graphics, Plate plate) {
        int n = plate.charWidth;
        int n2 = plate.charHeight;
        Point point = plate.getViewPortOrigin();
        Point point2 = plate.getOrigin();
        int n3 = (this.originX - point2.x) * n + point.x;
        int n4 = (this.originY - point2.y) * n2 + point.y;
        graphics.setColor(JaveGlobalRessources.colorSelectionBackground);
        graphics.fillRect(n3, n4, this.width * n, this.height * n2);
        graphics.setColor(JaveGlobalRessources.colorSelectionText);
        graphics.drawRect(n3, n4, this.width * n, this.height * n2);
    }

    public void paint(Graphics graphics, Plate plate) {
        this.paint(graphics, plate, false);
    }

    public void paint(Graphics graphics, Plate plate, boolean bl) {
        int n = plate.charWidth;
        int n2 = plate.charHeight;
        int n3 = plate.fontAscent;
        Point point = plate.getViewPortOrigin();
        Point point2 = plate.getOrigin();
        int n4 = (this.originX - point2.x) * n + point.x;
        int n5 = (this.originY - point2.y) * n2 + point.y;
        if (bl) {
            double d = (double)n2 / (double)this.rasterY;
            double d2 = (double)n / (double)this.rasterX;
            int n6 = 0;
            while (n6 < this.height) {
                int n7 = 0;
                while (n7 < this.width) {
                    if (this.pixels[n6][n7] != '\u0000') {
                        int n8 = 0;
                        while (n8 < this.rasterX) {
                            int n9 = 0;
                            while (n9 < this.rasterY) {
                                if ((this.pixels[n6][n7] & 1 << n9 + n8 * this.rasterY) > 0) {
                                    graphics.setColor(Color.red);
                                    graphics.drawRect(n4 + 3 + (int)((double)(n7 * n) + (double)n8 * d2), n5 + 3 + (int)((double)(n6 * n2) + (double)n9 * d), 1, 1);
                                } else {
                                    graphics.setColor(Color.black);
                                    graphics.drawLine(n4 + 3 + (int)((double)(n7 * n) + (double)n8 * d2), n5 + 3 + (int)((double)(n6 * n2) + (double)n9 * d), n4 + 3 + (int)((double)(n7 * n) + (double)n8 * d2), n5 + 3 + (int)((double)(n6 * n2) + (double)n9 * d));
                                }
                                ++n9;
                            }
                            ++n8;
                        }
                    }
                    ++n7;
                }
                ++n6;
            }
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolPreview);
        CharacterPlate characterPlate = this.getResult();
        CharacterPlate characterPlate2 = characterPlate.getClone();
        characterPlate2.replace('\u0000', ' ');
        characterPlate2.replace('\u00a0', ' ');
        plate.paintPreview(graphics, characterPlate2, 0, 0, this.originX, this.originY);
        int n10 = plate.getDocumentWidth();
        int n11 = plate.getDocumentHeight();
        graphics.setColor(JaveGlobalRessources.colorToolPreviewDelete);
        int n12 = 0;
        while (n12 < this.height) {
            int n13 = 0;
            while (n13 < this.width) {
                if (characterPlate.get(n13, n12) == ' ' || characterPlate.get(n13, n12) == '\u00a0') {
                    char c;
                    int n14 = this.originX + n13;
                    int n15 = this.originY + n12;
                    if (n14 >= 0 && n15 >= 0 && n14 < n10 && n15 < n11 && (c = plate.getChar(n14, n15)) != ' ') {
                        graphics.drawString(String.valueOf(c), n4 + n13 * n, n5 + n3 + n12 * n2);
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    protected static void printPattern(int n) {
        System.err.print('\n');
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 3) {
                if ((n & 1 << n2 + n3 * 4) > 0) {
                    System.err.print("X");
                } else {
                    System.err.print(".");
                }
                ++n3;
            }
            if (n2 < 3) {
                System.err.print('\n');
            }
            ++n2;
        }
        System.err.print(" -> [ ]\n");
    }

    protected static void addRule(int n, int n2, char[] cArray, char c, char[] cArray2) {
        int n3 = 0;
        while (n3 < 12) {
            if (cArray[n3] == '?') {
                char[] cArray3 = new char[12];
                System.arraycopy(cArray, 0, cArray3, 0, 12);
                cArray3[n3] = 88;
                cArray[n3] = 46;
                PixelPlate.addRule(n, n2, cArray, c, cArray2);
                PixelPlate.addRule(n, n2, cArray3, c, cArray2);
                return;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < 12) {
            if (cArray[n5] == 'X') {
                n4 |= 1 << n5;
            }
            ++n5;
        }
        if (cArray2[n4] != '\u0000' && cArray2[n4] != c) {
            return;
        }
        cArray2[n4] = c;
    }

    public char[][] getContentClone() {
        char[][] cArray = new char[this.height][this.width];
        int n = 0;
        while (n < this.height) {
            System.arraycopy(this.pixels[n], 0, cArray[n], 0, this.width);
            ++n;
        }
        return cArray;
    }

    public void setResult(CharacterPlate characterPlate) {
        this.plate = characterPlate;
    }

    public CharacterPlate getResult() {
        if (this.plate == null) {
            this.convert();
        }
        return this.plate;
    }

    protected final char convertPixel(int n) {
        if (n == 0 || n >= rules.length) {
            return '\u0000';
        }
        char c = rules[n];
        if (c == '\u0000' || c == ' ') {
            return this.convertThick(n);
        }
        return c;
    }

    protected final char convertDot(int n) {
        return DOT_TABLE[n];
    }

    protected final char convertThick(int n) {
        if (n == 0 || n >= rulesThick.length) {
            return '\u0000';
        }
        char c = rulesThick[n];
        if (c == '\u0000') {
            int n2;
            int n3 = 0;
            while (n3 < 12) {
                n2 = n | 1 << n3;
                c = rulesThick[n2];
                if (c != '\u0000') break;
                ++n3;
            }
            if (c == '\u0000') {
                n2 = 0;
                while (n2 < 12) {
                    int n4 = (n | 1 << n2) - (1 << n2);
                    c = rulesThick[n4];
                    if (c != '\u0000') break;
                    ++n2;
                }
                if (c == '\u0000') {
                    c = rules[n];
                }
            }
        }
        return c;
    }

    public void convert() {
        char[][] cArray = new char[this.height][this.width];
        switch (this.converter) {
            case 1: {
                int n = 0;
                while (n < this.height) {
                    int n2 = 0;
                    while (n2 < this.width) {
                        cArray[n][n2] = this.convertPixel(this.pixels[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.height) {
                    int n3 = 0;
                    while (n3 < this.width) {
                        cArray[n][n3] = this.convertDot(this.pixels[n][n3]);
                        ++n3;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.height) {
                    int n4 = 0;
                    while (n4 < this.width) {
                        int n5 = this.convertThick(this.pixels[n][n4]);
                        if (n5 == 32 || n5 == 0) {
                            cArray[n][n4] = '\u0000';
                        } else {
                            if (this.feltPenChar == 'M') {
                                if (n5 == 56) {
                                    n5 = 77;
                                } else if (n5 == 111) {
                                    n5 = 109;
                                }
                            } else if (this.feltPenChar == 'O') {
                                if (n5 == 56) {
                                    n5 = 79;
                                }
                            } else if (this.feltPenChar == 'X') {
                                if (n5 == 56) {
                                    n5 = 88;
                                }
                            } else if (this.feltPenChar == '$') {
                                if (n5 == 56) {
                                    n5 = 36;
                                } else if (n5 == 98) {
                                    n5 = 104;
                                } else if (n5 == 111) {
                                    n5 = 99;
                                } else if (n5 == 80) {
                                    n5 = 70;
                                } else if (n5 == 89) {
                                    n5 = 63;
                                }
                            } else if (this.feltPenChar == '!') {
                                if (n5 == 56) {
                                    n5 = 33;
                                } else if (n5 == 34) {
                                    n5 = 39;
                                } else if (n5 == 111) {
                                    n5 = 46;
                                } else if (n5 == 80) {
                                    n5 = 39;
                                } else if (n5 == 112) {
                                    n5 = 44;
                                } else if (n5 == 100) {
                                    n5 = 44;
                                } else if (n5 == 70) {
                                    n5 = 39;
                                } else if (n5 == 95) {
                                    n5 = 46;
                                } else if (n5 == 76) {
                                    n5 = 46;
                                } else if (n5 == 98) {
                                    n5 = 46;
                                } else if (n5 == 93) {
                                    n5 = 59;
                                } else if (n5 == 91) {
                                    n5 = 59;
                                } else if (n5 == 74) {
                                    n5 = 44;
                                } else if (n5 == 55) {
                                    n5 = 96;
                                } else if (n5 == 89) {
                                    n5 = 96;
                                }
                            } else if (this.feltPenChar == ':') {
                                if (n5 == 56) {
                                    n5 = 58;
                                } else if (n5 == 34) {
                                    n5 = 39;
                                } else if (n5 == 111) {
                                    n5 = 46;
                                } else if (n5 == 80) {
                                    n5 = 39;
                                } else if (n5 == 112) {
                                    n5 = 46;
                                } else if (n5 == 100) {
                                    n5 = 46;
                                } else if (n5 == 70) {
                                    n5 = 39;
                                } else if (n5 == 95) {
                                    n5 = 46;
                                } else if (n5 == 44) {
                                    n5 = 46;
                                } else if (n5 == 76) {
                                    n5 = 46;
                                } else if (n5 == 98) {
                                    n5 = 46;
                                } else if (n5 == 93) {
                                    n5 = 58;
                                } else if (n5 == 91) {
                                    n5 = 58;
                                } else if (n5 == 74) {
                                    n5 = 46;
                                } else if (n5 == 55) {
                                    n5 = 39;
                                } else if (n5 == 96) {
                                    n5 = 39;
                                } else if (n5 == 90) {
                                    n5 = 58;
                                } else if (n5 == 77) {
                                    n5 = 58;
                                } else if (n5 == 50) {
                                    n5 = 58;
                                } else if (n5 == 117) {
                                    n5 = 46;
                                } else if (n5 == 104) {
                                    n5 = 46;
                                } else if (n5 == 79) {
                                    n5 = 58;
                                } else if (n5 == 89) {
                                    n5 = 39;
                                }
                            }
                            cArray[n][n4] = n5;
                        }
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.height) {
                    int n6 = 0;
                    while (n6 < this.width) {
                        cArray[n][n6] = this.pixels[n][n6] == '\u0000' || this.pixels[n][n6] >= TWO_BY_TWO_CHARS.length ? (char)'\u0000' : TWO_BY_TWO_CHARS[this.pixels[n][n6]];
                        ++n6;
                    }
                    ++n;
                }
                break;
            }
            case 0: {
                int n = 0;
                while (n < this.height) {
                    int n7 = 0;
                    while (n7 < this.width) {
                        cArray[n][n7] = this.pixels[n][n7] > '\u0000' ? this.pixels[n][n7] : (char)'\u0000';
                        ++n7;
                    }
                    ++n;
                }
                break;
            }
            case 5: {
                int n = 0;
                while (n < this.height) {
                    int n8 = 0;
                    while (n8 < this.width) {
                        cArray[n][n8] = this.pixels[n][n8] == '\u0000' || this.pixels[n][n8] >= THREE_BY_TWO_CHARS.length ? (char)'\u0000' : THREE_BY_TWO_CHARS[this.pixels[n][n8]];
                        ++n8;
                    }
                    ++n;
                }
                break;
            }
        }
        if (this.plate == null) {
            this.plate = new CharacterPlate(cArray);
        } else {
            this.plate.setContent(cArray);
        }
        if (this.converter == 1) {
            this.plate.replace('\u0000', ' ');
            Filter.filter(this.plate, 2);
            this.plate.replace(' ', '\u0000');
        }
    }

    public synchronized void pasteResultInto(CharacterPlate characterPlate) {
        CharacterPlate characterPlate2 = this.getResult();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (characterPlate.contains(n2 + this.originX, n + this.originY)) {
                    char c = characterPlate2.get(n2, n);
                    if (c == '\u00a0') {
                        characterPlate.setForce(n2 + this.originX, n + this.originY, ' ');
                    } else if (c != '\u0000' && c != ' ') {
                        characterPlate.set(n2 + this.originX, n + this.originY, c);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void drawRectangle(Point2d point2d, Point2d point2d2) {
        this.drawRectangle(point2d.x, point2d.y, point2d2.x, point2d2.y);
    }

    public void drawRectangle(double d, double d2, double d3, double d4) {
        this.drawLine(d, d2, d3, d2);
        this.drawLine(d, d2, d, d4);
        this.drawLine(d3, d2, d3, d4);
        this.drawLine(d, d4, d3, d4);
    }

    public void fillRectangle(Point2d point2d, Point2d point2d2) {
        this.drawRectangle(point2d.x, point2d.y, point2d2.x, point2d2.y);
        int n = this.pencilSize;
        this.pencilSize = 1;
        int n2 = this.getPhysicalX(point2d.x);
        int n3 = this.getPhysicalY(point2d.y);
        int n4 = this.getPhysicalX(point2d2.x);
        int n5 = this.getPhysicalY(point2d2.y);
        int n6 = n2 <= n4 ? 1 : -1;
        int n7 = n3 <= n5 ? 1 : -1;
        int n8 = n2;
        while (n8 != n4 + n6) {
            int n9 = n3;
            while (n9 != n5 + n7) {
                this.set(n8, n9);
                n9 += n7;
            }
            n8 += n6;
        }
        this.pencilSize = n;
    }

    public void drawLine(Point2d point2d, Point2d point2d2) {
        this.drawLine(point2d.x, point2d.y, point2d2.x, point2d2.y);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        int n = this.getPhysicalX(d);
        int n2 = this.getPhysicalY(d2);
        int n3 = this.getPhysicalX(d3);
        int n4 = this.getPhysicalY(d4);
        this.drawLineBresenham(n, n2, n3, n4);
    }

    protected boolean isInside(int n, int n2) {
        return n >= this.originX * this.rasterX && n2 >= this.originY * this.rasterY && n - this.originX * this.rasterX < this.getVirtualWidth() && n2 - this.originY * this.rasterY < this.getVirtualHeight();
    }

    public void set(int n, int n2, char c) {
        this.setCharacter(c);
        this.set(n, n2);
    }

    public void set(int n, int n2) {
        this.set(n, n2, true);
    }

    public void set(int n, int n2, boolean bl) {
        if (this.pencilSize == 1) {
            this.setInternal(n, n2, bl);
            return;
        }
        this.setInternal(n, n2);
        this.setInternal(n - 1, n2, bl);
        this.setInternal(n + 1, n2, bl);
        this.setInternal(n, n2 - 1, bl);
        this.setInternal(n, n2 + 1, bl);
        this.setInternal(n - 1, n2 - 1, bl);
        this.setInternal(n - 1, n2 + 1, bl);
        this.setInternal(n + 1, n2 - 1, bl);
        this.setInternal(n + 1, n2 + 1, bl);
        this.setInternal(n + 2, n2, bl);
        this.setInternal(n - 2, n2, bl);
        if (this.pencilSize == 2) {
            return;
        }
        this.setInternal(n + 3, n2, bl);
        this.setInternal(n + 2, n2 - 1, bl);
        this.setInternal(n + 1, n2 - 2, bl);
        this.setInternal(n, n2 - 2, bl);
        this.setInternal(n - 1, n2 - 2, bl);
        this.setInternal(n - 2, n2 - 1, bl);
        this.setInternal(n - 3, n2, bl);
        this.setInternal(n - 2, n2 + 1, bl);
        this.setInternal(n - 1, n2 + 2, bl);
        this.setInternal(n, n2 + 2, bl);
        this.setInternal(n + 1, n2 + 2, bl);
        this.setInternal(n + 2, n2 + 1, bl);
        if (this.pencilSize == 3) {
            return;
        }
        this.setInternal(n + 4, n2, bl);
        this.setInternal(n + 4, n2 + 1, bl);
        this.setInternal(n + 4, n2 - 1, bl);
        this.setInternal(n + 3, n2 + 1, bl);
        this.setInternal(n + 3, n2 - 1, bl);
        this.setInternal(n + 3, n2 - 2, bl);
        this.setInternal(n + 2, n2 - 2, bl);
        this.setInternal(n + 3, n2 + 2, bl);
        this.setInternal(n + 2, n2 + 2, bl);
        this.setInternal(n + 1, n2 - 3, bl);
        this.setInternal(n + 1, n2 + 3, bl);
        this.setInternal(n, n2 - 3, bl);
        this.setInternal(n, n2 + 3, bl);
        this.setInternal(n - 4, n2, bl);
        this.setInternal(n - 4, n2 + 1, bl);
        this.setInternal(n - 4, n2 - 1, bl);
        this.setInternal(n - 3, n2 + 1, bl);
        this.setInternal(n - 3, n2 - 1, bl);
        this.setInternal(n - 3, n2 - 2, bl);
        this.setInternal(n - 2, n2 - 2, bl);
        this.setInternal(n - 3, n2 + 2, bl);
        this.setInternal(n - 2, n2 + 2, bl);
        this.setInternal(n - 1, n2 - 3, bl);
        this.setInternal(n - 1, n2 + 3, bl);
    }

    protected boolean isSet(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n3 = n / this.rasterX;
        if (n < 0) {
            n3 = (n - this.rasterX + 1) / this.rasterX;
        }
        n -= n3 * this.rasterX;
        n3 -= this.originX;
        n4 = n2 / this.rasterY;
        if (n2 < 0) {
            n4 = (n2 - this.rasterY + 1) / this.rasterY;
        }
        n2 -= n4 * this.rasterY;
        if ((n4 -= this.originY) < 0 || n3 < 0 || n4 >= this.height || n3 >= this.width) {
            return false;
        }
        if (this.converter == 0) {
            return this.pixels[n4][n3] == this.character;
        }
        return this.pixels[n4][n3] == (this.pixels[n4][n3] | 1 << n2 + n * this.rasterY);
    }

    protected void setInternal(int n, int n2) {
        this.setInternal(n, n2, true);
    }

    protected synchronized void setInternal(int n, int n2, boolean bl) {
        int n3;
        char[][] cArray;
        int n4 = 0;
        int n5 = 0;
        n4 = n / this.rasterX;
        if (n < 0) {
            n4 = (n - this.rasterX + 1) / this.rasterX;
        }
        n -= n4 * this.rasterX;
        n4 -= this.originX;
        n5 = n2 / this.rasterY;
        if (n2 < 0) {
            n5 = (n2 - this.rasterY + 1) / this.rasterY;
        }
        n2 -= n5 * this.rasterY;
        n5 -= this.originY;
        if (n4 < 0) {
            cArray = new char[this.height][this.width + -n4 + 2];
            n3 = 0;
            while (n3 < this.height) {
                System.arraycopy(this.pixels[n3], 0, cArray[n3], 2 - n4, this.width);
                ++n3;
            }
            this.originX += n4 - 2;
            this.width += -n4 + 2;
            this.pixels = cArray;
            n4 = 2;
        }
        if (n4 >= this.width) {
            cArray = new char[this.height][n4 + 1 + 2];
            n3 = 0;
            while (n3 < this.height) {
                System.arraycopy(this.pixels[n3], 0, cArray[n3], 0, this.width);
                ++n3;
            }
            this.width = n4 + 1 + 2;
            this.pixels = cArray;
        }
        if (n5 < 0) {
            cArray = new char[this.height + -n5 + 2][this.width];
            n3 = 0;
            while (n3 < this.height) {
                cArray[n3 + 2 - n5] = this.pixels[n3];
                ++n3;
            }
            this.originY += n5 - 2;
            this.height += -n5 + 2;
            this.pixels = cArray;
            n5 = 2;
        }
        if (n5 >= this.height) {
            cArray = new char[n5 + 1 + 2][this.width];
            n3 = 0;
            while (n3 < this.height) {
                cArray[n3] = this.pixels[n3];
                ++n3;
            }
            this.height = n5 + 1 + 2;
            this.pixels = cArray;
        }
        if (bl) {
            if (this.converter == 0) {
                this.pixels[n5][n4] = this.character;
            } else {
                char[] cArray2 = this.pixels[n5];
                int n6 = n4;
                cArray2[n6] = (char)(cArray2[n6] | 1 << n2 + n * this.rasterY);
            }
        } else {
            this.pixels[n5][n4] = this.converter == 0 ? (char)'\u0000' : (char)(this.pixels[n5][n4] | 1 << n2 + n * this.rasterY - 1 << n2 + n * this.rasterY);
        }
    }

    public void drawLineBresenham(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = n3 - n;
        int n9 = n4 - n2;
        int n10 = 1;
        int n11 = 1;
        if (n8 < 0) {
            n10 = -1;
            n8 = -n8;
        }
        if (n9 < 0) {
            n11 = -1;
            n9 = -n9;
        }
        if (n9 <= n8) {
            int n12 = 2 * n8;
            int n13 = 2 * n9;
            while (true) {
                this.set(n5, n6);
                if (n5 != n3) {
                    n5 += n10;
                    if ((n7 += n13) <= n8) continue;
                    n6 += n11;
                    n7 -= n12;
                    continue;
                }
                break;
            }
        } else {
            int n14 = 2 * n9;
            int n15 = 2 * n8;
            while (true) {
                this.set(n5, n6);
                if (n6 == n4) break;
                n6 += n11;
                if ((n7 += n15) <= n9) continue;
                n5 += n10;
                n7 -= n14;
            }
        }
    }

    /*
     * Opcode count of 28471 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        TWO_BY_TWO_CHARS = new char[]{' ', '\'', '.', '(', '`', '\"', '/', 'P', ',', '\\', '_', 'L', ')', '7', 'J', '8'};
        THREE_BY_TWO_CHARS = new char[]{' ', '`', '-', '!', '.', '|', 'i', '[', '\'', '~', '/', 'f', '/', '7', '/', 'P', '-', '\\', '=', '+', 'v', ')', 'z', 'D', '!', 'V', 'Y', '*', '/', 'Z', 'Z', 'A', ',', '\\', 'c', 't', '_', 'L', 's', 'b', '!', 'T', '(', '5', '2', 'X', 'K', 'K', 'i', '\\', 'e', 'N', 'g', 'G', 'm', 'W', ']', 'Y', '4', 'M', 'd', '8', 'W', '@'};
        FELTPEN_CHARS = new String[]{"!", ":", "$", "O", "8", "X", "M"};
        FELTPEN_GRADIENT_MODES = new int[]{12, 11, 10, 9, 8, 6, 7};
        initialized = false;
        DOT_TABLE = new char[]{'\u0000', '\'', '.', ':'};
        RULES_TABLE = new char[][]{{'\u0003', '\''}, {'\u0007', '|'}, {'\t', '|'}, {'\u000b', '|'}, {'\f', '.'}, {'\r', '|'}, {'\u000e', '|'}, {'\u000f', '|'}, {'\u0011', '\''}, {'\u0012', '\''}, {'\u0013', '\''}, {'\u0016', '/'}, {'\u0019', '\''}, {'\u001b', '\''}, {'\u001e', '|'}, {'\u001f', '|'}, {'!', '`'}, {'\"', '-'}, {'#', '`'}, {')', '|'}, {'+', '|'}, {'-', '|'}, {'/', '|'}, {'1', '`'}, {'2', '\''}, {'3', '\''}, {'4', '\''}, {'5', '\''}, {'6', '/'}, {'7', '\''}, {'<', '/'}, {'=', '/'}, {'>', '/'}, {'?', '/'}, {'D', '.'}, {'F', '.'}, {'H', ','}, {'I', '|'}, {'K', '|'}, {'L', ','}, {'M', '|'}, {'O', '|'}, {'V', '/'}, {'^', '/'}, {'i', '|'}, {'k', '|'}, {'m', '|'}, {'o', '|'}, {'p', '|'}, {'v', '/'}, {'x', '|'}, {'y', '['}, {'|', '|'}, {'}', '|'}, {'~', '|'}, {'\u007f', '|'}, {'\u0084', '.'}, {'\u0086', '\\'}, {'\u0087', '|'}, {'\u0088', '_'}, {'\u0089', '_'}, {'\u008c', '.'}, {'\u008f', '|'}, {'\u0090', '|'}, {'\u0092', '|'}, {'\u0094', '|'}, {'\u0096', '('}, {'\u00a6', '\\'}, {'\u00a7', '\\'}, {'\u00b0', '|'}, {'\u00b2', '|'}, {'\u00b4', '|'}, {'\u00bc', '|'}, {'\u00bd', '|'}, {'\u00be', '|'}, {'\u00bf', '|'}, {'\u00c2', '\\'}, {'\u00c3', '|'}, {'\u00c4', '.'}, {'\u00c6', '\\'}, {'\u00c7', '|'}, {'\u00c8', ','}, {'\u00ca', '\\'}, {'\u00cb', '|'}, {'\u00cc', '.'}, {'\u00ce', '\\'}, {'\u00cf', '|'}, {'\u00d0', '|'}, {'\u00d2', '|'}, {'\u00d3', '|'}, {'\u00d4', '|'}, {'\u00d7', '|'}, {'\u00db', '|'}, {'\u00df', '|'}, {'\u00e0', '|'}, {'\u00e1', '|'}, {'\u00e3', '|'}, {'\u00e6', '\\'}, {'\u00e7', '|'}, {'\u00e9', '['}, {'\u00eb', '|'}, {'\u00ef', '|'}, {'\u00f0', '|'}, {'\u00f1', '|'}, {'\u00f2', '|'}, {'\u00f3', '|'}, {'\u00f4', '|'}, {'\u00f7', '|'}, {'\u00f8', '|'}, {'\u00f9', '['}, {'\u00fb', '|'}, {'\u00fc', '|'}, {'\u00fd', '|'}, {'\u00fe', '|'}, {'\u00ff', '|'}, {'\u0101', '\''}, {'\u0109', '\''}, {'\u010c', '/'}, {'\u010d', '/'}, {'\u010e', '/'}, {'\u010f', '/'}, {'\u0110', '\''}, {'\u0111', '\''}, {'\u0112', '\''}, {'\u0113', '\''}, {'\u0116', '/'}, {'\u0119', '\''}, {'\u011b', '\''}, {'\u011c', '/'}, {'\u011d', '/'}, {'\u011e', '/'}, {'\u011f', '/'}, {'\u0121', '\"'}, {'\u0122', '-'}, {'\u0123', '\"'}, {'\u0124', '\''}, {'\u0125', '\''}, {'\u0126', '\''}, {'\u0127', '\''}, {'\u012c', '/'}, {'\u012d', '/'}, {'\u012e', '/'}, {'\u012f', '/'}, {'\u0131', '\"'}, {'\u0132', '\''}, {'\u0133', '\"'}, {'\u0134', '\''}, {'\u0135', '\''}, {'\u0136', '\''}, {'\u0137', '\''}, {'\u013c', '/'}, {'\u013d', '/'}, {'\u013e', '/'}, {'\u013f', '/'}, {'\u014c', '/'}, {'\u014d', '/'}, {'\u014e', '/'}, {'\u014f', '/'}, {'\u0155', '='}, {'\u0156', '/'}, {'\u015c', '/'}, {'\u015d', '/'}, {'\u015e', '/'}, {'\u015f', '/'}, {'\u0164', '/'}, {'\u0166', '/'}, {'\u0168', '/'}, {'\u0169', '/'}, {'\u016a', '/'}, {'\u016b', '/'}, {'\u016c', '/'}, {'\u016d', '/'}, {'\u016e', '/'}, {'\u016f', '/'}, {'\u0174', '/'}, {'\u0176', '/'}, {'\u0178', '/'}, {'\u0179', '/'}, {'\u017a', '/'}, {'\u017b', '/'}, {'\u017c', '/'}, {'\u017d', '/'}, {'\u017e', '/'}, {'\u017f', '/'}, {'\u018c', '.'}, {'\u018d', '/'}, {'\u018e', '/'}, {'\u018f', '/'}, {'\u0196', '('}, {'\u019c', '/'}, {'\u019d', '/'}, {'\u019e', '/'}, {'\u019f', '/'}, {'\u01ac', '/'}, {'\u01ad', '/'}, {'\u01ae', '/'}, {'\u01af', '/'}, {'\u01bc', '/'}, {'\u01bd', '/'}, {'\u01be', '/'}, {'\u01bf', '/'}, {'\u01cc', '/'}, {'\u01cd', '/'}, {'\u01ce', '/'}, {'\u01cf', '/'}, {'\u01dc', '/'}, {'\u01dd', '/'}, {'\u01de', '/'}, {'\u01df', '/'}, {'\u01e0', '|'}, {'\u01e1', '|'}, {'\u01e8', '/'}, {'\u01e9', '/'}, {'\u01ea', '/'}, {'\u01eb', '/'}, {'\u01ec', '/'}, {'\u01ed', '/'}, {'\u01ee', '/'}, {'\u01ef', '/'}, {'\u01f0', '|'}, {'\u01f1', '|'}, {'\u01f8', '/'}, {'\u01f9', '/'}, {'\u01fa', '/'}, {'\u01fb', '/'}, {'\u01fc', '/'}, {'\u01fd', '/'}, {'\u01fe', '/'}, {'\u01ff', '/'}, {'\u0202', '-'}, {'\u020a', '-'}, {'\u0210', '`'}, {'\u0211', '`'}, {'\u0212', '^'}, {'\u0213', '\"'}, {'\u0216', '/'}, {'\u0218', '`'}, {'\u0219', '`'}, {'\u021e', '/'}, {'\u0220', '-'}, {'\u0221', '-'}, {'\u0222', '-'}, {'\u0224', '-'}, {'\u0226', '-'}, {'\u022a', '-'}, {'\u022c', '/'}, {'\u022e', '+'}, {'\u022f', '+'}, {'\u0230', '`'}, {'\u0231', '`'}, {'\u0232', '^'}, {'\u0233', '\"'}, {'\u0236', '/'}, {'\u023c', '/'}, {'\u023d', '/'}, {'\u023e', '+'}, {'\u023f', '+'}, {'\u0244', ','}, {'\u0248', '/'}, {'\u0249', '/'}, {'\u024a', '/'}, {'\u024b', '/'}, {'\u024c', '/'}, {'\u024d', '/'}, {'\u024e', '/'}, {'\u024f', '/'}, {'\u0256', '/'}, {'\u0258', '/'}, {'\u0259', '/'}, {'\u025a', '/'}, {'\u025b', '/'}, {'\u025c', '/'}, {'\u025d', '/'}, {'\u025e', '/'}, {'\u025f', '/'}, {'\u0262', '-'}, {'\u0266', '-'}, {'\u0268', '/'}, {'\u0269', '/'}, {'\u026a', '/'}, {'\u026b', '/'}, {'\u026c', '/'}, {'\u026d', '/'}, {'\u026e', '/'}, {'\u026f', '/'}, {'\u0276', '/'}, {'\u0278', '/'}, {'\u0279', '/'}, {'\u027a', '/'}, {'\u027b', '/'}, {'\u027c', '/'}, {'\u027d', '/'}, {'\u027e', '/'}, {'\u027f', '/'}, {'\u0290', '|'}, {'\u0294', '|'}, {'\u02aa', '='}, {'\u02ac', '/'}, {'\u02b0', '|'}, {'\u02b4', '|'}, {'\u02c0', '/'}, {'\u02c8', '/'}, {'\u02c9', '/'}, {'\u02ca', '/'}, {'\u02cb', '/'}, {'\u02cc', '/'}, {'\u02cd', '/'}, {'\u02ce', '/'}, {'\u02cf', '/'}, {'\u02d0', '|'}, {'\u02d2', '+'}, {'\u02d4', '|'}, {'\u02d6', '+'}, {'\u02d8', '/'}, {'\u02d9', '/'}, {'\u02da', '/'}, {'\u02db', '/'}, {'\u02dc', '/'}, {'\u02dd', '/'}, {'\u02de', '/'}, {'\u02df', '/'}, {'\u02e0', ','}, {'\u02e8', '/'}, {'\u02e9', '/'}, {'\u02ea', '/'}, {'\u02eb', '/'}, {'\u02ec', '/'}, {'\u02ed', '/'}, {'\u02ee', '/'}, {'\u02ef', '/'}, {'\u02f0', '|'}, {'\u02f2', '+'}, {'\u02f4', '|'}, {'\u02f6', '+'}, {'\u02f8', '/'}, {'\u02f9', '/'}, {'\u02fa', '/'}, {'\u02fb', '/'}, {'\u02fc', '/'}, {'\u02fd', '/'}, {'\u02fe', '/'}, {'\u02ff', '/'}, {'\u0300', '\''}, {'\u0301', '\''}, {'\u0309', '\''}, {'\u030c', '/'}, {'\u030d', '/'}, {'\u030e', '/'}, {'\u030f', '/'}, {'\u0310', '`'}, {'\u0311', '\''}, {'\u0312', '\"'}, {'\u0313', '\"'}, {'\u0316', '/'}, {'\u0318', '`'}, {'\u0319', '\''}, {'\u031c', '/'}, {'\u031d', '/'}, {'\u031e', '/'}, {'\u031f', '/'}, {'\u0320', '-'}, {'\u0321', '\"'}, {'\u0322', '-'}, {'\u0323', '\"'}, {'\u0324', '/'}, {'\u0326', '/'}, {'\u032c', '/'}, {'\u032d', '/'}, {'\u032e', '/'}, {'\u032f', '/'}, {'\u0331', '\"'}, {'\u0332', '\"'}, {'\u0333', '\"'}, {'\u0334', '/'}, {'\u0336', '/'}, {'\u033c', '/'}, {'\u033d', '/'}, {'\u033e', '/'}, {'\u033f', '/'}, {'\u0344', '/'}, {'\u0345', '/'}, {'\u0346', '/'}, {'\u0347', '/'}, {'\u0348', '/'}, {'\u0349', '/'}, {'\u034a', '/'}, {'\u034b', '/'}, {'\u034c', '/'}, {'\u034d', '/'}, {'\u034e', '/'}, {'\u034f', '/'}, {'\u0354', '/'}, {'\u0355', '/'}, {'\u0356', '/'}, {'\u0357', '/'}, {'\u0358', '/'}, {'\u0359', '/'}, {'\u035a', '/'}, {'\u035b', '/'}, {'\u035c', '/'}, {'\u035d', '/'}, {'\u035e', '/'}, {'\u035f', '/'}, {'\u0364', '/'}, {'\u0365', '/'}, {'\u0366', '/'}, {'\u0367', '/'}, {'\u0368', '/'}, {'\u0369', '/'}, {'\u036a', '/'}, {'\u036b', '/'}, {'\u036c', '/'}, {'\u036d', '/'}, {'\u036e', '/'}, {'\u036f', '/'}, {'\u0374', '/'}, {'\u0375', '/'}, {'\u0376', '/'}, {'\u0377', '/'}, {'\u0378', '/'}, {'\u0379', '/'}, {'\u037a', '/'}, {'\u037b', '/'}, {'\u037c', '/'}, {'\u037d', '/'}, {'\u037e', '/'}, {'\u037f', '/'}, {'\u038c', '/'}, {'\u038d', '/'}, {'\u038e', '/'}, {'\u038f', '/'}, {'\u039c', '/'}, {'\u039d', '/'}, {'\u039e', '/'}, {'\u039f', '/'}, {'\u03ac', '/'}, {'\u03ad', '/'}, {'\u03ae', '/'}, {'\u03af', '/'}, {'\u03bc', '/'}, {'\u03bd', '/'}, {'\u03be', '/'}, {'\u03bf', '/'}, {'\u03c0', '|'}, {'\u03c8', '/'}, {'\u03c9', '/'}, {'\u03ca', '/'}, {'\u03cb', '/'}, {'\u03cc', '/'}, {'\u03cd', '/'}, {'\u03ce', '/'}, {'\u03cf', '/'}, {'\u03d0', '|'}, {'\u03d8', '/'}, {'\u03d9', '/'}, {'\u03da', '/'}, {'\u03db', '/'}, {'\u03dc', '/'}, {'\u03dd', '/'}, {'\u03de', '/'}, {'\u03df', '/'}, {'\u03e0', '|'}, {'\u03e8', '/'}, {'\u03e9', '/'}, {'\u03ea', '/'}, {'\u03eb', '/'}, {'\u03ec', '/'}, {'\u03ed', '/'}, {'\u03ee', '/'}, {'\u03ef', '/'}, {'\u03f0', '|'}, {'\u03f8', '/'}, {'\u03f9', '/'}, {'\u03fa', '/'}, {'\u03fb', '/'}, {'\u03fc', '/'}, {'\u03fd', '/'}, {'\u03fe', '/'}, {'\u03ff', '/'}, {'\u0404', '.'}, {'\u0405', '.'}, {'\u0421', '`'}, {'\u0422', '-'}, {'\u0423', '\\'}, {'\u0430', '\\'}, {'\u0431', '`'}, {'\u0432', '\\'}, {'\u0433', '\\'}, {'\u0440', '.'}, {'\u0442', '.'}, {'\u0443', '\\'}, {'\u0444', '.'}, {'\u0445', '.'}, {'\u0446', '.'}, {'\u0447', '\\'}, {'\u0448', ','}, {'\u044c', '.'}, {'\u0453', '\\'}, {'\u0455', '='}, {'\u0457', '\\'}, {'\u0461', '\\'}, {'\u0463', '\\'}, {'\u0467', '\\'}, {'\u0471', '\\'}, {'\u0473', '\\'}, {'\u0477', '\\'}, {'\u0480', ','}, {'\u0481', ','}, {'\u0486', '\\'}, {'\u0487', '\\'}, {'\u0488', ','}, {'\u0489', ','}, {'\u0490', '|'}, {'\u0492', '|'}, {'\u04a6', '\\'}, {'\u04a7', '\\'}, {'\u04b0', '|'}, {'\u04b2', '|'}, {'\u04b4', '+'}, {'\u04b6', '+'}, {'\u04c0', '.'}, {'\u04c4', '.'}, {'\u04c6', '\\'}, {'\u04c7', '\\'}, {'\u04c8', ','}, {'\u04cc', '.'}, {'\u04d0', '|'}, {'\u04d2', '|'}, {'\u04e6', '\\'}, {'\u04e7', '\\'}, {'\u04e9', '>'}, {'\u04eb', '>'}, {'\u04ed', '>'}, {'\u04ef', '>'}, {'\u04f0', '|'}, {'\u04f2', '|'}, {'\u04f4', '+'}, {'\u04f6', '+'}, {'\u0504', '.'}, {'\u050c', '/'}, {'\u051c', '/'}, {'\u0521', '`'}, {'\u052c', '/'}, {'\u0530', '\\'}, {'\u0531', '`'}, {'\u0532', '\\'}, {'\u0533', '\\'}, {'\u053c', '/'}, {'\u0543', '\\'}, {'\u0544', '.'}, {'\u0547', '\\'}, {'\u054c', '/'}, {'\u0551', '='}, {'\u0553', '\\'}, {'\u0554', '='}, {'\u0555', '='}, {'\u0557', '\\'}, {'\u055c', '/'}, {'\u0563', '\\'}, {'\u0567', '\\'}, {'\u0568', '/'}, {'\u056c', '/'}, {'\u0573', '\\'}, {'\u0577', '\\'}, {'\u0578', '/'}, {'\u057c', '/'}, {'\u058c', '/'}, {'\u059c', '/'}, {'\u05ac', '/'}, {'\u05bc', '/'}, {'\u05cc', '/'}, {'\u05dc', '/'}, {'\u05e8', '/'}, {'\u05ec', '/'}, {'\u05f8', '/'}, {'\u05fc', '/'}, {'\u0610', '\\'}, {'\u0611', '\\'}, {'\u0612', '\\'}, {'\u0613', '\\'}, {'\u0621', '`'}, {'\u0622', '-'}, {'\u0623', '\\'}, {'\u0626', '-'}, {'\u062c', '/'}, {'\u0630', '\\'}, {'\u0631', '`'}, {'\u0632', '\\'}, {'\u0633', '\\'}, {'\u0643', '\\'}, {'\u0647', '\\'}, {'\u0648', '/'}, {'\u064c', '/'}, {'\u0650', '\\'}, {'\u0651', '\\'}, {'\u0652', '\\'}, {'\u0653', '\\'}, {'\u0657', '\\'}, {'\u0661', '\\'}, {'\u0662', '-'}, {'\u0663', '\\'}, {'\u0666', '-'}, {'\u0667', '\\'}, {'\u066c', '/'}, {'\u0670', '\\'}, {'\u0671', '\\'}, {'\u0672', '\\'}, {'\u0673', '\\'}, {'\u0677', '\\'}, {'\u0680', '/'}, {'\u0684', '/'}, {'\u0688', '/'}, {'\u068c', '/'}, {'\u0690', ')'}, {'\u0691', ')'}, {'\u0696', 'O'}, {'\u0697', 'O'}, {'\u0698', ')'}, {'\u0699', '['}, {'\u069e', 'O'}, {'\u069f', 'O'}, {'\u06a0', '/'}, {'\u06a4', '/'}, {'\u06a8', '/'}, {'\u06ac', '/'}, {'\u06b4', '+'}, {'\u06b6', '+'}, {'\u06c0', '/'}, {'\u06c4', '/'}, {'\u06c8', '/'}, {'\u06cc', '/'}, {'\u06d2', '+'}, {'\u06d6', '+'}, {'\u06e0', '/'}, {'\u06e4', '/'}, {'\u06e8', '/'}, {'\u06ec', '/'}, {'\u06f2', '+'}, {'\u06f4', '+'}, {'\u06f6', '+'}, {'\u0700', '|'}, {'\u070c', '/'}, {'\u071c', '/'}, {'\u0721', '`'}, {'\u072c', '/'}, {'\u0730', '\\'}, {'\u0731', '`'}, {'\u0732', '\\'}, {'\u0733', '\\'}, {'\u073c', '/'}, {'\u0743', '\\'}, {'\u0744', '/'}, {'\u0745', '/'}, {'\u0746', '/'}, {'\u0747', '/'}, {'\u0748', '/'}, {'\u074c', '/'}, {'\u0753', '\\'}, {'\u0754', '/'}, {'\u0755', '/'}, {'\u0756', '/'}, {'\u0757', '/'}, {'\u075c', '/'}, {'\u0763', '\\'}, {'\u0764', '/'}, {'\u0765', '/'}, {'\u0766', '/'}, {'\u0767', '/'}, {'\u0768', '/'}, {'\u076c', '/'}, {'\u0773', '\\'}, {'\u0774', '/'}, {'\u0775', '/'}, {'\u0776', '/'}, {'\u0777', '/'}, {'\u0778', '/'}, {'\u077c', '/'}, {'\u0780', '|'}, {'\u0784', '/'}, {'\u0787', 'V'}, {'\u0788', '/'}, {'\u078c', '/'}, {'\u078f', 'V'}, {'\u0796', 'O'}, {'\u0797', 'O'}, {'\u0799', '['}, {'\u079c', '/'}, {'\u079e', 'O'}, {'\u079f', 'O'}, {'\u07a0', '/'}, {'\u07a4', '/'}, {'\u07a8', '/'}, {'\u07ac', '/'}, {'\u07bc', '/'}, {'\u07c0', '|'}, {'\u07c4', '/'}, {'\u07c7', 'V'}, {'\u07c8', '/'}, {'\u07cc', '/'}, {'\u07cf', 'V'}, {'\u07d0', '|'}, {'\u07dc', '/'}, {'\u07e0', '|'}, {'\u07e4', '/'}, {'\u07e8', '/'}, {'\u07ec', '/'}, {'\u07f0', '|'}, {'\u07f8', '/'}, {'\u07fc', '/'}, {'\u0803', '\''}, {'\u0808', '_'}, {'\u0812', '\''}, {'\u0813', '\''}, {'\u0842', '\\'}, {'\u0843', '\\'}, {'\u0844', '.'}, {'\u0846', '\\'}, {'\u0847', '\\'}, {'\u0848', ','}, {'\u084a', '\\'}, {'\u084b', '\\'}, {'\u084e', '\\'}, {'\u084f', '\\'}, {'\u0852', '\\'}, {'\u0853', '\\'}, {'\u0861', '\\'}, {'\u0862', '\\'}, {'\u0863', '\\'}, {'\u0865', '\\'}, {'\u0867', '\\'}, {'\u0869', '\\'}, {'\u086b', '\\'}, {'\u086d', '\\'}, {'\u086f', '\\'}, {'\u0870', '|'}, {'\u0871', '\\'}, {'\u0872', '\\'}, {'\u0873', '\\'}, {'\u0875', '\\'}, {'\u0877', '\\'}, {'\u0878', '|'}, {'\u0879', '\\'}, {'\u087b', '\\'}, {'\u087d', '\\'}, {'\u087f', '\\'}, {'\u0880', '_'}, {'\u0884', '.'}, {'\u0886', '\\'}, {'\u0887', '\\'}, {'\u0888', '_'}, {'\u0889', '_'}, {'\u088c', '.'}, {'\u0896', '('}, {'\u08a6', '\\'}, {'\u08a7', '\\'}, {'\u08c0', '.'}, {'\u08c2', '\\'}, {'\u08c3', '\\'}, {'\u08c6', '\\'}, {'\u08c7', '\\'}, {'\u08c8', ','}, {'\u08ca', '\\'}, {'\u08cb', '\\'}, {'\u08ce', '\\'}, {'\u08cf', '\\'}, {'\u08d2', '\\'}, {'\u08d3', '\\'}, {'\u08e1', '\\'}, {'\u08e2', '\\'}, {'\u08e3', '\\'}, {'\u08e5', '\\'}, {'\u08e6', '\\'}, {'\u08e7', '\\'}, {'\u08e9', '\\'}, {'\u08eb', '\\'}, {'\u08ed', '\\'}, {'\u08ef', '\\'}, {'\u08f0', '|'}, {'\u08f1', '\\'}, {'\u08f2', '\\'}, {'\u08f3', '\\'}, {'\u08f5', '\\'}, {'\u08f7', '\\'}, {'\u08f8', '|'}, {'\u08f9', '\\'}, {'\u08fb', '\\'}, {'\u08fd', '\\'}, {'\u08ff', '\\'}, {'\u0900', '|'}, {'\u0908', '_'}, {'\u090c', '/'}, {'\u0910', '\''}, {'\u0911', '\''}, {'\u0912', '\''}, {'\u091c', '/'}, {'\u0920', '|'}, {'\u092c', '/'}, {'\u093c', '/'}, {'\u0940', '|'}, {'\u0942', '\\'}, {'\u0943', '\\'}, {'\u094c', '/'}, {'\u0952', '\\'}, {'\u0953', '\\'}, {'\u095c', '/'}, {'\u0960', '|'}, {'\u0962', '\\'}, {'\u0963', '\\'}, {'\u0968', '/'}, {'\u096c', '/'}, {'\u0970', '['}, {'\u0972', '\\'}, {'\u0973', '\\'}, {'\u0978', '/'}, {'\u097c', '/'}, {'\u0980', '_'}, {'\u0984', '.'}, {'\u0988', '_'}, {'\u098c', '.'}, {'\u0996', '['}, {'\u0997', '['}, {'\u099c', '/'}, {'\u099e', '['}, {'\u099f', '['}, {'\u09ac', '/'}, {'\u09bc', '/'}, {'\u09c2', '\\'}, {'\u09c3', '\\'}, {'\u09cc', '/'}, {'\u09d2', '\\'}, {'\u09d3', '\\'}, {'\u09dc', '/'}, {'\u09e0', '['}, {'\u09e2', '\\'}, {'\u09e3', '\\'}, {'\u09e4', '<'}, {'\u09e8', '/'}, {'\u09ec', '/'}, {'\u09f0', '['}, {'\u09f2', '\\'}, {'\u09f3', '\\'}, {'\u09f8', '/'}, {'\u09fc', '/'}, {'\u0a02', '-'}, {'\u0a22', '-'}, {'\u0a2c', '/'}, {'\u0a42', '\\'}, {'\u0a43', '\\'}, {'\u0a48', '/'}, {'\u0a4c', '/'}, {'\u0a52', '\\'}, {'\u0a53', '\\'}, {'\u0a62', '\\'}, {'\u0a63', '\\'}, {'\u0a6c', '/'}, {'\u0a72', '\\'}, {'\u0a73', '\\'}, {'\u0aa2', '='}, {'\u0aaa', '='}, {'\u0aac', '/'}, {'\u0ac0', '/'}, {'\u0ac2', '\\'}, {'\u0ac3', '\\'}, {'\u0ac8', '/'}, {'\u0acc', '/'}, {'\u0ad2', '\\'}, {'\u0ad3', '\\'}, {'\u0ae0', ','}, {'\u0ae2', '\\'}, {'\u0ae3', '\\'}, {'\u0aec', '/'}, {'\u0af2', '\\'}, {'\u0af3', '\\'}, {'\u0b00', '|'}, {'\u0b0c', '/'}, {'\u0b1c', '/'}, {'\u0b20', '|'}, {'\u0b2c', '/'}, {'\u0b3c', '/'}, {'\u0b40', '|'}, {'\u0b42', '\\'}, {'\u0b43', '\\'}, {'\u0b48', '/'}, {'\u0b4c', '/'}, {'\u0b52', '\\'}, {'\u0b53', '\\'}, {'\u0b5c', '/'}, {'\u0b60', '|'}, {'\u0b62', '\\'}, {'\u0b63', '\\'}, {'\u0b68', '/'}, {'\u0b6c', '/'}, {'\u0b72', '\\'}, {'\u0b73', '\\'}, {'\u0b78', '/'}, {'\u0b7c', '/'}, {'\u0b8c', '/'}, {'\u0b9c', '/'}, {'\u0bac', '/'}, {'\u0bbc', '/'}, {'\u0bc0', '|'}, {'\u0bc2', '\\'}, {'\u0bc3', '\\'}, {'\u0bc8', '/'}, {'\u0bcc', '/'}, {'\u0bd0', '|'}, {'\u0bd2', '\\'}, {'\u0bd3', '\\'}, {'\u0bdc', '/'}, {'\u0be0', '|'}, {'\u0be2', '\\'}, {'\u0be3', '\\'}, {'\u0be4', '<'}, {'\u0be8', '/'}, {'\u0bec', '/'}, {'\u0bf0', '|'}, {'\u0bf2', '\\'}, {'\u0bf3', '\\'}, {'\u0bf8', '/'}, {'\u0bfc', '/'}, {'\u0c00', '.'}, {'\u0c01', '\\'}, {'\u0c03', '\\'}, {'\u0c05', '\\'}, {'\u0c07', '\\'}, {'\u0c09', '\\'}, {'\u0c0b', '\\'}, {'\u0c0d', '\\'}, {'\u0c0f', '\\'}, {'\u0c11', '\\'}, {'\u0c13', '\\'}, {'\u0c15', '\\'}, {'\u0c17', '\\'}, {'\u0c19', '\\'}, {'\u0c1b', '\\'}, {'\u0c1d', '\\'}, {'\u0c1f', '\\'}, {'\u0c21', '\\'}, {'\u0c22', '\\'}, {'\u0c23', '\\'}, {'\u0c25', '\\'}, {'\u0c26', '\\'}, {'\u0c27', '\\'}, {'\u0c29', '\\'}, {'\u0c2a', '\\'}, {'\u0c2b', '\\'}, {'\u0c2d', '\\'}, {'\u0c2e', '\\'}, {'\u0c2f', '\\'}, {'\u0c30', '\\'}, {'\u0c31', '\\'}, {'\u0c32', '\\'}, {'\u0c33', '\\'}, {'\u0c35', '\\'}, {'\u0c37', '\\'}, {'\u0c39', '\\'}, {'\u0c3b', '\\'}, {'\u0c3d', '\\'}, {'\u0c3f', '\\'}, {'\u0c40', '.'}, {'\u0c41', '\\'}, {'\u0c42', '\\'}, {'\u0c43', '\\'}, {'\u0c44', '.'}, {'\u0c45', '\\'}, {'\u0c47', '\\'}, {'\u0c48', ','}, {'\u0c49', '\\'}, {'\u0c4b', '\\'}, {'\u0c4c', '.'}, {'\u0c4d', '\\'}, {'\u0c4f', '\\'}, {'\u0c51', '\\'}, {'\u0c52', '\\'}, {'\u0c53', '\\'}, {'\u0c55', '\\'}, {'\u0c57', '\\'}, {'\u0c59', '\\'}, {'\u0c5b', '\\'}, {'\u0c5d', '\\'}, {'\u0c5f', '\\'}, {'\u0c61', '\\'}, {'\u0c62', '\\'}, {'\u0c63', '\\'}, {'\u0c65', '\\'}, {'\u0c66', '\\'}, {'\u0c67', '\\'}, {'\u0c69', '\\'}, {'\u0c6a', '\\'}, {'\u0c6b', '\\'}, {'\u0c6d', '\\'}, {'\u0c6e', '\\'}, {'\u0c6f', '\\'}, {'\u0c70', '|'}, {'\u0c71', '\\'}, {'\u0c72', '\\'}, {'\u0c73', '\\'}, {'\u0c75', '\\'}, {'\u0c77', '\\'}, {'\u0c79', '\\'}, {'\u0c7b', '\\'}, {'\u0c7d', '\\'}, {'\u0c7f', '\\'}, {'\u0c80', ','}, {'\u0c81', ','}, {'\u0c83', '\\'}, {'\u0c85', '\\'}, {'\u0c86', '\\'}, {'\u0c87', '\\'}, {'\u0c88', ','}, {'\u0c89', ','}, {'\u0c8b', '\\'}, {'\u0c8d', '\\'}, {'\u0c8f', '\\'}, {'\u0c91', '\\'}, {'\u0c93', '\\'}, {'\u0c95', '\\'}, {'\u0c97', '\\'}, {'\u0c99', '\\'}, {'\u0c9b', '\\'}, {'\u0c9d', '\\'}, {'\u0c9f', '\\'}, {'\u0ca1', '\\'}, {'\u0ca2', '\\'}, {'\u0ca3', '\\'}, {'\u0ca5', '\\'}, {'\u0ca6', '\\'}, {'\u0ca7', '\\'}, {'\u0ca9', '\\'}, {'\u0caa', '\\'}, {'\u0cab', '\\'}, {'\u0cad', '\\'}, {'\u0cae', '\\'}, {'\u0caf', '\\'}, {'\u0cb0', '|'}, {'\u0cb1', '\\'}, {'\u0cb3', '\\'}, {'\u0cb5', '\\'}, {'\u0cb7', '\\'}, {'\u0cb9', '\\'}, {'\u0cbb', '\\'}, {'\u0cbd', '\\'}, {'\u0cbf', '\\'}, {'\u0cc0', '.'}, {'\u0cc1', '\\'}, {'\u0cc2', '\\'}, {'\u0cc3', '\\'}, {'\u0cc4', '.'}, {'\u0cc5', '\\'}, {'\u0cc6', '\\'}, {'\u0cc7', '\\'}, {'\u0cc8', ','}, {'\u0cc9', '\\'}, {'\u0ccb', '\\'}, {'\u0ccc', '.'}, {'\u0ccd', '\\'}, {'\u0ccf', '\\'}, {'\u0cd1', '\\'}, {'\u0cd2', '\\'}, {'\u0cd3', '\\'}, {'\u0cd5', '\\'}, {'\u0cd7', '\\'}, {'\u0cd9', '\\'}, {'\u0cdb', '\\'}, {'\u0cdd', '\\'}, {'\u0cdf', '\\'}, {'\u0ce1', '\\'}, {'\u0ce2', '\\'}, {'\u0ce3', '\\'}, {'\u0ce5', '\\'}, {'\u0ce6', '\\'}, {'\u0ce7', '\\'}, {'\u0ce9', '\\'}, {'\u0cea', '\\'}, {'\u0ceb', '\\'}, {'\u0ced', '\\'}, {'\u0cee', '\\'}, {'\u0cef', '\\'}, {'\u0cf0', '|'}, {'\u0cf1', '\\'}, {'\u0cf2', '\\'}, {'\u0cf3', '\\'}, {'\u0cf5', '\\'}, {'\u0cf7', '\\'}, {'\u0cf9', '\\'}, {'\u0cfb', '\\'}, {'\u0cfd', '\\'}, {'\u0cff', '\\'}, {'\u0d00', '|'}, {'\u0d01', '\\'}, {'\u0d03', '\\'}, {'\u0d0c', '/'}, {'\u0d11', '\\'}, {'\u0d13', '\\'}, {'\u0d1c', '/'}, {'\u0d20', '|'}, {'\u0d21', '\\'}, {'\u0d23', '\\'}, {'\u0d2c', '/'}, {'\u0d30', '\\'}, {'\u0d31', '\\'}, {'\u0d32', '\\'}, {'\u0d33', '\\'}, {'\u0d3c', '/'}, {'\u0d40', '|'}, {'\u0d41', '\\'}, {'\u0d42', '\\'}, {'\u0d43', '\\'}, {'\u0d4c', '/'}, {'\u0d51', '\\'}, {'\u0d52', '\\'}, {'\u0d53', '\\'}, {'\u0d5c', '/'}, {'\u0d60', '|'}, {'\u0d61', '\\'}, {'\u0d62', '\\'}, {'\u0d63', '\\'}, {'\u0d68', '/'}, {'\u0d6c', '/'}, {'\u0d70', '|'}, {'\u0d71', '\\'}, {'\u0d72', '\\'}, {'\u0d73', '\\'}, {'\u0d78', '/'}, {'\u0d7c', '/'}, {'\u0d81', '\\'}, {'\u0d83', '\\'}, {'\u0d8c', '/'}, {'\u0d91', '\\'}, {'\u0d93', '\\'}, {'\u0d9c', '/'}, {'\u0da1', '\\'}, {'\u0da3', '\\'}, {'\u0dac', '/'}, {'\u0db0', '|'}, {'\u0db1', '\\'}, {'\u0db3', '\\'}, {'\u0dbc', '/'}, {'\u0dc1', '\\'}, {'\u0dc2', '\\'}, {'\u0dc3', '\\'}, {'\u0dcc', '/'}, {'\u0dd1', '\\'}, {'\u0dd2', '\\'}, {'\u0dd3', '\\'}, {'\u0ddc', '/'}, {'\u0de1', '\\'}, {'\u0de2', '\\'}, {'\u0de3', '\\'}, {'\u0de4', '<'}, {'\u0de8', '/'}, {'\u0dec', '/'}, {'\u0df0', '|'}, {'\u0df1', '\\'}, {'\u0df2', '\\'}, {'\u0df3', '\\'}, {'\u0df8', '/'}, {'\u0dfc', '/'}, {'\u0e00', '|'}, {'\u0e01', '\\'}, {'\u0e03', '\\'}, {'\u0e10', '|'}, {'\u0e11', '\\'}, {'\u0e12', '\\'}, {'\u0e13', '\\'}, {'\u0e21', '\\'}, {'\u0e23', '\\'}, {'\u0e2c', '/'}, {'\u0e30', '\\'}, {'\u0e31', '\\'}, {'\u0e32', '\\'}, {'\u0e33', '\\'}, {'\u0e41', '\\'}, {'\u0e42', '\\'}, {'\u0e43', '\\'}, {'\u0e48', '/'}, {'\u0e4c', '/'}, {'\u0e50', '\\'}, {'\u0e51', '\\'}, {'\u0e52', '\\'}, {'\u0e53', '\\'}, {'\u0e61', '\\'}, {'\u0e62', '\\'}, {'\u0e63', '\\'}, {'\u0e6c', '/'}, {'\u0e70', '|'}, {'\u0e71', '\\'}, {'\u0e72', '\\'}, {'\u0e73', '\\'}, {'\u0e81', '\\'}, {'\u0e83', '\\'}, {'\u0e91', '\\'}, {'\u0e93', '\\'}, {'\u0e96', 'O'}, {'\u0e97', 'O'}, {'\u0e99', '['}, {'\u0e9e', 'O'}, {'\u0e9f', 'O'}, {'\u0ea1', '\\'}, {'\u0ea3', '\\'}, {'\u0eac', '/'}, {'\u0eb0', '|'}, {'\u0eb1', '\\'}, {'\u0eb3', '\\'}, {'\u0ec0', '/'}, {'\u0ec1', '\\'}, {'\u0ec2', '\\'}, {'\u0ec3', '\\'}, {'\u0ec8', '/'}, {'\u0ecc', '/'}, {'\u0ed1', '\\'}, {'\u0ed2', '\\'}, {'\u0ed3', '\\'}, {'\u0ee0', ','}, {'\u0ee1', '\\'}, {'\u0ee2', '\\'}, {'\u0ee3', '\\'}, {'\u0eec', '/'}, {'\u0ef0', '|'}, {'\u0ef1', '\\'}, {'\u0ef2', '\\'}, {'\u0ef3', '\\'}, {'\u0f00', '|'}, {'\u0f01', '\\'}, {'\u0f03', '\\'}, {'\u0f0c', '/'}, {'\u0f10', '|'}, {'\u0f11', '\\'}, {'\u0f13', '\\'}, {'\u0f1c', '/'}, {'\u0f20', '|'}, {'\u0f21', '\\'}, {'\u0f23', '\\'}, {'\u0f2c', '/'}, {'\u0f30', '\\'}, {'\u0f31', '\\'}, {'\u0f32', '\\'}, {'\u0f33', '\\'}, {'\u0f3c', '/'}, {'\u0f40', '|'}, {'\u0f41', '\\'}, {'\u0f42', '\\'}, {'\u0f43', '\\'}, {'\u0f48', '/'}, {'\u0f4c', '/'}, {'\u0f51', '\\'}, {'\u0f52', '\\'}, {'\u0f53', '\\'}, {'\u0f5c', '/'}, {'\u0f60', '|'}, {'\u0f61', '\\'}, {'\u0f62', '\\'}, {'\u0f63', '\\'}, {'\u0f68', '/'}, {'\u0f6c', '/'}, {'\u0f70', '|'}, {'\u0f71', '\\'}, {'\u0f72', '\\'}, {'\u0f73', '\\'}, {'\u0f78', '/'}, {'\u0f7c', '/'}, {'\u0f80', '|'}, {'\u0f81', '\\'}, {'\u0f83', '\\'}, {'\u0f87', 'V'}, {'\u0f8c', '/'}, {'\u0f8f', 'V'}, {'\u0f91', '\\'}, {'\u0f93', '\\'}, {'\u0f96', 'O'}, {'\u0f97', 'O'}, {'\u0f99', '['}, {'\u0f9c', '/'}, {'\u0f9e', 'O'}, {'\u0f9f', 'O'}, {'\u0fa1', '\\'}, {'\u0fa3', '\\'}, {'\u0fac', '/'}, {'\u0fb0', '|'}, {'\u0fb1', '\\'}, {'\u0fb3', '\\'}, {'\u0fbc', '/'}, {'\u0fc0', '|'}, {'\u0fc1', '\\'}, {'\u0fc2', '\\'}, {'\u0fc3', '\\'}, {'\u0fc7', 'V'}, {'\u0fc8', '/'}, {'\u0fcc', '/'}, {'\u0fcf', 'V'}, {'\u0fd0', '|'}, {'\u0fd1', '\\'}, {'\u0fd2', '\\'}, {'\u0fd3', '\\'}, {'\u0fdc', '/'}, {'\u0fe0', '|'}, {'\u0fe1', '\\'}, {'\u0fe2', '\\'}, {'\u0fe3', '\\'}, {'\u0fe4', '<'}, {'\u0fe8', '/'}, {'\u0fec', '/'}, {'\u0ff0', '|'}, {'\u0ff1', '\\'}, {'\u0ff2', '\\'}, {'\u0ff3', '\\'}, {'\u0ff8', '/'}, {'\u0ffc', '/'}};
        RULES_THICK_TABLE = new char[][]{{'\u0003', '\''}, {'\u0005', '\''}, {'\u0007', '\''}, {'\n', '.'}, {'\f', '.'}, {'\u000e', '.'}, {'\u0011', '\''}, {'\u0013', '\''}, {'\u0015', '\''}, {'\u0017', '\''}, {'!', '\''}, {'#', '\''}, {'%', '\''}, {'\'', '\''}, {'1', '\''}, {'3', '\''}, {'5', '\''}, {'6', 'P'}, {'7', 'P'}, {'>', 'P'}, {'?', 'P'}, {'H', '.'}, {'J', '.'}, {'L', '.'}, {'N', '.'}, {'v', 'P'}, {'w', 'P'}, {'~', 'P'}, {'\u007f', 'P'}, {'\u0088', '_'}, {'\u008a', '.'}, {'\u008c', '.'}, {'\u008e', '.'}, {'\u00b6', 'P'}, {'\u00b7', 'P'}, {'\u00be', 'P'}, {'\u00bf', 'P'}, {'\u00c6', 'b'}, {'\u00c7', 'b'}, {'\u00c8', '.'}, {'\u00ca', '.'}, {'\u00cc', '.'}, {'\u00ce', 'b'}, {'\u00cf', 'b'}, {'\u00d6', 'b'}, {'\u00d7', 'b'}, {'\u00de', 'b'}, {'\u00df', 'b'}, {'\u00e6', 'b'}, {'\u00e7', 'b'}, {'\u00ee', 'b'}, {'\u00ef', 'b'}, {'\u00f6', 'b'}, {'\u00f7', 'b'}, {'\u00fe', 'b'}, {'\u00ff', 'b'}, {'\u0101', '\''}, {'\u0103', '\''}, {'\u0105', '\''}, {'\u0107', '\''}, {'\u0108', '.'}, {'\u0109', '`'}, {'\u010a', '.'}, {'\u010c', '.'}, {'\u010e', '.'}, {'\u0110', '`'}, {'\u0111', '\''}, {'\u0113', '\''}, {'\u0115', '\''}, {'\u0117', '\''}, {'\u0118', '`'}, {'\u0119', '`'}, {'\u0120', '`'}, {'\u0121', '\''}, {'\u0123', '\''}, {'\u0125', '\''}, {'\u0127', '\''}, {'\u0128', '`'}, {'\u0129', '`'}, {'\u0130', '`'}, {'\u0131', '\''}, {'\u0133', '\''}, {'\u0135', '\''}, {'\u0136', 'P'}, {'\u0137', 'P'}, {'\u0138', '`'}, {'\u0139', '`'}, {'\u013e', 'P'}, {'\u013f', 'P'}, {'\u0148', '.'}, {'\u014a', '.'}, {'\u014c', '.'}, {'\u014e', '.'}, {'\u0176', 'P'}, {'\u0177', 'P'}, {'\u017e', 'P'}, {'\u017f', 'P'}, {'\u0188', '.'}, {'\u018a', '.'}, {'\u018c', '.'}, {'\u018e', '.'}, {'\u01b6', 'P'}, {'\u01b7', 'P'}, {'\u01be', 'P'}, {'\u01bf', 'P'}, {'\u01c8', '.'}, {'\u01ca', '.'}, {'\u01cc', '.'}, {'\u01ce', '.'}, {'\u01f6', 'P'}, {'\u01f7', 'P'}, {'\u01fe', 'P'}, {'\u01ff', 'P'}, {'\u0230', 'Y'}, {'\u0231', 'Y'}, {'\u0232', 'Y'}, {'\u0233', 'Y'}, {'\u0234', 'Y'}, {'\u0235', 'Y'}, {'\u0236', 'P'}, {'\u0237', 'P'}, {'\u023e', 'P'}, {'\u023f', 'P'}, {'\u0270', 'Y'}, {'\u0271', 'Y'}, {'\u0272', 'Y'}, {'\u0273', 'Y'}, {'\u0274', 'Y'}, {'\u0275', 'Y'}, {'\u0276', 'P'}, {'\u0277', 'P'}, {'\u027e', 'P'}, {'\u027f', 'P'}, {'\u02b0', 'Y'}, {'\u02b1', 'Y'}, {'\u02b2', 'Y'}, {'\u02b3', 'Y'}, {'\u02b4', 'Y'}, {'\u02b5', 'Y'}, {'\u02b6', 'P'}, {'\u02b7', 'P'}, {'\u02be', 'P'}, {'\u02bf', 'P'}, {'\u02c6', 'b'}, {'\u02c7', 'b'}, {'\u02ce', 'b'}, {'\u02cf', 'b'}, {'\u02d6', 'b'}, {'\u02d7', 'b'}, {'\u02de', 'b'}, {'\u02df', 'b'}, {'\u02e6', 'b'}, {'\u02e7', 'b'}, {'\u02ee', 'b'}, {'\u02ef', 'b'}, {'\u02f0', 'Y'}, {'\u02f1', 'Y'}, {'\u02f2', 'Y'}, {'\u02f3', 'Y'}, {'\u02f4', 'Y'}, {'\u02f5', 'Y'}, {'\u02f6', 'b'}, {'\u02f7', 'b'}, {'\u02fe', 'b'}, {'\u02ff', 'b'}, {'\u0300', '`'}, {'\u0301', '`'}, {'\u0308', '`'}, {'\u0309', '`'}, {'\u0310', '`'}, {'\u0311', '`'}, {'\u0313', '\"'}, {'\u0318', '`'}, {'\u0319', '`'}, {'\u0320', '`'}, {'\u0321', '`'}, {'\u0328', '`'}, {'\u0329', '`'}, {'\u0330', 'Y'}, {'\u0331', 'Y'}, {'\u0332', 'Y'}, {'\u0333', 'Y'}, {'\u0334', 'Y'}, {'\u0335', 'Y'}, {'\u0336', 'P'}, {'\u0337', 'P'}, {'\u0338', '`'}, {'\u0339', '`'}, {'\u033e', 'P'}, {'\u033f', 'P'}, {'\u0370', 'Y'}, {'\u0371', 'Y'}, {'\u0372', 'Y'}, {'\u0373', 'Y'}, {'\u0374', 'Y'}, {'\u0375', 'Y'}, {'\u0376', 'P'}, {'\u0377', 'P'}, {'\u037e', 'P'}, {'\u037f', 'P'}, {'\u03b0', 'Y'}, {'\u03b1', 'Y'}, {'\u03b2', 'Y'}, {'\u03b3', 'Y'}, {'\u03b4', 'Y'}, {'\u03b5', 'Y'}, {'\u03b6', 'P'}, {'\u03b7', 'P'}, {'\u03be', 'P'}, {'\u03bf', 'P'}, {'\u03f0', 'Y'}, {'\u03f1', 'Y'}, {'\u03f2', 'Y'}, {'\u03f3', 'Y'}, {'\u03f4', 'Y'}, {'\u03f5', 'Y'}, {'\u03f6', 'P'}, {'\u03f7', 'P'}, {'\u03fe', 'P'}, {'\u03ff', 'P'}, {'\u0436', 'P'}, {'\u0437', 'P'}, {'\u043e', 'P'}, {'\u043f', 'P'}, {'\u0476', 'P'}, {'\u0477', 'P'}, {'\u047e', 'P'}, {'\u047f', 'P'}, {'\u04b6', 'P'}, {'\u04b7', 'P'}, {'\u04be', 'P'}, {'\u04bf', 'P'}, {'\u04c4', 'o'}, {'\u04c6', 'o'}, {'\u04c7', 'b'}, {'\u04cc', 'o'}, {'\u04ce', 'o'}, {'\u04cf', 'b'}, {'\u04d6', 'b'}, {'\u04d7', 'b'}, {'\u04de', 'b'}, {'\u04df', 'b'}, {'\u04e4', 'o'}, {'\u04e6', 'o'}, {'\u04e7', 'b'}, {'\u04ec', 'o'}, {'\u04ee', 'o'}, {'\u04ef', 'b'}, {'\u04f6', 'b'}, {'\u04f7', 'b'}, {'\u04fe', 'b'}, {'\u04ff', 'b'}, {'\u0500', '`'}, {'\u0501', '`'}, {'\u0508', '`'}, {'\u0509', '`'}, {'\u0510', '`'}, {'\u0511', '`'}, {'\u0518', '`'}, {'\u0519', '`'}, {'\u0520', '`'}, {'\u0521', '`'}, {'\u0528', '`'}, {'\u0529', '`'}, {'\u0530', '`'}, {'\u0531', '`'}, {'\u0536', 'P'}, {'\u0537', 'P'}, {'\u0538', '`'}, {'\u0539', '`'}, {'\u053e', 'P'}, {'\u053f', 'P'}, {'\u0576', 'P'}, {'\u0577', 'P'}, {'\u057e', 'P'}, {'\u057f', 'P'}, {'\u05b6', 'P'}, {'\u05b7', 'P'}, {'\u05be', 'P'}, {'\u05bf', 'P'}, {'\u05f6', 'P'}, {'\u05f7', 'P'}, {'\u05fe', 'P'}, {'\u05ff', 'P'}, {'\u0630', 'Y'}, {'\u0631', 'Y'}, {'\u0632', 'Y'}, {'\u0633', 'Y'}, {'\u0634', 'Y'}, {'\u0635', 'Y'}, {'\u0636', 'P'}, {'\u0637', 'P'}, {'\u063e', 'P'}, {'\u063f', 'P'}, {'\u0670', 'Y'}, {'\u0671', 'Y'}, {'\u0672', 'Y'}, {'\u0673', 'Y'}, {'\u0674', 'Y'}, {'\u0675', 'Y'}, {'\u0676', 'P'}, {'\u0677', 'P'}, {'\u067e', 'P'}, {'\u067f', 'P'}, {'\u06b0', 'Y'}, {'\u06b1', 'Y'}, {'\u06b2', 'Y'}, {'\u06b3', 'Y'}, {'\u06b4', 'Y'}, {'\u06b5', 'Y'}, {'\u06b6', 'P'}, {'\u06b7', 'P'}, {'\u06be', 'P'}, {'\u06bf', 'P'}, {'\u06c0', 'd'}, {'\u06c2', 'd'}, {'\u06c4', 'o'}, {'\u06c6', 'o'}, {'\u06c7', 'b'}, {'\u06c8', 'd'}, {'\u06ca', 'd'}, {'\u06cc', 'o'}, {'\u06ce', 'o'}, {'\u06cf', 'b'}, {'\u06d0', 'd'}, {'\u06d2', 'd'}, {'\u06d4', 'd'}, {'\u06d6', 'b'}, {'\u06d7', 'b'}, {'\u06d8', 'd'}, {'\u06da', 'd'}, {'\u06dc', 'd'}, {'\u06de', 'b'}, {'\u06df', 'b'}, {'\u06e0', 'd'}, {'\u06e2', 'd'}, {'\u06e4', 'o'}, {'\u06e6', 'o'}, {'\u06e7', 'b'}, {'\u06e8', 'd'}, {'\u06ea', 'd'}, {'\u06ec', 'o'}, {'\u06ee', 'o'}, {'\u06ef', 'b'}, {'\u06f0', 'd'}, {'\u06f1', 'Y'}, {'\u06f2', 'd'}, {'\u06f3', 'Y'}, {'\u06f4', 'd'}, {'\u06f5', 'Y'}, {'\u06f6', '8'}, {'\u06f7', '8'}, {'\u06f8', 'd'}, {'\u06fa', 'd'}, {'\u06fc', 'd'}, {'\u06fe', '8'}, {'\u06ff', '8'}, {'\u0700', '`'}, {'\u0701', '`'}, {'\u0708', '`'}, {'\u0709', '`'}, {'\u0710', '`'}, {'\u0711', '`'}, {'\u0718', '`'}, {'\u0719', '`'}, {'\u0720', '`'}, {'\u0721', '`'}, {'\u0728', '`'}, {'\u0729', '`'}, {'\u0730', 'Y'}, {'\u0731', 'Y'}, {'\u0732', 'Y'}, {'\u0733', 'Y'}, {'\u0734', 'Y'}, {'\u0735', 'Y'}, {'\u0736', 'P'}, {'\u0737', 'P'}, {'\u0738', '`'}, {'\u0739', '`'}, {'\u073e', 'P'}, {'\u073f', 'P'}, {'\u0770', 'Y'}, {'\u0771', 'Y'}, {'\u0772', 'Y'}, {'\u0773', 'Y'}, {'\u0774', 'Y'}, {'\u0775', 'Y'}, {'\u0776', 'P'}, {'\u0777', 'P'}, {'\u077e', 'P'}, {'\u077f', 'P'}, {'\u07b0', 'Y'}, {'\u07b1', 'Y'}, {'\u07b2', 'Y'}, {'\u07b3', 'Y'}, {'\u07b4', 'Y'}, {'\u07b5', 'Y'}, {'\u07b6', 'P'}, {'\u07b7', 'P'}, {'\u07be', 'P'}, {'\u07bf', 'P'}, {'\u07c0', 'd'}, {'\u07c2', 'd'}, {'\u07c4', 'd'}, {'\u07c6', 'd'}, {'\u07c8', 'd'}, {'\u07ca', 'd'}, {'\u07cc', 'd'}, {'\u07ce', 'd'}, {'\u07d0', 'd'}, {'\u07d2', 'd'}, {'\u07d4', 'd'}, {'\u07d6', 'd'}, {'\u07d8', 'd'}, {'\u07da', 'd'}, {'\u07dc', 'd'}, {'\u07de', 'd'}, {'\u07df', '8'}, {'\u07e0', 'd'}, {'\u07e2', 'd'}, {'\u07e4', 'd'}, {'\u07e6', 'd'}, {'\u07e8', 'd'}, {'\u07ea', 'd'}, {'\u07ec', 'd'}, {'\u07ee', 'd'}, {'\u07ef', '8'}, {'\u07f0', 'd'}, {'\u07f1', 'Y'}, {'\u07f2', 'd'}, {'\u07f3', 'Y'}, {'\u07f4', 'd'}, {'\u07f5', 'Y'}, {'\u07f6', '8'}, {'\u07f7', '8'}, {'\u07f8', 'd'}, {'\u07fa', 'd'}, {'\u07fb', '8'}, {'\u07fc', 'd'}, {'\u07fd', '8'}, {'\u07fe', '8'}, {'\u07ff', '8'}, {'\u0801', ','}, {'\u0803', '\''}, {'\u0805', '\''}, {'\u0807', '\''}, {'\u0808', '.'}, {'\u0809', ','}, {'\u080a', '.'}, {'\u080c', '.'}, {'\u080e', '.'}, {'\u0811', '\''}, {'\u0813', '\''}, {'\u0815', '\''}, {'\u0817', '\''}, {'\u0821', '\''}, {'\u0823', '\''}, {'\u0825', '\''}, {'\u0827', '\''}, {'\u0831', '\''}, {'\u0833', '\''}, {'\u0835', '\''}, {'\u0837', '\''}, {'\u0840', ','}, {'\u0841', ','}, {'\u0848', '.'}, {'\u0849', ','}, {'\u084a', '.'}, {'\u084c', '.'}, {'\u084e', '.'}, {'\u0880', '_'}, {'\u0881', ','}, {'\u0888', '_'}, {'\u0889', ','}, {'\u088a', '.'}, {'\u088c', '.'}, {'\u088e', '.'}, {'\u08c0', ','}, {'\u08c1', ','}, {'\u08c6', 'b'}, {'\u08c7', 'b'}, {'\u08c8', '.'}, {'\u08c9', ','}, {'\u08ca', '.'}, {'\u08cc', '.'}, {'\u08ce', 'b'}, {'\u08cf', 'b'}, {'\u08d6', 'b'}, {'\u08d7', 'b'}, {'\u08de', 'b'}, {'\u08df', 'b'}, {'\u08e6', 'b'}, {'\u08e7', 'b'}, {'\u08ee', 'b'}, {'\u08ef', 'b'}, {'\u08f6', 'b'}, {'\u08f7', 'b'}, {'\u08fe', 'b'}, {'\u08ff', 'b'}, {'\u0901', '\''}, {'\u0903', '\''}, {'\u0905', '\''}, {'\u0907', '\''}, {'\u0908', '.'}, {'\u090a', '.'}, {'\u090c', '.'}, {'\u090e', '.'}, {'\u0911', '\''}, {'\u0913', '\''}, {'\u0915', '\''}, {'\u0917', '\''}, {'\u0921', '\''}, {'\u0923', '\''}, {'\u0925', '\''}, {'\u0927', '\''}, {'\u0931', '\''}, {'\u0933', '\''}, {'\u0935', '\''}, {'\u0937', '\''}, {'\u0948', '.'}, {'\u094a', '.'}, {'\u094c', '.'}, {'\u094e', '.'}, {'\u0988', '.'}, {'\u098a', '.'}, {'\u098c', '.'}, {'\u098e', '.'}, {'\u09c8', '.'}, {'\u09ca', '.'}, {'\u09cc', '.'}, {'\u09ce', '.'}, {'\u09ff', '8'}, {'\u0a00', ','}, {'\u0a01', ','}, {'\u0a08', ','}, {'\u0a09', ','}, {'\u0a30', 'Y'}, {'\u0a31', 'Y'}, {'\u0a32', 'Y'}, {'\u0a33', 'Y'}, {'\u0a34', 'Y'}, {'\u0a35', 'Y'}, {'\u0a36', 'Y'}, {'\u0a37', 'Y'}, {'\u0a40', ','}, {'\u0a41', ','}, {'\u0a48', ','}, {'\u0a49', ','}, {'\u0a70', 'Y'}, {'\u0a71', 'Y'}, {'\u0a72', 'Y'}, {'\u0a73', 'Y'}, {'\u0a74', 'Y'}, {'\u0a75', 'Y'}, {'\u0a76', 'Y'}, {'\u0a77', 'Y'}, {'\u0a80', ','}, {'\u0a81', ','}, {'\u0a88', ','}, {'\u0a89', ','}, {'\u0ab0', 'Y'}, {'\u0ab1', 'Y'}, {'\u0ab2', 'Y'}, {'\u0ab3', 'Y'}, {'\u0ab4', 'Y'}, {'\u0ab5', 'Y'}, {'\u0ab6', 'Y'}, {'\u0ab7', 'Y'}, {'\u0ac0', ','}, {'\u0ac1', ','}, {'\u0ac6', 'b'}, {'\u0ac7', 'b'}, {'\u0ac8', ','}, {'\u0ac9', ','}, {'\u0ace', 'b'}, {'\u0acf', 'b'}, {'\u0ad6', 'b'}, {'\u0ad7', 'b'}, {'\u0ade', 'b'}, {'\u0adf', 'b'}, {'\u0ae6', 'b'}, {'\u0ae7', 'b'}, {'\u0aee', 'b'}, {'\u0aef', 'b'}, {'\u0af0', 'Y'}, {'\u0af1', 'Y'}, {'\u0af2', 'Y'}, {'\u0af3', 'Y'}, {'\u0af4', 'Y'}, {'\u0af5', 'Y'}, {'\u0af6', 'b'}, {'\u0af7', 'b'}, {'\u0afe', 'b'}, {'\u0aff', 'b'}, {'\u0b30', 'Y'}, {'\u0b31', 'Y'}, {'\u0b32', 'Y'}, {'\u0b33', 'Y'}, {'\u0b34', 'Y'}, {'\u0b35', 'Y'}, {'\u0b36', 'Y'}, {'\u0b37', 'Y'}, {'\u0b70', 'Y'}, {'\u0b71', 'Y'}, {'\u0b72', 'Y'}, {'\u0b73', 'Y'}, {'\u0b74', 'Y'}, {'\u0b75', 'Y'}, {'\u0b76', 'Y'}, {'\u0b77', 'Y'}, {'\u0b7f', '8'}, {'\u0bb0', 'Y'}, {'\u0bb1', 'Y'}, {'\u0bb2', 'Y'}, {'\u0bb3', 'Y'}, {'\u0bb4', 'Y'}, {'\u0bb5', 'Y'}, {'\u0bb6', 'Y'}, {'\u0bb7', 'Y'}, {'\u0bbf', '8'}, {'\u0bdf', '8'}, {'\u0bef', '8'}, {'\u0bf0', 'Y'}, {'\u0bf1', 'Y'}, {'\u0bf2', 'Y'}, {'\u0bf3', 'Y'}, {'\u0bf4', 'Y'}, {'\u0bf5', 'Y'}, {'\u0bf6', 'Y'}, {'\u0bf7', 'Y'}, {'\u0bfb', '8'}, {'\u0bfd', '8'}, {'\u0bfe', '8'}, {'\u0bff', '8'}, {'\u0c00', ','}, {'\u0c01', ','}, {'\u0c08', ','}, {'\u0c09', ','}, {'\u0c40', ','}, {'\u0c41', ','}, {'\u0c48', ','}, {'\u0c49', ','}, {'\u0c80', ','}, {'\u0c81', ','}, {'\u0c88', ','}, {'\u0c89', ','}, {'\u0cc0', ','}, {'\u0cc1', ','}, {'\u0cc4', 'o'}, {'\u0cc6', 'o'}, {'\u0cc7', 'b'}, {'\u0cc8', ','}, {'\u0cc9', ','}, {'\u0ccc', 'o'}, {'\u0cce', 'o'}, {'\u0ccf', 'b'}, {'\u0cd6', 'b'}, {'\u0cd7', 'b'}, {'\u0cde', 'b'}, {'\u0cdf', 'b'}, {'\u0ce4', 'o'}, {'\u0ce6', 'o'}, {'\u0ce7', 'b'}, {'\u0cec', 'o'}, {'\u0cee', 'o'}, {'\u0cef', 'b'}, {'\u0cf6', 'b'}, {'\u0cf7', 'b'}, {'\u0cfe', 'b'}, {'\u0cff', 'b'}, {'\u0d7f', '8'}, {'\u0dbf', '8'}, {'\u0ddf', '8'}, {'\u0def', '8'}, {'\u0df7', '8'}, {'\u0dfb', '8'}, {'\u0dfd', '8'}, {'\u0dfe', '8'}, {'\u0dff', '8'}, {'\u0e00', ','}, {'\u0e01', ','}, {'\u0e08', ','}, {'\u0e09', ','}, {'\u0e30', 'Y'}, {'\u0e31', 'Y'}, {'\u0e32', 'Y'}, {'\u0e33', 'Y'}, {'\u0e34', 'Y'}, {'\u0e35', 'Y'}, {'\u0e36', 'Y'}, {'\u0e37', 'Y'}, {'\u0e40', ','}, {'\u0e41', ','}, {'\u0e48', ','}, {'\u0e49', ','}, {'\u0e70', 'Y'}, {'\u0e71', 'Y'}, {'\u0e72', 'Y'}, {'\u0e73', 'Y'}, {'\u0e74', 'Y'}, {'\u0e75', 'Y'}, {'\u0e76', 'Y'}, {'\u0e77', 'Y'}, {'\u0e7f', '8'}, {'\u0e80', ','}, {'\u0e81', ','}, {'\u0e88', ','}, {'\u0e89', ','}, {'\u0eb0', 'Y'}, {'\u0eb1', 'Y'}, {'\u0eb2', 'Y'}, {'\u0eb3', 'Y'}, {'\u0eb4', 'Y'}, {'\u0eb5', 'Y'}, {'\u0eb6', 'Y'}, {'\u0eb7', 'Y'}, {'\u0ebf', '8'}, {'\u0ec0', 'd'}, {'\u0ec1', ','}, {'\u0ec2', 'd'}, {'\u0ec4', 'o'}, {'\u0ec6', 'o'}, {'\u0ec7', 'b'}, {'\u0ec8', 'd'}, {'\u0ec9', ','}, {'\u0eca', 'd'}, {'\u0ecc', 'o'}, {'\u0ece', 'o'}, {'\u0ecf', 'b'}, {'\u0ed0', 'd'}, {'\u0ed2', 'd'}, {'\u0ed4', 'd'}, {'\u0ed6', 'b'}, {'\u0ed7', 'b'}, {'\u0ed8', 'd'}, {'\u0eda', 'd'}, {'\u0edc', 'd'}, {'\u0ede', 'b'}, {'\u0edf', 'b'}, {'\u0ee0', 'd'}, {'\u0ee2', 'd'}, {'\u0ee4', 'o'}, {'\u0ee6', 'o'}, {'\u0ee7', 'b'}, {'\u0ee8', 'd'}, {'\u0eea', 'd'}, {'\u0eec', 'o'}, {'\u0eee', 'o'}, {'\u0eef', 'b'}, {'\u0ef0', 'd'}, {'\u0ef1', 'Y'}, {'\u0ef2', 'd'}, {'\u0ef3', 'Y'}, {'\u0ef4', 'd'}, {'\u0ef5', 'Y'}, {'\u0ef6', '8'}, {'\u0ef7', '8'}, {'\u0ef8', 'd'}, {'\u0efa', 'd'}, {'\u0efb', '8'}, {'\u0efc', 'd'}, {'\u0efd', '8'}, {'\u0efe', '8'}, {'\u0eff', '8'}, {'\u0f30', 'Y'}, {'\u0f31', 'Y'}, {'\u0f32', 'Y'}, {'\u0f33', 'Y'}, {'\u0f34', 'Y'}, {'\u0f35', 'Y'}, {'\u0f36', 'Y'}, {'\u0f37', 'Y'}, {'\u0f3f', '8'}, {'\u0f5f', '8'}, {'\u0f6f', '8'}, {'\u0f70', 'Y'}, {'\u0f71', 'Y'}, {'\u0f72', 'Y'}, {'\u0f73', 'Y'}, {'\u0f74', 'Y'}, {'\u0f75', 'Y'}, {'\u0f76', 'Y'}, {'\u0f77', 'Y'}, {'\u0f7b', '8'}, {'\u0f7d', '8'}, {'\u0f7e', '8'}, {'\u0f7f', '8'}, {'\u0f9f', '8'}, {'\u0faf', '8'}, {'\u0fb0', 'Y'}, {'\u0fb1', 'Y'}, {'\u0fb2', 'Y'}, {'\u0fb3', 'Y'}, {'\u0fb4', 'Y'}, {'\u0fb5', 'Y'}, {'\u0fb6', 'Y'}, {'\u0fb7', 'Y'}, {'\u0fbb', '8'}, {'\u0fbd', '8'}, {'\u0fbe', '8'}, {'\u0fbf', '8'}, {'\u0fc0', 'd'}, {'\u0fc2', 'd'}, {'\u0fc4', 'd'}, {'\u0fc6', 'd'}, {'\u0fc8', 'd'}, {'\u0fca', 'd'}, {'\u0fcc', 'd'}, {'\u0fce', 'd'}, {'\u0fcf', '8'}, {'\u0fd0', 'd'}, {'\u0fd2', 'd'}, {'\u0fd4', 'd'}, {'\u0fd6', 'd'}, {'\u0fd7', '8'}, {'\u0fd8', 'd'}, {'\u0fda', 'd'}, {'\u0fdb', '8'}, {'\u0fdc', 'd'}, {'\u0fdd', '8'}, {'\u0fde', 'd'}, {'\u0fdf', '8'}, {'\u0fe0', 'd'}, {'\u0fe2', 'd'}, {'\u0fe4', 'd'}, {'\u0fe6', 'd'}, {'\u0fe7', '8'}, {'\u0fe8', 'd'}, {'\u0fea', 'd'}, {'\u0feb', '8'}, {'\u0fec', 'd'}, {'\u0fed', '8'}, {'\u0fee', 'd'}, {'\u0fef', '8'}, {'\u0ff0', 'd'}, {'\u0ff1', 'Y'}, {'\u0ff2', 'd'}, {'\u0ff3', 'Y'}, {'\u0ff4', 'd'}, {'\u0ff5', 'Y'}, {'\u0ff6', '8'}, {'\u0ff7', '8'}, {'\u0ff8', 'd'}, {'\u0ff9', '8'}, {'\u0ffa', 'd'}, {'\u0ffb', '8'}, {'\u0ffc', 'd'}, {'\u0ffd', '8'}, {'\u0ffe', '8'}, {'\u0fff', '8'}};
    }
}

