/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GProgressDialog;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JMOVExporter;
import de.jave.javeplayer.JaveMovieFile;
import de.jave.javeplayer.JaveMovieFrame;
import de.jave.util.CancelAble;
import java.awt.Dimension;
import java.awt.Frame;

public class JaveMovieExportThread
extends Thread
implements CancelAble {
    protected GProgressDialog progressDialog;
    protected JaveMovieFile movieFile;
    protected JMOVExporter exporter;
    protected Frame parent;
    protected boolean shallStop;

    public JaveMovieExportThread(Frame frame, JaveMovieFile javeMovieFile, JMOVExporter jMOVExporter, GProgressDialog gProgressDialog) {
        this.progressDialog = gProgressDialog;
        this.parent = frame;
        this.movieFile = javeMovieFile;
        this.exporter = jMOVExporter;
        this.shallStop = false;
    }

    public void doCancel() {
        this.shallStop = true;
    }

    public void run() {
        Object object;
        try {
            this.progressDialog.setProgress(0.0);
            object = new Dimension(0, 0);
            int n = this.movieFile.getFrameCount();
            JaveMovieFrame javeMovieFrame = null;
            CharacterPlate characterPlate = null;
            int n2 = 0;
            while (n2 < n) {
                Thread.yield();
                javeMovieFrame = this.movieFile.getFrame(n2);
                characterPlate = new CharacterPlate(javeMovieFrame.getContent());
                if (characterPlate.getWidth() > ((Dimension)object).width) {
                    ((Dimension)object).width = characterPlate.getWidth();
                }
                if (characterPlate.getHeight() > ((Dimension)object).height) {
                    ((Dimension)object).height = characterPlate.getHeight();
                }
                ++n2;
            }
            if (this.shallStop) {
                this.aborted();
                return;
            }
            this.exporter.setMaxFrameSize((Dimension)object);
            this.exporter.init();
            Thread.yield();
            int n3 = 0;
            while (n3 < n) {
                javeMovieFrame = this.movieFile.getFrame(n3);
                Thread.yield();
                this.progressDialog.setProgress((double)n3 / (double)n);
                if (this.shallStop) {
                    this.aborted();
                    return;
                }
                characterPlate = new CharacterPlate(javeMovieFrame.getContent());
                char[][] cArray = javeMovieFrame.getSelection();
                if (cArray != null) {
                    new CharacterPlate(cArray).pasteInto(characterPlate, javeMovieFrame.getSelectionX(), javeMovieFrame.getSelectionY());
                }
                Thread.yield();
                this.exporter.setFrameDuration(javeMovieFrame.getDuration());
                this.exporter.setColors(javeMovieFrame.getForeground(), javeMovieFrame.getBackground());
                this.exporter.setFrameSize(characterPlate.getWidth(), characterPlate.getHeight());
                this.exporter.writeFrame(characterPlate.getContent());
                ++n3;
            }
            Thread.yield();
            this.exporter.close();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.progressDialog.dispose();
            this.exporter.emergencyCleanUp();
            new GErrorDialog(this.parent, "JavE Movie Editor", "Error exporting file: The result file is to big.").show();
            return;
        }
        catch (Throwable throwable) {
            this.progressDialog.dispose();
            this.exporter.emergencyCleanUp();
            new GErrorDialog(this.parent, "JavE Movie Editor", "Error exporting file", throwable).show();
            return;
        }
        this.progressDialog.dispose();
        object = "Export finished successfully.";
        new GDialog(this.parent, "JavE Movie Editor", (String)object, 3).show();
    }

    protected void aborted() throws Throwable {
        this.progressDialog.dispose();
        this.exporter.close();
        new GDialog(this.parent, "JavE Movie Editor", "Export aborted.", 2).show();
    }
}

