/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.Document;
import de.jave.jave.DocumentListener;
import de.jave.jave.Jave;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public abstract class JaveGame
implements KeyListener,
DocumentListener {
    protected Jave jave;
    protected CharacterPlate plate;
    protected Document document;
    protected boolean enabled;

    public JaveGame(Jave jave) {
        this.jave = jave;
        this.enabled = true;
        this.plate = new CharacterPlate(this.getPreferredSize());
        this.document = jave.pasteAsNewDocument(this.plate, this.getTitle());
        this.document.addDocumentListener(this);
        this.document.setModified(false);
        jave.setColorScheme(this.getPreferredColorScheme());
        jave.plate.addKeyListener(this);
        jave.switchToSelectonTool();
        this.requestFocus();
    }

    protected abstract Dimension getPreferredSize();

    protected abstract String getTitle();

    protected abstract int getPreferredColorScheme();

    protected abstract void keyPressed(KeyEvent var1, int var2, char var3);

    protected abstract void keyTyped(KeyEvent var1, int var2, char var3);

    public void quit() {
        this.jave.plate.removeKeyListener(this);
        this.document.setModified(false);
        this.jave.doClose();
    }

    protected void requestFocus() {
        this.jave.plate.requestFocus();
    }

    protected void repaint() {
        this.jave.plate.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.enabled) {
            this.keyPressed(keyEvent, keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.enabled) {
            this.keyTyped(keyEvent, keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
    }

    public void documentClosing() {
        this.jave.plate.removeKeyListener(this);
        this.document.setModified(false);
    }

    public void documentHiding() {
        this.enabled = false;
    }

    public void documentShowing() {
        this.requestFocus();
        this.jave.switchToSelectonTool();
        this.enabled = true;
    }

    public void documentChanged() {
    }
}

