/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.internet.HTMLTools;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.CharacterPlate;
import de.jave.jave.GifExportOptionsPanel;
import de.jave.jave.JMOVExportOptionsPanel;
import de.jave.jave.JaveAsciiPacker;
import de.jave.text.TextTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jmge.gif.DirectGif89Frame;
import net.jmge.gif.Gif89Encoder;

public class JMOVExporter {
    protected Gif89Encoder gifEncoder;
    protected String title = null;
    protected int outputFormat;
    protected String outputFilename;
    protected String outputFilenameEnding;
    protected BufferedWriter bw;
    protected int frameCount = 0;
    protected int frameWidth;
    protected int frameHeight;
    protected Dimension maxFrameSize;
    protected Color gifBGColor = Color.white;
    protected Color gifFGColor = Color.black;
    protected int gifScale;
    protected Font gifFont;
    protected boolean pixelView;
    protected Vector frameDurations;
    protected int totalDuration = 0;
    protected int currentDuration = 270;
    protected CharacterPlate lastContent = null;
    protected int ciffers = 4;

    public void setEstimatedFileCount(int n) {
        this.ciffers = 1;
        --n;
        while (n >= 10) {
            n /= 10;
            ++this.ciffers;
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean showOptionsDialogs(Frame frame, String string) {
        String string2;
        Object object;
        Container container;
        JMOVExportOptionsPanel jMOVExportOptionsPanel = new JMOVExportOptionsPanel("Export Output format");
        GDialog gDialog = new GDialog(frame, string, (Component)jMOVExportOptionsPanel, GDialog.OK_CANCEL);
        gDialog.show();
        if (gDialog.getAnswer() != 0) {
            return false;
        }
        this.outputFormat = jMOVExportOptionsPanel.getFormat();
        this.outputFilenameEnding = JMOVExportOptionsPanel.FILENAME_ENDINGS[this.outputFormat];
        if (this.outputFormat == 7 || this.outputFormat == 8) {
            container = new GifExportOptionsPanel(true);
            object = new GDialog(frame, "Batch conversion - GIF options", (Component)container, GDialog.OK_CANCEL);
            ((Dialog)object).show();
            if (((GDialog)object).getAnswer() != 0) {
                return false;
            }
            this.gifScale = ((GifExportOptionsPanel)container).getFontScale();
            string2 = ((GifExportOptionsPanel)container).getFontName();
            this.gifFont = ((GifExportOptionsPanel)container).getResultFont();
            this.pixelView = ((GifExportOptionsPanel)container).getPixelView();
        }
        container = new FileDialog(frame, "Export Output File", 1);
        ((FileDialog)container).setFile("*" + this.outputFilenameEnding);
        ((Dialog)container).show();
        object = ((FileDialog)container).getFile();
        string2 = ((FileDialog)container).getDirectory();
        if (object == null) {
            return false;
        }
        this.outputFilename = string2 + (String)object;
        if (this.outputFilename.endsWith(this.outputFilenameEnding)) {
            this.outputFilename = this.outputFilename.substring(0, this.outputFilename.length() - this.outputFilenameEnding.length());
        }
        return true;
    }

    public void setFrameSize(int n, int n2) {
        this.frameWidth = n;
        this.frameHeight = n2;
    }

    public void setMaxFrameSize(Dimension dimension) {
        this.maxFrameSize = dimension;
    }

    public void setColors(Color color, Color color2) {
        this.gifBGColor = color2;
        this.gifFGColor = color;
    }

    public void setFont(Font font) {
        this.gifFont = font;
    }

    public void setScale(int n) {
        this.gifScale = n;
    }

    public void setFrameDuration(int n) {
        this.currentDuration = n;
    }

    public void init() throws Exception {
        this.bw = null;
        this.frameDurations = new Vector();
        this.lastContent = null;
        switch (this.outputFormat) {
            case 0: {
                this.bw = new BufferedWriter(new FileWriter(this.outputFilename + this.outputFilenameEnding));
                this.bw.write("*:JavE 5.0 http://www.jave.de");
                this.bw.newLine();
                this.bw.newLine();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.bw = new BufferedWriter(new FileWriter(this.outputFilename + this.outputFilenameEnding));
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                this.gifEncoder = new Gif89Encoder();
                this.gifEncoder.setComments("Created using JavE 5.0 - http://www.jave.de");
                this.gifEncoder.setLoopCount(0);
            }
        }
    }

    public void writeFrame(char[][] cArray) throws Exception {
        switch (this.outputFormat) {
            case 0: {
                this.bw.write("J:");
                this.bw.write(JaveAsciiPacker.encode(cArray));
                this.bw.newLine();
                this.bw.newLine();
                break;
            }
            case 2: {
                int n;
                if (this.frameCount == 0) {
                    JMOVExporter.writeScrollbarAnimationHeader(this.bw, this.frameHeight);
                }
                if ((n = this.currentDuration / 67) < 1) {
                    n = 1;
                }
                String[] stringArray = TextTools.toStringArray(cArray);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        this.bw.write(stringArray[n3]);
                        this.bw.newLine();
                        ++n3;
                    }
                    this.bw.newLine();
                    ++n2;
                }
                break;
            }
            case 1: {
                if (this.frameCount == 0) {
                    JMOVExporter.writeScrollbarAnimationHeader(this.bw, this.frameHeight);
                }
            }
            case 5: {
                String[] stringArray = TextTools.toStringArray(cArray);
                int n = 0;
                while (n < stringArray.length) {
                    this.bw.write(stringArray[n]);
                    this.bw.newLine();
                    ++n;
                }
                this.bw.newLine();
                break;
            }
            case 4: {
                if (this.frameCount == 0) {
                    JMOVExporter.writeJavascriptAnimationHeader(this.bw, this.maxFrameSize.width, this.maxFrameSize.height, this.title);
                }
                this.writeJavascriptAnimationFrame(this.bw, cArray);
                break;
            }
            case 3: {
                if (this.frameCount == 0) {
                    JMOVExporter.writeCompressedJavascriptAnimationHeader(this.bw, this.maxFrameSize.width, this.maxFrameSize.height, this.title);
                }
                this.writeCompressedJavascriptAnimationFrame(this.bw, cArray);
                break;
            }
            case 6: {
                this.bw = new BufferedWriter(new FileWriter(this.outputFilename + "_" + TextTools.fillFront(String.valueOf(this.frameCount), '0', this.ciffers) + this.outputFilenameEnding));
                String[] stringArray = TextTools.toStringArray(cArray);
                int n = 0;
                while (n < stringArray.length) {
                    this.bw.write(stringArray[n]);
                    this.bw.newLine();
                    ++n;
                }
                this.bw.close();
                break;
            }
            case 8: {
                Image image = AsciiToThumbnailConverter.convert(new CharacterPlate(cArray), this.gifScale, this.gifFont, this.gifBGColor, this.gifFGColor, this.pixelView);
                Gif89Encoder gif89Encoder = new Gif89Encoder(image);
                gif89Encoder.setComments("Created using JavE 5.0 - http://www.jave.de");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.outputFilename + "_" + TextTools.fillFront(String.valueOf(this.frameCount), '0', this.ciffers) + this.outputFilenameEnding));
                gif89Encoder.encode(bufferedOutputStream);
                ((OutputStream)bufferedOutputStream).close();
                break;
            }
            case 7: {
                Image image = AsciiToThumbnailConverter.convert(new CharacterPlate(cArray), this.gifScale, this.gifFont, this.gifBGColor, this.gifFGColor, this.pixelView);
                DirectGif89Frame directGif89Frame = new DirectGif89Frame(image);
                directGif89Frame.setDelay(this.currentDuration / 10);
                this.gifEncoder.addFrame(directGif89Frame);
            }
        }
        this.frameDurations.addElement(new Integer(this.currentDuration));
        ++this.frameCount;
        this.totalDuration += this.currentDuration;
        this.lastContent = new CharacterPlate(cArray);
    }

    public void emergencyCleanUp() {
        try {
            if (this.bw != null) {
                this.bw.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void close() throws Exception {
        switch (this.outputFormat) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                this.bw.close();
                break;
            }
            case 4: {
                this.writeJavascriptAnimationFooter(this.bw);
                this.bw.close();
                break;
            }
            case 3: {
                this.writeCompressedJavascriptAnimationFooter(this.bw);
                this.bw.close();
                break;
            }
            case 7: {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.outputFilename + this.outputFilenameEnding));
                this.gifEncoder.encode(bufferedOutputStream);
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    protected static void writeScrollbarAnimationHeader(BufferedWriter bufferedWriter, int n) throws IOException {
        if ((n += 2) < 9) {
            int n2 = n - 2;
            bufferedWriter.write(",--> Resize your browser window until this line is at the top and... <-.");
            bufferedWriter.newLine();
            int n3 = 0;
            while (n3 < n2) {
                bufferedWriter.write("|                                                                      |");
                bufferedWriter.newLine();
                ++n3;
            }
            bufferedWriter.write("`-> ...this one is at the bottom. Hit page down repeatedly to scroll.<-'");
            bufferedWriter.newLine();
        } else {
            int n4 = n - 9;
            int n5 = (n4 + 2) / 3;
            int n6 = (n4 - n5 + 1) / 2;
            int n7 = n4 - n5 - n6;
            bufferedWriter.write("---> Resize your browser window until this line is at the top and... <--");
            bufferedWriter.newLine();
            bufferedWriter.write("] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [");
            bufferedWriter.newLine();
            bufferedWriter.write("------------------------------------------------------------------------");
            bufferedWriter.newLine();
            int n8 = 0;
            while (n8 < n5) {
                bufferedWriter.write("    |                 |                 |                 |");
                bufferedWriter.newLine();
                ++n8;
            }
            bufferedWriter.write("    |   Scrollbar     |   Scrollbar     |   Scrollbar     |   Scrollbar");
            bufferedWriter.newLine();
            bufferedWriter.write("    |    Animation    |    Animation    |    Animation    |    Animation");
            bufferedWriter.newLine();
            int n9 = 0;
            while (n9 < n6) {
                bufferedWriter.write("    |                 |                 |                 |");
                bufferedWriter.newLine();
                ++n9;
            }
            bufferedWriter.write("    |            (created using JavE 5.0 - http://www.jave.de)");
            bufferedWriter.newLine();
            int n10 = 0;
            while (n10 < n7) {
                bufferedWriter.write("    |                 |                 |                 |");
                bufferedWriter.newLine();
                ++n10;
            }
            bufferedWriter.write("------------------------------------------------------------------------");
            bufferedWriter.newLine();
            bufferedWriter.write("] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [] [");
            bufferedWriter.newLine();
            bufferedWriter.write("--> ...this one is at the bottom. Hit page down repeatedly to scroll.<--");
            bufferedWriter.newLine();
        }
    }

    protected static void writeJavascriptAnimationHeader(BufferedWriter bufferedWriter, int n, int n2, String string) throws IOException {
        bufferedWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<HTML><HEAD><TITLE>");
        if (string == null) {
            bufferedWriter.write("Javascript Animation");
        } else {
            bufferedWriter.write(HTMLTools.encode(string));
        }
        bufferedWriter.write("</TITLE></HEAD>");
        bufferedWriter.newLine();
        bufferedWriter.write("<BODY bgcolor=\"#000000\" onLoad=\"Play()\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<FORM NAME=\"f\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<TEXTAREA COLS=" + n + " ROWS=" + n2 + " NAME=\"ta\" basefont=\"courier\" WRAP=\"physical\" VALUE=\"\">");
        bufferedWriter.newLine();
        bufferedWriter.write("</TEXTAREA> <input type=\"button\" name=\"b1\" value=' \" ' onclick=\"freeze()\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<input type=\"button\" name=\"b2\" value='show' onclick=\"page()\">");
        bufferedWriter.newLine();
        bufferedWriter.write("</FORM>");
        bufferedWriter.newLine();
        bufferedWriter.write("<SCRIPT LANGUAGE=\"JavaScript\"><!--");
        bufferedWriter.newLine();
        bufferedWriter.write("No=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("Rows=" + n2 + ";");
        bufferedWriter.newLine();
        bufferedWriter.write("Cols=" + (n + 1) + ";");
        bufferedWriter.newLine();
        bufferedWriter.write("go=true;");
        bufferedWriter.newLine();
        bufferedWriter.write("var Ascii = \"\"");
    }

    protected void writeJavascriptAnimationFrame(BufferedWriter bufferedWriter, char[][] cArray) throws IOException {
        String[] stringArray = TextTools.toStringArray(cArray);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() < this.maxFrameSize.width) {
                stringArray[n] = stringArray[n] + JMOVExporter.spaces(this.maxFrameSize.width - stringArray[n].length());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.maxFrameSize.height) {
            bufferedWriter.newLine();
            bufferedWriter.write("+\"");
            if (n2 < stringArray.length) {
                this.writeAsJavaScript(bufferedWriter, stringArray[n2]);
            } else {
                bufferedWriter.write(JMOVExporter.spaces(this.maxFrameSize.width));
            }
            bufferedWriter.write("\\r\\n\"");
            ++n2;
        }
    }

    protected void writeJavascriptAnimationFooter(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(";");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("var Delay = new Array(");
        int n = 0;
        while (n < this.frameDurations.size()) {
            bufferedWriter.write(this.frameDurations.elementAt(n).toString());
            if (n < this.frameDurations.size() - 1) {
                if ((n + 1) % 16 == 0) {
                    bufferedWriter.write(",");
                    bufferedWriter.newLine();
                } else {
                    bufferedWriter.write(", ");
                }
            }
            ++n;
        }
        bufferedWriter.write(");");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("PicLength=Rows*(Cols+1);");
        bufferedWriter.newLine();
        bufferedWriter.write("No_Pics=Ascii.length/PicLength;");
        bufferedWriter.newLine();
        bufferedWriter.write("function MakeArray()");
        bufferedWriter.newLine();
        bufferedWriter.write("  {");
        bufferedWriter.newLine();
        bufferedWriter.write("  this.length = No_Pics;");
        bufferedWriter.newLine();
        bufferedWriter.write("  for(var i=0;i<No_Pics;i++) {");
        bufferedWriter.newLine();
        bufferedWriter.write("    this[i]=Ascii.substring(PicLength*i,PicLength*(1+i));");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.write("A=new MakeArray();");
        bufferedWriter.newLine();
        bufferedWriter.write("function Play()");
        bufferedWriter.newLine();
        bufferedWriter.write(" {");
        bufferedWriter.newLine();
        bufferedWriter.write("  ms = Delay[No];");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (go){");
        bufferedWriter.newLine();
        bufferedWriter.write("    document.f.ta.value = A[No];");
        bufferedWriter.newLine();
        bufferedWriter.write("    No++;");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (No >= No_Pics)");
        bufferedWriter.newLine();
        bufferedWriter.write("    No = 0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  setTimeout(\"Play()\", ms);");
        bufferedWriter.newLine();
        bufferedWriter.write(" }");
        bufferedWriter.newLine();
        bufferedWriter.write("function freeze() {go=!go;}");
        bufferedWriter.newLine();
        bufferedWriter.write("function page()");
        bufferedWriter.newLine();
        bufferedWriter.write("  {");
        bufferedWriter.newLine();
        bufferedWriter.write("  var n=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  var m=No_Pics;");
        bufferedWriter.newLine();
        bufferedWriter.write("  var a=A;");
        bufferedWriter.newLine();
        bufferedWriter.write("  document.write(\"<HTML>\\n<HEAD><TITLE>Show Single Pictures</TITLE></HEAD>\\n\");");
        bufferedWriter.newLine();
        bufferedWriter.write("  document.write(\"<BODY>\\n<PRE>\\n\");");
        bufferedWriter.newLine();
        bufferedWriter.write("  for (n=0;n<m;n++)");
        bufferedWriter.newLine();
        bufferedWriter.write("    {");
        bufferedWriter.newLine();
        bufferedWriter.write("    document.write(a[n]);");
        bufferedWriter.newLine();
        bufferedWriter.write("    document.write(\"\\n\\n\");");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("  document.write(\"</PRE>\\n</BODY>\\n</HTML>\");");
        bufferedWriter.newLine();
        bufferedWriter.write("  document.close();");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.write("  //--></SCRIPT>");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("</BODY></HTML>");
        bufferedWriter.newLine();
    }

    protected static void writeCompressedJavascriptAnimationHeader(BufferedWriter bufferedWriter, int n, int n2, String string) throws IOException {
        bufferedWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<HTML><HEAD><TITLE>");
        if (string == null) {
            bufferedWriter.write("Javascript Animation");
        } else {
            bufferedWriter.write(HTMLTools.encode(string));
        }
        bufferedWriter.write("</TITLE><style type=\"text/css\"><!--.f { font-family: monospace; }--></style></HEAD>");
        bufferedWriter.newLine();
        bufferedWriter.write("<BODY onLoad=\"Play(); Progress()\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<FORM NAME=\"f\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<TEXTAREA COLS=" + n + " ROWS=" + n2 + " NAME=\"ta\" basefont=\"courier\" WRAP=\"physical\" VALUE=\"\">");
        bufferedWriter.newLine();
        bufferedWriter.write("</TEXTAREA>");
        bufferedWriter.newLine();
        bufferedWriter.write("<br>");
        bufferedWriter.newLine();
        bufferedWriter.write("<input type=\"checkbox\" name=\"loop\"> Loop");
        bufferedWriter.newLine();
        bufferedWriter.write("<input type=\"button\" name=\"b1\" value=' \" ' onclick=\"freeze()\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<input type=\"text\" size=20 class=\"f\" name=\"progress\">");
        bufferedWriter.newLine();
        bufferedWriter.write("</FORM>");
        bufferedWriter.newLine();
        bufferedWriter.write("<SCRIPT LANGUAGE=\"JavaScript1.2\"><!--");
        bufferedWriter.newLine();
        bufferedWriter.write("No=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("go=true;");
        bufferedWriter.newLine();
        bufferedWriter.write("var frames = new Array(");
    }

    protected void writeAsJavaScript(BufferedWriter bufferedWriter, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\\"<>", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\\")) {
                bufferedWriter.write("\\\\");
                continue;
            }
            if (string2.equals("\"")) {
                bufferedWriter.write("\\\"");
                continue;
            }
            if (string2.equals("<")) {
                bufferedWriter.write("\\x3C");
                continue;
            }
            if (string2.equals(">")) {
                bufferedWriter.write("\\x3E");
                continue;
            }
            bufferedWriter.write(string2);
        }
    }

    protected void writeCompressedJavascriptAnimationFrame(BufferedWriter bufferedWriter, char[][] cArray) throws IOException {
        if (this.frameCount > 0) {
            bufferedWriter.write(",");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("\"");
        CharacterPlate characterPlate = new CharacterPlate(cArray);
        String string = JMOVExporter.getDifferenceCode(this.lastContent, characterPlate);
        if (string != null) {
            this.writeAsJavaScript(bufferedWriter, string);
        } else {
            this.writeAsJavaScript(bufferedWriter, JaveAsciiPacker.encodeOptimized(cArray));
        }
        bufferedWriter.write("\"");
    }

    protected static String getDifferenceCode(CharacterPlate characterPlate, CharacterPlate characterPlate2) {
        if (characterPlate == null || characterPlate2 == null) {
            return null;
        }
        int n = characterPlate.getWidth();
        int n2 = characterPlate.getHeight();
        if (characterPlate2.getWidth() != n || characterPlate2.getHeight() != n2) {
            return null;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            if (!characterPlate.getLine(n4).equals(characterPlate2.getLine(n4))) {
                if (n3 != -1) {
                    return null;
                }
                n3 = n4;
            }
            ++n4;
        }
        if (n3 == -1) {
            return "";
        }
        String string = characterPlate.getLine(n3);
        String string2 = characterPlate2.getLine(n3);
        int n5 = 0;
        while (n5 < n && string.charAt(n5) == string2.charAt(n5)) {
            ++n5;
        }
        int n6 = n - n5;
        while (n6 > 1 && string.charAt(n5 + n6 - 1) == string2.charAt(n5 + n6 - 1)) {
            --n6;
        }
        if (n5 == 0) {
            return "D" + n3 + ":" + string2.substring(n5, n5 + n6);
        }
        return "D" + n3 + "%" + n5 + ":" + string2.substring(n5, n5 + n6);
    }

    protected void writeCompressedJavascriptAnimationFooter(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(");");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        int n = 0;
        bufferedWriter.write("var MStotal = " + this.totalDuration + ";");
        bufferedWriter.newLine();
        bufferedWriter.write("var Delay = new Array(");
        int n2 = 0;
        while (n2 < this.frameDurations.size()) {
            int n3 = (Integer)this.frameDurations.elementAt(n2);
            if (n2 > 0 && n == n3) {
                bufferedWriter.write("0");
            } else if (n3 == 0) {
                bufferedWriter.write("1");
            } else {
                bufferedWriter.write(String.valueOf(n3));
            }
            n = n3;
            if (n2 < this.frameDurations.size() - 1) {
                bufferedWriter.write(",");
            }
            if ((n2 + 1) % 16 == 0) {
                bufferedWriter.newLine();
            }
            ++n2;
        }
        bufferedWriter.write(");");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function decodeA(code){");
        bufferedWriter.newLine();
        bufferedWriter.write("  var length=code.length;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //1) Algorithm marker");
        bufferedWriter.newLine();
        bufferedWriter.write("  var index=1;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //2) Width");
        bufferedWriter.newLine();
        bufferedWriter.write("  var w=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  var ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("  var num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  while(!isNaN(num)){");
        bufferedWriter.newLine();
        bufferedWriter.write("    w *= 10;");
        bufferedWriter.newLine();
        bufferedWriter.write("    w += num;");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //3) Height");
        bufferedWriter.newLine();
        bufferedWriter.write("  var h=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("  num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  while(!isNaN(num)){");
        bufferedWriter.newLine();
        bufferedWriter.write("    h *= 10;");
        bufferedWriter.newLine();
        bufferedWriter.write("    h += num;");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var chars = new String();");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  while(index<length)");
        bufferedWriter.newLine();
        bufferedWriter.write("  {");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch = code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("    if (ch != '%')");
        bufferedWriter.newLine();
        bufferedWriter.write("        chars += ch;");
        bufferedWriter.newLine();
        bufferedWriter.write("    else");
        bufferedWriter.newLine();
        bufferedWriter.write("    {");
        bufferedWriter.newLine();
        bufferedWriter.write("      ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("      if (ch=='%')");
        bufferedWriter.newLine();
        bufferedWriter.write("        chars += '%';");
        bufferedWriter.newLine();
        bufferedWriter.write("      else if (ch=='0')");
        bufferedWriter.newLine();
        bufferedWriter.write("        chars += \"\\r\\n\";");
        bufferedWriter.newLine();
        bufferedWriter.write("      else");
        bufferedWriter.newLine();
        bufferedWriter.write("      {");
        bufferedWriter.newLine();
        bufferedWriter.write("        //how many characters?");
        bufferedWriter.newLine();
        bufferedWriter.write("        var count=Number(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("        ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("        num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("        while(!isNaN(num))");
        bufferedWriter.newLine();
        bufferedWriter.write("        {");
        bufferedWriter.newLine();
        bufferedWriter.write("          count = count * 10;");
        bufferedWriter.newLine();
        bufferedWriter.write("          count = count + num;");
        bufferedWriter.newLine();
        bufferedWriter.write("          ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("          num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("        }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("        if (ch=='%')");
        bufferedWriter.newLine();
        bufferedWriter.write("          ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("        //count times ch");
        bufferedWriter.newLine();
        bufferedWriter.write("        for (var i=0;i<count;++i)");
        bufferedWriter.newLine();
        bufferedWriter.write("          chars += ch;");
        bufferedWriter.newLine();
        bufferedWriter.write("      }");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  return chars;");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function decodeB(code){");
        bufferedWriter.newLine();
        bufferedWriter.write("  var length=code.length;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //1) Algorithm marker");
        bufferedWriter.newLine();
        bufferedWriter.write("  var index=1;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //2) Width");
        bufferedWriter.newLine();
        bufferedWriter.write("  var w=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  var ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("  var num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  while(!isNaN(num)){");
        bufferedWriter.newLine();
        bufferedWriter.write("    w*=10;");
        bufferedWriter.newLine();
        bufferedWriter.write("    w+=num;");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  //3) Height");
        bufferedWriter.newLine();
        bufferedWriter.write("  var h=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("  num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  while(!isNaN(num) && index<length){");
        bufferedWriter.newLine();
        bufferedWriter.write("    h*=10;");
        bufferedWriter.newLine();
        bufferedWriter.write("    h+=num;");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var chars = new String();");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var i=index;");
        bufferedWriter.newLine();
        bufferedWriter.write("  for (var y=0;y<h;++y){");
        bufferedWriter.newLine();
        bufferedWriter.write("    for (var x=0;x<w;++x){");
        bufferedWriter.newLine();
        bufferedWriter.write("      if (i>=length)");
        bufferedWriter.newLine();
        bufferedWriter.write("        return chars;");
        bufferedWriter.newLine();
        bufferedWriter.write("      else");
        bufferedWriter.newLine();
        bufferedWriter.write("        chars += code.charAt(i);");
        bufferedWriter.newLine();
        bufferedWriter.write("      ++i;");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("    chars += \"\\r\\n\";");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  return chars;");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("preFrame = \"\";");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function decodeD(code){");
        bufferedWriter.newLine();
        bufferedWriter.write("  var a = preFrame.split(\"\\r\\n\");");
        bufferedWriter.newLine();
        bufferedWriter.write("  var index = 1;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var y = 0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("  num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  while(!isNaN(num)){");
        bufferedWriter.newLine();
        bufferedWriter.write("    y *= 10;");
        bufferedWriter.newLine();
        bufferedWriter.write("    y += num;");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var x = 0;");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (ch == '%'){");
        bufferedWriter.newLine();
        bufferedWriter.write("    ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("    num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("    while(!isNaN(num)){");
        bufferedWriter.newLine();
        bufferedWriter.write("      x *= 10;");
        bufferedWriter.newLine();
        bufferedWriter.write("      x += num;");
        bufferedWriter.newLine();
        bufferedWriter.write("      ch=code.charAt(index++);");
        bufferedWriter.newLine();
        bufferedWriter.write("      num=parseInt(ch);");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  if (y >= a.length)");
        bufferedWriter.newLine();
        bufferedWriter.write("    a[y] = \"\";");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  if (a[y].length < x)");
        bufferedWriter.newLine();
        bufferedWriter.write("    for (i = a[y].length; i < x; i++)");
        bufferedWriter.newLine();
        bufferedWriter.write("      a[y] += \" \";");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  s = code.slice(index);");
        bufferedWriter.newLine();
        bufferedWriter.write("  a[y] = a[y].substr(0, x) + s + a[y].slice(x + s.length);");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  return a.join(\"\\r\\n\");");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function decode(code){");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (code.length<4)");
        bufferedWriter.newLine();
        bufferedWriter.write("    return preFrame;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  var algorithm = code.charAt(0);");
        bufferedWriter.newLine();
        bufferedWriter.write("  switch (algorithm){");
        bufferedWriter.newLine();
        bufferedWriter.write("    case 'A':");
        bufferedWriter.newLine();
        bufferedWriter.write("      preFrame = decodeA(code);");
        bufferedWriter.newLine();
        bufferedWriter.write("      break;");
        bufferedWriter.newLine();
        bufferedWriter.write("    case 'B':");
        bufferedWriter.newLine();
        bufferedWriter.write("      preFrame = decodeB(code);");
        bufferedWriter.newLine();
        bufferedWriter.write("      break;");
        bufferedWriter.newLine();
        bufferedWriter.write("    case 'D':");
        bufferedWriter.newLine();
        bufferedWriter.write("      preFrame = decodeD(code);");
        bufferedWriter.newLine();
        bufferedWriter.write("      break;");
        bufferedWriter.newLine();
        bufferedWriter.write("    default:");
        bufferedWriter.newLine();
        bufferedWriter.write("      return \"ERROR\";");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  return preFrame;");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("lastMS=0;");
        bufferedWriter.newLine();
        bufferedWriter.write("MSsum=0;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function Play(){");
        bufferedWriter.newLine();
        bufferedWriter.write("  ms = Delay[No];");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (ms==0)");
        bufferedWriter.newLine();
        bufferedWriter.write("    ms=lastMS;");
        bufferedWriter.newLine();
        bufferedWriter.write("  lastMS=ms;");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  if (go){");
        bufferedWriter.newLine();
        bufferedWriter.write("    document.f.ta.value = decode(frames[No]);");
        bufferedWriter.newLine();
        bufferedWriter.write("    if (No < frames.length - 1){");
        bufferedWriter.newLine();
        bufferedWriter.write("      No++;");
        bufferedWriter.newLine();
        bufferedWriter.write("      MSsum += ms;");
        bufferedWriter.newLine();
        bufferedWriter.write("    }else");
        bufferedWriter.newLine();
        bufferedWriter.write("    if (document.f.loop.checked){");
        bufferedWriter.newLine();
        bufferedWriter.write("      No = 0;");
        bufferedWriter.newLine();
        bufferedWriter.write("      MSsum = 0;");
        bufferedWriter.newLine();
        bufferedWriter.write("    }");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("  setTimeout(\"Play()\", ms);");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function Progress(){");
        bufferedWriter.newLine();
        bufferedWriter.write("  if (go){");
        bufferedWriter.newLine();
        bufferedWriter.write("    p = Math.floor(20 * MSsum / MStotal);");
        bufferedWriter.newLine();
        bufferedWriter.write("    s = \"\";");
        bufferedWriter.newLine();
        bufferedWriter.write("    for (i = 0; i < 20; i++)");
        bufferedWriter.newLine();
        bufferedWriter.write("      s += i == p ? \"O\" : \"-\";");
        bufferedWriter.newLine();
        bufferedWriter.write("    document.f.progress.value = s;");
        bufferedWriter.newLine();
        bufferedWriter.write("  }");
        bufferedWriter.newLine();
        bufferedWriter.write("  setTimeout(\"Progress()\", 500);");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("function freeze()");
        bufferedWriter.newLine();
        bufferedWriter.write("{");
        bufferedWriter.newLine();
        bufferedWriter.write("  go=!go;");
        bufferedWriter.newLine();
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.write("  //--></SCRIPT>");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("</BODY></HTML>");
        bufferedWriter.newLine();
    }

    protected static final String spaces(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 32;
            ++n2;
        }
        return new String(cArray);
    }
}

