/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.calculus.CalculusTool;
import de.jave.calculus.ParseException;
import de.jave.formula2.Formula2;
import de.jave.gui.GChoice;
import de.jave.gui.GGridLayout;
import de.jave.gui.VFlowLayout;
import de.jave.jave.CharacterPlate;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FunctionPlotTool
extends DialogTool
implements ItemListener,
NumberListener,
TextListener {
    protected static final String[] STR_STYLE = new String[]{"lines", "dot", "2by2 (JFL...)", "3by2", "Felt pen 8"};
    protected static final int[] MODE = new int[]{0, 2, 4, 13, 6};
    protected TextField tfFormula;
    protected GChoice chStyle;
    protected Checkbox cbLegend;
    protected TextField dfXMin;
    protected TextField dfXMax;
    protected TextField dfYMin;
    protected TextField dfYMax;
    protected TextField dfAxisX;
    protected TextField dfAxisY;

    public FunctionPlotTool(Jave jave, Plate plate) {
        super(jave, plate);
    }

    protected int getPreferredColorScheme() {
        return 0;
    }

    public Component getOptionsComponent() {
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout(0, 2, 2, 2));
        this.dfXMin = new TextField("-4.7", 10);
        this.dfXMin.addTextListener(this);
        panel.add(new Label("X min:", 2));
        panel.add(this.dfXMin);
        this.dfXMax = new TextField("4.7", 10);
        this.dfXMax.addTextListener(this);
        panel.add(new Label("X max:", 2));
        panel.add(this.dfXMax);
        this.dfYMin = new TextField("-9.0", 10);
        this.dfYMin.addTextListener(this);
        panel.add(new Label("Y min:", 2));
        panel.add(this.dfYMin);
        this.dfYMax = new TextField("9.0", 10);
        this.dfYMax.addTextListener(this);
        panel.add(new Label("Y max:", 2));
        panel.add(this.dfYMax);
        this.dfAxisX = new TextField("0.0", 10);
        this.dfAxisX.addTextListener(this);
        panel.add(new Label("Axis X=", 2));
        panel.add(this.dfAxisX);
        this.dfAxisY = new TextField("0.0", 10);
        this.dfAxisY.addTextListener(this);
        panel.add(new Label("Axis Y=", 2));
        panel.add(this.dfAxisY);
        this.tfFormula = new TextField("sin(x)+x/2");
        this.tfFormula.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.tfFormula.addTextListener(this);
        Label label = new Label("f(x)=", 2);
        label.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        Panel panel2 = new Panel();
        panel2.add(label);
        panel2.add(this.tfFormula);
        Panel panel3 = new Panel();
        this.chStyle = new GChoice("Style:", STR_STYLE);
        this.chStyle.addItemListener(this);
        this.cbLegend = new Checkbox("Legend", false);
        this.cbLegend.addItemListener(this);
        panel3.add(this.chStyle);
        panel3.add(this.cbLegend);
        Panel panel4 = new Panel();
        panel4.setLayout(new VFlowLayout());
        panel4.add(panel2);
        panel4.add(panel);
        panel4.add(panel3);
        return panel4;
    }

    protected Dimension getPreferredPlateSize() {
        return JaveGlobalRessources.getDefaultDocumentDimension();
    }

    protected String getToolTitle() {
        return "Function Plotter";
    }

    public String getToolActionName() {
        return "plot";
    }

    protected void toolStarted() {
        this.convert();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.convert();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.convert();
    }

    public void numberChanged(NumberEvent numberEvent) {
        this.convert();
    }

    protected void convert() {
        double d;
        int n = 70;
        int n2 = 30;
        double d2 = -4.7;
        double d3 = 4.7;
        double d4 = -9.0;
        double d5 = 9.0;
        try {
            d2 = Double.valueOf(this.dfXMin.getText());
            this.dfXMin.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXMin.setForeground(Color.red);
            return;
        }
        try {
            d3 = Double.valueOf(this.dfXMax.getText());
            this.dfXMax.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXMax.setForeground(Color.red);
            return;
        }
        try {
            d4 = Double.valueOf(this.dfYMin.getText());
            this.dfYMin.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfYMin.setForeground(Color.red);
            return;
        }
        try {
            d5 = Double.valueOf(this.dfYMax.getText());
            this.dfYMax.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfYMax.setForeground(Color.red);
            return;
        }
        if (d3 == d2) {
            this.dfXMin.setForeground(Color.magenta);
            this.dfXMax.setForeground(Color.magenta);
            return;
        }
        if (d5 == d4) {
            this.dfYMin.setForeground(Color.magenta);
            this.dfYMax.setForeground(Color.magenta);
            return;
        }
        if (d2 > d3) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        if (d4 > d5) {
            d = d4;
            d4 = d5;
            d5 = d;
        }
        d = 0.0;
        double d6 = 0.0;
        try {
            d = Double.valueOf(this.dfAxisX.getText());
            this.dfAxisX.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfAxisX.setForeground(Color.red);
            return;
        }
        try {
            d6 = Double.valueOf(this.dfAxisY.getText());
            this.dfAxisY.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfAxisY.setForeground(Color.red);
            return;
        }
        if (d < d2) {
            d = d2;
            this.dfAxisX.setForeground(Color.magenta);
        } else if (d > d3) {
            d = d3;
            this.dfAxisX.setForeground(Color.magenta);
        }
        if (d6 < d4) {
            d6 = d4;
            this.dfAxisY.setForeground(Color.magenta);
        } else if (d6 > d5) {
            d6 = d5;
            this.dfAxisY.setForeground(Color.magenta);
        }
        int n3 = 0;
        int n4 = MODE[this.chStyle.getSelectedIndex()];
        String string = this.tfFormula.getText();
        CharacterPlate characterPlate = CalculusTool.createAxis(n3, d, d6, n, n2, d2, d3, d4, d5);
        characterPlate.setMix(false);
        try {
            CalculusTool.plotFunction(string, n4, n, n2, d2, d3, d4, d5, characterPlate);
        }
        catch (ParseException parseException) {
            characterPlate.paste("No valid expression!", 1, 1);
        }
        this.characterPlate.clear();
        characterPlate.pasteIntoForce(this.characterPlate, 0, 0);
        if (this.cbLegend.getState()) {
            String string2 = null;
            try {
                string2 = Formula2.toAscii(string);
            }
            catch (de.jave.formula2.ParseException parseException) {
                string2 = "No valid expression!";
            }
            CharacterPlate characterPlate2 = new CharacterPlate(string2);
            characterPlate2.pasteInto(this.characterPlate, 1, 1);
        }
        this.repaintPlate();
    }
}

