/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.figlet.FIGFileManager;
import de.jave.gui.CenterLayout;
import de.jave.gui.FilenameTextField;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GGridLayout2;
import de.jave.gui.GLabel;
import de.jave.gui.GTextArea;
import de.jave.gui.GUpDownArrangement;
import de.jave.gui.Wizard;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Document;
import de.jave.jave.FigletDialog;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.Plate;
import de.jave.jave.WatermarkPainterExclusive;
import de.jave.text.TextTools;
import de.jave.util.Toolbox;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;

public class FigletExportAssistant
extends Wizard
implements WatermarkPainterExclusive,
TextListener,
ItemListener,
NumberListener,
ActionListener {
    protected Jave jave;
    protected Plate plate;
    protected static final String TITLE = "FIGlet Font Export Assistant";
    protected int figCharWidth;
    protected int figCharHeight;
    protected int figCharDescent;
    protected int figCharHSpacing;
    protected int figCharVSpacing;
    protected TextArea taRaster;
    protected IntegerTextField ifWidth;
    protected IntegerTextField ifHeight;
    protected IntegerTextField ifDescent;
    protected IntegerTextField ifHSpacing;
    protected IntegerTextField ifVSpacing;
    protected FigletDialog testFigletDialog;
    protected TextField tfFilename;
    protected TextArea taComments;
    protected Checkbox[] chSmushing;
    protected Choice chHDefaultLayout;
    protected Choice chVDefaultLayout;
    protected Button bTest;
    protected Choice chRaster;
    protected static final String TMP_FILE_NAME = JaveGlobalRessources.codeBase + "/tmp/test_font.flf";
    protected static final String FIGLET_TEST_TITLE = "FIGlet Editor - Test new font";
    protected boolean rememberGrid;
    protected static final String[] DEFAULT_RASTERS = new String[]{"ABCDEFG\nHIJKLMN\nOPQRSTU\nVWXYZ \n!\"=+-:;", "ABCDEFGHIJ\nKLMNOPQRST\nUVWXYZ\n0123456789\nabcdefghij\nklmnopqrst\nuvwxyz\n\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\n !\"#$%&'\n()*+,-./\n:;<=>?@\n[\\]^_\u00b4{|}~"};
    protected static final String[] DEFAULT_RASTERS_NAMES = new String[]{"minimal", "complete"};
    protected static final String SUCCEED_MESSAGE = "Your new FIGlet font has been saved into JavE's font folder.\nAfter restarting JavE it will be available in the category 'new'.\n\nPlease consider making your font public by informing the\npeople on the newsgroup alt.ascii-art or JavE's program author\nmarkus@jave.de.\n\nDon't forget to backup a copy of this font so you will not\naccidently lose it!";
    protected static final int[][] UMLAUTS = new int[][]{{196, 65}, {214, 79}, {220, 85}, {228, 97}, {246, 111}, {252, 117}, {223, 32}};
    protected static final String[] SMUSHING = new String[]{"Equal character smushing", "Underscore smushing", "Hierarchy smushing", "Opposite pair smushing", "Big X smushing", "Hardblank smushing", "Equal character smushing", "Underscore smushing", "Hierarchy smushing", "Horizontal line smushing", "Vertical line supersmushing"};
    protected static final int[] SMUSHING_SUMMANDS = new int[]{1, 2, 4, 8, 16, 32, 256, 512, 1024, 2048, 4096};
    protected static final String[] STEP_LABELS = new String[]{"FIGlet font export assistant", "Step 1: Adjust character size", "Step 2: Adjust arrangement", "Step 3: Adjust layout rules", "Step 4: Add comments", "You are almost finished"};
    protected static final String[] STEP_INSTRUCTIONS = new String[]{"This assistant will help you creating you own FIGlet font.", "Adjust the dimensions to fit the characters you have created.\nSee the raster in the current document to validate these settings.\nDon't forget to adjust the descent (number of lines underneath the baseline).", "Edit the character mask below to make the raster fit your character arrangement.\n(You can still use the selection tool to move the FIGlet characters you have created)", "Take a minute to carefully adjust the layout rules.", "Add some comments to let everybody know who created this font.\nSome notes have already been added automatically.", "Finally enter an appropriate name for the new font."};

    public FigletExportAssistant(Jave jave, Plate plate) {
        super(jave, TITLE, false);
        this.jave = jave;
        this.plate = plate;
        this.ifWidth.setValue(8);
        this.ifHeight.setValue(5);
        this.ifDescent.setValue(1);
    }

    public void show() {
        super.show();
        if (this.plate.hasSelection()) {
            Rectangle rectangle = this.plate.getSelectionRegion();
            this.figCharWidth = rectangle.width;
            this.figCharHeight = rectangle.height;
            this.figCharDescent = 1;
            this.plate.dropSelection();
            this.ifWidth.setValue(this.figCharWidth);
            this.ifHeight.setValue(this.figCharHeight);
            this.ifDescent.setValue(this.figCharDescent);
        }
        this.plate.addWatermarkPainter(this);
        this.rememberGrid = this.jave.isGridVisible();
        this.jave.setGridVisible(false);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.step == 0) {
            return;
        }
        graphics.setFont(JaveGlobalRessources.FONT_SMALL);
        FontMetrics fontMetrics = this.getFontMetrics(JaveGlobalRessources.FONT_SMALL);
        int n7 = fontMetrics.getAscent();
        char[][] cArray = this.getRaster();
        int n8 = 0;
        while (n8 < cArray.length) {
            int n9 = 0;
            while (n9 < cArray[0].length) {
                if (cArray[n8][n9] != '\u0000') {
                    int n10 = n + (n9 * this.figCharWidth - n3) * n5 + this.figCharHSpacing * n9 * n5 + 1;
                    int n11 = n2 + (n8 * this.figCharHeight - n4) * n6 + this.figCharVSpacing * n8 * n6 + 1;
                    int n12 = this.figCharWidth * n5 - 2;
                    int n13 = this.figCharHeight * n6 - 2;
                    int n14 = n11 + n13 - this.figCharDescent * n6;
                    graphics.setColor(JaveGlobalRessources.colorWatermarkFill);
                    graphics.fillRect(n10, n11, n12, n13);
                    graphics.setColor(JaveGlobalRessources.colorWatermark);
                    graphics.drawRect(n10, n11, n12, n13);
                    graphics.drawLine(n10, n11 + 1, n10 + n12, n11 + 1);
                    graphics.drawLine(n10, n14, n10 + n5, n14);
                    graphics.drawLine(n10 + n12, n14, n10 + n12 - n5, n14);
                    graphics.drawLine(n10 + 1, n14, n10 + 1, n11);
                    graphics.drawLine(n10 + n12 - 1, n14, n10 + n12 - 1, n11);
                    String string = String.valueOf(cArray[n8][n9]);
                    if (cArray[n8][n9] == ' ') {
                        string = "[space]";
                    }
                    graphics.drawString(string, n10 + 3, n11 + n7);
                }
                ++n9;
            }
            ++n8;
        }
    }

    public char[][] getRaster() {
        String string = this.taRaster.getText();
        char[][] cArray = TextTools.toCharField(string);
        Hashtable<Character, Character> hashtable = new Hashtable<Character, Character>();
        int n = 0;
        while (n < cArray.length) {
            int n2 = 0;
            while (n2 < cArray[0].length) {
                Character c = new Character(cArray[n][n2]);
                if (hashtable.containsKey(c)) {
                    cArray[n][n2] = '\u0000';
                } else {
                    hashtable.put(c, c);
                }
                ++n2;
            }
            ++n;
        }
        return cArray;
    }

    public void finish() {
        String string = this.tfFilename.getText().trim();
        if (string.length() == 0) {
            new GErrorDialog((Frame)this.jave, "JavE", "Please enter a name for the font.").show();
            return;
        }
        File file = new File(FIGFileManager.getBaseDir().getAbsolutePath() + File.separator + string + ".flf");
        if (file.exists()) {
            GDialog gDialog = new GDialog((Frame)this.jave, "JavE", "The font '" + string + "' already exists.\nDo you want to replace the existing file?", GDialog.YES_NO_CANCEL, 2);
            gDialog.show();
            if (gDialog.getAnswer() != 0) {
                return;
            }
        }
        System.err.println(file);
        this.exportToFile(file);
        new GDialog((Frame)this.jave, "JavE FIGlet font export assistant", SUCCEED_MESSAGE, 3).show();
        this.close();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.plate.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.taRaster.setText(DEFAULT_RASTERS[this.chRaster.getSelectedIndex()]);
        this.plate.repaint();
    }

    public void numberChanged(NumberEvent numberEvent) {
        this.figCharWidth = this.ifWidth.getValue();
        this.figCharHeight = this.ifHeight.getValue();
        this.figCharDescent = this.ifDescent.getValue();
        this.figCharVSpacing = this.ifVSpacing.getValue();
        this.figCharHSpacing = this.ifHSpacing.getValue();
        this.plate.repaint();
    }

    public void stepChanged() {
        this.plate.repaint();
    }

    public boolean hasHelp() {
        return true;
    }

    public void help() {
        JaveGlobalRessources.openDocumentation("./figletexport/figletexport.html");
    }

    public void cancel() {
        this.close();
    }

    protected void close() {
        this.plate.removeWatermarkPainter(this);
        this.plate.repaint();
        this.jave.setGridVisible(this.rememberGrid);
        if (this.testFigletDialog != null) {
            this.testFigletDialog.dispose();
        }
        this.dispose();
    }

    public int getStepCount() {
        return STEP_LABELS.length;
    }

    public String[] getSideLabels() {
        return new String[]{"Introduction", "Size", "Alignment", "Layout", "Comments", "Font name"};
    }

    public Component createComponentForStep(int n) {
        switch (n) {
            case 0: {
                GLabel gLabel = new GLabel("To use this tool you already must have painted the characters.\nYour document should look like this:");
                TextArea textArea = new TextArea("    _    ___      ___    ___     ___     ___      ___\n   /_\\  | _ )    / __|  |   \\   | __|   | __|    / __|\n  / _ \\ | _ \\   | (__   | |) |  | _|    | _|    | (_ |\n /_/ \\_\\|___/    \\___|  |___/   |___|   |_|      \\___|\n  _  _   ___        _    _  __   _       __  __\n | || | |_ _|    _ | |  | |/ /  | |     |  \\/  |\n | __ |  | |    | || |  | ' <   | |__   | |\\/| |  _ _ _\n |_||_| |___|    \\__/   |_|\\_\\  |____|  |_|  |_| (_|_|_)");
                textArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
                textArea.setEditable(false);
                GLabel gLabel2 = new GLabel("If your document fulfills this demand please continue to the next step.");
                Panel panel = new Panel();
                panel.setLayout(new BorderLayout(0, 0));
                panel.add((Component)gLabel, "North");
                panel.add((Component)textArea, "Center");
                panel.add((Component)gLabel2, "South");
                return panel;
            }
            case 1: {
                this.ifWidth = new IntegerTextField(this.figCharWidth, 1, 30);
                this.ifWidth.addNumberListener(this);
                this.ifHeight = new IntegerTextField(this.figCharHeight, 1, 30);
                this.ifHeight.addNumberListener(this);
                this.ifDescent = new IntegerTextField(this.figCharDescent, 0, 20);
                this.ifDescent.addNumberListener(this);
                this.ifHSpacing = new IntegerTextField(this.figCharHSpacing, 0, 20);
                this.ifHSpacing.addNumberListener(this);
                this.ifVSpacing = new IntegerTextField(this.figCharVSpacing, 0, 20);
                this.ifVSpacing.addNumberListener(this);
                Panel panel = new Panel();
                panel.setLayout(new GGridLayout2(0, 2, 2, 2));
                panel.add(new Label("Width:", 2));
                panel.add(new GUpDownArrangement(this.ifWidth));
                panel.add(new Label("Height:", 2));
                panel.add(new GUpDownArrangement(this.ifHeight));
                panel.add(new Label("Descent:", 2));
                panel.add(new GUpDownArrangement(this.ifDescent));
                panel.add(new Label("Horizontal spacing:", 2));
                panel.add(new GUpDownArrangement(this.ifHSpacing));
                panel.add(new Label("Vertical spacing:", 2));
                panel.add(new GUpDownArrangement(this.ifVSpacing));
                Panel panel2 = new Panel();
                panel2.setLayout(new CenterLayout());
                panel2.add(panel);
                return panel2;
            }
            case 2: {
                this.chRaster = new Choice();
                int n2 = 0;
                while (n2 < DEFAULT_RASTERS_NAMES.length) {
                    this.chRaster.add(DEFAULT_RASTERS_NAMES[n2]);
                    ++n2;
                }
                this.chRaster.addItemListener(this);
                Panel panel = new Panel();
                panel.add(new Label("Default arrangements:", 2));
                panel.add(this.chRaster);
                this.taRaster = new GTextArea(DEFAULT_RASTERS[0], 7, 40);
                this.taRaster.addTextListener(this);
                this.taRaster.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
                Panel panel3 = new Panel();
                panel3.setLayout(new BorderLayout());
                panel3.add((Component)this.taRaster, "Center");
                panel3.add((Component)panel, "South");
                return panel3;
            }
            case 3: {
                GBorderedPanel gBorderedPanel = new GBorderedPanel("horizontal");
                gBorderedPanel.setLayout(new GGridLayout2(0, 1));
                this.chHDefaultLayout = new Choice();
                this.chHDefaultLayout.add("Smushing");
                this.chHDefaultLayout.add("Kerning");
                this.chHDefaultLayout.add("Full Width");
                Panel panel = new Panel();
                panel.add(new Label("Default layout:"));
                panel.add(this.chHDefaultLayout);
                gBorderedPanel.add(panel);
                this.chSmushing = new Checkbox[11];
                int n3 = 0;
                while (n3 < 6) {
                    this.chSmushing[n3] = new Checkbox(SMUSHING[n3], true);
                    gBorderedPanel.add(this.chSmushing[n3]);
                    ++n3;
                }
                GBorderedPanel gBorderedPanel2 = new GBorderedPanel("vertical");
                gBorderedPanel2.setLayout(new GGridLayout2(0, 1));
                this.chVDefaultLayout = new Choice();
                this.chVDefaultLayout.add("Smushing");
                this.chVDefaultLayout.add("Fitting");
                this.chVDefaultLayout.add("Full Height");
                Panel panel4 = new Panel();
                panel4.add(new Label("Default layout:"));
                panel4.add(this.chVDefaultLayout);
                gBorderedPanel2.add(panel4);
                int n4 = 6;
                while (n4 < 11) {
                    this.chSmushing[n4] = new Checkbox(SMUSHING[n4], true);
                    gBorderedPanel2.add(this.chSmushing[n4]);
                    ++n4;
                }
                Panel panel5 = new Panel();
                panel5.setLayout(new GridLayout(0, 2));
                panel5.add(gBorderedPanel);
                panel5.add(gBorderedPanel2);
                this.bTest = new Button("Verify the settings by testing the font.");
                this.bTest.addActionListener(this);
                Panel panel6 = new Panel();
                panel6.setLayout(new CenterLayout());
                panel6.add(this.bTest);
                GLabel gLabel = new GLabel("Testing and adjusting the layout settings is very important.\nYou can always edit the characters or switch back to an earlier step.");
                Panel panel7 = new Panel();
                panel7.setLayout(new BorderLayout());
                panel7.add((Component)panel5, "North");
                panel7.add((Component)panel6, "Center");
                panel7.add((Component)gLabel, "South");
                return panel7;
            }
            case 4: {
                String string = "Author : \nDate   : " + Toolbox.getDateString() + "\n" + "Version: 1.0\n" + "-------------------------------------------------\n" + "\n" + "-------------------------------------------------\n" + "This font has been created using JavE's FIGlet font export assistant.\n" + "Have a look at: http://www.jave.de\n" + "\n" + "Permission is hereby given to modify this font, as long as the\n" + "modifier's name is placed on a comment line.";
                this.taComments = new GTextArea(string, 6, 60);
                this.taComments.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
                return this.taComments;
            }
            case 5: {
                Panel panel = new Panel();
                this.tfFilename = new FilenameTextField("", 12);
                panel.add(this.tfFilename);
                panel.add(new Label(".flf", 0));
                return panel;
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.testFont();
    }

    protected void testFont() {
        File file = new File(TMP_FILE_NAME);
        this.exportToFile(file);
        if (this.testFigletDialog == null) {
            this.testFigletDialog = new FigletDialog(this.jave, FIGLET_TEST_TITLE, 1);
            this.testFigletDialog.setText("Testing this great\nnew Font!");
        }
        this.testFigletDialog.loadFontFile("test_font", file);
        this.testFigletDialog.show();
    }

    protected void exportToFile(File file) {
        int n;
        int n2;
        int n3;
        char c;
        if (this.plate.hasSelection()) {
            this.plate.dropSelection();
        }
        Document document = this.plate.getDocument();
        CharacterPlate characterPlate = document.getContent();
        char[][] cArray = this.getRaster();
        boolean[] blArray = new boolean[128];
        CharacterPlate[] characterPlateArray = new CharacterPlate[255];
        int n4 = 0;
        while (n4 < cArray.length) {
            c = '\u0000';
            while (c < cArray[0].length) {
                if (cArray[n4][c] != '\u0000') {
                    characterPlateArray[cArray[n4][c]] = characterPlate.getCopy(new Rectangle(c * this.figCharHSpacing + c * this.figCharWidth, n4 * this.figCharVSpacing + n4 * this.figCharHeight, this.figCharWidth, this.figCharHeight));
                    char[][] cArray2 = characterPlateArray[cArray[n4][c]].getContent();
                    n3 = 0;
                    while (n3 < this.figCharHeight) {
                        n2 = 0;
                        while (n2 < this.figCharWidth) {
                            if (cArray2[n3][n2] <= '\u0080') {
                                blArray[cArray2[n3][n2]] = true;
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                }
                ++c;
            }
            ++n4;
        }
        c = '#';
        while (c < '\u0080' && blArray[c]) {
            c = (char)(c + 1);
        }
        char c2 = (char)(c + 1);
        while (c2 < '\u0080' && blArray[c2]) {
            c2 = (char)(c2 + '\u0001');
        }
        n3 = 0;
        while (n3 < 26) {
            if (characterPlateArray[n3 + 65] == null) {
                characterPlateArray[n3 + 65] = characterPlateArray[n3 + 97].getClone();
            } else if (characterPlateArray[n3 + 97] == null) {
                characterPlateArray[n3 + 97] = characterPlateArray[n3 + 65].getClone();
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < UMLAUTS.length) {
            if (characterPlateArray[UMLAUTS[n2][0]] == null) {
                characterPlateArray[FigletExportAssistant.UMLAUTS[n2][0]] = characterPlateArray[UMLAUTS[n2][1]].getClone();
            }
            ++n2;
        }
        int n5 = 32;
        while (n5 < 127) {
            if (characterPlateArray[n5] == null) {
                characterPlateArray[n5] = new CharacterPlate(this.figCharWidth, this.figCharHeight);
            }
            ++n5;
        }
        if (characterPlateArray[32].isEmpty()) {
            LineAlgorithm.drawLineBresenham(characterPlateArray[32], 0, 0, 0, this.figCharHeight - 1, c2);
        }
        int n6 = 0;
        while (n6 < 255) {
            if (characterPlateArray[n6] != null) {
                Insets insets = characterPlateArray[n6].getEmptyInsets();
                if (insets.right > 0) {
                    --insets.right;
                }
                n = this.figCharWidth - insets.right + 2;
                characterPlateArray[n6].setSize(n, this.figCharHeight);
                if (n6 != 32 && characterPlateArray[n6].isEmpty()) {
                    characterPlateArray[n6].set(0, 0, (char)n6);
                }
                LineAlgorithm.drawLineBresenham(characterPlateArray[n6], n - 2, 0, n - 2, this.figCharHeight - 1, c);
                characterPlateArray[n6].setForce(n - 1, this.figCharHeight - 1, c);
            }
            ++n6;
        }
        int n7 = 0;
        n = 0;
        while (n < 6) {
            if (this.chSmushing[n].getState()) {
                n7 += SMUSHING_SUMMANDS[n];
            }
            ++n;
        }
        int n8 = 0;
        int n9 = 6;
        while (n9 < 11) {
            if (this.chSmushing[n9].getState()) {
                n8 += SMUSHING_SUMMANDS[n9];
            }
            ++n9;
        }
        int n10 = 0;
        int n11 = n7 + n8;
        switch (this.chHDefaultLayout.getSelectedIndex()) {
            case 0: {
                n11 += 128;
                n10 = n7;
                break;
            }
            case 1: {
                n11 += 64;
                n10 = 0;
                break;
            }
            case 2: {
                n11 += 0;
                n10 = -1;
            }
        }
        switch (this.chVDefaultLayout.getSelectedIndex()) {
            case 0: {
                n11 += 16384;
                break;
            }
            case 1: {
                n11 += 8192;
                break;
            }
        }
        int n12 = 0;
        int n13 = this.figCharHeight - this.figCharDescent;
        int n14 = this.figCharWidth + 2;
        String string = null;
        int n15 = 0;
        if (this.taComments != null) {
            string = this.taComments.getText();
            Dimension dimension = TextTools.getDimensionOf(string);
            n15 = dimension.height;
        }
        int n16 = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("flf2a" + c2 + " " + this.figCharHeight + " " + n13 + " " + n14 + " " + n10 + " " + n15 + " " + n12 + " " + n11 + " " + n16);
            bufferedWriter.newLine();
            if (n15 > 0) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            int n17 = 32;
            while (n17 < 127) {
                bufferedWriter.write(characterPlateArray[n17].toString());
                bufferedWriter.newLine();
                ++n17;
            }
            int n18 = 0;
            while (n18 < UMLAUTS.length) {
                bufferedWriter.write(characterPlateArray[UMLAUTS[n18][0]].toString());
                bufferedWriter.newLine();
                ++n18;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.err.println("Error saving File: " + exception);
        }
    }

    public String getLabelForStep(int n) {
        return STEP_LABELS[n];
    }

    public String getInstructionsForStep(int n) {
        return STEP_INSTRUCTIONS[n];
    }
}

