/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.figlet.FIGDriver;
import de.jave.figlet.FIGFileManager;
import de.jave.figlet.FIGThread;
import de.jave.gfx.GfxTools;
import de.jave.gui.GDialog;
import de.jave.gui.GGridLayout2;
import de.jave.gui.GLabel;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import de.jave.util.ResultConsumer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class FIGletTool
extends Tool
implements ActionListener,
ResultConsumer {
    protected Point textOrigin = null;
    protected Point location1;
    protected StringBuffer keyboardBuffer;
    protected int fontHeight;
    protected int fontUnderLength;
    protected Choice chCategory;
    protected Choice chFont;
    protected Button bFontInfo;
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = false;
    protected Rectangle previewRegion;
    protected boolean isActive;
    protected FIGDriver figDriver;
    protected FIGThread figThread;
    protected CharacterPlate previewPlate;
    protected boolean disabled = false;

    public FIGletTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public boolean containsScreenPoint(Point point) {
        return this.previewRegion != null && this.previewRegion.contains(point);
    }

    protected void updateFontChoice() {
        this.chFont.setEnabled(false);
        this.chFont.removeAll();
        String[] stringArray = FIGFileManager.getCategoryFonts(this.chCategory.getSelectedItem());
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.chFont.add(stringArray[n]);
                ++n;
            }
        }
        this.chFont.select(0);
        this.fontHeight = this.figDriver.getFontHeight(this.chFont.getSelectedItem());
        this.fontUnderLength = this.figDriver.getFontUnderLength(this.chFont.getSelectedItem());
        this.chFont.setEnabled(true);
    }

    protected void prevFont() {
        int n = this.chFont.getSelectedIndex();
        if (n > 0) {
            this.chFont.select(n - 1);
            this.fontChanged();
        } else {
            this.beep();
        }
    }

    protected void nextFont() {
        int n = this.chFont.getSelectedIndex();
        if (n + 1 < this.chFont.getItemCount()) {
            this.chFont.select(n + 1);
            this.fontChanged();
        } else {
            this.beep();
        }
    }

    static void showFontInfo(FIGDriver fIGDriver, String string, Frame frame) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 4, 0, 0));
        String[] stringArray = fIGDriver.getFontInfos(string);
        int n = 0;
        while (n < stringArray.length) {
            panel.add(new Label(stringArray[n], 2));
            panel.add(new Label(stringArray[n + 1], 0));
            n += 2;
        }
        TextArea textArea = new TextArea(8, 60);
        textArea.setText(fIGDriver.getFontComment(string));
        textArea.setEditable(false);
        textArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)textArea, "Center");
        panel2.add((Component)panel, "North");
        GDialog gDialog = new GDialog(frame, "Figlet Font Informations", "Font: " + string, panel2);
        gDialog.setResizable(true);
        gDialog.show();
    }

    protected void showFontInfo() {
        String string = this.chFont.getSelectedItem();
        FIGletTool.showFontInfo(this.figDriver, string, this.jave);
    }

    public Component createOptionsComponent() {
        this.figDriver = new FIGDriver();
        this.figThread = new FIGThread(this.figDriver, this, null, null);
        this.figThread.start();
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout2(0, 2, 2, 2));
        this.chCategory = new Choice();
        String[] stringArray = FIGFileManager.getAllCategoryNames();
        if (stringArray == null || stringArray.length == 0) {
            panel.add(new GLabel("No FIGlet fonts available!\n - Tool disabled.\n\nDownload and install FIGlet fonts\nfrom the JavE homepage."));
            this.disabled = true;
            return panel;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.chCategory.add(stringArray[n]);
            ++n;
        }
        this.chFont = new Choice();
        this.bFontInfo = new Button("Font Information");
        this.bFontInfo.addActionListener(this);
        this.cbMix = new Checkbox("Mix", false);
        this.cbMix.addItemListener(this);
        panel.add(new Label("Font Category:", 2));
        panel.add(this.chCategory);
        panel.add(new Label("Font:", 2));
        panel.add(this.chFont);
        panel.add(this.bFontInfo);
        panel.add(this.cbMix);
        this.chCategory.select(FIGFileManager.getDefaultCategoryName());
        this.updateFontChoice();
        this.chFont.select(FIGFileManager.getDefaultFontName());
        this.chFont.addItemListener(this);
        this.chCategory.addItemListener(this);
        return panel;
    }

    public void putResult(Object object) {
        if (object == null) {
            this.previewPlate = null;
            this.repaintCursor();
            return;
        }
        this.previewPlate = new CharacterPlate((String)object);
        this.previewPlate.setMix(this.plate.getContent().isMix());
        if (this.previewPlate.isEmpty(0, 0, 0, this.previewPlate.getHeight() - 1)) {
            this.previewPlate.removeColumnsLeft(1);
        }
        this.repaintCursor();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chCategory) {
            this.updateFontChoice();
            this.fontHeight = this.figDriver.getFontHeight(this.chFont.getSelectedItem());
            this.fontUnderLength = this.figDriver.getFontUnderLength(this.chFont.getSelectedItem());
            this.repaintCursor();
            this.figletize();
        } else if (object == this.chFont) {
            this.fontChanged();
        }
        this.plate.requestFocus();
    }

    protected void fontChanged() {
        this.fontHeight = this.figDriver.getFontHeight(this.chFont.getSelectedItem());
        this.fontUnderLength = this.figDriver.getFontUnderLength(this.chFont.getSelectedItem());
        this.repaintCursor();
        this.figletize();
    }

    private void figletize() {
        if (this.keyboardBuffer == null) {
            return;
        }
        if (this.keyboardBuffer.length() == 0) {
            this.previewPlate = null;
            this.repaintCursor();
            return;
        }
        String string = this.keyboardBuffer.toString();
        String string2 = this.chFont.getSelectedItem();
        this.figThread.addJob("<raw " + string2 + ">" + string);
    }

    public String getName() {
        return "FIGlet";
    }

    public String getIconName() {
        return "figlet";
    }

    public void takeToHand() {
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.isActive = true;
        this.checkSize();
    }

    public void putAside(boolean bl) {
        this.pasteResult();
        this.isActive = false;
    }

    public void checkSize() {
        if (this.textOrigin == null) {
            return;
        }
        if (this.textOrigin.x >= this.plate.getDocumentWidth()) {
            this.textOrigin.x = this.plate.getDocumentWidth() - 1;
        }
        if (this.textOrigin.y >= this.plate.getDocumentHeight()) {
            this.textOrigin.y = this.plate.getDocumentHeight() - 1;
        }
    }

    public void cursorUp(int n) {
        this.textOrigin.y -= n;
        if (this.textOrigin.y < 0) {
            this.textOrigin.y = 0;
        }
    }

    public void cursorDown(int n) {
        this.textOrigin.y += n;
        if (this.textOrigin.y >= this.plate.getDocumentHeight()) {
            this.textOrigin.y = this.plate.getDocumentHeight() - 1;
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.disabled || this.textOrigin == null) {
            return;
        }
        int n = this.textOrigin.x;
        if (this.previewPlate != null) {
            int n2 = this.textOrigin.x;
            int n3 = this.textOrigin.y - (this.fontHeight - this.fontUnderLength) + 1;
            this.plate.paintPreview(graphics, this.previewPlate, 0, 0, n2, n3);
            n += this.previewPlate.getWidth();
            Point point = this.plate.getScreenPointFor(n2, n3);
            this.previewRegion = new Rectangle(point.x, point.y, this.previewPlate.getWidth() * this.plate.charWidth, this.fontHeight * this.plate.charHeight);
            graphics.setColor(JaveGlobalRessources.colorToolHelping);
            GfxTools.drawBrokenRectangle(graphics, this.previewRegion.x, this.previewRegion.y, this.previewRegion.width, this.previewRegion.height);
            graphics.setFont(JaveGlobalRessources.FONT_SMALL);
            String string = this.previewPlate.getWidth() + "x" + this.previewPlate.getHeight();
            graphics.drawString(string, this.previewRegion.x, this.previewRegion.y - 2);
            int n4 = graphics.getFontMetrics().stringWidth(string);
            n4 = (n4 / this.plate.charWidth + 2) * this.plate.charWidth;
            string = this.keyboardBuffer.toString();
            graphics.setFont(this.plate.getFont());
            graphics.drawString(string, this.previewRegion.x + n4, this.previewRegion.y - 2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.getHeight();
            int n6 = fontMetrics.stringWidth(string);
            int n7 = this.previewRegion.x + n4 + n6 + 3;
            int n8 = this.previewRegion.y - n5 + 4;
            int n9 = this.previewRegion.y - 2;
            graphics.drawLine(n7, n8, n7, n9);
            graphics.drawLine(n7 - 2, n8 - 1, n7 - 2, n8 - 1);
            graphics.drawLine(n7 + 2, n8 - 1, n7 + 2, n8 - 1);
            graphics.drawLine(n7 - 2, n9 + 1, n7 - 2, n9 + 1);
            graphics.drawLine(n7 + 2, n9 + 1, n7 + 2, n9 + 1);
        }
        graphics.setColor(JaveGlobalRessources.colorCursor);
        this.paintTextCursor(graphics, n, this.textOrigin.y);
    }

    protected void paintTextCursor(Graphics graphics, int n, int n2) {
        Point point = this.getScreenPointFor(n, n2 - (this.fontHeight - this.fontUnderLength) + 1);
        int n3 = point.x + 2;
        int n4 = point.y + this.plate.charHeight * this.fontHeight - 2;
        int n5 = point.y + 2;
        int n6 = point.y + (this.fontHeight - this.fontUnderLength) * this.plate.charHeight;
        graphics.drawLine(n3, n5, n3, n4);
        graphics.drawLine(n3 - 1, n5 - 1, n3 - 4, n5 - 1);
        graphics.drawLine(n3 + 1, n5 - 1, n3 + 4, n5 - 1);
        graphics.drawLine(n3 - 1, n4 + 1, n3 - 4, n4 + 1);
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 4, n4 + 1);
        if (this.fontUnderLength != 0) {
            graphics.drawLine(n3 - 3, n6, n3 + 3, n6);
        }
    }

    protected void pasteResult() {
        if (this.previewPlate == null || this.textOrigin == null) {
            return;
        }
        this.setMixMode(this.cbMix.getState());
        this.previewPlate.pasteInto(this.plate.getContent(), this.textOrigin.x, this.textOrigin.y - (this.fontHeight - this.fontUnderLength) + 1);
        this.previewPlate = null;
        this.previewRegion = null;
        this.keyboardBuffer = new StringBuffer();
        this.saveCurrentState("FIGlet");
        this.repaintAll();
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.disabled || point2 == null) {
            return;
        }
        if (this.previewRegion != null && this.previewRegion.contains(point)) {
            this.location1 = point2;
            return;
        }
        if (this.previewPlate != null) {
            this.pasteResult();
        }
        this.textOrigin = point2;
        this.repaintCursor();
    }

    public void prepareForSave() {
        if (this.previewPlate != null) {
            this.pasteResult();
        }
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        this.location1 = null;
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.disabled) {
            return;
        }
        if (this.location1 != null && point2 != null) {
            if (point2.equals(this.location1)) {
                return;
            }
            this.textOrigin.x += point2.x - this.location1.x;
            this.textOrigin.y += point2.y - this.location1.y;
            this.location1 = point2;
            this.repaintCursor();
        }
    }

    public void charEntered(char c) {
        if (this.textOrigin == null || c < ' ' || c > '\u00ff' || c > '~' && c < '\u0091') {
            return;
        }
        if (this.keyboardBuffer == null) {
            this.keyboardBuffer = new StringBuffer();
        }
        this.keyboardBuffer.append(c);
        this.figletize();
    }

    protected void delete() {
    }

    protected void backSpace() {
        if (this.keyboardBuffer == null || this.keyboardBuffer.length() == 0) {
            return;
        }
        this.keyboardBuffer.setLength(this.keyboardBuffer.length() - 1);
        this.figletize();
    }

    protected void enter() {
        this.pasteResult();
        this.textOrigin.y += this.fontHeight;
        this.repaintCursor();
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.disabled) {
            return;
        }
        if (this.previewRegion == null) {
            return;
        }
        if (this.previewRegion.contains(point)) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bFontInfo) {
            this.showFontInfo();
        }
        this.plate.requestFocus();
    }

    public void keyTyped(char c, KeyEvent keyEvent) {
        if (this.disabled) {
            return;
        }
        this.charEntered(c);
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.disabled || this.textOrigin == null) {
            return;
        }
        switch (n) {
            case 127: {
                this.delete();
                return;
            }
            case 8: {
                this.backSpace();
                return;
            }
            case 27: {
                if (this.previewPlate != null) {
                    this.previewPlate = null;
                    this.previewRegion = null;
                    this.keyboardBuffer = new StringBuffer();
                    this.repaintCursor();
                }
                return;
            }
            case 38: {
                if (Tool.altDown) {
                    this.nextFont();
                } else {
                    this.moveCursorUp();
                }
                return;
            }
            case 40: {
                if (Tool.altDown) {
                    this.prevFont();
                } else {
                    this.moveCursorDown();
                }
                return;
            }
            case 39: {
                this.moveCursorRight();
                return;
            }
            case 37: {
                this.moveCursorLeft();
                return;
            }
            case 10: {
                this.enter();
                return;
            }
        }
    }

    protected void moveCursorRight() {
        ++this.textOrigin.x;
        this.repaintCursor();
    }

    protected void moveCursorLeft() {
        if (this.textOrigin.x < -1) {
            return;
        }
        --this.textOrigin.x;
        this.repaintCursor();
    }

    protected void moveCursorNewline() {
    }

    protected void moveCursorRightDown() {
    }

    protected void moveCursorRightUp() {
    }

    protected void moveCursorLeftDown() {
    }

    protected void moveCursorLeftUp() {
    }

    protected void moveCursorDown() {
        ++this.textOrigin.y;
        this.plate.ensureVisible(this.textOrigin.x, this.textOrigin.y + this.fontUnderLength);
        this.repaintCursor();
    }

    protected void moveCursorPageDown() {
    }

    protected void moveCursorUp() {
        if (this.textOrigin.y < 1) {
            return;
        }
        --this.textOrigin.y;
        this.plate.ensureVisible(this.textOrigin.x, this.textOrigin.y - this.fontHeight);
        this.repaintCursor();
    }

    protected void moveCursorPageUp() {
    }

    protected void moveCursorEnd() {
    }

    protected void moveCursorPos1() {
    }

    protected void moveCursorCtrlEnd() {
    }

    protected void moveCursorCtrlPos1() {
    }
}

