/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.gui.GChoice;
import de.jave.jave.EllipseAlgorithm;
import de.jave.jave.FreehandAlgorithm;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class EllipseToolAlgorithmic
extends Tool {
    protected Point location1;
    protected Point location2;
    protected GChoice chMode;
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;
    protected static final int ELLIPSE = 0;
    protected static final int ELLIPSE_CHARACTERS = 1;
    protected static final String[] MODE_STR = new String[]{"Line style", "Characters"};

    public EllipseToolAlgorithmic(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Ellipse Algorithmic";
    }

    public String getIconName() {
        return "ellipse";
    }

    public Component createOptionsComponent() {
        this.chMode = new GChoice(MODE_STR);
        this.chMode.select(0);
        this.chMode.addItemListener(this);
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1, 2, 2));
        panel.add(this.chMode);
        panel.add(this.cbMix);
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void paintCursorFeature(Graphics graphics) {
        int n;
        if (this.markPlate == null || this.location1 == null || this.location2 == null) {
            return;
        }
        Point point = Tool.getQuadraticLocation(this.location1, this.location2, Tool.shiftDown);
        Rectangle rectangle = Tool.getRectangleFor(this.location1, point);
        Point point2 = this.getScreenPointFor(rectangle.x, rectangle.y);
        int n2 = this.location1.x;
        int n3 = this.location1.y;
        int n4 = point.x - this.location1.x;
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n = point.y - this.location1.y) < 0) {
            n = -n;
        }
        int n5 = n4 * 2 + 1;
        int n6 = n * 2 + 1;
        int n7 = n5 * this.plate.charWidth + 1;
        int n8 = n6 * this.plate.charHeight + 1;
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        Point point3 = this.getScreenPointFor(n2 - n4, n3 - n);
        graphics.drawOval(point3.x + this.plate.charWidth / 2, point3.y + this.plate.charHeight / 2, n7 - this.plate.charWidth, n8 - this.plate.charHeight);
        Point point4 = this.getScreenPointFor(n2, n3);
        graphics.drawOval(point4.x + this.plate.charWidth / 2 - 1, point4.y + this.plate.charHeight / 2 - 1, 2, 2);
        this.showStatus("(" + rectangle.x + "," + rectangle.y + ") -> (" + (rectangle.x + rectangle.width - 1) + "," + (rectangle.y + rectangle.height - 1) + ")" + " = (" + n5 + "," + n6 + ")");
        this.markPlate.clear();
        int n9 = this.chMode.getSelectedIndex();
        if (n9 == 1) {
            EllipseAlgorithm.drawEllipse(this.markPlate, n2, n3, n4, n, this.getMouseChar());
            this.markPlate.convert();
        } else {
            EllipseAlgorithm.drawEllipse(this.markPlate, n2, n3, n4, n, '#');
            FreehandAlgorithm.convertMarksToFreehandLine(this.markPlate, 0);
        }
        this.markPlate.paint(graphics, this.plate, this.debug);
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        GfxTools.drawBrokenRectangle(graphics, point3.x, point3.y, n7, n8);
        graphics.setFont(JaveGlobalRessources.FONT_SMALL);
        graphics.drawString(n5 + "x" + n6, point3.x + 2, point3.y + 10);
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.location1 = point2;
        this.location2 = point2;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        this.markPlate.setMode(1);
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.cbMix.getState());
        this.markPlate.pasteResultInto(this.plate.getContent());
        this.markPlate = null;
        this.saveCurrentState("draw ellipse");
        this.repaintAll();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
            return;
        }
        if (point2.equals(this.location2)) {
            return;
        }
        this.location2 = point2;
        this.repaintCursor();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27) {
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
        }
    }
}

