/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Clipart;
import de.jave.jave.ClipartManager;
import de.jave.util.Toolbox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

public class ClipartGroup {
    protected String name;
    protected Vector cliparts;

    public ClipartGroup(String string) {
        if (string.endsWith(".jcf")) {
            string = string.substring(0, string.length() - 4);
        }
        this.name = string;
        this.cliparts = new Vector();
    }

    public void add(Clipart clipart) {
        this.cliparts.addElement(clipart);
    }

    public String getName() {
        return this.name;
    }

    public void load() {
        this.cliparts = new Vector();
        try {
            File file = new File(ClipartManager.BASE_DIR + this.name + ".jcf");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) {
                    throw new Exception("Unexpected End of Clipart File '" + this.name + ".jcf' !");
                }
                string3 = bufferedReader.readLine();
                if (string3 == null) {
                    throw new Exception("Unexpected End of Clipart File '" + this.name + ".jcf' !");
                }
                Clipart clipart = new Clipart(string, string3, string2);
                this.cliparts.addElement(clipart);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Error loading Clipart-File! " + exception);
        }
    }

    public void save() {
        try {
            File file = new File(ClipartManager.BASE_DIR + this.name + ".jcf");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.cliparts.size()) {
                Clipart clipart = (Clipart)this.cliparts.elementAt(n);
                bufferedWriter.write(clipart.getName());
                bufferedWriter.newLine();
                bufferedWriter.write(clipart.getAuthor());
                bufferedWriter.newLine();
                bufferedWriter.write(clipart.getCode());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving Clipart-File! " + exception);
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ClipartGroup '" + this.name + "':\n");
        int n = 0;
        while (n < this.cliparts.size()) {
            stringBuffer.append(" " + n + ": " + ((Clipart)this.cliparts.elementAt(n)).toString() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getClipartCount() {
        return this.cliparts.size();
    }

    public Clipart getClipart(int n) {
        return (Clipart)this.cliparts.elementAt(n);
    }

    public Clipart getClipart(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.cliparts.size()) {
            if (string.equals(((Clipart)this.cliparts.elementAt(n)).getName())) {
                return (Clipart)this.cliparts.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public String[] getClipartNames() {
        String[] stringArray = new String[this.cliparts.size()];
        int n = 0;
        while (n < this.cliparts.size()) {
            stringArray[n] = ((Clipart)this.cliparts.elementAt(n)).getName();
            ++n;
        }
        Toolbox.quickSortIgnoreCase(stringArray);
        return stringArray;
    }
}

