/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.BezierAlgorithm;
import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class BezierToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;
    protected Point point3;
    protected Point movingPoint;

    public BezierToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Bezier Generic";
    }

    public String getIconName() {
        return "bezier_generic";
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        if (this.point1 == null) {
            this.movingPoint = this.point1 = point;
            this.point2 = null;
            this.point3 = null;
        } else if (this.point2 == null) {
            this.movingPoint = this.point2 = point;
            this.point3 = null;
        } else if (this.point3 == null) {
            this.movingPoint = this.point3 = point;
            this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
            GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
            this.markPlate.setCharacter(this.getMouseChar());
        }
        this.repaintCursor();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.movingPoint == null) {
            return;
        }
        this.movingPoint.x = point.x;
        this.movingPoint.y = point.y;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null || this.point3 == null) {
            return;
        }
        this.movingPoint = null;
        this.setMixMode(this.getMixMode());
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.plate.getContent());
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
        this.markPlate = null;
        this.plate.saveCurrentState("draw bezier");
        this.plate.repaint();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.point3 = null;
            this.movingPoint = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.point1 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        graphics.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        GfxTools.drawBrokenLine(graphics, this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        if (this.point3 == null) {
            return;
        }
        int n = (4 * this.point3.x - this.point1.x - this.point2.x) / 2;
        int n2 = (4 * this.point3.y - this.point1.y - this.point2.y) / 2;
        Point point = new Point(n, n2);
        GfxTools.drawBrokenLine(graphics, this.point1.x, this.point1.y, point.x, point.y);
        GfxTools.drawBrokenLine(graphics, this.point2.x, this.point2.y, point.x, point.y);
        Point[] pointArray = new Point[]{this.point1, point, this.point2};
        Point[] pointArray2 = BezierAlgorithm.getPolyLineForBezier(pointArray);
        int n3 = 0;
        while (n3 < pointArray2.length - 1) {
            graphics.drawLine(pointArray2[n3].x, pointArray2[n3].y, pointArray2[n3 + 1].x, pointArray2[n3 + 1].y);
            ++n3;
        }
        this.markPlate.clear();
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(this.point2);
        Point2d point2d3 = this.plate.getRealLocationForScreenPoint(point);
        this.markPlate.drawBezier(point2d, point2d3, point2d2);
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }

    public void putAside(boolean bl) {
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }
}

