/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GChoiceTextField;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class AsciiGradients
implements JaveConfigurationLoadable {
    protected static final String[] DEFAULT_GRADIENTS = new String[]{" .'~:;!>+=icjtJY56SXDQKHNWM", " .':!+ijY6XbKHNM", " .:+j6bHM", " .:coCO8@", " .:oO8@", " .:oO8", " :+#"};
    protected static String[] gradients;
    protected static boolean initialized;

    protected AsciiGradients() {
    }

    public String getConfigurationFileName() {
        return "./config/gradients.txt";
    }

    public static void init() {
        AsciiGradients.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new AsciiGradients());
        initialized = true;
    }

    public void setDefaultConfiguration() {
        gradients = DEFAULT_GRADIENTS;
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public static String getDefaultGradient() {
        return AsciiGradients.getGradients()[0];
    }

    public static String[] getGradients() {
        if (gradients == null) {
            gradients = DEFAULT_GRADIENTS;
        }
        return gradients;
    }

    public static GChoiceTextField createComponent() {
        if (gradients == null) {
            gradients = DEFAULT_GRADIENTS;
        }
        GChoiceTextField gChoiceTextField = new GChoiceTextField("Gradient:", gradients[0], 18);
        int n = 0;
        while (n < gradients.length) {
            gChoiceTextField.add(gradients[n]);
            ++n;
        }
        gChoiceTextField.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        return gChoiceTextField;
    }

    public void loadConfiguration(File file) throws Exception {
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 0) continue;
                vector.addElement(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new Exception();
        }
        int n = vector.size();
        if (n == 0) {
            throw new Exception("The file seems to be empty.");
        }
        gradients = new String[n];
        int n2 = 0;
        while (n2 < n) {
            AsciiGradients.gradients[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        initialized = true;
    }

    static {
        initialized = false;
    }
}

