/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;

public class GuiTools {
    private GuiTools() {
    }

    public static final void fillRectHorizontal(Graphics graphics, Dimension dimension, Color color, Color color2) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        double d = dimension.width;
        int n7 = 0;
        while (n7 < dimension.width) {
            double d2 = (double)n7 / d;
            double d3 = 1.0 - d2;
            graphics.setColor(new Color((int)((double)n * d3 + (double)n4 * d2), (int)((double)n2 * d3 + (double)n5 * d2), (int)((double)n3 * d3 + (double)n6 * d2)));
            graphics.drawLine(n7, 0, n7, dimension.height);
            ++n7;
        }
    }

    public static final void fillRectVertical(Graphics graphics, Dimension dimension, Color color, Color color2) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        double d = dimension.height;
        int n7 = 0;
        while (n7 < dimension.height) {
            double d2 = (double)n7 / d;
            double d3 = 1.0 - d2;
            graphics.setColor(new Color((int)((double)n * d3 + (double)n4 * d2), (int)((double)n2 * d3 + (double)n5 * d2), (int)((double)n3 * d3 + (double)n6 * d2)));
            graphics.drawLine(0, n7, dimension.width, n7);
            ++n7;
        }
    }

    public static void draw3dRectangleUp(Graphics graphics, Dimension dimension) {
        GuiTools.draw3dRectangleUp(graphics, 0, 0, dimension.width, dimension.height);
    }

    public static void drawSmall3dRectangleUp(Graphics graphics, Dimension dimension) {
        GuiTools.drawSmall3dRectangleUp(graphics, 0, 0, dimension.width, dimension.height);
    }

    public static void draw3dRectangleUp(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
    }

    public static void drawSmall3dRectangleUp(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
    }

    public static void draw3dRectangleDown(Graphics graphics, Dimension dimension) {
        GuiTools.draw3dRectangleDown(graphics, 0, 0, dimension.width, dimension.height);
    }

    public static void drawSmall3dRectangleDown(Graphics graphics, Dimension dimension) {
        GuiTools.drawSmall3dRectangleDown(graphics, 0, 0, dimension.width, dimension.height);
    }

    public static void draw3dRectangleDown(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
    }

    public static void drawSmall3dRectangleDown(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
    }

    public static final void centerToFrame(Window window) {
        try {
            Container container = GuiTools.getParentFrame(window);
            if (container == null) {
                container = GuiTools.getParentApplet(window);
            }
            if (container == null) {
                GuiTools.centerOnScreen(window);
                return;
            }
            Dimension dimension = container.getSize();
            Dimension dimension2 = window.getSize();
            Point point = container.getLocationOnScreen();
            int n = point.x + (dimension.width - dimension2.width) / 2;
            int n2 = point.y + (dimension.height - dimension2.height) / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            window.setLocation(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void centerOnScreen(Window window) {
        try {
            Toolkit toolkit = window.getToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Dimension dimension2 = window.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            window.setLocation(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final Frame getParentFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static final Applet getParentApplet(Component component) {
        while (component != null && !(component instanceof Applet)) {
            component = component.getParent();
        }
        return (Applet)component;
    }
}

