/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GPaintedButton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;

public class GTextButton
extends GPaintedButton {
    protected String text;
    protected char shortcut;
    protected int textWidth = -1;
    protected int textHeight = -1;
    protected Dimension normalSize;

    public GTextButton(String string) {
        this.text = string;
        this.shortcut = '\u0000';
        this.computeTextSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.computeTextSize();
        this.repaint();
    }

    protected void computeTextSize() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics == null) {
            return;
        }
        this.textWidth = fontMetrics.stringWidth(this.text);
        this.textHeight = fontMetrics.getAscent();
        this.normalSize = new Dimension(this.textWidth + 14, 23);
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.textWidth == -1) {
            this.computeTextSize();
        }
        return this.normalSize;
    }

    public void setShortcut(char c) {
        this.shortcut = c;
    }

    protected void paintEnabled(Graphics graphics) {
        graphics.setColor(SystemColor.textText);
        int n = (this.getSize().width - this.textWidth) / 2;
        int n2 = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        graphics.drawString(this.text, n, n2);
        this.paintShortcut(graphics, n, n2);
    }

    protected void paintShortcut(Graphics graphics, int n, int n2) {
        if (this.shortcut != '\u0000') {
            int n3 = 0;
            while (Character.toLowerCase(this.text.charAt(n3)) != this.shortcut) {
                ++n3;
            }
            String string = this.text.substring(0, n3);
            String string2 = this.text.substring(0, n3 + 1);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            int n5 = fontMetrics.stringWidth(string2) - 1;
            if (n5 - n4 < 3) {
                n5 = n4 + 3;
            }
            graphics.drawLine(n + n4, n2 + 1, n + n5, n2 + 1);
        }
    }

    protected void paintPressed(Graphics graphics) {
        graphics.setColor(SystemColor.textText);
        int n = (this.getSize().width - this.textWidth) / 2;
        int n2 = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        graphics.drawString(this.text, n + 1, n2 + 1);
        this.paintShortcut(graphics, n + 1, n2 + 1);
    }

    protected void paintDisabled(Graphics graphics) {
        graphics.setColor(SystemColor.controlLtHighlight);
        int n = (this.getSize().width - this.textWidth) / 2;
        int n2 = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        graphics.drawString(this.text, n + 1, n2 + 1);
        this.paintShortcut(graphics, n + 1, n2 + 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawString(this.text, n, n2);
        this.paintShortcut(graphics, n, n2);
    }
}

