/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.SystemExitWindowListener;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;

public class GLine
extends Canvas {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int UP = 2;
    public static final int DOWN = 4;
    protected int style;
    protected String label;
    protected int direction;

    public GLine() {
        this(null, 0, 4);
    }

    public GLine(String string) {
        this(string, 0, 4);
    }

    public GLine(String string, int n) {
        this(string, 0, n);
    }

    public GLine(int n) {
        this(null, n, 4);
    }

    public GLine(int n, int n2) {
        this(null, n, n2);
    }

    public GLine(String string, int n, int n2) {
        this.label = string;
        this.direction = n;
        this.style = n2;
    }

    public Dimension getPreferredSize() {
        if (this.direction == 0) {
            if (this.label == null) {
                return new Dimension(100, 6);
            }
            return new Dimension(100, 16);
        }
        return new Dimension(6, 100);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.direction == 0) {
            if (this.label == null) {
                if (this.style == 4) {
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(2, 3, dimension.width - 2, 3);
                    graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, 2);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(2, 2, dimension.width - 3, 2);
                } else {
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(3, 3, dimension.width - 3, 3);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(2, 2, dimension.width - 3, 2);
                    graphics.drawLine(2, 3, 2, 3);
                }
            } else {
                graphics.drawString(this.label, 12, 12);
                int n = this.getFontMetrics(this.getFont()).stringWidth(this.label);
                if (this.style == 4) {
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(3, 8, 9, 8);
                    graphics.drawLine(14 + n, 8, dimension.width - 3, 8);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(2, 7, 9, 7);
                    graphics.drawLine(14 + n, 7, dimension.width - 3, 7);
                    graphics.drawLine(2, 8, 2, 8);
                } else {
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(3, 8, 9, 8);
                    graphics.drawLine(14 + n, 8, dimension.width - 3, 8);
                    graphics.setColor(SystemColor.controlLtHighlight);
                    graphics.drawLine(2, 7, 9, 7);
                    graphics.drawLine(14 + n, 7, dimension.width - 3, 7);
                    graphics.drawLine(2, 8, 2, 8);
                }
            }
        } else if (this.style == 4) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(3, 2, 3, dimension.height - 3);
            graphics.drawLine(2, dimension.height - 3, 2, dimension.height - 3);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(2, 2, 2, dimension.height - 4);
        } else {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(3, 2, 3, dimension.height - 3);
            graphics.drawLine(2, dimension.height - 3, 2, dimension.height - 3);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(2, 2, 2, dimension.height - 4);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addWindowListener(SystemExitWindowListener.instance());
        frame.setLayout(new FlowLayout());
        frame.add(new GLine());
        frame.add(new GLine(0, 2));
        frame.add(new GLine(1));
        frame.add(new GLine(1, 2));
        frame.add(new GLine("Hallo!"));
        frame.add(new GLine("Hallo!", 2));
        frame.pack();
        frame.show();
    }
}

