/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GLabel;
import de.jave.gui.GuiTools;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class GCheckbox
extends Panel
implements MouseListener,
ItemSelectable {
    protected boolean pressed = false;
    protected boolean state;
    transient ItemListener itemListener;

    public GCheckbox(boolean bl) {
        this.state = bl;
        this.addMouseListener(this);
    }

    public Insets insets() {
        return new Insets(0, 20, 0, 0);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this};
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = (dimension.height - 20) / 2;
        GuiTools.draw3dRectangleDown(graphics, 2, n + 2, 16, 16);
        if (this.state) {
            graphics.setColor(this.getForeground());
            graphics.drawLine(6, n + 7, 9, n + 10);
            graphics.drawLine(6, n + 8, 8, n + 10);
            graphics.drawLine(6, n + 9, 8, n + 11);
            graphics.drawLine(9, n + 8, 12, n + 5);
            graphics.drawLine(9, n + 9, 12, n + 6);
            graphics.drawLine(10, n + 9, 12, n + 7);
        }
    }

    public void setState(boolean bl) {
        if (this.state == bl) {
            return;
        }
        this.state = bl;
        this.repaint();
    }

    public boolean getState() {
        return this.state;
    }

    public void toggle() {
        this.setState(!this.getState());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.pressed) {
            return;
        }
        this.setState(!this.getState());
        this.pressed = false;
        if (this.itemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 0, this, this.getState() ? 1 : 2);
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!(mouseEvent.isMetaDown() || mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isShiftDown())) {
            this.pressed = true;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setLayout(new GridLayout(0, 1));
        GCheckbox gCheckbox = new GCheckbox(true);
        gCheckbox.add(new GLabel("Hello!"));
        frame.add(gCheckbox);
        frame.pack();
        frame.show();
    }

    protected void addImpl(Component component, Object object, int n) {
        component.addMouseListener(this);
        super.addImpl(component, object, n);
    }
}

