/*
 * Decompiled with CFR 0.152.
 */
package de.jave.formula2;

import de.jave.formula2.Formula2;
import de.jave.text.TextTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

public class Formula2RegressionTester {
    protected static final String TESTSETS = "testfaelle.txt";
    protected static final String TESTRESULTS = "testresult.txt";
    protected static final String TRENNZEILE = "#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$";

    public static String[] loadTestSets() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            stringArray = new BufferedReader(new FileReader(TESTSETS));
            while ((string = stringArray.readLine()) != null) {
                if ((string = string.trim()).length() <= 0) continue;
                vector.addElement(string);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public static void createCorrectResults() {
        String[] stringArray = Formula2RegressionTester.loadTestSets();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(TESTRESULTS));
            int n = 0;
            while (n < stringArray.length) {
                try {
                    String string = Formula2.toAscii(stringArray[n]);
                    String[] stringArray2 = TextTools.toStringArray(string);
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        bufferedWriter.write(stringArray2[n2]);
                        bufferedWriter.newLine();
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    System.err.println("ERROR PARSING line " + (n + 1) + ": " + stringArray[n]);
                    System.err.println(exception);
                    exception.printStackTrace(System.err);
                }
                bufferedWriter.write("#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$#$ " + (n + 1));
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
    }

    public static void check() {
        String[] stringArray = Formula2RegressionTester.loadTestSets();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(TESTRESULTS));
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = null;
                try {
                    stringArray2 = TextTools.toStringArray(Formula2.toAscii(stringArray[n]));
                }
                catch (Exception exception) {
                    System.err.println("ERROR PARSING line " + (n + 1) + ": " + stringArray[n]);
                    System.err.println(exception);
                    exception.printStackTrace(System.err);
                    stringArray2 = new String[]{};
                }
                Vector<String> vector = new Vector<String>();
                String string = null;
                while ((string = bufferedReader.readLine()) != null && !string.startsWith(TRENNZEILE)) {
                    vector.addElement(string);
                }
                String[] stringArray3 = new String[vector.size()];
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray3[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
                boolean bl = true;
                if (stringArray3.length != stringArray2.length) {
                    bl = false;
                } else {
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        if (!stringArray3[n3].equals(stringArray2[n3])) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!bl) {
                    Formula2RegressionTester.printError(n + 1, stringArray[n], stringArray3, stringArray2);
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
    }

    protected static void printError(int n, String string, String[] stringArray, String[] stringArray2) {
        System.out.println("TEST FEHLGESCHLAGEN: Zeile " + n);
        System.out.println("CODE: " + string);
        System.out.println("IST:");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            System.out.println(stringArray2[n2]);
            ++n2;
        }
        System.out.println("SOLL:");
        int n3 = 0;
        while (n3 < stringArray.length) {
            System.out.println(stringArray[n3]);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        if (!new File(TESTRESULTS).exists()) {
            Formula2RegressionTester.createCorrectResults();
        } else {
            Formula2RegressionTester.check();
        }
    }
}

