package com.planet_ink.coffee_mud.Behaviors;
import com.planet_ink.coffee_mud.core.interfaces.*;
import com.planet_ink.coffee_mud.core.*;
import com.planet_ink.coffee_mud.Abilities.interfaces.*;
import com.planet_ink.coffee_mud.Areas.interfaces.*;
import com.planet_ink.coffee_mud.Behaviors.interfaces.*;
import com.planet_ink.coffee_mud.CharClasses.interfaces.*;
import com.planet_ink.coffee_mud.Commands.interfaces.*;
import com.planet_ink.coffee_mud.Common.interfaces.*;
import com.planet_ink.coffee_mud.Exits.interfaces.*;
import com.planet_ink.coffee_mud.Items.interfaces.*;
import com.planet_ink.coffee_mud.Locales.interfaces.*;
import com.planet_ink.coffee_mud.MOBS.interfaces.*;
import com.planet_ink.coffee_mud.Races.interfaces.*;


import java.util.*;
import com.planet_ink.coffee_mud.Libraries.interfaces.*;

/* 
   Copyright 2000-2006 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public class Conquerable extends Arrest
{
	public String ID(){return "Conquerable";}
	protected boolean defaultModifiableNames(){return false;}
	protected String getLawParms(){ return "custom";}

    protected String savedHoldingClan="";
    protected String prevHoldingClan="";
    protected String holdingClan="";
    protected Vector clanItems=new Vector();
    protected DVector clanControlPoints=new DVector(2);
    protected DVector assaults=new DVector(2);
    protected Vector noMultiFollows=new Vector();
    protected int totalControlPoints=-1;
    protected Area myArea=null;
    protected String journalName="";
    protected boolean allowLaw=false;
    protected boolean REVOLTNOW=false;
    protected long waitToReload=0;
    protected long conquestDate=0;
    public boolean isFullyControlledByClan(){
        return ((holdingClan.length()>0)&&((System.currentTimeMillis()-conquestDate)>CONTROLTIME));
    }

    protected int revoltDown=REVOLTFREQ;
    protected static final int REVOLTFREQ=(int)((TimeManager.MILI_DAY*3)/Tickable.TIME_TICK);
    protected int checkDown=0;
    protected static final int CHECKFREQ=10;
    protected int pointDown=0;
    protected static final int POINTFREQ=(int)((10*60000)/Tickable.TIME_TICK);
    protected int fightDown=0;
    protected static final int FIGHTFREQ=2;

    public String rulingClan()
    {
        return holdingClan;
    }
    public String conquestInfo(Area myArea)
    {
        StringBuffer str=new StringBuffer("");
        if((totalControlPoints<0)&&(myArea!=null))
			recalculateControlPoints(myArea);
        if((holdingClan.length()==0)||(totalControlPoints<0))
            str.append("Area '"+myArea.name()+"' is not currently controlled by any clan.\n\r");
        else
        {
            Clan C=CMLib.clans().getClan(holdingClan);
            if(C!=null)
            {
                if(isFullyControlledByClan())
                    str.append("Area '"+myArea.name()+"' is controlled by "+C.typeName()+" "+C.name()+".\n\r");
                else
                {
                    str.append("Area '"+myArea.name()+"' is occupied by "+C.typeName()+" "+C.name()+".\n\r");
                    long remain=CONTROLTIME-(System.currentTimeMillis()-conquestDate);
                    String remainStr=myArea.getTimeObj().deriveEllapsedTimeString(remain);
                    str.append("Full control will automatically be achived in "+remainStr+".\n\r");
                }
                
                if(C.getGovernment()!=Clan.GVT_THEOCRACY)
                {
                    int pts=calcItemControlPoints(myArea);
                    int chance=calcRevoltChance(myArea);
                    str.append(C.name()+" has handed out clan items here for "+pts+" loyalty points.\n\r");
                    str.append("There is currently a "+chance+"% chance of revolt here.\n\r");
                }
            }
            else
            {
                if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest",holdingClan+" has laid waste to "+myArea.name()+".");
                endClanRule();
                str.append("This area is laid waste by "+holdingClan+".\n\r");
            }
        }
        if((totalControlPoints<0)&&(myArea!=null))
			recalculateControlPoints(myArea);
        if(totalControlPoints<0)
            str.append("This area has not yet calculated its required control points.\n\r");
        else
	        str.append("This area requires "+totalControlPoints+" points to control.\n\r");
        if(clanControlPoints.size()==0)
            str.append("There are no control points won at present by any clan.\n\r");
        synchronized(clanControlPoints)
        {
            for(int i=0;i<clanControlPoints.size();i++)
            {
                String clanID=(String)clanControlPoints.elementAt(i,1);
                int[] ic=(int[])clanControlPoints.elementAt(i,2);
                Clan C=CMLib.clans().getClan(clanID);
                if(C!=null)
                    str.append(C.typeName()+" "+C.name()+" has "+ic[0]+" control points.\n\r");
            }
        }
        return str.toString();
    }
    public int controlPoints()
    {
        if(totalControlPoints>=0) return totalControlPoints;
        return 0;
    }
    public int revoltChance()
    {
    	if(myArea==null) return 100;
        Clan C=CMLib.clans().getClan(holdingClan);
        if((C==null)||(C.getGovernment()!=Clan.GVT_THEOCRACY))
	    	return calcRevoltChance(myArea);
        return 0;
    }

	public void setParms(String newParms)
	{
		super.setParms(newParms);
		journalName=CMParms.getParmStr(newParms,"JOURNAL","");
		allowLaw=CMParms.getParmStr(newParms,"LAW","FALSE").toUpperCase().startsWith("T");
		loadAttempt=false;
        clanItems=new Vector();
        clanControlPoints=new DVector(2);
        assaults=new DVector(2);
        noMultiFollows=new Vector();
	}

	public boolean isAnyKindOfOfficer(Law laws, MOB M)
	{
		if((M!=null)
		&&(allowLaw)
		&&(!CMLib.flags().isAnimalIntelligence(M))
		&&(M.location()!=null)
		&&((!M.isMonster())||CMLib.flags().isMobile(M))
		&&(holdingClan.length()>0)
		&&(M.getClanID().equals(holdingClan)))
			for(int i=0;i<M.inventorySize();i++)
			{
				Item I=M.fetchInventory(i);
				if((I!=null)
				&&(I instanceof ClanItem)
				&&(!I.amWearingAt(Item.IN_INVENTORY))
				&&(((ClanItem)I).ciType()==ClanItem.CI_BANNER))
					return true;
			}
		return false;
	}

	public boolean isTheJudge(Law laws, MOB M)
	{
		if((M!=null)
		&&(allowLaw)
		&&(!CMLib.flags().isAnimalIntelligence(M))
		&&(M.location()!=null)
		&&(holdingClan.length()>0)
		&&(M.getClanID().equals(holdingClan)))
			for(int i=0;i<M.inventorySize();i++)
			{
				Item I=M.fetchInventory(i);
				if((I!=null)
				&&(I instanceof ClanItem)
				&&(!I.amWearingAt(Item.IN_INVENTORY))
				&&(((ClanItem)I).ciType()==ClanItem.CI_GAVEL))
					return true;
			}
		return false;
	}

    protected synchronized void endClanRule()
	{
		if(holdingClan.length()==0)
			return;
		if((!CMProps.getBoolVar(CMProps.SYSTEMB_MUDSTARTED))
		||(CMSecurity.isDisabled("CONQUEST")))
			return;
        prevHoldingClan=holdingClan;
		for(int v=0;v<clanItems.size();v++)
		{
			Item I=(Item)clanItems.elementAt(v);
			if((I.owner() instanceof MOB)
			&&(I instanceof ClanItem)
			&&(((ClanItem)I).clanID().equals(holdingClan)))
			{
				MOB M=(MOB)I.owner();
				if((M.location()!=null)&&(!M.amDead())&&(M.isMonster()))
				{
					M.delInventory(I);
					if(M.getClanID().equals(holdingClan))
						M.setClanID("");
					I.setRawWornCode(0);
					I.setContainer(null);
					M.location().addItemRefuse(I,Item.REFUSE_PLAYER_DROP);
				}
			}
		}

		if(myArea!=null)
		{
			for(Enumeration e=myArea.getMetroMap();e.hasMoreElements();)
			{
				Room R=(Room)e.nextElement();
				for(int i=0;i<R.numInhabitants();i++)
				{
					MOB M=R.fetchInhabitant(i);
					if((M!=null)
					&&(M.isMonster())
					&&(M.getStartRoom()!=null)
					&&(myArea.inMetroArea(M.getStartRoom().getArea()))
					&&(M.getClanID().equals(holdingClan)))
						M.setClanID("");
				}
			}
			if(holdingClan.length()>0)
			{
	            if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest",holdingClan+" has lost control of "+myArea.name()+".");
	            Vector channels=CMLib.channels().getFlaggedChannelNames("CONQUESTS");
	            for(int i=0;i<channels.size();i++)
	                CMLib.commands().postChannel((String)channels.elementAt(i),"ALL",holdingClan+" has lost control of "+myArea.name()+".",false);
				if(journalName.length()>0)
					CMLib.database().DBWriteJournal(journalName,"Conquest","ALL",holdingClan+" loses control of "+myArea.name()+".","See the subject line.",-1);
			}
			Law laws=getLaws(myArea,false);
			if(laws.lawIsActivated())
			{
				laws.setInternalStr("ACTIVATED","FALSE");
				laws.resetLaw();
				CMLib.database().DBReCreateData(myArea.Name(),"ARREST",myArea.Name()+"/ARREST",laws.rawLawString());
			}

		}
		holdingClan="";
        conquestDate=0;
        synchronized(clanItems)
        {
            try{
            for(int c=clanItems.size();c>=0;c--)
                if(((ClanItem)clanItems.elementAt(c)).ciType()!=ClanItem.CI_FLAG)
                    deRegisterClanItem(c);
            }catch(ArrayIndexOutOfBoundsException x){}
        }
	}

    public int calcItemControlPoints(Area A)
    {
        int itemControlPoints=0;
        synchronized(clanItems)
        {
            for(int i=clanItems.size()-1;i>=0;i--)
            {
                ClanItem I=(ClanItem)clanItems.elementAt(i);
                if((!I.amDestroyed())
                &&(I.owner() instanceof MOB)
                &&(((MOB)I.owner()).isMonster())
                &&(CMLib.flags().isInTheGame((MOB)I.owner(),true))
                &&(A.inMetroArea(((MOB)I.owner()).getStartRoom().getArea()))
                &&((holdingClan.length()==0)||(I.clanID().equals(holdingClan)))
                &&(I.ciType()!=ClanItem.CI_PROPAGANDA))
                    itemControlPoints+=((MOB)((Item)I).owner()).envStats().level();
            }
        }
        return itemControlPoints;
    }
    
    public int calcRevoltChance(Area A)
    {
        if(totalControlPoints<=0) return 0;
        int itemControlPoints=calcItemControlPoints(A);
        int totalNeeded=(int)Math.round(CMath.mul(0.05,totalControlPoints));
        if(totalNeeded<=0) totalNeeded=1;
        int chance=(int)Math.round(10.0-(CMath.mul(10.0,CMath.div(itemControlPoints,totalNeeded))));
        if(chance<=0) return 0;
        return chance;
        
    }
    
	public boolean tick(Tickable ticking, int tickID)
	{
		if((!CMProps.getBoolVar(CMProps.SYSTEMB_MUDSTARTED))
		||(CMSecurity.isDisabled("CONQUEST")))
			return true;

		if(!super.tick(ticking,tickID))
			return false;
		if(tickID!=Tickable.TICKID_AREA) return true;
		if(!(ticking instanceof Area)) return true;
		Area A=(Area)ticking;

		if(A!=myArea) myArea=A;

		for(int i=clanItems.size()-1;i>=0;i--)
		{
			Item I=(Item)clanItems.elementAt(i);
			if(!I.tick(this,Tickable.TICKID_CLANITEM))
                deRegisterClanItem(i);
			else
				I.setExpirationDate(0);
		}

		// calculate total control points
		// make sure all intelligent mobs belong to the clan
		if((totalControlPoints<0)
		&&((waitToReload<=0)||(System.currentTimeMillis()>waitToReload))
		&&(myArea!=null))
		{
			HashSet doneMOBs=new HashSet();
            HashSet doneRooms=new HashSet();
            clanItems.clear();
			Vector itemSet=CMLib.database().DBReadData(myArea.name(),"CONQITEMS","CONQITEMS/"+myArea.name());
			if((itemSet!=null)&&(itemSet.size()>0)&&(((Vector)itemSet.firstElement()).size()>3))
			{
				String data=(String)((Vector)itemSet.firstElement()).elementAt(3);
				Vector xml=CMLib.xml().parseAllXML(data);
				if(xml!=null)
				{
					savedHoldingClan=CMLib.xml().getValFromPieces(xml,"CLANID");
                    prevHoldingClan=CMLib.xml().getValFromPieces(xml,"OLDCLANID");
                    conquestDate=CMLib.xml().getLongFromPieces(xml,"CLANDATE");
					holdingClan=savedHoldingClan;
					Vector allData=CMLib.xml().getRealContentsFromPieces(xml,"ACITEMS");
					if(allData!=null)
					for(int c=0;c<allData.size();c++)
					{
						XMLLibrary.XMLpiece iblk=(XMLLibrary.XMLpiece)allData.elementAt(c);
						if((iblk.tag.equalsIgnoreCase("ACITEM"))&&(iblk.contents!=null))
						{
							Vector roomData=iblk.contents;
							String roomID=CMLib.xml().getValFromPieces(roomData,"ROOMID");
							String MOBname=CMLib.xml().getValFromPieces(roomData,"MOB");
							Room R=CMLib.map().getRoom(roomID);
							if((R!=null)&&(A.inMetroArea(R.getArea())))
							{
								String iClass=CMLib.xml().getValFromPieces(roomData,"ICLAS");
								Item newItem=CMClass.getItem(iClass);
								if(newItem!=null)
								{
									newItem.baseEnvStats().setLevel(CMLib.xml().getIntFromPieces(roomData,"ILEVL"));
									newItem.baseEnvStats().setAbility(CMLib.xml().getIntFromPieces(roomData,"IABLE"));
									newItem.baseEnvStats().setRejuv(CMLib.xml().getIntFromPieces(roomData,"IREJV"));
									newItem.setUsesRemaining(CMLib.xml().getIntFromPieces(roomData,"IUSES"));
									newItem.setMiscText(CMLib.coffeeMaker().restoreAngleBrackets(CMLib.xml().getValFromPieces(roomData,"ITEXT")));
									newItem.recoverEnvStats();
									MOB foundMOB=null;
									if(MOBname.length()>0)
										for(int i=0;i<R.numInhabitants();i++)
										{
											MOB M=R.fetchInhabitant(i);
											if((M!=null)
											&&(M.isMonster())
											&&(M.name().equals(MOBname))
											&&(M.getStartRoom()==R)
											&&(!doneMOBs.contains(M)))
											{ foundMOB=M; break;}
										}
									if((foundMOB==null)&&(MOBname.length()>0))
										for(Enumeration e=A.getMetroMap();e.hasMoreElements();)
										{
											Room R2=(Room)e.nextElement();
											for(int i=0;i<R2.numInhabitants();i++)
											{
												MOB M=R2.fetchInhabitant(i);
												if((M!=null)
												&&(M.isMonster())
												&&(M.name().equals(MOBname))
												&&(M.getStartRoom()==R)
												&&(!doneMOBs.contains(M)))
												{ foundMOB=M; break;}
											}
										}
									if(foundMOB!=null)
									{
                                        boolean found=false;
                                        for(int i=0;i<foundMOB.inventorySize();i++)
                                            if(newItem.sameAs(foundMOB.fetchInventory(i)))
                                                found=true;
                                        if(!found)
                                        {
    										foundMOB.addInventory(newItem);
    										newItem.wearIfPossible(foundMOB);
                                        }
									}
									else
                                    {
                                        if(!doneRooms.contains(R))
                                        {
                                            doneRooms.add(R);
                                            for(int i=R.numItems()-1;i>=0;i--)
                                            {
                                                Item I=R.fetchItem(i);
                                                if(I instanceof ClanItem)
                                                    I.destroy();
                                            }
                                        }
										R.addItem(newItem);
                                    }
                                    registerClanItem(newItem);
								}
							}
						}
					}
				}
			}
			recalculateControlPoints(A);
		}
		else
		{
			if((--checkDown)<=0)
			{
				checkDown=CHECKFREQ;
				// make sure clanitems are truely in the area
				synchronized(clanItems)
				{
					for(int i=clanItems.size()-1;i>=0;i--)
					{
						ClanItem I=(ClanItem)clanItems.elementAt(i);
						Room R=CMLib.map().roomLocation(I);
						if(R==null)
                            deRegisterClanItem(i);
                        else
						if(!A.inMetroArea(R.getArea()))
                            deRegisterClanItem(i);
                        else
						if(I.amDestroyed())
                            deRegisterClanItem(i);
                        else
						if((I.ciType()==ClanItem.CI_FLAG)&&(!R.isContent(I)))
                            deRegisterClanItem(i);
						else
						if(I!=null)
							I.setExpirationDate(0);
					}
				}

				// make sure holding clan still holds
				if((holdingClan.length()>0)
				&&(totalControlPoints>=0)
				&&(!flagFound(A,holdingClan)))
                {
                    if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest",holdingClan+" has "+totalControlPoints+" points and flag="+flagFound(A,holdingClan));
                    if((prevHoldingClan.length()>0)
                    &&(!holdingClan.equalsIgnoreCase(prevHoldingClan))
                    &&(CMLib.clans().getClan(prevHoldingClan)!=null)
                    &&(flagFound(A,prevHoldingClan)))
                        declareWinner(prevHoldingClan);
                    else
    					endClanRule();
                }
			}

            if((--revoltDown)<=0)
            {
                revoltDown=Conquerable.REVOLTFREQ;
                if(holdingClan.length()>0)
                {
                    Clan C=CMLib.clans().getClan(holdingClan);
                    if((C==null)||(C.getGovernment()!=Clan.GVT_THEOCRACY))
                    {
                        int chance=calcRevoltChance(A);
                    	if((REVOLTNOW)&&(chance<100))
                    	{
                        	Log.sysOut("Conquerable",A.Name()+" revolted against "+holdingClan+" with "+chance+"% chance");
                            if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest","The inhabitants of "+myArea.name()+" have revolted against "+holdingClan+" with "+chance+"% chance, after "+calcItemControlPoints(myArea)+" item points of "+totalControlPoints+" control points.");
                            Vector channels=CMLib.channels().getFlaggedChannelNames("CONQUESTS");
                            for(int i=0;i<channels.size();i++)
                                CMLib.commands().postChannel((String)channels.elementAt(i),"ALL","The inhabitants of "+myArea.name()+" have revolted against "+holdingClan+".",false);
                            if(journalName.length()>0)
                                CMLib.database().DBWriteJournal(journalName,"Conquest","ALL","The inhabitants of "+myArea.name()+" have revolted against "+holdingClan+".","See the subject line.",-1);
                            if((prevHoldingClan.length()>0)
                            &&(!holdingClan.equalsIgnoreCase(prevHoldingClan))
                            &&(CMLib.clans().getClan(prevHoldingClan)!=null)
                            &&(flagFound(A,prevHoldingClan)))
                                declareWinner(prevHoldingClan);
                            else
                                endClanRule();
                    	}
                    	else
                    	{
    	                    if(CMLib.dice().rollPercentage()<chance)
    	                    {
    	                        Vector channels=CMLib.channels().getFlaggedChannelNames("CONQUESTS");
    	                        for(int i=0;i<channels.size();i++)
    	                            CMLib.commands().postChannel((String)channels.elementAt(i),"ALL","There are the rumblings of revolt in "+myArea.name()+".",false);
    	                    }
                    	}
                    }
                }
            }
            
			if((--pointDown)<=0)
			{
				pointDown=POINTFREQ;
				// slowly decrease control points over time
				synchronized(clanControlPoints)
				{
					for(int v=clanControlPoints.size()-1;v>=0;v--)
					{
						int[] pts=(int[])clanControlPoints.elementAt(v,2);
						if(pts[0]<=1)
							clanControlPoints.removeElementAt(v);
						else
							pts[0]--;
					}
				}
			}

			if((--fightDown)<=0)
			{
				fightDown=FIGHTFREQ;
				if(assaults.size()>0)
					synchronized(assaults)
					{
						while(assaults.size()>0)
						{
							MOB M1=(MOB)assaults.elementAt(0,1);
							MOB M2=(MOB)assaults.elementAt(0,2);
							if((M1!=M2)
							&&(M1.location()==M2.location())
							&&(!M1.isInCombat())
							&&(CMLib.flags().canBeSeenBy(M2,M1)))
							{
								Vector V=new Vector();
								V.addElement("YELL");
								V.addElement(warCrys()[CMLib.dice().roll(1,warCrys().length,-1)]);
								M1.doCommand(V);
								CMLib.combat().postAttack(M1,M2,M1.fetchWieldedItem());
							}
							assaults.removeElementAt(0);
						}
					}
			}
		}
		return true;
	}

	public void recalculateControlPoints(Area A)
	{
		totalControlPoints=0;
		for(Enumeration e=A.getMetroMap();e.hasMoreElements();)
		{
			Room R=(Room)e.nextElement();
			for(int i=0;i<R.numInhabitants();i++)
			{
				MOB M=R.fetchInhabitant(i);
				if((M!=null)
		        &&(M.isMonster())
				&&(M.getStartRoom()!=null)
				&&(A.inMetroArea(M.getStartRoom().getArea()))
				&&(!CMLib.flags().isAnimalIntelligence(M)))
				{
					if((M.getClanID().length()==0)
					&&(holdingClan.length()>0))
						M.setClanID(holdingClan);
					totalControlPoints+=M.envStats().level();
				}
			}
		}
	}
	
	public boolean okMessage(Environmental myHost, CMMsg msg)
	{
        boolean debugging=CMSecurity.isDebugging("CONQUEST");
		if((msg.targetMinor()==CMMsg.TYP_EXPIRE)
		&&(msg.target() instanceof Room)
		&&(myArea!=null)
		&&(!CMSecurity.isDisabled("CONQUEST"))
		&&(totalControlPoints>=0)
		&&((!savedHoldingClan.equals(""))||(!holdingClan.equals(""))))
		{
			synchronized(clanItems)
			{
				for(int i=0;i<clanItems.size();i++)
				{
					ClanItem I=(ClanItem)clanItems.elementAt(i);
					Room R=CMLib.map().roomLocation(I);
					if((R==msg.target())
					&&(!((Item)I).amDestroyed())
					&&((I.ciType()!=ClanItem.CI_FLAG)||(R.isContent(I))))
						return false;
				}
			}
		}
		if((holdingClan.length()>0)
		&&(msg.source().getClanID().equals(holdingClan))
		&&(!CMSecurity.isDisabled("CONQUEST")))
		{
			if((msg.source().isMonster())
			&&(msg.target() instanceof MOB)
			&&(CMath.bset(msg.targetCode(),CMMsg.MASK_MALICIOUS))
			&&(!((MOB)msg.target()).isInCombat())
			&&(msg.source().getVictim()!=msg.target())
			&&(((MOB)msg.target()).getClanID().equals(holdingClan))
            &&(!CMLib.flags().isAnimalIntelligence(msg.source())))
			{
				MOB target=(MOB)msg.target();
				msg.source().tell(target.name()+" is a fellow "+holdingClan+" member, and you must respect "+target.charStats().himher()+".");
				if(target.getVictim()==msg.source())
				{
					target.makePeace();
					target.setVictim(null);
				}
				return false;
			}
			else
			if((msg.sourceMinor()==CMMsg.TYP_EXPCHANGE)
			&&(msg.target() instanceof MOB)
			&&(myArea!=null)
			&&(((MOB)msg.target()).getStartRoom()!=null)
			&&(myArea.inMetroArea(((MOB)msg.target()).getStartRoom().getArea())))
				msg.setValue(0);
			else
			if((msg.targetMinor()==CMMsg.TYP_ORDER)
			&&(!msg.source().isMonster())
			&&(msg.target() instanceof MOB)
			&&(((MOB)msg.target()).isMonster()))
			{
				Item badge=null;
				Item I=null;
				ClanItem CI=null;
				for(int i=msg.source().inventorySize()-1;i>=0;i--)
				{
					I=msg.source().fetchInventory(i);
					if(I instanceof ClanItem)
					{
						CI=(ClanItem)I;
						if(CI.ciType()==ClanItem.CI_LEGALBADGE)
						{ badge=CI; break;}
					}
				}
				if(badge==null)
				{
					
				}
			}
		}
		else // must not be equal because of else to above
		if((holdingClan.length()>0)
		&&(msg.source().getClanID().length()>0)
		&&(msg.target() instanceof MOB)
		&&(((MOB)msg.target()).amFollowing()==msg.source())
		&&(CMath.bset(msg.targetCode(),CMMsg.MASK_MALICIOUS))
		&&(!((MOB)msg.target()).isInCombat())
		&&(msg.source().getVictim()!=msg.target())
		&&(((MOB)msg.target()).getClanID().equals(holdingClan))
		&&(noMultiFollows.contains(msg.target())))
		{
			noMultiFollows.remove(msg.target());
            if(debugging) Log.debugOut("Conquest",msg.source().getClanID()+" lose "+(msg.target().envStats().level())+" points by harming "+msg.target().name());
			changeControlPoints(msg.source().getClanID(),-msg.target().envStats().level());
		}

        if((holdingClan.length()>0)
        &&(!CMSecurity.isDisabled("CONQUEST")))
        {
            if((msg.target() instanceof Room)
            &&(msg.tool() instanceof Ability)
            &&(msg.tool().ID().startsWith("Prayer_Infuse")))
            {
                if((!msg.source().getClanID().equals(holdingClan))
                ||(CMLib.clans().getClan(holdingClan)==null)
                ||(CMLib.clans().getClan(holdingClan).getGovernment()!=Clan.GVT_THEOCRACY))
                {
                    msg.source().tell("Only a member of a conquering theocracy can pray for that here.");
                    return false;
                }
            }
        
    		if((msg.sourceMinor()==CMMsg.TYP_EXPCHANGE)
    		&&(!msg.source().isMonster())
    		&&(msg.value()>0))
    		{
    			Clan C=CMLib.clans().getClan(holdingClan);
    			if(C.getTaxes()!=0)
    			{
    				int value=(int)Math.round(CMath.mul(msg.value(),C.getTaxes()));
    				if(value>0)
    				{
    					msg.setValue(msg.value()-value);
    					C.setExp(C.getExp()+value);
    					C.update();
    				}
    			}
    		}
        }
		return super.okMessage(myHost,msg);
	}

	public void setControlPoints(String clanID, int newControlPoints)
	{
		int changeAmount=0;
		synchronized(clanControlPoints)
		{
			int index=-1;
			for(int v=0;v<clanControlPoints.size();v++)
			{
				if(((String)clanControlPoints.elementAt(v,1)).equalsIgnoreCase(clanID))
				{ index=v; break;}
			}
			int[] i=null;
			if(index>=0)
				i=(int[])clanControlPoints.elementAt(index,2);
			if(i==null)
			{
				if(newControlPoints>0)
					changeAmount=newControlPoints;
			}
			else
				changeAmount=newControlPoints-i[0];
		}
		if(changeAmount!=0)
			changeControlPoints(clanID,changeAmount);
	}

	
    protected void declareWinner(String clanID)
	{
		if((holdingClan.equals(clanID))||(totalControlPoints<0))
			return;
		Clan C=CMLib.clans().findClan(clanID);
		if(C==null) return;

        if(CMSecurity.isDebugging("CONQUEST")) 
            Log.debugOut("Conquest","The inhabitants of "+myArea.name()+" are conquered by "+clanID+", vanquishing '"+holdingClan+"'.");
		if(holdingClan.length()>0)
		   endClanRule();

        revoltDown=REVOLTFREQ;
		holdingClan=clanID;
		synchronized(clanControlPoints)
		{
			clanControlPoints.clear();
		}
		if(myArea!=null)
		{
			for(Enumeration e=myArea.getMetroMap();e.hasMoreElements();)
			{
				Room R=(Room)e.nextElement();
				for(int i=0;i<R.numInhabitants();i++)
				{
					MOB M=R.fetchInhabitant(i);
					if((M!=null)
					&&(M.isMonster())
					&&(M.getStartRoom()!=null)
					&&(myArea.inMetroArea(M.getStartRoom().getArea()))
					&&(!CMLib.flags().isAnimalIntelligence(M))
					&&(M.getClanID().length()==0))
						M.setClanID(holdingClan);
				}
			}
            Vector channels=CMLib.channels().getFlaggedChannelNames("CONQUESTS");
            for(int i=0;i<channels.size();i++)
                CMLib.commands().postChannel((String)channels.elementAt(i),"ALL",holdingClan+" gains control of "+myArea.name()+".",false);
			if(journalName.length()>0)
				CMLib.database().DBWriteJournal(journalName,"Conquest","ALL",holdingClan+" gains control of "+myArea.name()+".","See the subject line.",-1);
            conquestDate=System.currentTimeMillis();
		}
	}

    protected void registerClanItem(Environmental I)
	{
		synchronized(clanItems)
		{
			if(!clanItems.contains(I))
				clanItems.addElement(I);
		}
	}
    
    protected void deRegisterClanItem(int i)
    {
        synchronized(clanItems)
        {
            try
            {
                clanItems.removeElementAt(i);
            }
            catch(Exception e){e.printStackTrace();}
        }
    }


    protected boolean flagFound(Area A, String clanID)
	{
		if(CMLib.clans().findClan(clanID)==null) return false;
		synchronized(clanItems)
		{
			for(int i=0;i<clanItems.size();i++)
			{
				ClanItem I=(ClanItem)clanItems.elementAt(i);
				if((I.clanID().equals(clanID))
				&&(!I.amDestroyed())
				&&(I.ciType()==ClanItem.CI_FLAG))
				{
					Room R=CMLib.map().roomLocation(I);
					if((R!=null)&&((A==null)||(A.inMetroArea(R.getArea()))))
						return true;
				}
			}
		}
		return false;
	}

    protected boolean changeControlPoints(String clanID, int amount)
	{
		synchronized(clanControlPoints)
		{
			int index=-1;
			for(int v=0;v<clanControlPoints.size();v++)
			{
				if(((String)clanControlPoints.elementAt(v,1)).equalsIgnoreCase(clanID))
				{ index=v; break;}
			}
			if(index<0)
			{
				if((holdingClan.length()>0)
				&&(!clanID.equals(holdingClan))
				&&(myArea!=null))
				{
					for(Enumeration e=myArea.getMetroMap();e.hasMoreElements();)
					{
						Room R=(Room)e.nextElement();
						for(int i=0;i<R.numInhabitants();i++)
						{
							MOB M=R.fetchInhabitant(i);
							if((M!=null)
							&&(M.isMonster())
							&&(M.getStartRoom()!=null)
							&&(myArea.inMetroArea(M.getStartRoom().getArea()))
							&&(M.getClanID().equals(clanID)))
								amount+=M.envStats().level();
						}
					}
				}
				if(amount>0)
				{
					int[] i=new int[1];
					i[0]+=amount;
					clanControlPoints.addElement(clanID,i);
                    if(i[0]>=totalControlPoints)
                        declareWinner(clanID);
				}
			}
			else
			{
				int[] i=(int[])clanControlPoints.elementAt(index,2);
				i[0]+=amount;
				if(i[0]<=0)
					clanControlPoints.removeElementAt(index);
				else
				if(i[0]>=totalControlPoints)
					declareWinner((String)clanControlPoints.elementAt(index,1));
			}
            if(CMSecurity.isDebugging("CONQUEST"))
            {
                index=clanControlPoints.indexOf(clanID);
                if(index<0)
                    Log.debugOut(clanID+" is not getting their points calculted.");
                else
                {
                    int[] i=(int[])clanControlPoints.elementAt(index,2);
                    if(i==null)
                        Log.debugOut(clanID+" is not getting their points calculted.");
                    else
                        Log.debugOut(clanID+" now has "+i[0]+" control points of "+totalControlPoints+" in "+myArea.name()+".");
                }
            }
		}
		return true;
	}


    protected static String[] warCrys()
    {
        return DEFAULT_WAR_CRYS;
    }
	protected static final String[] DEFAULT_WAR_CRYS={
		"INVADERS! Attack!",
		"We are under attack! To arms!",
		"Destroy the enemy!",
		"War!!!!!"
	};

	public void executeMsg(Environmental myHost, CMMsg msg)
	{
		super.executeMsg(myHost,msg);
        
        boolean debugging=CMSecurity.isDebugging("CONQUEST");
		if((myHost instanceof Area)
		&&(CMProps.getBoolVar(CMProps.SYSTEMB_MUDSTARTED)
		&&(!CMSecurity.isDisabled("CONQUEST")))
		&&(totalControlPoints>=0))
		{
			// first look for kills and follows and register the points
			// from those events.  Protect against multi-follows using
			// a queue.
			if((((msg.sourceMinor()==CMMsg.TYP_DEATH)&&(msg.tool()!=null)&&(msg.tool() instanceof MOB))
				||((msg.sourceMinor()==CMMsg.TYP_FOLLOW)&&(msg.target()!=null)&&(msg.target() instanceof MOB)&&(!noMultiFollows.contains(msg.source()))))
			&&(msg.source().isMonster())
			&&(msg.source().getStartRoom()!=null))
			{
				Room R=msg.source().location();
				MOB killer=null;
				if(msg.sourceMinor()==CMMsg.TYP_FOLLOW)
				{
					if(noMultiFollows.size()>=7)
						noMultiFollows.removeElementAt(0);
					noMultiFollows.addElement(msg.source());
					if(msg.target() instanceof MOB)
						killer=(MOB)msg.target();
				}
				else
				if(msg.tool() instanceof MOB)
					killer=(MOB)msg.tool();
				if((killer!=null)&&(R!=null))
				{
					// make sure followers are picked up
					while((killer.getClanID().length()==0)
					&&(killer.amFollowing()!=null)
					&&(R.isInhabitant(killer.amFollowing())))
						killer=killer.amFollowing();
						
					if(((Area)myHost).inMetroArea(msg.source().getStartRoom().getArea()))
					{ // a native was killed
						if((!killer.getClanID().equals(holdingClan))
                        &&(flagFound((Area)myHost,killer.getClanID())))
                        {
    						if(killer.getClanID().length()>0)
                            {
                                if(debugging) Log.debugOut("Conquest",killer.getClanID()+" gain "+(msg.source().envStats().level())+" points by killing "+msg.source().name());
    							Clan C=CMLib.clans().getClan(killer.getClanID());
                                int level=msg.source().envStats().level();
    							if((C!=null)&&(C.getGovernment()==Clan.GVT_THEOCRACY)
    							&&(killer.getWorshipCharID().equals(msg.source().getWorshipCharID())))
    								level=(level>1)?level/2:level;
                                changeControlPoints(killer.getClanID(),level);
                            }
                            else
                            if((killer.amFollowing()!=null)&&(killer.amFollowing().getClanID().length()>0))
                            {
                                if(debugging) Log.debugOut("Conquest",killer.amFollowing().getClanID()+" gain "+(msg.source().envStats().level())+" points by killing "+msg.source().name());
    							Clan C=CMLib.clans().getClan(killer.amFollowing().getClanID());
                                int level=msg.source().envStats().level();
    							if((C!=null)&&(C.getGovernment()==Clan.GVT_THEOCRACY)
    							&&(killer.amFollowing().getWorshipCharID().equals(msg.source().getWorshipCharID())))
    								level=(level>1)?level/2:level;
                                changeControlPoints(killer.amFollowing().getClanID(),level);
                            }
                        }
					}
					else // a foreigner was killed
					if((killer.getClanID().equals(holdingClan))
					&&(msg.source().getClanID().length()>0)
					&&(flagFound((Area)myHost,msg.source().getClanID())))
                    {
                        if(debugging) Log.debugOut("Conquest",msg.source().getClanID()+" lose "+(msg.source().envStats().level())+" points by allowing the death of "+msg.source().name());
						changeControlPoints(msg.source().getClanID(),-msg.source().envStats().level());
                    }
				}
			}
			else
            if(((msg.tool() instanceof Ability)
            &&(msg.tool().ID().equals("Skill_Convert"))
            &&(msg.target() instanceof MOB)
            &&(msg.source().getClanID().length()>0)
            &&(((MOB)msg.target()).isMonster())
            &&(((MOB)msg.target()).getStartRoom()!=null)))
            {
                Clan C=CMLib.clans().getClan(msg.source().getClanID());
                if((C!=null)
                &&(C.getGovernment()==Clan.GVT_THEOCRACY)
                &&(((Area)myHost).inMetroArea(((MOB)msg.target()).getStartRoom().getArea()))
                &&(!msg.source().getClanID().equals(holdingClan))
                &&(flagFound((Area)myHost,msg.source().getClanID())))
                {
                    if(debugging) Log.debugOut("Conquest",msg.source().getClanID()+" gain "+(msg.source().envStats().level())+" points by killing "+msg.source().name());
                    changeControlPoints(msg.source().getClanID(),msg.target().envStats().level());
                }
            }
            else
			if((holdingClan.length()>0)
			&&(CMath.bset(msg.sourceMajor(),CMMsg.MASK_ALWAYS)
			&&(msg.source().isMonster())
			&&(msg.source().getStartRoom()!=null)
			&&(((Area)myHost).inMetroArea(msg.source().getStartRoom().getArea()))
			&&(!CMLib.flags().isAnimalIntelligence(msg.source()))
			&&(!msg.source().getClanID().equals(holdingClan))))
			   msg.source().setClanID(holdingClan);

			if(msg.tool() instanceof ClanItem)
				registerClanItem(msg.tool());
			if(msg.target() instanceof ClanItem)
				registerClanItem(msg.target());

			if(((msg.targetMinor()==CMMsg.TYP_LOOK)||(msg.targetMinor()==CMMsg.TYP_EXAMINE))
			&&(msg.target() instanceof Room)
			&&(holdingClan.length()>0)
			&&(msg.source().getClanID().length()>0)
			&&(!msg.source().getClanID().equals(holdingClan))
			&&(((Room)msg.target()).numInhabitants()>0)
			&&(myArea.inMetroArea(((Room)msg.target()).getArea())))
			{
				Clan C=CMLib.clans().getClan(holdingClan);
				if(C==null)
                {
                    if(debugging) Log.debugOut("Conquest",holdingClan+" no longer exists.");
					endClanRule();
                }
				else
				if(C.getClanRelations(msg.source().getClanID())==Clan.REL_WAR)
				{
					Room R=(Room)msg.target();
					for(int i=0;i<R.numInhabitants();i++)
					{
						MOB M=R.fetchInhabitant(i);
						if((M!=null)
						&&(M.isMonster())
						&&(M.getClanID().equals(holdingClan))
						&&(!M.isInCombat())
						&&(!CMLib.flags().isAnimalIntelligence(M))
						&&(CMLib.flags().aliveAwakeMobileUnbound(M,true))
						&&(CMLib.flags().canBeSeenBy(msg.source(),M))
						&&(!assaults.contains(M)))
							assaults.addElement(M,msg.source());
					}
				}
			}
		}
		if(((msg.sourceMinor()==CMMsg.TYP_SHUTDOWN)
			||(msg.sourceMinor()==CMMsg.TYP_ROOMRESET))
		&&(myArea!=null)
		&&(!CMSecurity.isDisabled("CONQUEST")))
		{
			waitToReload=System.currentTimeMillis()+60000;
			if((totalControlPoints>=0)
			&&((!savedHoldingClan.equals(""))||(!holdingClan.equals(""))))
			{
				totalControlPoints=-1;
				StringBuffer data=new StringBuffer("");
				data.append(CMLib.xml().convertXMLtoTag("CLANID",holdingClan));
                data.append(CMLib.xml().convertXMLtoTag("OLDCLANID",prevHoldingClan));
                data.append(CMLib.xml().convertXMLtoTag("CLANDATE",conquestDate));
				data.append("<ACITEMS>");
				synchronized(clanItems)
				{
					for(int i=0;i<clanItems.size();i++)
					{
						ClanItem I=(ClanItem)clanItems.elementAt(i);
						Room R=CMLib.map().roomLocation(I);
						if((R!=null)
						&&(((Area)myHost).inMetroArea(R.getArea()))
						&&(!((Item)I).amDestroyed())
						&&((I.ciType()!=ClanItem.CI_FLAG)||(R.isContent(I))))
						{
							data.append("<ACITEM>");
							if(((Item)I).owner() instanceof Room)
								data.append(CMLib.xml().convertXMLtoTag("ROOMID",CMLib.map().getExtendedRoomID(R)));
							else
							if(((Item)I).owner() instanceof MOB)
							{
								MOB M=(MOB)((Item)I).owner();
								if((M.getStartRoom()!=null)
								&&(myArea.inMetroArea(M.getStartRoom().getArea())))
								{
									data.append(CMLib.xml().convertXMLtoTag("ROOMID",CMLib.map().getExtendedRoomID(M.getStartRoom())));
									data.append(CMLib.xml().convertXMLtoTag("MOB",((MOB)((Item)I).owner()).Name()));
								}
							}
							data.append(CMLib.xml().convertXMLtoTag("ICLAS",CMClass.className(I)));
							data.append(CMLib.xml().convertXMLtoTag("IREJV",I.baseEnvStats().rejuv()));
							data.append(CMLib.xml().convertXMLtoTag("IUSES",((Item)I).usesRemaining()));
							data.append(CMLib.xml().convertXMLtoTag("ILEVL",I.baseEnvStats().level()));
							data.append(CMLib.xml().convertXMLtoTag("IABLE",I.baseEnvStats().ability()));
							data.append(CMLib.xml().convertXMLtoTag("ITEXT",CMLib.coffeeMaker().parseOutAngleBrackets(I.text())));
							data.append("</ACITEM>");
                            ((Item)I).destroy();
						}
					}
					clanItems.clear();
				}
				savedHoldingClan="";
				holdingClan="";
                prevHoldingClan="";
				clanControlPoints=new DVector(2);
				data.append("</ACITEMS>");
				CMLib.database().DBReCreateData(myArea.name(),"CONQITEMS","CONQITEMS/"+myArea.name(),data.toString());
			}
		}
	}

	protected boolean isAnUltimateAuthorityHere(MOB M, Law laws)
	{
		if((holdingClan.length()==0)
		||(!allowLaw)
		||(totalControlPoints<0)
		||(!CMProps.getBoolVar(CMProps.SYSTEMB_MUDSTARTED)))
			return false;
		Clan C=CMLib.clans().getClan(holdingClan);
		if(C==null)
        { 
            if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest",holdingClan+" no longer exists.");
            endClanRule(); 
            return false;
        }
		return C.allowedToDoThis(M,Clan.FUNC_CLANCANORDERCONQUERED)==1;
	}

	protected boolean theLawIsEnabled()
	{
		if((holdingClan.length()==0)
		||(!allowLaw)
		||(totalControlPoints<0)
		||(!CMProps.getBoolVar(CMProps.SYSTEMB_MUDSTARTED))
		||(CMSecurity.isDisabled("ARREST")))
			return false;
		if(flagFound(null,holdingClan))
			return true;
        if(CMSecurity.isDebugging("CONQUEST")) Log.debugOut("Conquest",holdingClan+" has "+totalControlPoints+" points and flag="+flagFound(null,holdingClan)+" in law check.");
		endClanRule();
		return false;
	}
}
