/*
 * Decompiled with CFR 0.152.
 */
package gebhard.uielements;

import de.jave.util.ProgressListener;
import de.jave.util.Toolbox;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.io.IOException;

public class ProgressBar
extends Canvas
implements ProgressListener {
    private double value;
    private Color color = new Color(0, 0, 127);
    private boolean displayValue;

    public static void main(String[] stringArray) throws IOException {
        Frame frame = new Frame();
        frame.setLayout(new GridLayout(1, 0));
        ProgressBar progressBar = new ProgressBar(0.3);
        frame.add(progressBar);
        frame.pack();
        frame.show();
    }

    public ProgressBar() {
        this(0.0);
    }

    public ProgressBar(double d) {
        this.value = d;
        this.displayValue = true;
    }

    public void setAction(String string) {
    }

    public void finished() {
        this.setProgress(1.0);
    }

    public void setProgress(double d) {
        this.value = d;
        this.repaint(50L);
    }

    public double getProgress() {
        return this.value;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, 14);
    }

    public Dimension getMinimumSize() {
        return new Dimension(60, 14);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, dimension.width - 2, 0);
        graphics.drawLine(0, 1, 0, dimension.height - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        if (this.value >= 1.0) {
            return;
        }
        int n = (int)(this.value * (double)(dimension.width - 2));
        graphics.setColor(this.color);
        graphics.fillRect(1, 1, n, dimension.height - 2);
        if (this.displayValue) {
            Font font = new Font("Dialog", 0, 10);
            graphics.setFont(font);
            graphics.setColor(Color.darkGray);
            int n2 = 5;
            graphics.drawString(String.valueOf(Toolbox.round(100.0 * this.value, 1)) + "%", n2, dimension.height - 5);
        }
    }
}

