/*
 * Decompiled with CFR 0.152.
 */
package gebhard.uielements;

import gebhard.uielements.NumberTextField;
import java.awt.TextComponent;
import java.awt.event.KeyListener;
import java.awt.event.TextListener;

public class IntegerTextField
extends NumberTextField
implements KeyListener,
TextListener {
    protected static final int DEFAULT_MAX = 10000;
    protected static final int DEFAULT_MIN = 0;
    protected static final int DEFAULT_STEP = 1;
    protected int min;
    protected int max;
    protected int dflt;
    protected int step;

    public IntegerTextField() {
        this(0, 0, 10000, 1);
    }

    public IntegerTextField(int n) {
        this(n, 0, 10000, 1);
    }

    public IntegerTextField(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public IntegerTextField(int n, int n2, int n3, int n4) {
        super(String.valueOf(n));
        this.min = n2;
        this.max = n3;
        this.step = n4;
        this.dflt = n;
        if (this.dflt < n2) {
            this.dflt = n2;
            return;
        }
        if (this.dflt > n3) {
            this.dflt = n3;
        }
    }

    public void setRange(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.ensureRange();
    }

    public int getValue() {
        this.ensureRange();
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.dflt;
        }
        return n;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.ensureRange();
    }

    public void setMaximum(int n) {
        this.max = n;
        this.ensureRange();
    }

    public void setValue(int n) {
        if (n == this.getValue()) {
            return;
        }
        ((TextComponent)this).setText(String.valueOf(n));
        this.ensureRange();
    }

    protected void ensureRange() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ((TextComponent)this).setText(String.valueOf(this.dflt));
            return;
        }
        if (n > this.max) {
            ((TextComponent)this).setText(String.valueOf(this.max));
            return;
        }
        if (n < this.min) {
            ((TextComponent)this).setText(String.valueOf(this.min));
        }
    }

    protected void incValue() {
        int n = this.getValue() + this.step;
        if (n > this.max) {
            return;
        }
        this.setValue(n);
    }

    protected void decValue() {
        int n = this.getValue() - this.step;
        if (n < this.min) {
            return;
        }
        this.setValue(n);
    }

    protected char mapInputChar(char c) {
        return c;
    }

    protected boolean isTextValid() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n > this.max) {
            return false;
        }
        return n >= this.min;
    }

    protected boolean isValidInput(char c) {
        return c >= '0' && c <= '9' || c == '-';
    }
}

