/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GButton;
import de.jave.gui.GButtonGroup;
import de.jave.gui.GTextArea;
import de.jave.gui.VFlowLayout;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.RectangleStylePanel;
import de.jave.jave.algorithm.AlignLeft;
import de.jave.jave.algorithm.AlignRight;
import de.jave.jave.algorithm.CenterByTheLine;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class TextboxDialog
extends Dialog
implements WindowListener,
TextListener,
ItemListener,
ActionListener {
    protected static final String TITLE = "Textbox Editor";
    protected Jave parent;
    protected TextArea taInput;
    protected TextArea taPreview;
    protected Button bInsert;
    protected Button bClose;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected RectangleStylePanel rectangleStylePanel;
    protected GButtonGroup alignmentButtonGroup;
    protected Point location;

    public TextboxDialog(Jave jave) {
        this(jave, "Your text here", new Point(0, 0));
    }

    public TextboxDialog(Jave jave, String string, Point point) {
        super(jave, TITLE, false);
        this.parent = jave;
        this.location = point;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 2));
        panel.add(new Label("Alignment:", 2));
        this.alignmentButtonGroup = new GButtonGroup();
        GButton gButton = JaveImages.createButton("alignment_left");
        gButton.setToggleButton(true);
        this.alignmentButtonGroup.add(gButton);
        panel.add(gButton);
        GButton gButton2 = JaveImages.createButton("alignment_center");
        gButton2.setToggleButton(true);
        this.alignmentButtonGroup.add(gButton2);
        panel.add(gButton2);
        GButton gButton3 = JaveImages.createButton("alignment_right");
        gButton3.setToggleButton(true);
        this.alignmentButtonGroup.add(gButton3);
        panel.add(gButton3);
        this.alignmentButtonGroup.addItemListener(this);
        this.rectangleStylePanel = new RectangleStylePanel(jave.plate);
        this.rectangleStylePanel.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new VFlowLayout());
        panel2.add(panel);
        panel2.add(this.rectangleStylePanel);
        this.taInput = new GTextArea(string, 8, 40, 1);
        this.taInput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taInput.addTextListener(this);
        this.taPreview = new GTextArea("", 8, 40, 1);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Text:", -1);
        gBorderedPanel.setLayout(new GridLayout());
        gBorderedPanel.add(this.taInput);
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Preview:", -1);
        gBorderedPanel2.setLayout(new GridLayout());
        gBorderedPanel2.add(this.taPreview);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)gBorderedPanel2, "Center");
        panel3.add((Component)panel2, "East");
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(0, 1, 4, 4));
        panel4.add(panel3);
        panel4.add(gBorderedPanel);
        Panel panel5 = new Panel();
        this.bInsert = new Button("Insert");
        this.bInsert.addActionListener(this);
        panel5.add(this.bInsert);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        panel5.add(this.bClose);
        this.add((Component)panel4, "Center");
        this.add((Component)panel5, "South");
        this.pack();
        this.preview();
    }

    public void setContent(String string) {
        this.taInput.setText(string);
        this.preview();
    }

    public void setLocation(Point point) {
        this.location = point;
    }

    public void setTextboxStyle(int n) {
        this.rectangleStylePanel.setStyle(n);
        this.preview();
    }

    public void show() {
        super.show();
        this.taInput.selectAll();
        this.taInput.requestFocus();
    }

    public void preview() {
        this.taPreview.setText(this.getResult().toString());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.preview();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.preview();
    }

    protected CharacterPlate getResult() {
        CharacterPlate characterPlate = new CharacterPlate(this.taInput.getText());
        int n = this.alignmentButtonGroup.getSelectedIndex();
        if (n == 1) {
            characterPlate = CenterByTheLine.getInstance().apply(characterPlate);
        } else if (n == 0) {
            characterPlate = AlignLeft.getInstance().apply(characterPlate);
        } else if (n == 2) {
            characterPlate = AlignRight.getInstance().apply(characterPlate);
        }
        characterPlate.addColumnsLeft(1);
        characterPlate.addColumnsRight(1);
        characterPlate.addLinesBottom(1);
        characterPlate.addLinesTop(1);
        char[] cArray = this.rectangleStylePanel.getCurrentChars();
        RectangleAlgorithm.drawRectangle(characterPlate, new Rectangle(0, 0, characterPlate.getWidth(), characterPlate.getHeight()), cArray);
        return characterPlate;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bInsert) {
            this.parent.pasteAsNewSelection(this.getResult(), this.location);
            this.setVisible(false);
            this.parent.dialogClosed(this);
        } else if (object == this.bClose) {
            this.setVisible(false);
            this.parent.dialogClosed(this);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.parent.dialogClosed(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static int getTextboxStyle(char[][] cArray) {
        return RectangleAlgorithm.getRectangleStyle(cArray);
    }
}

