/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GGridLayout2;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveTextCursor;
import de.jave.jave.Plate;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.text.TextTools;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TextTool
extends Tool
implements Runnable,
FocusListener {
    protected boolean hasFocus;
    protected Point point1;
    protected Rectangle selectionRegion;
    protected static final int MOVEMENT_NORMAL = 0;
    protected static final int MOVEMENT_DIRECTED = 1;
    protected static final int MOVEMENT_NONE = 2;
    protected static final int MOVEMENT_TRACK = 3;
    protected static final String[] STR_MOVEMENT = new String[]{"Normal", "Directed", "None", "Track Following"};
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = false;
    protected Choice chMovement;
    protected static final int RIGHT = 0;
    protected static final int DOWN = 1;
    protected static final int LEFT = 7;
    protected static final int UP = 6;
    protected static final int RIGHT_UP = 2;
    protected static final int RIGHT_DOWN = 3;
    protected static final int LEFT_UP = 4;
    protected static final int LEFT_DOWN = 5;
    protected static final int UNDEFINED = -1;
    protected int lastDirection;
    protected Thread blinkThread = new Thread(this);
    protected boolean shallStop = false;
    protected boolean isActive;
    protected boolean cursorShowing;
    protected static boolean cursorBlockStyle = JaveGlobalRessources.getInifile().getBool("TextTool", "cursorBlockStyle", false);

    public TextTool(Plate plate, Jave jave) {
        super(plate, jave);
        this.blinkThread.setPriority(1);
        this.blinkThread.start();
        plate.addFocusListener(this);
    }

    public void plateScrolled() {
        this.putCursor();
    }

    public void cursorUp(int n) {
        Point point = this.getCursorLocation();
        point.y -= n;
        if (point.y < 0) {
            point.y = 0;
        }
        this.putCursor();
    }

    public void cursorDown(int n) {
        Point point = this.getCursorLocation();
        point.y += n;
        if (point.y >= this.plate.getDocumentHeight()) {
            point.y = this.plate.getDocumentHeight() - 1;
        }
        this.putCursor();
    }

    public static void setCursorBlockStyle(boolean bl) {
        cursorBlockStyle = bl;
        JaveGlobalRessources.getInifile().put("TextTool", "cursorBlockStyle", cursorBlockStyle);
    }

    public static boolean getCursorBlockStyle() {
        return cursorBlockStyle;
    }

    protected static boolean isOppositeDirection(int n, int n2) {
        return n + n2 == 7;
    }

    public void run() {
        while (!this.shallStop) {
            try {
                Thread.currentThread();
                Thread.sleep(JaveGlobalRessources.cursorBlinkPause);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isActive || !this.hasFocus || this.selectionRegion != null) continue;
            if (this.cursorShowing) {
                if (!JaveGlobalRessources.cursorBlink) continue;
                this.removeCursor();
                continue;
            }
            this.putCursor();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.blinkThread.interrupt();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.removeCursor();
    }

    public Component createOptionsComponent() {
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout2(2, 0, 2, 2));
        panel.add(new Label("Cursor movement:", 2));
        this.chMovement = new Choice();
        int n = 0;
        while (n < STR_MOVEMENT.length) {
            this.chMovement.addItem(STR_MOVEMENT[n]);
            ++n;
        }
        this.chMovement.select(0);
        panel.add(this.chMovement);
        this.chMovement.addItemListener(this);
        this.cbMix = new Checkbox("Mix", false);
        this.cbMix.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new GGridLayout2(0, 1));
        panel2.add(panel);
        panel2.add(this.cbMix);
        return panel2;
    }

    public String getName() {
        return "Text";
    }

    public String getIconName() {
        return "text";
    }

    public void takeToHand() {
        this.isActive = true;
        this.setCursor(JaveGlobalRessources.cursorText);
        this.putCursor();
    }

    public void putAside(boolean bl) {
        this.isActive = false;
        this.removeCursor();
    }

    public void checkSize() {
        Point point = this.getCursorLocation();
        if (point.x >= this.plate.getDocumentWidth()) {
            point.x = this.plate.getDocumentWidth() - 1;
        } else if (point.x < 0) {
            point.x = 0;
        }
        if (point.y >= this.plate.getDocumentHeight()) {
            point.y = this.plate.getDocumentHeight() - 1;
        } else if (point.y < 0) {
            point.y = 0;
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.selectionRegion != null) {
            this.showStatus("(" + this.selectionRegion.x + "," + this.selectionRegion.y + ") -> (" + (this.selectionRegion.x + this.selectionRegion.width) + "," + this.selectionRegion.y + this.selectionRegion.height + ") = (" + this.selectionRegion.width + "," + this.selectionRegion.height + ")");
            graphics.setColor(JaveGlobalRessources.colorTool);
            Point point = this.getScreenPointFor(this.selectionRegion.x, this.selectionRegion.y);
            graphics.drawRect(point.x, point.y, this.selectionRegion.width * this.plate.charWidth, this.selectionRegion.height * this.plate.charHeight);
            return;
        }
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.selectionRegion = null;
        this.point1 = point;
        this.lastDirection = -1;
        Point point3 = this.getCursorLocation();
        point3.x = point2.x;
        point3.y = point2.y;
        this.removeCursor();
        this.blinkThread.interrupt();
    }

    protected synchronized void putCursor() {
        Point point = this.getCursorLocation();
        if (point == null) {
            this.removeCursor();
            return;
        }
        if (JaveGlobalRessources.debug) {
            System.out.println("PUT");
        }
        int n = 1;
        if (Tool.insert) {
            n = 2;
        } else if (cursorBlockStyle) {
            n = 3;
        }
        this.plate.setXORPainter(new JaveTextCursor(this.getScreenPointFor(point), n, this.plate.charWidth, this.plate.charHeight));
        this.cursorShowing = true;
    }

    protected synchronized void removeCursor() {
        if (JaveGlobalRessources.debug) {
            System.out.println("REMOVE");
        }
        this.plate.setXORPainter(null);
        this.cursorShowing = false;
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        Point point3 = this.getCursorLocation();
        if (point2 == null || this.point1 == null || point3 == null || mouseEvent.isMetaDown()) {
            return;
        }
        if (Tool.abs(this.point1.x - point.x) > 2 || Tool.abs(this.point1.y - point.y) > 2) {
            Rectangle rectangle = Tool.getRectangleFor(point3, point2);
            if (rectangle.equals(this.selectionRegion)) {
                return;
            }
            this.selectionRegion = rectangle;
            this.removeCursor();
            this.repaintCursor();
        } else if (this.selectionRegion != null) {
            this.selectionRegion = null;
            this.repaintCursor();
        }
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.selectionRegion != null) {
            this.jave.switchToSelectonTool();
            this.plate.setSelection(this.selectionRegion);
            this.point1 = null;
            this.selectionRegion = null;
            SelectionTool selectionTool = this.jave.getSelectionTool();
            selectionTool.synchronizeToSelection();
            return;
        }
        if (mouseEvent.getClickCount() == 2 && this.plate.getChar(point2.x, point2.y) != ' ') {
            Rectangle rectangle = this.getAutoSelectRegion(point2.x, point2.y);
            this.jave.switchToSelectonTool();
            this.plate.setSelection(rectangle);
            this.point1 = null;
            this.selectionRegion = null;
            SelectionTool selectionTool = this.jave.getSelectionTool();
            selectionTool.synchronizeToSelection();
            return;
        }
        this.point1 = null;
        this.selectionRegion = null;
    }

    protected void moveToTrack() {
        char c;
        Point point = this.getCursorLocation();
        int n = point.x;
        int n2 = point.y;
        if (n + 1 < this.plate.getDocumentWidth() && (c = this.plate.getChar(n + 1, n2)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 0)) {
            this.moveCursorRight();
            return;
        }
        if (n2 + 1 < this.plate.getDocumentHeight() && (c = this.plate.getChar(n, n2 + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 1)) {
            this.moveCursorDown();
            return;
        }
        if (n > 0 && (c = this.plate.getChar(n - 1, n2)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 7)) {
            this.moveCursorLeft();
            return;
        }
        if (n2 > 0 && (c = this.plate.getChar(n, n2 - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 6)) {
            this.moveCursorUp();
            return;
        }
        if (n + 1 < this.plate.getDocumentWidth() && n2 > 0 && (c = this.plate.getChar(n + 1, n2 - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 2)) {
            this.moveCursorRightUp();
            return;
        }
        if (n + 1 < this.plate.getDocumentWidth() && n2 + 1 < this.plate.getDocumentHeight() && (c = this.plate.getChar(n + 1, n2 + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 3)) {
            this.moveCursorRightDown();
            return;
        }
        if (n > 0 && n2 > 0 && (c = this.plate.getChar(n - 1, n2 - 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 4)) {
            this.moveCursorLeftUp();
            return;
        }
        if (n > 0 && n2 + 1 < this.plate.getDocumentHeight() && (c = this.plate.getChar(n - 1, n2 + 1)) != ' ' && !TextTool.isOppositeDirection(this.lastDirection, 5)) {
            this.moveCursorLeftDown();
            return;
        }
        this.moveCursorRight();
    }

    public void charEntered(char c) {
        if (c < ' ' || c > '\u00ff' || c > '~' && c < '\u0091') {
            return;
        }
        Point point = this.getCursorLocation();
        if (Tool.insert) {
            this.setMixMode(false);
            if (point.x == this.plate.getDocumentWidth() - 1) {
                this.plate.setChar(point, c);
                this.plate.addColumnsRight(1);
            } else {
                CharacterPlate characterPlate = this.plate.getContent();
                String string = characterPlate.getLine(point.y, point.x);
                if (string.charAt(string.length() - 1) != ' ') {
                    this.plate.addColumnsRight(1);
                } else {
                    string = string.substring(0, string.length() - 1);
                }
                characterPlate.paste(string, point.x + 1, point.y);
                this.plate.setChar(point, c);
            }
        } else {
            this.setMixMode(this.cbMix.getState());
            this.plate.setChar(point, c);
        }
        int n = this.chMovement.getSelectedIndex();
        if (n == 0) {
            this.moveCursorRight();
        } else if (n == 1) {
            switch (this.lastDirection) {
                case 6: {
                    this.moveCursorUp();
                    break;
                }
                case 1: {
                    this.moveCursorDown();
                    break;
                }
                case 0: {
                    this.moveCursorRight();
                    break;
                }
                case 7: {
                    this.moveCursorLeft();
                    break;
                }
                case -1: {
                    this.moveCursorRight();
                }
            }
        } else if (n == 3) {
            this.moveToTrack();
        }
        this.plate.ensureVisible(point);
        this.putCursor();
        this.repaintAll();
        this.plate.saveCurrentState("text");
    }

    public void setInsert(boolean bl) {
        super.setInsert(bl);
        this.removeCursor();
        this.blinkThread.interrupt();
        this.cbMix.setEnabled(!bl);
    }

    public void setCursorLocation(int n, int n2) {
        this.removeCursor();
        Point point = this.getCursorLocation();
        point.x = n;
        point.y = n2;
        this.plate.ensureVisible(point);
        this.blinkThread.interrupt();
    }

    protected void backSpace() {
        Point point = this.getCursorLocation();
        if (point.x == 0 && point.y == 0) {
            this.beep();
            this.blinkThread.interrupt();
            return;
        }
        if (!Tool.insert) {
            this.moveCursorLeft();
            this.plate.setCharForce(point, ' ');
        } else {
            boolean bl;
            if (point.x == 0) {
                CharacterPlate characterPlate = this.plate.getContent();
                String string = TextTools.trimRight(characterPlate.getLine(point.y));
                String string2 = TextTools.trimRight(characterPlate.getLine(point.y - 1));
                if (string2.length() == 0) {
                    this.plate.removeLine(point.y - 1);
                    --point.y;
                } else {
                    if (string2.length() + string.length() >= characterPlate.getWidth()) {
                        this.plate.addColumnsRight(string2.length() + string.length() - characterPlate.getWidth());
                    }
                    characterPlate.paste(string, string2.length(), point.y - 1);
                    this.plate.removeLine(point.y);
                    --point.y;
                    point.x = string2.length();
                }
                this.blinkThread.interrupt();
                return;
            }
            CharacterPlate characterPlate = this.plate.getContent();
            String string = TextTools.trimRight(characterPlate.getLine(point.y, point.x));
            boolean bl2 = bl = string.length() == 0;
            if (!bl) {
                this.moveCursorLeft();
                characterPlate.paste(string, point.x, point.y);
                this.plate.setCharForce(point.x + string.length(), point.y, ' ');
            } else {
                this.moveCursorLeft();
                this.plate.setCharForce(point, ' ');
            }
        }
        this.plate.ensureVisible(point);
        this.putCursor();
        this.repaintAll();
        this.saveCurrentState("text");
        this.blinkThread.interrupt();
    }

    protected void delete() {
        Point point = this.getCursorLocation();
        if (!Tool.insert) {
            this.plate.setCharForce(point, ' ');
        } else {
            CharacterPlate characterPlate = this.document.getContent();
            if (point.x == this.plate.getDocumentWidth()) {
                String string = characterPlate.getLine(point.y, point.x + 1);
                int n = string.length() - 1;
                while (n > 0 && string.charAt(n) == ' ') {
                    --n;
                }
                string = string.substring(0, n + 1);
                this.plate.removeLine(point.y);
                n = characterPlate.getWidth();
                while (characterPlate.get(n - 1, point.y - 1) == ' ') {
                    --n;
                }
                if (n + string.length() >= characterPlate.getWidth()) {
                    this.plate.addColumnsRight(n + string.length() - characterPlate.getWidth());
                }
                characterPlate.paste(string, n, point.y - 1);
                point.x = n;
                --point.y;
            } else {
                String string = characterPlate.getLine(point.y, point.x + 1);
                characterPlate.paste(string, point.x, point.y);
                characterPlate.delete(characterPlate.getWidth() - 1, point.y, characterPlate.getWidth() - 1, point.y);
            }
        }
        this.plate.ensureVisible(point);
        this.repaintAll();
        this.saveCurrentState("text");
        this.blinkThread.interrupt();
    }

    protected void enter() {
        Point point = this.getCursorLocation();
        if (!Tool.insert || Tool.shiftDown) {
            this.removeCursor();
            this.moveCursorNewline();
            this.plate.ensureVisible(point);
            this.blinkThread.interrupt();
            return;
        }
        CharacterPlate characterPlate = this.plate.getContent();
        String string = characterPlate.getLine(point.y, point.x);
        characterPlate.delete(point.x, point.y, characterPlate.width - 1, point.y);
        this.plate.insertLine(point.y + 1, string);
        this.moveCursorNewline();
        this.plate.ensureVisible(point);
        this.plate.saveCurrentState("text");
        this.blinkThread.interrupt();
    }

    public void keyTyped(char c, KeyEvent keyEvent) {
        if (JaveGlobalRessources.debug) {
            System.out.println("KEY_TYPED " + c);
        }
        this.charEntered(c);
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (JaveGlobalRessources.debug) {
            System.out.println("KEY_PRESSED " + n);
        }
        if (n == 9 && Tool.controlDown) {
            return;
        }
        if (n == 27) {
            this.point1 = null;
            this.selectionRegion = null;
            this.repaintCursor();
            return;
        }
        Point point = this.getCursorLocation();
        if (Tool.shiftDown && (n == 38 || n == 40 || n == 37 || n == 39)) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 38: {
                    if (point.y != 0) break;
                    this.beep();
                    return;
                }
                case 40: {
                    break;
                }
                case 37: {
                    if (point.x == 0) {
                        this.beep();
                        return;
                    }
                    n2 = 1;
                    break;
                }
            }
            this.jave.switchToSelectonTool();
            this.plate.setSelection(new Rectangle(point.x - n2, point.y - n3, 1, 1));
            SelectionTool selectionTool = this.jave.getSelectionTool();
            selectionTool.synchronizeToSelection();
            return;
        }
        switch (n) {
            case 127: {
                this.delete();
                return;
            }
            case 8: {
                this.backSpace();
                return;
            }
            case 38: {
                this.removeCursor();
                this.moveCursorUp();
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 40: {
                this.removeCursor();
                this.moveCursorDown();
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 39: {
                this.removeCursor();
                this.moveCursorRight();
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 9: {
                this.removeCursor();
                int n4 = 0;
                while (n4 < 8) {
                    this.moveCursorRight();
                    ++n4;
                }
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 37: {
                this.removeCursor();
                this.moveCursorLeft();
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 35: {
                this.removeCursor();
                if (keyEvent.isControlDown()) {
                    this.moveCursorCtrlEnd();
                } else {
                    this.moveCursorEnd();
                }
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 36: {
                this.removeCursor();
                if (keyEvent.isControlDown()) {
                    this.moveCursorCtrlPos1();
                } else {
                    this.moveCursorPos1();
                }
                this.plate.ensureVisible(point);
                this.blinkThread.interrupt();
                return;
            }
            case 10: {
                this.enter();
                return;
            }
        }
    }

    protected void moveCursorRight() {
        Point point = this.getCursorLocation();
        if (point.x + 1 == this.plate.getDocumentWidth()) {
            this.beep();
        } else {
            ++point.x;
        }
        this.lastDirection = 0;
    }

    protected void moveCursorLeft() {
        Point point = this.getCursorLocation();
        if (point.x == 0) {
            this.beep();
        } else {
            --point.x;
        }
        this.lastDirection = 7;
    }

    protected void moveCursorNewline() {
        Point point = this.getCursorLocation();
        if (point.y + 1 == this.plate.getDocumentHeight()) {
            this.beep();
        } else {
            point.x = 0;
            ++point.y;
        }
    }

    protected void moveCursorRightDown() {
        Point point = this.getCursorLocation();
        if (point.y + 1 == this.plate.getDocumentHeight() || point.x + 1 == this.plate.getDocumentWidth()) {
            this.beep();
        } else {
            ++point.y;
            ++point.x;
        }
        this.lastDirection = 3;
    }

    protected void moveCursorRightUp() {
        Point point = this.getCursorLocation();
        if (point.y == 0 || point.x + 1 == this.plate.getDocumentWidth()) {
            this.beep();
        } else {
            --point.y;
            ++point.x;
        }
        this.lastDirection = 2;
    }

    protected void moveCursorLeftDown() {
        Point point = this.getCursorLocation();
        if (point.y + 1 == this.plate.getDocumentHeight() || point.x == 0) {
            this.beep();
        } else {
            ++point.y;
            --point.x;
        }
        this.lastDirection = 5;
    }

    protected void moveCursorLeftUp() {
        Point point = this.getCursorLocation();
        if (point.y == 0 || point.x == 0) {
            this.beep();
        } else {
            --point.y;
            --point.x;
        }
        this.lastDirection = 4;
    }

    protected void moveCursorDown() {
        Point point = this.getCursorLocation();
        if (point.y + 1 == this.plate.getDocumentHeight()) {
            this.beep();
        } else {
            ++point.y;
        }
        this.lastDirection = 1;
    }

    protected void moveCursorUp() {
        Point point = this.getCursorLocation();
        if (point.y == 0) {
            this.beep();
        } else {
            --point.y;
        }
        this.lastDirection = 6;
    }

    protected void moveCursorEnd() {
        Point point = this.getCursorLocation();
        if (Tool.insert) {
            CharacterPlate characterPlate = this.plate.getContent();
            String string = TextTools.trimRight(characterPlate.getLine(point.y));
            int n = string.length();
            if (n > this.plate.getDocumentWidth() - 1) {
                this.plate.addColumnsRight(1);
            }
            point.x = n == point.x ? this.plate.getDocumentWidth() - 1 : n;
            return;
        }
        point.x = this.plate.getDocumentWidth() - 1;
    }

    protected void moveCursorPos1() {
        Point point = this.getCursorLocation();
        point.x = 0;
    }

    protected void moveCursorCtrlEnd() {
        Point point = this.getCursorLocation();
        point.x = this.plate.getDocumentWidth() - 1;
        point.y = this.plate.getDocumentHeight() - 1;
    }

    protected void moveCursorCtrlPos1() {
        Point point = this.getCursorLocation();
        point.x = 0;
        point.y = 0;
    }
}

