/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.RectangleStylePanel;
import de.jave.jave.Tool;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RectangleToolAlgorithmic
extends Tool {
    protected Point location1;
    protected Point location2;
    protected RectangleStylePanel rectangleStylePanel;
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;

    public RectangleToolAlgorithmic(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Rectangle Algorithmic";
    }

    public String getIconName() {
        return "rectangle";
    }

    public Component createOptionsComponent() {
        this.rectangleStylePanel = new RectangleStylePanel(this.plate);
        this.rectangleStylePanel.addItemListener(this);
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(2, 3));
        panel.add((Component)this.rectangleStylePanel, "Center");
        panel.add((Component)this.cbMix, "South");
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.location1 == null || this.location2 == null) {
            return;
        }
        if (this.markPlate == null) {
            return;
        }
        Point point = Tool.getQuadraticLocation(this.location1, this.location2, Tool.shiftDown);
        Rectangle rectangle = Tool.getRectangleFor(this.location1, point);
        this.showStatus("(" + rectangle.x + "," + rectangle.y + ") -> (" + (rectangle.x + rectangle.width - 1) + "," + (rectangle.y + rectangle.height - 1) + ")" + " = (" + rectangle.width + "," + rectangle.height + ")");
        this.markPlate.clear();
        char[] cArray = this.rectangleStylePanel.getCurrentChars();
        if (this.rectangleStylePanel.isUnderLineStyle()) {
            --rectangle.y;
            ++rectangle.height;
        }
        RectangleAlgorithm.drawRectangle(this.markPlate, rectangle, cArray);
        boolean bl = false;
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, bl);
        Point point2 = this.getScreenPointFor(rectangle.x, rectangle.y);
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        GfxTools.drawBrokenRectangle(graphics, point2.x, point2.y, rectangle.width * this.plate.charWidth, rectangle.height * this.plate.charHeight);
        if (rectangle.width - 2 > 0 && rectangle.height - 2 > 0) {
            GfxTools.drawBrokenRectangle(graphics, point2.x + this.plate.charWidth, point2.y + this.plate.charHeight, (rectangle.width - 2) * this.plate.charWidth, (rectangle.height - 2) * this.plate.charHeight);
        }
        graphics.setFont(JaveGlobalRessources.FONT_SMALL);
        graphics.drawString(rectangle.width + "x" + rectangle.height, point2.x + 2, point2.y - 2);
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        Tool.shiftDown = mouseEvent.isShiftDown();
        this.location1 = point2;
        this.location2 = point2;
        this.markPlate = new PixelPlate(point2.x - 15, point2.y - 10, 30, 20);
        this.markPlate.setMode(1);
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.location1 == null || point2 == null) {
            return;
        }
        if (this.markPlate != null) {
            this.setMixMode(this.cbMix.getState());
            this.markPlate.pasteResultInto(this.plate.getContent());
            this.plate.saveCurrentState("draw rectangle");
            this.plate.repaint();
            this.markPlate = null;
        }
        this.showStatus("(" + point2.x + "," + point2.y + ")");
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            if (this.location2 != null) {
                this.location2 = null;
                this.repaintCursor();
            }
            return;
        }
        if (point2.equals(this.location2)) {
            return;
        }
        this.location2 = point2;
        this.repaintCursor();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27) {
            this.location1 = null;
            this.location2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }
}

