/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import java.awt.Point;

public class Point2d
implements Cloneable {
    private static final double EPSILON = 0.001;
    private static final double _EPSILON = 1000.0;
    public double x;
    public double y;

    public Point2d() {
        this(0.0, 0.0);
    }

    public Point2d(int n, int n2) {
        this((double)n, (double)n2);
    }

    public Point2d(Point point) {
        this(point.x, point.y);
    }

    public Point2d(Point2d point2d) {
        this(point2d.x, point2d.y);
    }

    public Point2d(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void translate(Point2d point2d) {
        this.x += point2d.x;
        this.y += point2d.y;
    }

    public void moveTo(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void moveTo(Point2d point2d) {
        this.x = point2d.x;
        this.y = point2d.y;
    }

    public Object clone() {
        try {
            Point2d point2d = (Point2d)super.clone();
            return point2d;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    void clone(Point2d point2d) {
        this.x = point2d.x;
        this.y = point2d.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point2d)) {
            return false;
        }
        return this.x - 0.001 <= ((Point2d)object).x && this.x + 0.001 >= ((Point2d)object).x && this.y - 0.001 <= ((Point2d)object).y && this.y + 0.001 >= ((Point2d)object).y;
    }

    public int hashCode() {
        return ((int)(this.x * 1000.0) << 8) + ((int)(this.y * 1000.0) << 16);
    }

    public double getDistance(Point2d point2d) {
        return Math.sqrt(Math.pow(this.x - point2d.x, 2.0) + Math.pow(this.y - point2d.y, 2.0));
    }

    public double getDistanceTo(Point2d point2d, Point2d point2d2) {
        if (point2d.x == point2d2.x && point2d.y == point2d2.y) {
            return this.getDistance(point2d);
        }
        double d = this.x - point2d.x;
        double d2 = this.y - point2d.y;
        double d3 = point2d2.x - point2d.x;
        double d4 = point2d2.y - point2d.y;
        double d5 = (d3 * d + d4 * d2) / (d3 * d3 + d4 * d4);
        double d6 = point2d.x + d5 * d3;
        double d7 = point2d.y + d5 * d4;
        return Math.sqrt(Math.pow(this.x - d6, 2.0) + Math.pow(this.y - d7, 2.0));
    }

    public void normalize() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        this.x /= d;
        this.y /= d;
    }

    public static Point2d getVector(Point2d point2d, Point2d point2d2) {
        return new Point2d(point2d2.x - point2d.x, point2d2.y - point2d.y);
    }

    public double getAngle() {
        if (this.x == 0.0) {
            if (this.y > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        double d = Math.atan(this.y / this.x);
        d = this.x > 0.0 ? (d += 1.5707963267948966) : (d += 4.71238898038469);
        return d;
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x * d2 - this.y * d3;
        double d5 = this.x * d3 + this.y * d2;
        this.x = d4;
        this.y = d5;
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "Point2d(" + this.x + "," + this.y + ")";
    }
}

