/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GScrollPanel;
import de.jave.gui.GScrollable;
import de.jave.gui.StatusDisplay;
import de.jave.jave.BooleanPlate;
import de.jave.jave.CharacterPlate;
import de.jave.jave.CharacterSets;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.Document;
import de.jave.jave.Jave;
import de.jave.jave.JaveClipboardSelection;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveLogFile;
import de.jave.jave.JaveSelection;
import de.jave.jave.PixelView;
import de.jave.jave.Point2d;
import de.jave.jave.Selection;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkPainter;
import de.jave.jave.WatermarkPainterExclusive;
import de.jave.jave.XORPainter;
import de.jave.text.TextTools;
import de.jave.undo.LogFile;
import de.jave.undo.UndoManager;
import de.jave.util.RelativeTimeClock;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class Plate
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener,
GScrollable {
    private static int counter = 0;
    protected GScrollPanel scrollPanel;
    protected XORPainter xorPainter = null;
    protected boolean xorPainterDisplayed = false;
    protected Tool currentTool;
    protected Tool[] tools;
    char char1;
    char char2;
    protected int fontSize;
    protected static final int DEFAULT_FONT_SIZE = 13;
    protected static final int MIN_FONT_SIZE = 7;
    protected static final int MAX_FONT_SIZE = 16;
    protected int charWidth;
    protected int charHeight;
    StatusDisplay status;
    private Dimension offDimension;
    private Image offImage;
    private Graphics offGraphics;
    protected WatermarkPainterExclusive watermarkPainterExclusive;
    protected Vector watermarkPainters;
    protected Selection selection;
    protected boolean grid;
    protected boolean pixelView;
    protected boolean markIllegal;
    protected Jave jave;
    protected Document document;
    protected Point viewPortOrigin;
    protected String fontName = "Monospaced";
    protected int fontAscent = 0;
    protected boolean mouseRightButton = false;
    protected boolean repaintEverything = false;
    protected boolean repainted = true;
    protected boolean keyMark1 = false;
    protected boolean keyMark2 = false;
    protected boolean keyMark3 = false;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;
    protected boolean altDown = false;

    public Plate(Jave jave) {
        this.jave = jave;
        this.grid = true;
        this.viewPortOrigin = new Point(0, 0);
        this.char1 = (char)79;
        this.char2 = (char)88;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setDocument(null);
    }

    public void scrollPositionChanged(GScrollPanel gScrollPanel) {
        this.repaint();
        this.currentTool.plateScrolled();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setXORPainter(XORPainter xORPainter) {
        Plate plate = this;
        synchronized (plate) {
            Graphics graphics;
            if (JaveGlobalRessources.debug) {
                System.out.println(".-->setXORPainter.........: " + xORPainter);
            }
            if (this.xorPainterDisplayed && this.xorPainter != null) {
                if (JaveGlobalRessources.debug) {
                    System.out.println(" Deleting old XORPainter: " + this.xorPainter);
                }
                if ((graphics = this.getGraphics()) != null) {
                    this.xorPainter.paintXOR(graphics);
                    this.xorPainterDisplayed = false;
                } else if (JaveGlobalRessources.debug) {
                    System.out.println("  ERROR: unable to paint old painter to delete it: g==null");
                }
            }
            this.xorPainter = xORPainter;
            if (xORPainter == null) {
                this.xorPainterDisplayed = false;
            } else {
                graphics = this.getGraphics();
                if (graphics != null) {
                    this.xorPainter.paintXOR(graphics);
                    this.xorPainterDisplayed = true;
                } else if (JaveGlobalRessources.debug) {
                    System.out.println("  ERROR: unable to paint new painter to show it: g==null");
                }
            }
            if (JaveGlobalRessources.debug) {
                System.out.println("`-->setXORPainter finished: " + xORPainter);
            }
        }
    }

    public void setMix(boolean bl) {
        if (this.document == null) {
            return;
        }
        this.document.getContent().setMix(bl);
    }

    public void addWatermarkPainter(WatermarkPainterExclusive watermarkPainterExclusive) {
        this.watermarkPainterExclusive = watermarkPainterExclusive;
    }

    public void addWatermarkPainter(WatermarkPainter watermarkPainter) {
        if (this.watermarkPainters == null) {
            this.watermarkPainters = new Vector(10);
        }
        this.watermarkPainters.addElement(watermarkPainter);
    }

    public void removeWatermarkPainter(WatermarkPainter watermarkPainter) {
        if (watermarkPainter == this.watermarkPainterExclusive) {
            this.watermarkPainterExclusive = null;
        } else {
            this.watermarkPainters.removeElement(watermarkPainter);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public CompressedDocumentState getDocumentState(String string) {
        char[][] cArray = this.document.getContent().getContent();
        Point point = this.getOrigin();
        char[][] cArray2 = null;
        Point point2 = null;
        BooleanPlate booleanPlate = null;
        if (this.hasSelection()) {
            cArray2 = this.selection.getContent().getContent();
            point2 = this.selection.getLocation();
            booleanPlate = this.selection.getMask();
        }
        Point point3 = this.document.getCursorLocation();
        String string2 = null;
        if (this.currentTool != null) {
            string2 = this.currentTool.getName();
        }
        return new CompressedDocumentState(cArray, point, cArray2, point2, booleanPlate, point3, string2, string, JaveGlobalRessources.getColorScheme());
    }

    public void setContent(CharacterPlate characterPlate) {
        if (this.document == null) {
            throw new RuntimeException("ERROR: No document in plate.setContent()");
        }
        this.document.setContent(characterPlate);
        if (this.scrollPanel != null) {
            this.scrollPanel.doLayout();
        }
        this.jave.plateSizeChanged();
        this.repaint();
    }

    public synchronized void setDocument(Document document) {
        Object object;
        this.setXORPainter(null);
        if (this.document != null) {
            object = this.getOrigin();
            this.document.setScrollOrigin((Point)object);
        }
        this.document = document;
        if (document == null) {
            this.setCursor(Cursor.getDefaultCursor());
            this.selection = null;
            if (this.scrollPanel != null) {
                this.scrollPanel.doLayout();
            }
            this.repaint();
            this.jave.plateSizeChanged();
            return;
        }
        this.selection = document.getSelection();
        this.selection.setPlate(this);
        if (this.scrollPanel != null) {
            this.scrollPanel.doLayout();
        }
        this.jave.plateSizeChanged();
        this.currentTool.setDocument(document);
        this.setOrigin(document.getScrollOrigin());
        this.repaint();
        if (document.undoManager == null) {
            document.undoManager = new UndoManager(this.getDocumentState(null));
            document.undoManager.setMaxSize(524288);
            object = null;
            try {
                object = JaveLogFile.createNewLogFile();
            }
            catch (Exception exception) {
                System.err.println("Unable to create a new logfile: " + exception);
            }
            if (object != null) {
                document.undoManager.setLogFile((LogFile)object);
            }
            RelativeTimeClock relativeTimeClock = new RelativeTimeClock();
            document.setRelativeTimeClock(relativeTimeClock);
        }
    }

    public boolean isInside(Point point) {
        return this.isInside(point.x, point.y);
    }

    public boolean isInside(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.document.getWidth() && n2 < this.document.getHeight();
    }

    public void setScrollPanel(GScrollPanel gScrollPanel) {
        this.scrollPanel = gScrollPanel;
        gScrollPanel.setVerticalIncrement(this.charHeight);
        gScrollPanel.setHorizontalIncrement(this.charWidth);
    }

    public GScrollPanel getScrollPanel() {
        return this.scrollPanel;
    }

    public boolean isEmpty() {
        return this.document.isEmpty();
    }

    public void crop() {
        if (!this.hasSelection()) {
            Insets insets = this.document.getContent().getEmptyInsets();
            if (insets.left == 0 && insets.right == 0 && insets.top == 0 && insets.bottom == 0) {
                return;
            }
            CharacterPlate characterPlate = this.document.getContent();
            int n = characterPlate.getWidth() - insets.left - insets.right;
            int n2 = characterPlate.getHeight() - insets.top - insets.bottom;
            CharacterPlate characterPlate2 = characterPlate.getCopy(insets.left, insets.top, n, n2);
            characterPlate.setSize(n, n2);
            characterPlate.clear();
            boolean bl = characterPlate.isMix();
            characterPlate.setMix(false);
            characterPlate2.pasteInto(characterPlate, 0, 0);
            characterPlate.setMix(bl);
            this.scrollPanel.doLayout();
            this.jave.plateSizeChanged();
            this.currentTool.checkSize();
            this.setCursor(JaveGlobalRessources.cursorSelection);
            this.repaint();
            return;
        }
        this.cropToSelection();
        this.currentTool.checkSize();
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    protected void cropToSelection() {
        if (!this.selection.hasSelection()) {
            return;
        }
        int n = this.selection.getWidth();
        int n2 = this.selection.getHeight();
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.setSize(n, n2);
        boolean bl = characterPlate.isMix();
        characterPlate.setMix(false);
        characterPlate.clear();
        CharacterPlate characterPlate2 = this.selection.getContent();
        characterPlate2.pasteInto(characterPlate, 0, 0);
        this.selection.delete();
        characterPlate.setMix(bl);
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void unselect() {
        this.unselect(false);
    }

    public void unselect(boolean bl) {
        this.selection.delete();
        if (!bl) {
            this.jave.updateSelectionMenu();
            this.repaint();
        }
    }

    protected Point getPasteLocation() {
        if (this.hasSelection()) {
            return this.selection.getLocation();
        }
        return this.document.getCursorLocation();
    }

    public void pasteAsNewSelection(CharacterPlate characterPlate) {
        this.pasteAsNewSelection(characterPlate, this.getPasteLocation());
    }

    public void pasteAsNewSelection(CharacterPlate characterPlate, Point point) {
        if (this.hasSelection()) {
            this.dropSelection();
        }
        this.selection.set(point, characterPlate);
        this.repaint();
    }

    public void pasteAsNewSelection(JaveClipboardSelection javeClipboardSelection, Point point) {
        if (this.hasSelection()) {
            this.dropSelection();
        }
        this.selection.set(point, javeClipboardSelection);
        this.repaint();
    }

    protected void pasteSelection() {
        this.selection.paste();
    }

    public void dropSelectionQuiet() {
        this.dropSelection(true);
    }

    public void dropSelection() {
        this.dropSelection(false);
    }

    public void dropSelection(boolean bl) {
        if (!this.hasSelection()) {
            throw new RuntimeException("No Selection to drop in Plate.dropSelection()!");
        }
        CharacterPlate characterPlate = this.document.getContent();
        Point point = this.selection.getLocation();
        boolean bl2 = false;
        if (point.x < 0) {
            characterPlate.addColumnsLeft(-point.x);
            point.x = 0;
            this.selection.setLocation(point.x, point.y);
            bl2 = true;
        }
        if (point.y < 0) {
            characterPlate.addLinesTop(-point.y);
            point.y = 0;
            this.selection.setLocation(point.x, point.y);
            bl2 = true;
        }
        if (point.x + this.selection.getWidth() > this.document.getWidth()) {
            characterPlate.addColumnsRight(point.x + this.selection.getWidth() - this.document.getWidth());
            bl2 = true;
        }
        if (point.y + this.selection.getHeight() > this.document.getHeight()) {
            characterPlate.addLinesBottom(point.y + this.selection.getHeight() - this.document.getHeight());
            bl2 = true;
        }
        if (bl2) {
            this.repaint();
            this.scrollPanel.doLayout();
            this.jave.plateSizeChanged();
        }
        this.pasteSelection();
        this.unselect(bl);
    }

    public void setSelection(Rectangle rectangle) {
        this.setSelection(rectangle, this.cut(rectangle));
    }

    public void setSelectionContent(CharacterPlate characterPlate) {
        this.setSelectionContent(new JaveSelection(characterPlate));
    }

    public void setSelectionContent(JaveSelection javeSelection) {
        Rectangle rectangle = this.selection.getRegion();
        int n = javeSelection.getHeight();
        if (n == 0) {
            this.unselect();
            return;
        }
        int n2 = javeSelection.getWidth();
        if (n2 == 0) {
            this.unselect();
            return;
        }
        rectangle.height = n;
        rectangle.width = n2;
        this.setSelection(rectangle, javeSelection);
    }

    public void setSelectionContent(char[][] cArray) {
        this.setSelectionContent(new CharacterPlate(cArray));
    }

    public void setSelection(Rectangle rectangle, CharacterPlate characterPlate) {
        this.selection.set(rectangle, new JaveSelection(characterPlate));
        this.jave.updateSelectionMenu();
        this.repaint();
    }

    public void setSelection(Rectangle rectangle, JaveSelection javeSelection) {
        this.selection.set(rectangle, javeSelection);
        this.jave.updateSelectionMenu();
        this.repaint();
    }

    public Point moveSelection(int n, int n2, boolean bl) {
        Point point = this.selection.move(n, n2, bl);
        this.repaint();
        return point;
    }

    public Point moveSelection(int n, int n2) {
        Point point = this.selection.move(n, n2);
        this.repaint();
        return point;
    }

    public boolean hasSelection() {
        if (this.selection == null) {
            return false;
        }
        return this.selection.hasSelection();
    }

    public CharacterPlate getSelectionContent() {
        return this.selection.getContent();
    }

    public Rectangle getSelectionRegion() {
        return this.selection.getRegion();
    }

    public boolean selectionContains(Point point) {
        return this.selection.contains(point);
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void expandSelection() {
        Rectangle rectangle = this.selection.getRegion();
        this.dropSelection();
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        this.setSelection(rectangle);
    }

    public void shrinkSelection() {
        CharacterPlate characterPlate = this.getSelectionContent();
        Insets insets = characterPlate.getEmptyInsets();
        int n = characterPlate.getWidth();
        int n2 = characterPlate.getHeight();
        if (insets.top + insets.bottom >= n2 || insets.right + insets.left >= n || n2 == 1 && n == 1 && characterPlate.get(0, 0) == ' ') {
            this.dropSelection();
            return;
        }
        int n3 = n - insets.left - insets.right;
        int n4 = n2 - insets.bottom - insets.top;
        CharacterPlate characterPlate2 = new CharacterPlate(n3, n4);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                characterPlate2.set(n6, n5, characterPlate.get(n6 + insets.left, n5 + insets.top));
                ++n6;
            }
            ++n5;
        }
        Point point = this.selection.getLocation();
        this.selection.set(new Point(point.x + insets.left, point.y + insets.top), characterPlate2);
        this.repaint();
    }

    public void zoomIn() {
        if (this.fontSize < 16) {
            this.setFontSize(this.fontSize + 1);
        }
    }

    public void zoomOut() {
        if (this.fontSize > 7) {
            this.setFontSize(this.fontSize - 1);
        }
    }

    public void setFont(String string) {
        this.setFont(string, this.fontSize);
    }

    public void setFontSize(int n) {
        this.setFont(this.fontName, n);
    }

    public void setFont(String string, int n) {
        if (n == this.fontSize && string.equals(this.fontName)) {
            return;
        }
        this.setFont(new Font(string, 0, n));
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontName = font.getName();
        this.fontSize = font.getSize();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.charWidth = fontMetrics.charWidth('#');
        this.charHeight = (int)Math.round(-0.14 * (double)this.fontSize * (double)this.fontSize + 4.56 * (double)this.fontSize - 19.3);
        this.fontAscent = this.charHeight - fontMetrics.getDescent();
        if (this.scrollPanel != null) {
            this.scrollPanel.setHorizontalIncrement(this.charWidth);
            this.scrollPanel.setVerticalIncrement(this.charHeight);
            this.scrollPanel.setVerticalBlockIncrement(this.getSize().height);
            this.scrollPanel.doLayout();
        }
        this.repaint();
    }

    public void setTools(Tool[] toolArray) {
        this.tools = toolArray;
    }

    public Tool[] getTools() {
        return this.tools;
    }

    public int getCurrentToolIndex() {
        int n = 0;
        while (n < this.tools.length) {
            if (this.tools[n] == this.currentTool) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public Tool getTool(int n) {
        return this.tools[n];
    }

    public void setCurrentTool(Tool tool) {
        if (this.currentTool == tool) {
            return;
        }
        if (this.currentTool != null) {
            this.currentTool.putAside(tool instanceof SelectionTool);
        }
        this.currentTool = tool;
        this.currentTool.takeToHand();
        this.currentTool.setDocument(this.document);
        this.requestFocus();
        this.setCursor(this.currentTool.getCursor());
        if (this.getSize().height != 0) {
            this.repaint();
        }
    }

    public void setCursor(Cursor cursor) {
        if (!cursor.equals(this.getCursor())) {
            super.setCursor(cursor);
        }
    }

    public void setStatusDisplay(StatusDisplay statusDisplay) {
        this.status = statusDisplay;
    }

    protected void showStatus(String string) {
        if (this.status != null) {
            this.status.showStatus(string);
        }
    }

    public Dimension getPreferredSize() {
        if (this.document == null) {
            return new Dimension(80 * this.charWidth + 1, 24 * this.charHeight + 1);
        }
        return new Dimension(this.getDocumentWidth() * this.charWidth + 1, this.getDocumentHeight() * this.charHeight + 1);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public char[][] copy(Rectangle rectangle) {
        return this.document.getContent().getCopy(rectangle).getContent();
    }

    public CharacterPlate cut(Rectangle rectangle) {
        CharacterPlate characterPlate = this.document.getContent();
        int n = characterPlate.getWidth();
        int n2 = characterPlate.getHeight();
        CharacterPlate characterPlate2 = new CharacterPlate(rectangle.width, rectangle.height);
        int n3 = 0;
        while (n3 < rectangle.width) {
            int n4 = n3 + rectangle.x;
            int n5 = 0;
            while (n5 < rectangle.height) {
                int n6 = n5 + rectangle.y;
                if (n4 >= 0 && n4 < n && n6 >= 0 && n6 < n2) {
                    characterPlate2.setForce(n3, n5, characterPlate.get(n4, n6));
                    characterPlate.set(n4, n6, ' ');
                }
                ++n5;
            }
            ++n3;
        }
        this.repaint();
        return characterPlate2;
    }

    protected void paste(int n, int n2, CharacterPlate characterPlate) {
        this.paste(n, n2, characterPlate.getContent());
    }

    protected void paste(int n, int n2, char[][] cArray) {
        CharacterPlate characterPlate = this.document.getContent();
        int n3 = characterPlate.getWidth();
        int n4 = characterPlate.getHeight();
        int n5 = 0;
        while (n5 < cArray.length) {
            int n6 = 0;
            while (n6 < cArray[n5].length) {
                int n7 = n6 + n;
                int n8 = n5 + n2;
                if (n7 >= 0 && n7 < n3 && n8 >= 0 && n8 < n4) {
                    characterPlate.set(n7, n8, cArray[n5][n6]);
                }
                ++n6;
            }
            ++n5;
        }
        this.repaint();
    }

    protected void delete(Rectangle rectangle) {
        this.delete(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void delete(int n, int n2, int n3, int n4) {
        CharacterPlate characterPlate = this.document.getContent();
        int n5 = characterPlate.getWidth();
        int n6 = characterPlate.getHeight();
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n7 + n;
            if (n8 >= 0 && n8 < n5) {
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = n9 + n2;
                    if (n10 >= 0 && n10 < n6) {
                        characterPlate.setForce(n8, n10, ' ');
                    }
                    ++n9;
                }
            }
            ++n7;
        }
        this.repaint();
    }

    public void setPlateSize(Dimension dimension) {
        this.setPlateSize(dimension.width, dimension.height);
    }

    public void setPlateSize(int n, int n2) {
        if (this.document.getWidth() == n && this.document.getHeight() == n2) {
            return;
        }
        if (this.hasSelection()) {
            this.pasteSelection();
            this.selection.delete();
        }
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.setSize(n, n2);
        this.currentTool.checkSize();
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public int getDocumentHeight() {
        if (this.document == null) {
            return -1;
        }
        return this.document.getHeight();
    }

    public int getDocumentWidth() {
        if (this.document == null) {
            return -1;
        }
        return this.document.getWidth();
    }

    public void insertLine(int n) {
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.insertLine(n);
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void insertLine(int n, String string) {
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.insertLine(n, string);
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void addColumnsRight(int n) {
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.addColumnsRight(n);
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void removeLine(int n) {
        CharacterPlate characterPlate = this.document.getContent();
        characterPlate.removeLine(n);
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void setText(String string) {
        this.setPlateSize(TextTools.getDimensionOf(string));
        CharacterPlate characterPlate = this.document.getContent();
        int n = characterPlate.getHeight();
        int n2 = characterPlate.getWidth();
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\f");
        while (stringTokenizer.hasMoreTokens() && n3 < n) {
            String string2 = stringTokenizer.nextToken();
            int n4 = 0;
            while (n4 < string2.length() && n4 < n2) {
                characterPlate.setForce(n4, n3, string2.charAt(n4));
                ++n4;
            }
            ++n3;
        }
        this.repaint();
    }

    public CharacterPlate getContent() {
        return this.document.getContent();
    }

    public JaveSelection getContentOfInterest() {
        if (this.document == null) {
            return null;
        }
        if (this.hasSelection()) {
            return this.selection.getJaveSelection();
        }
        return new JaveSelection(this.document.getContent());
    }

    public void setContentOfInterest(JaveSelection javeSelection) {
        if (this.hasSelection()) {
            this.setSelectionContent(javeSelection);
        } else {
            this.document.setContent(javeSelection.getContent());
            this.jave.plateSizeChanged();
            this.repaint();
        }
    }

    public final void beep() {
        this.getToolkit().beep();
    }

    public void clear() {
        this.unselect();
        this.document.getContent().clear();
        this.currentTool.reset();
        this.repaint();
        this.scrollPanel.doLayout();
        this.jave.plateSizeChanged();
    }

    public void setMouseChar1(char c) {
        this.char1 = c;
    }

    public void setMouseChar2(char c) {
        this.char2 = c;
    }

    public char getMouseChar() {
        if (this.mouseRightButton) {
            return this.char2;
        }
        return this.char1;
    }

    public boolean isMouseRightButton() {
        return this.mouseRightButton;
    }

    public void selectAll() {
        if (this.hasSelection()) {
            this.dropSelection();
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getDocumentWidth(), this.getDocumentHeight());
        this.setSelection(rectangle, this.cut(rectangle));
    }

    public void saveCurrentState() {
        this.saveCurrentState(null);
    }

    public void saveCurrentState(String string) {
        if (this.document == null) {
            return;
        }
        CompressedDocumentState compressedDocumentState = this.getDocumentState(string);
        long l = this.document.getRelativeTimeClock().getMillisSinceLastCall();
        if ((l /= 2L) > 1000L) {
            l = 1000L;
        }
        compressedDocumentState.setDuration((int)l);
        this.document.undoManager.saveCurrentState(compressedDocumentState);
        if (!this.document.isModified()) {
            this.document.setModified(true);
            this.jave.updateFrameTitle();
        }
        this.jave.updateUndoRedo();
        this.document.documentChanged();
    }

    public Point getOrigin() {
        if (this.scrollPanel == null) {
            return new Point(0, 0);
        }
        return this.scrollPanel.getScrollLocation();
    }

    public Point getViewPortOrigin() {
        return this.viewPortOrigin;
    }

    public void setOrigin(Point point) {
        if (this.scrollPanel != null) {
            this.scrollPanel.setScrollLocation(point);
        }
    }

    public Point getScreenPointFor(Point point) {
        return this.getScreenPointFor(point.x, point.y);
    }

    public Point getScreenPointFor(int n, int n2) {
        Point point = this.scrollPanel.getScrollLocation();
        point.x = (n - point.x) * this.charWidth + this.viewPortOrigin.x;
        point.y = (n2 - point.y) * this.charHeight + this.viewPortOrigin.y;
        return point;
    }

    public Point getScreenPointFor(Point2d point2d) {
        return this.getScreenPointFor(point2d.x, point2d.y);
    }

    public Point getScreenPointFor(double d, double d2) {
        Point point = this.scrollPanel.getScrollLocation();
        point.x = (int)((d - (double)point.x) * (double)this.charWidth + (double)this.viewPortOrigin.x);
        point.y = (int)((d2 - (double)point.y) * (double)this.charHeight + (double)this.viewPortOrigin.y);
        return point;
    }

    protected Point getLocationForScreenPoint(Point point) {
        Point point2 = this.scrollPanel.getScrollLocation();
        int n = point.x - this.viewPortOrigin.x;
        int n2 = point.y - this.viewPortOrigin.y;
        point2.x = (int)Math.floor((double)n / (double)this.charWidth) + point2.x;
        point2.y = (int)Math.floor((double)n2 / (double)this.charHeight) + point2.y;
        if (point2.x < 0 || point2.y < 0 || point2.x >= this.getDocumentWidth() || point2.y >= this.getDocumentHeight()) {
            if (this.currentTool.containsScreenPoint(point) || this.currentTool.containsLocation(point2)) {
                return point2;
            }
            return null;
        }
        return point2;
    }

    protected Point getLocationForScreenPointAnywhere(Point point) {
        Point point2 = this.scrollPanel.getScrollLocation();
        point.x -= this.viewPortOrigin.x;
        point.y -= this.viewPortOrigin.y;
        point2.x = (int)Math.floor((double)point.x / (double)this.charWidth) + point2.x;
        point2.y = (int)Math.floor((double)point.y / (double)this.charHeight) + point2.y;
        return point2;
    }

    protected Point2d getRealLocationForScreenPoint(Point point) {
        return this.getRealLocationForScreenPoint(point.x, point.y);
    }

    protected Point2d getRealLocationForScreenPoint(int n, int n2) {
        Point point = this.scrollPanel.getScrollLocation();
        double d = (double)(n -= this.viewPortOrigin.x) / (double)this.charWidth + (double)point.x;
        double d2 = (double)(n2 -= this.viewPortOrigin.y) / (double)this.charHeight + (double)point.y;
        return new Point2d(d, d2);
    }

    public Point ensureVisible(Point point) {
        return this.ensureVisible(point.x, point.y);
    }

    public Point ensureVisible(int n, int n2) {
        Point point = new Point(n * this.charWidth + this.viewPortOrigin.x, n2 * this.charHeight + this.viewPortOrigin.y);
        Point point2 = this.getOrigin();
        int n3 = point2.x;
        int n4 = point2.y;
        this.scrollPanel.ensureVisible(point);
        point2 = this.getOrigin();
        return new Point(point2.x - n3, point2.y - n4);
    }

    public void repaintCursor() {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO repaintCursor()");
        }
        this.repainted = false;
        super.repaint();
    }

    public void repaint() {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO repaint()");
        }
        this.repaintEverything = true;
        this.repainted = false;
        super.repaint();
    }

    public void repaint(long l) {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO repaint(" + l + ")");
        }
        this.repaintEverything = true;
        this.repainted = false;
        super.repaint(l);
    }

    public void paint(Graphics graphics) {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO paint(Graphics)");
        }
        this.update(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics graphics) {
        if (JaveGlobalRessources.debug) {
            System.out.println(" _____________________________________________________________");
            System.out.println("|updating graphics: xorPainter=" + this.xorPainter + " displayed==" + this.xorPainterDisplayed + "..");
        }
        Dimension dimension = this.getSize();
        this.scrollPanel.setVerticalBlockIncrement(dimension.height / this.charHeight);
        if (this.document == null) {
            graphics.setColor(JaveGlobalRessources.colorPlateEmpty);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (JaveGlobalRessources.debug) {
                System.out.println(" ..updating graphics finished, because no document to draw ");
                System.out.println("|_____________________________________________________________");
            }
            return;
        }
        if (this.offGraphics == null || this.offDimension == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
            this.offDimension = new Dimension(dimension.width, dimension.height);
            this.repaintEverything = true;
        }
        Point point = this.scrollPanel.getScrollLocation();
        if (this.repaintEverything) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            this.offGraphics.setColor(JaveGlobalRessources.colorPlateEmpty);
            this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
            int n6 = this.getDocumentWidth();
            int n7 = this.getDocumentHeight();
            Point point2 = new Point(point.x + (int)Math.ceil((double)dimension.width / (double)this.charWidth - 1.0), point.y + (int)Math.ceil((double)dimension.height / (double)this.charHeight - 1.0));
            if (point2.x >= n6) {
                point2.x = n6 - 1;
            }
            if (point2.y >= n7) {
                point2.y = n7 - 1;
            }
            if ((n5 = dimension.height - (n7 - point.y) * this.charHeight) < 0) {
                n5 = 0;
            }
            if ((n4 = dimension.width - (n6 - point.x) * this.charWidth) < 0) {
                n4 = 0;
            }
            int n8 = 0;
            int n9 = 0;
            n9 = point.y > 0 ? n5 : n5 / 2;
            n8 = n5 - n9;
            int n10 = 0;
            int n11 = 0;
            if (point.x > 0) {
                n11 = n4;
            } else {
                n10 = n4 / 2;
            }
            n11 = n4 - n10;
            this.viewPortOrigin.x = n10;
            this.viewPortOrigin.y = n8;
            int n12 = (n6 - point.x) * this.charWidth;
            if (dimension.width < n12) {
                n12 = dimension.width;
            }
            if (dimension.height < (n3 = (n7 - point.y) * this.charHeight)) {
                n3 = dimension.height;
            }
            this.offGraphics.setColor(JaveGlobalRessources.colorPlateBackground);
            this.offGraphics.fillRect(this.viewPortOrigin.x, this.viewPortOrigin.y, (n6 - point.x) * this.charWidth, (n7 - point.y) * this.charHeight);
            if (this.watermarkPainterExclusive != null) {
                this.watermarkPainterExclusive.paint(this.offGraphics, this.viewPortOrigin.x, this.viewPortOrigin.y, point.x, point.y, this.charWidth, this.charHeight);
            } else if (this.watermarkPainters != null) {
                n2 = 0;
                while (n2 < this.watermarkPainters.size()) {
                    ((WatermarkPainter)this.watermarkPainters.elementAt(n2)).paint(this.offGraphics, this.viewPortOrigin.x, this.viewPortOrigin.y, point.x, point.y, this.charWidth, this.charHeight);
                    ++n2;
                }
            }
            this.offGraphics.setFont(this.getFont());
            if (this.grid) {
                this.offGraphics.setColor(JaveGlobalRessources.colorPlateLines);
                n2 = 0;
                while (n2 * this.charWidth <= n12) {
                    this.offGraphics.drawLine(this.viewPortOrigin.x + n2 * this.charWidth, this.viewPortOrigin.y, this.viewPortOrigin.x + n2 * this.charWidth, this.viewPortOrigin.y + n3);
                    ++n2;
                }
                n = 0;
                while (n * this.charHeight <= n3) {
                    this.offGraphics.drawLine(this.viewPortOrigin.x, this.viewPortOrigin.y + n * this.charHeight, this.viewPortOrigin.x + n12, this.viewPortOrigin.y + n * this.charHeight);
                    ++n;
                }
            }
            n2 = (n6 - point.x) * this.charWidth;
            n = (n7 - point.y) * this.charHeight;
            this.offGraphics.setColor(JaveGlobalRessources.colorPlateShadow);
            if (point.x == 0) {
                this.offGraphics.drawLine(this.viewPortOrigin.x, this.viewPortOrigin.y, this.viewPortOrigin.x, this.viewPortOrigin.y + n);
            }
            if (point.y == 0) {
                this.offGraphics.drawLine(this.viewPortOrigin.x, this.viewPortOrigin.y, this.viewPortOrigin.x + n2, this.viewPortOrigin.y);
            }
            this.offGraphics.drawLine(this.viewPortOrigin.x + n2, this.viewPortOrigin.y, this.viewPortOrigin.x + n2, this.viewPortOrigin.y + 2);
            if (point.y == 0) {
                this.offGraphics.fillRect(this.viewPortOrigin.x + n2, this.viewPortOrigin.y + 2, 3, n + 1);
            } else {
                this.offGraphics.fillRect(this.viewPortOrigin.x + n2, this.viewPortOrigin.y, 3, n + 3);
            }
            this.offGraphics.drawLine(this.viewPortOrigin.x, this.viewPortOrigin.y + n, this.viewPortOrigin.x + 2, this.viewPortOrigin.y + n);
            if (point.x == 0) {
                this.offGraphics.fillRect(this.viewPortOrigin.x + 2, this.viewPortOrigin.y + n, n2 - 2, 3);
            } else {
                this.offGraphics.fillRect(this.viewPortOrigin.x, this.viewPortOrigin.y + n, n2, 3);
            }
            this.offGraphics.setColor(JaveGlobalRessources.colorText);
            if (this.pixelView) {
                PixelView.paintPixelView(this.offGraphics, this.getContent(), point, point2, this.viewPortOrigin, this.charWidth, this.charHeight, this.fontAscent);
            } else {
                CharacterPlate characterPlate = this.getContent();
                int n13 = point.y;
                while (n13 <= point2.y) {
                    this.offGraphics.drawString(new String(characterPlate.getContent()[n13], point.x, point2.x - point.x + 1), this.viewPortOrigin.x, this.viewPortOrigin.y + (n13 - point.y) * this.charHeight + this.fontAscent);
                    ++n13;
                }
                if (this.markIllegal) {
                    this.offGraphics.setColor(Color.red);
                    int n14 = point.y;
                    while (n14 <= point2.y) {
                        int n15 = point.x;
                        while (n15 <= point2.x) {
                            char c = characterPlate.get(n15, n14);
                            if (!CharacterSets.isLegal(c)) {
                                this.offGraphics.drawOval(this.viewPortOrigin.x + (n15 - point.x) * this.charWidth - 2, this.viewPortOrigin.y + (n14 - point.y) * this.charHeight - 2, this.charWidth + 4, this.charHeight + 4);
                            }
                            ++n15;
                        }
                        ++n14;
                    }
                }
            }
            this.selection.paint(this.offGraphics);
        }
        graphics.drawImage(this.offImage, 0, 0, this);
        this.xorPainterDisplayed = false;
        this.selection.paintBorder(graphics);
        graphics.setFont(this.getFont());
        this.currentTool.paintCursorFeature(graphics);
        Plate plate = this;
        synchronized (plate) {
            if (!this.xorPainterDisplayed && this.xorPainter != null) {
                if (JaveGlobalRessources.debug) {
                    System.out.println(" painting xor-painter to be redisplayed again..");
                }
                this.xorPainter.paintXOR(graphics);
                this.xorPainterDisplayed = true;
                if (JaveGlobalRessources.debug) {
                    System.out.println(" ..painting xor-painter to be redisplayed again finished.");
                }
            }
        }
        this.repaintEverything = false;
        this.repainted = true;
        if (JaveGlobalRessources.debug) {
            System.out.println(" ..updating graphics finished: xorPainter=" + this.xorPainter + " displayed=" + this.xorPainterDisplayed);
            System.out.println("|_____________________________________________________________");
            System.out.println();
        }
    }

    public boolean isRepainted() {
        return this.repainted;
    }

    public void paintPreview(Graphics graphics, CharacterPlate characterPlate, int n, int n2, Point point) {
        this.paintPreview(graphics, characterPlate, n, n2, point.x, point.y);
    }

    public void paintPreview(Graphics graphics, CharacterPlate characterPlate, int n, int n2, int n3, int n4) {
        graphics.setColor(JaveGlobalRessources.colorToolPreview);
        graphics.setFont(this.getFont());
        Point point = this.getScreenPointFor(n3, n4);
        int n5 = characterPlate.getHeight();
        int n6 = 0;
        while (n6 < n5) {
            char[] cArray = characterPlate.getContent()[n6];
            boolean bl = true;
            int n7 = 0;
            while (bl && n7 < cArray.length) {
                if (cArray[n7] != ' ') {
                    bl = false;
                }
                ++n7;
            }
            CharacterPlate characterPlate2 = this.document.getContent();
            int n8 = 0;
            while (n8 < cArray.length) {
                if (characterPlate2.contains(n3 + n8, n4 + n6)) {
                    cArray[n8] = characterPlate2.getPasteResult(cArray[n8], n3 + n8, n4 + n6);
                }
                ++n8;
            }
            if (!bl) {
                graphics.drawString(new String(cArray), point.x - n * this.charWidth, point.y + (n6 - n2) * this.charHeight + this.fontAscent);
            }
            ++n6;
        }
    }

    public void showCoordinates(Point point) {
        if (point == null) {
            this.showStatus("");
        } else {
            this.showStatus("(" + point.x + "," + point.y + ")");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Tool.setMetaDown(mouseEvent.isMetaDown());
        if (this.document == null) {
            return;
        }
        this.currentTool.mouseClicked(mouseEvent.getPoint(), this.getLocationForScreenPoint(mouseEvent.getPoint()), mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        Tool.setMetaDown(mouseEvent.isMetaDown());
        this.mouseRightButton = mouseEvent.isMetaDown();
        if (this.document == null) {
            return;
        }
        this.currentTool.mousePressed(mouseEvent.getPoint(), this.getLocationForScreenPoint(mouseEvent.getPoint()), mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.document == null) {
            return;
        }
        Tool.setMetaDown(mouseEvent.isMetaDown());
        this.currentTool.mouseReleased(mouseEvent.getPoint(), this.getLocationForScreenPointAnywhere(mouseEvent.getPoint()), mouseEvent);
        if (this.shiftDown) {
            this.shiftDown = false;
            this.currentTool.shiftReleased();
        }
        if (this.controlDown) {
            this.controlDown = false;
            this.currentTool.controlReleased();
        }
        this.mouseRightButton = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.document == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(this.currentTool.getCursor());
        this.currentTool.mouseEntered(mouseEvent.getPoint(), this.getLocationForScreenPoint(mouseEvent.getPoint()), mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.document == null) {
            return;
        }
        this.showStatus("");
        this.currentTool.mouseExited(mouseEvent.getPoint(), this.getLocationForScreenPoint(mouseEvent.getPoint()), mouseEvent);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        char c;
        if (this.document == null) {
            return;
        }
        Point point = this.getLocationForScreenPoint(mouseEvent.getPoint());
        this.showCoordinates(point);
        if (point != null && this.markIllegal && this.isInside(point.x, point.y) && !CharacterSets.isLegal(c = this.getChar(point.x, point.y))) {
            this.showStatus("Illegal Character: " + c);
        }
        this.currentTool.mouseMoved(mouseEvent.getPoint(), point, mouseEvent);
        if (point == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.currentTool.getCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.document == null) {
            return;
        }
        Point point = this.getLocationForScreenPointAnywhere(mouseEvent.getPoint());
        this.currentTool.mouseDragged(mouseEvent.getPoint(), point, mouseEvent);
        if (point == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.currentTool.getCursor());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.document == null) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.keyMark1) {
            if (c == ' ') {
                this.currentTool.keyTyped('\u00b4', keyEvent);
                this.keyMark1 = false;
                return;
            }
            if (c == 'a') {
                this.currentTool.keyTyped('\u00e1', keyEvent);
                this.keyMark1 = false;
                return;
            }
            if (c == 'o') {
                this.currentTool.keyTyped('\u00f3', keyEvent);
                this.keyMark1 = false;
                return;
            }
            if (c == 'i') {
                this.currentTool.keyTyped('\u00ed', keyEvent);
                this.keyMark1 = false;
                return;
            }
            if (c == 'u') {
                this.currentTool.keyTyped('\u00fa', keyEvent);
                this.keyMark1 = false;
                return;
            }
            this.keyMark1 = false;
        }
        if (this.keyMark2) {
            if (c == ' ') {
                this.currentTool.keyTyped('`', keyEvent);
                this.keyMark2 = false;
                return;
            }
            if (c == 'a') {
                this.currentTool.keyTyped('\u00e0', keyEvent);
                this.keyMark2 = false;
                return;
            }
            if (c == 'o') {
                this.currentTool.keyTyped('\u00f2', keyEvent);
                this.keyMark2 = false;
                return;
            }
            if (c == 'i') {
                this.currentTool.keyTyped('\u00ec', keyEvent);
                this.keyMark2 = false;
                return;
            }
            if (c == 'u') {
                this.currentTool.keyTyped('\u00f9', keyEvent);
                this.keyMark2 = false;
                return;
            }
            this.keyMark2 = false;
        }
        if (this.keyMark3) {
            if (c == ' ') {
                this.currentTool.keyTyped('^', keyEvent);
                this.keyMark3 = false;
                return;
            }
            if (c == 'a') {
                this.currentTool.keyTyped('\u00e2', keyEvent);
                this.keyMark3 = false;
                return;
            }
            if (c == 'o') {
                this.currentTool.keyTyped('\u00f4', keyEvent);
                this.keyMark3 = false;
                return;
            }
            if (c == 'i') {
                this.currentTool.keyTyped('\u00ee', keyEvent);
                this.keyMark3 = false;
                return;
            }
            if (c == 'u') {
                this.currentTool.keyTyped('\u00fb', keyEvent);
                this.keyMark3 = false;
                return;
            }
            this.keyMark3 = false;
        }
        this.currentTool.keyTyped(c, keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.document == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 155: {
                this.toggleInsert();
                break;
            }
            case 33: {
                this.scrollPanel.blockUp();
                if (!keyEvent.isControlDown()) {
                    this.currentTool.cursorUp(this.getSize().height / this.charHeight);
                }
                return;
            }
            case 34: {
                this.scrollPanel.blockDown();
                if (!keyEvent.isControlDown()) {
                    this.currentTool.cursorDown(this.getSize().height / this.charHeight);
                }
                return;
            }
            case 35: {
                if (!keyEvent.isControlDown()) break;
                this.scrollPanel.verticalEnd();
                break;
            }
            case 36: {
                if (!keyEvent.isControlDown()) break;
                this.scrollPanel.verticalHome();
            }
        }
        char c = keyEvent.getKeyChar();
        if (c == '+' && keyEvent.isControlDown()) {
            this.jave.doZoomPlus();
            keyEvent.consume();
            return;
        }
        if (c == '-' && keyEvent.isControlDown()) {
            this.jave.doZoomMinus();
            keyEvent.consume();
            return;
        }
        if (this.keyMark1 && n != 93 && (c < 'a' || c > 'z') && c != ' ') {
            this.keyMark1 = false;
        }
        if (this.keyMark2 && n != 93 && (c < 'a' || c > 'z') && c != ' ') {
            this.keyMark2 = false;
        }
        if (this.keyMark3 && n != 92 && (c < 'a' || c > 'z') && c != ' ') {
            this.keyMark3 = false;
        }
        if (n == 93 && !keyEvent.isShiftDown()) {
            if (this.keyMark1) {
                this.currentTool.keyTyped('\u00b4', keyEvent);
                this.keyMark1 = false;
                return;
            }
            this.keyMark1 = true;
        }
        if (n == 93 && keyEvent.isShiftDown()) {
            if (this.keyMark2) {
                this.currentTool.keyTyped('`', keyEvent);
                this.keyMark2 = false;
                return;
            }
            this.keyMark2 = true;
        }
        if (n == 92 && !keyEvent.isShiftDown()) {
            if (this.keyMark3) {
                this.currentTool.keyTyped('^', keyEvent);
                this.keyMark3 = false;
                return;
            }
            this.keyMark3 = true;
        }
        if (!this.shiftDown && keyEvent.isShiftDown()) {
            this.shiftDown = true;
            this.currentTool.shiftPressed();
        }
        if (!this.controlDown && keyEvent.isControlDown()) {
            this.controlDown = true;
            this.currentTool.controlPressed();
        }
        if (!this.altDown && keyEvent.isAltDown()) {
            this.altDown = true;
            this.currentTool.altPressed();
        }
        this.currentTool.keyPressed(n, keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.document == null) {
            return;
        }
        this.currentTool.keyReleased(keyEvent);
        if (this.shiftDown) {
            this.shiftDown = false;
            this.currentTool.shiftReleased();
        }
        if (this.controlDown) {
            this.controlDown = false;
            this.currentTool.controlReleased();
        }
        if (this.altDown) {
            this.altDown = false;
            this.currentTool.altReleased();
        }
    }

    protected void toggleInsert() {
        this.jave.toggleInsert();
    }

    public void drawString(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < string.length()) {
            this.setChar(n + n3, n2, string.charAt(n3));
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void pan(int var1_1, int var2_2) {
        if (var1_1 != 0 || var2_2 != 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.panRight();
            --var1_1;
lbl5:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl6:
        // 2 sources

        while (var1_1 < 0) {
            this.panLeft();
            ++var1_1;
        }
        while (var2_2 > 0) {
            this.panDown();
            --var2_2;
        }
        while (var2_2 < 0) {
            this.panUp();
            ++var2_2;
        }
        this.repaint(50L);
    }

    protected void panLeft() {
        this.getContent().panLeft();
    }

    protected void panRight() {
        this.getContent().panRight();
    }

    protected void panUp() {
        this.getContent().panUp();
    }

    protected void panDown() {
        this.getContent().panDown();
    }

    public String getUndoActionName() {
        if (this.document == null || this.document.undoManager == null) {
            return "";
        }
        return this.document.undoManager.getUndoActionName();
    }

    public String getRedoActionName() {
        if (this.document == null || this.document.undoManager == null) {
            return "";
        }
        return this.document.undoManager.getRedoActionName();
    }

    public boolean canUndo() {
        if (this.document == null || this.document.undoManager == null) {
            return false;
        }
        return this.document.undoManager.canUndo();
    }

    public boolean canRedo() {
        if (this.document == null || this.document.undoManager == null) {
            return false;
        }
        return this.document.undoManager.canRedo();
    }

    public synchronized void redo() {
        if (this.document == null || !this.canRedo()) {
            System.err.println("ERROR! redo can not be performed!");
            return;
        }
        CompressedDocumentState compressedDocumentState = (CompressedDocumentState)this.document.undoManager.redo();
        this.setDocumentState(compressedDocumentState);
        this.setToolState(compressedDocumentState);
        this.setCursorState(compressedDocumentState);
        this.document.documentChanged();
    }

    public synchronized void undo() {
        if (this.document == null || !this.canUndo()) {
            System.err.println("ERROR! undo can not be performed!");
            return;
        }
        CompressedDocumentState compressedDocumentState = (CompressedDocumentState)this.document.undoManager.undo();
        this.setDocumentState(compressedDocumentState);
        CompressedDocumentState compressedDocumentState2 = (CompressedDocumentState)this.document.undoManager.getNextState();
        if (compressedDocumentState2 != null) {
            this.setToolState(compressedDocumentState2);
        }
        this.setCursorState(compressedDocumentState);
        this.document.documentChanged();
    }

    protected void setDocumentState(CompressedDocumentState compressedDocumentState) {
        int n = this.document.getWidth();
        int n2 = this.document.getHeight();
        this.document.setDocumentState(compressedDocumentState);
        this.selection = this.document.getSelection();
        this.selection.setPlate(this);
        if (this.document.getHeight() != n2 || this.document.getWidth() != n) {
            this.jave.plateSizeChanged();
        }
        this.scrollPanel.doLayout();
        this.jave.setColorScheme(compressedDocumentState.getColorScheme());
        this.repaint();
        this.setOrigin(this.document.getScrollOrigin());
    }

    protected void setToolState(CompressedDocumentState compressedDocumentState) {
        String string = compressedDocumentState.getToolName();
        if (string != null) {
            int n = 0;
            n = 0;
            while (n < this.tools.length) {
                if (this.tools[n].getName().equals(string)) break;
                ++n;
            }
            if (this.tools[n].getName().equals(string)) {
                this.jave.setTool(n);
            }
        }
    }

    protected void setCursorState(CompressedDocumentState compressedDocumentState) {
        Point point = this.document.getCursorLocation();
        point.x = compressedDocumentState.getCursorLocation().x;
        point.y = compressedDocumentState.getCursorLocation().y;
        this.currentTool.plateScrolled();
    }

    public char getChar(int n, int n2) {
        return this.getContent().get(n, n2);
    }

    public void setChar(Point point, char c) {
        if (point == null) {
            return;
        }
        this.setChar(point.x, point.y, c);
    }

    public void setChar(int n, int n2, char c) {
        if (n < 0 || n2 < 0 || n >= this.getDocumentWidth() || n2 >= this.getDocumentHeight()) {
            return;
        }
        CharacterPlate characterPlate = this.getContent();
        if (c != characterPlate.get(n, n2)) {
            characterPlate.set(n, n2, c);
        }
    }

    public void setCharForce(Point point, char c) {
        if (point == null) {
            return;
        }
        this.setCharForce(point.x, point.y, c);
    }

    public void setCharForce(int n, int n2, char c) {
        if (n < 0 || n2 < 0 || n >= this.getDocumentWidth() || n2 >= this.getDocumentHeight()) {
            return;
        }
        CharacterPlate characterPlate = this.getContent();
        if (c != characterPlate.get(n, n2)) {
            characterPlate.setForce(n, n2, c);
        }
    }

    public boolean hasGrid() {
        return this.grid;
    }

    public void setGrid(boolean bl) {
        if (this.grid != bl) {
            this.grid = bl;
            this.repaint();
        }
    }

    public void setPixelView(boolean bl) {
        if (this.pixelView != bl) {
            this.pixelView = bl;
            this.repaint();
        }
    }

    public void setMarkIllegalChars(boolean bl) {
        if (this.markIllegal != bl) {
            this.markIllegal = bl;
            this.repaint();
        }
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO repaint(" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        }
        super.repaint(n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (JaveGlobalRessources.debug) {
            System.out.println("CALL TO repaint(" + l + "," + n + "," + n2 + "," + n3 + "," + n4 + ")");
        }
        super.repaint(l, n, n2, n3, n4);
    }
}

