/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.gui.GTextArea;
import de.jave.jave.FillTool;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Pattern;
import de.jave.jave.PatternList;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class PatternDialog
extends Dialog
implements ActionListener,
ItemListener,
WindowListener {
    protected static final String TITLE = "Pattern Library";
    protected FillTool fillTool;
    protected List list;
    protected PatternList patternList;
    protected TextArea taPattern;
    protected TextArea taPreview;
    protected TextField tfAuthor;
    protected Button bUse;
    protected Button bClose;
    protected Button bDelete;
    protected Pattern currentPattern;
    protected Frame parent;

    public PatternDialog(Frame frame, FillTool fillTool) {
        super(frame, TITLE);
        this.parent = frame;
        this.fillTool = fillTool;
        this.patternList = new PatternList();
        this.patternList.load();
        this.init();
        this.addWindowListener(this);
        this.updatePreview();
    }

    protected void init() {
        this.list = new List();
        int n = this.patternList.getPatternCount();
        int n2 = 0;
        while (n2 < n) {
            this.list.add(this.patternList.getPattern(n2).getName());
            ++n2;
        }
        this.list.setMultipleMode(false);
        this.list.select(0);
        this.list.addItemListener(this);
        this.currentPattern = this.patternList.getPattern(0);
        this.taPattern = new GTextArea("", 6, 10);
        this.taPattern.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPattern.setEditable(false);
        this.tfAuthor = new TextField(15);
        this.tfAuthor.setEditable(false);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.list, "Center");
        panel.add((Component)this.taPattern, "South");
        this.bDelete = new Button("Delete");
        this.bDelete.addActionListener(this);
        this.bUse = new Button("Use");
        this.bUse.addActionListener(this);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.add(this.bDelete);
        panel2.add(this.bUse);
        panel2.add(this.bClose);
        Panel panel3 = new Panel();
        panel3.add(new Label("Author:"));
        panel3.add(this.tfAuthor);
        this.taPreview = new GTextArea("", 12, 30);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Preview:", -1);
        gBorderedPanel.setLayout(new GridLayout());
        gBorderedPanel.add(this.taPreview);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)panel3, "North");
        panel4.add((Component)gBorderedPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "West");
        this.add((Component)panel4, "Center");
        this.add((Component)panel2, "South");
    }

    public void addPattern(Pattern pattern) {
        this.patternList.add(pattern);
        this.patternList.save();
        this.updateList();
        this.updatePreview();
    }

    protected void updateList() {
        this.list.removeAll();
        int n = this.patternList.getPatternCount();
        int n2 = 0;
        while (n2 < n) {
            this.list.add(this.patternList.getPattern(n2).getName());
            ++n2;
        }
        this.list.select(n - 1);
    }

    protected void updatePreview() {
        int n = this.list.getSelectedIndex();
        this.currentPattern = this.patternList.getPattern(n);
        char[][] cArray = JaveAsciiPacker.decode(this.currentPattern.getCode());
        this.taPattern.setText(TextTools.toString(cArray));
        this.tfAuthor.setText(this.currentPattern.getAuthor());
        int n2 = cArray.length;
        int n3 = cArray[0].length;
        int n4 = n2;
        while (n4 < 30) {
            n4 += n2;
        }
        int n5 = n3;
        while (n5 < 12) {
            n5 += n3;
        }
        char[][] cArray2 = new char[n4][n5];
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n5) {
                cArray2[n6][n7] = cArray[n6 % n2][n7 % n3];
                ++n7;
            }
            ++n6;
        }
        this.taPreview.setText(TextTools.toString(cArray2));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updatePreview();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bUse) {
            this.fillTool.setPattern(this.currentPattern);
            return;
        }
        if (object == this.bClose) {
            this.setVisible(false);
            return;
        }
        if (object == this.bDelete) {
            int n = this.list.getSelectedIndex();
            this.currentPattern = this.patternList.getPattern(n);
            String string = "Do you really want to delete\nthe Pattern \"" + this.currentPattern.getName() + "\" ?";
            GDialog gDialog = new GDialog(this.parent, "Delete pattern", string, GDialog.YES_NO_CANCEL, 2);
            gDialog.show();
            int n2 = gDialog.getAnswer();
            if (n2 == -1 || n2 == 1 || n2 == 2) {
                return;
            }
            this.patternList.delete(n);
            this.patternList.save();
            this.updateList();
            this.list.select(n - 1);
            this.updatePreview();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

