/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.XORPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class JaveTextCursor
implements XORPainter {
    protected int style;
    protected int charHeight;
    protected int charWidth;
    protected Point location;
    public static final int CURSOR_HORIZONTAL_LINE = 1;
    public static final int CURSOR_VERTICAL_LINE = 2;
    public static final int CURSOR_BLOCK = 3;
    protected long id;
    protected static long counter = 0L;

    public JaveTextCursor(Point point, int n, int n2, int n3) {
        this.style = n;
        this.charHeight = n3;
        this.charWidth = n2;
        this.location = point;
        this.id = ++counter;
    }

    public void paintXOR(Graphics graphics) {
        if (JaveGlobalRessources.debug) {
            System.out.print("  painting " + this + ".. " + graphics.getColor());
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        switch (this.style) {
            case 3: {
                graphics.fillRect(this.location.x, this.location.y, this.charWidth + 1, this.charHeight + 1);
                break;
            }
            case 1: {
                int n = this.location.y + this.charHeight - 2;
                graphics.drawLine(this.location.x + 1, n, this.location.x + 1 + this.charWidth - 2, n);
                break;
            }
            case 2: {
                graphics.drawLine(this.location.x + 2, this.location.y + this.charHeight - 2, this.location.x + 2, this.location.y + 2);
            }
        }
        graphics.setPaintMode();
        if (JaveGlobalRessources.debug) {
            System.out.println("..painting " + this + " finished");
        }
    }

    public String toString() {
        return "TextCursor[" + this.id + "]";
    }
}

