/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GuiTools;
import de.jave.jave.Jave;
import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.JaveAlgorithmOptionsListener;
import de.jave.jave.algorithm.JaveAlgorithmOptionsPanel;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class JaveOptionsAlgorithmDialog
extends Dialog
implements JaveAlgorithmOptionsListener,
WindowListener,
ActionListener {
    protected Jave jave;
    protected Button bClose;
    protected Button bCancel;
    protected JaveSelection source;
    protected boolean applied = false;
    protected JaveOptionsAlgorithm algorithm;

    public JaveOptionsAlgorithmDialog(Jave jave, JaveOptionsAlgorithm javeOptionsAlgorithm) {
        super((Frame)jave, true);
        this.jave = jave;
        this.algorithm = javeOptionsAlgorithm;
        this.setTitle(javeOptionsAlgorithm.getMenuItemLabel());
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.source = this.jave.getContentOfInterest();
        javeOptionsAlgorithm.getOptions().adjustTo(this.source);
        JaveAlgorithmOptionsPanel javeAlgorithmOptionsPanel = javeOptionsAlgorithm.getOptions().getPanel();
        this.bClose = new Button(" Ok ");
        this.bClose.addActionListener(this);
        this.bCancel = new Button("Cancel");
        this.bCancel.addActionListener(this);
        Panel panel = new Panel();
        panel.add(this.bClose);
        panel.add(this.bCancel);
        this.add((Component)javeAlgorithmOptionsPanel, "Center");
        this.add((Component)panel, "South");
        this.pack();
        GuiTools.centerToFrame(this);
        javeOptionsAlgorithm.getOptions().addAlgorithmOptionsListener(this);
    }

    public void algorithmOptionsChanged() {
        JaveSelection javeSelection = this.algorithm.apply(this.source.getClone());
        this.jave.setContentOfInterest(javeSelection);
        this.applied = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            this.doClose();
        } else if (object == this.bCancel) {
            this.doCancel();
        }
    }

    private void doClose() {
        this.algorithm.getOptions().removeAlgorithmOptionsListener(this);
        if (this.applied) {
            this.jave.plate.saveCurrentState(this.algorithm.getActionName());
        }
        this.applied = false;
        this.setVisible(false);
    }

    private void doCancel() {
        this.algorithm.getOptions().removeAlgorithmOptionsListener(this);
        if (this.applied) {
            this.jave.setContentOfInterest(this.source);
            this.applied = false;
        }
        this.setVisible(false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doCancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

