/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.FontChoice;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.util.Toolbox;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Fonts
implements JaveConfigurationLoadable {
    protected static Hashtable fontTable;
    protected static String defaultFontName;
    protected static boolean initialized;

    public String getConfigurationFileName() {
        return "./config/fonts.cfg";
    }

    public static void init() {
        Fonts.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new Fonts());
        initialized = true;
    }

    public void setDefaultConfiguration() {
        fontTable = new Hashtable(3);
        fontTable.put("Monospaced", new Integer(13));
        defaultFontName = "Monospaced";
        initialized = true;
    }

    public void loadConfiguration(File file) throws Exception {
        String[] stringArray = FontChoice.getAllAvailableFontNames();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length * 2);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], stringArray[n]);
            ++n;
        }
        fontTable = new Hashtable(30);
        defaultFontName = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
            int n3 = 13;
            String string2 = string;
            char c = string.charAt(string.length() - 1);
            if (c >= '0' && c <= '9' && (n2 = string.lastIndexOf(32)) != -1) {
                try {
                    n3 = Integer.parseInt(string.substring(n2 + 1));
                    string2 = string.substring(0, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!hashtable.containsKey(string2)) continue;
            fontTable.put(string2, new Integer(n3));
            if (defaultFontName != null) continue;
            defaultFontName = string2;
        }
        bufferedReader.close();
        if (fontTable.size() == 0 || defaultFontName == null) {
            throw new Exception();
        }
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Font getDefaultFont() {
        return Fonts.getFont(defaultFontName);
    }

    public static Font getFont(String string) {
        return new Font(string, 0, (Integer)fontTable.get(string));
    }

    public static String getDefaultFontName() {
        return defaultFontName;
    }

    public static String debugLinux() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = FontChoice.getAllAvailableFontNames();
        Toolbox.quickSort(stringArray);
        stringBuffer.append("All Fonts available to the JRE on this system:\n");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("  " + stringArray[n] + '\n');
            ++n;
        }
        stringBuffer.append("Those seem to be fixed width ones:\n");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = 0;
        while (n2 < stringArray.length) {
            Font font = new Font(stringArray[n2], 0, 13);
            FontMetrics fontMetrics = toolkit.getFontMetrics(font);
            if (fontMetrics.charWidth('#') == fontMetrics.charWidth('|')) {
                stringBuffer.append("  " + stringArray[n2] + '\n');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String[] getFontList() {
        String[] stringArray = new String[fontTable.size()];
        Enumeration enumeration = fontTable.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        Toolbox.quickSort(stringArray);
        return stringArray;
    }

    static {
        initialized = false;
    }
}

