/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterDrawable;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.text.TextTools;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class CharacterPlate
implements CharacterDrawable,
JaveConfigurationLoadable {
    protected char[][] chars;
    protected boolean mix;
    protected int width;
    protected int height;
    protected static final String DEFAULT_MIX_RULE_A = "-\\-||---||oooooooooooddddddddddPPPPPPPPP,,,,,....'''''88888bbbb``YY";
    protected static final String DEFAULT_MIX_RULE_B = "|/++__/\\/\\PdY8b\"_`'.,P,.'8b`Y_\",.'8b`Y_\".8bY_8bY_8b`Y\"b`Y_\"`Y_\"Y\"_\"";
    protected static final String DEFAULT_MIX_RULE_C = "+X++|=++++8d88b8odboo8ddd88d8d88PP88P88P,8bY,8bY.8b'Y\"88888b8b8Y\"8Y";
    protected static char[] mixRuleA;
    protected static char[] mixRuleB;
    protected static char[] mixRuleC;
    protected static boolean initialized;

    public String getConfigurationFileName() {
        return "./config/mix.txt";
    }

    protected CharacterPlate() {
    }

    public static void init() {
        CharacterPlate.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new CharacterPlate());
        initialized = true;
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public CharacterPlate(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public CharacterPlate(int n, int n2) {
        this.chars = new char[n2][n];
        this.width = n;
        this.height = n2;
        this.clear();
        this.mix = false;
    }

    public CharacterPlate(char[][] cArray) {
        this.chars = cArray;
        this.height = this.chars.length;
        this.width = this.chars[0].length;
        this.mix = false;
    }

    public CharacterPlate(String string) {
        if (string.length() == 0) {
            this.width = 0;
            this.height = 0;
            this.chars = new char[0][0];
        } else {
            this.chars = TextTools.toCharField(string);
            this.height = this.chars.length;
            this.width = this.chars[0].length;
        }
        this.mix = false;
    }

    public CharacterPlate(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.width = 0;
            this.height = 0;
            this.chars = new char[0][0];
        } else {
            this.chars = TextTools.toCharField(stringArray);
            this.height = this.chars.length;
            this.width = this.chars[0].length;
        }
        this.mix = false;
    }

    public char[][] getContent() {
        return this.chars;
    }

    public char[][] getContentClone() {
        return CharacterPlate.getClone(this.chars);
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public boolean equals(String string, int n, int n2) {
        int n3 = 0;
        while (n3 < string.length()) {
            if (!this.contains(n + n3, n2)) {
                return false;
            }
            if (this.get(n + n3, n2) != string.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static final char[][] getClone(char[][] cArray) {
        int n = cArray.length;
        int n2 = cArray[0].length;
        char[][] cArray2 = new char[n][n2];
        int n3 = 0;
        while (n3 < n) {
            System.arraycopy(cArray[n3], 0, cArray2[n3], 0, n2);
            ++n3;
        }
        return cArray2;
    }

    public CharacterPlate getCopy(Rectangle rectangle) {
        return this.getCopy(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public CharacterPlate getCopy(int n, int n2, int n3, int n4) {
        char[][] cArray = new char[n4][n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5 + n;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = n7 + n2;
                cArray[n7][n5] = n6 >= 0 && n6 < this.width && n8 >= 0 && n8 < this.height ? this.get(n6, n8) : (char)32;
                ++n7;
            }
            ++n5;
        }
        return new CharacterPlate(cArray);
    }

    public CharacterPlate getClone() {
        char[][] cArray = CharacterPlate.getClone(this.chars);
        return new CharacterPlate(cArray);
    }

    public static CharacterPlate tabelize(String string) {
        int n;
        int n2;
        String[] stringArray = TextTools.toStringArray(string);
        int n3 = 1;
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = 1 + TextTools.count(stringArray[n4], '\t');
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        int[] nArray = new int[n3];
        int n6 = 0;
        while (n6 < stringArray.length) {
            n2 = 0;
            n = 0;
            int n7 = stringArray[n6].indexOf(9);
            while (n7 != -1) {
                if (nArray[n2] < n7 - n) {
                    nArray[n2] = n7 - n;
                }
                ++n2;
                n = n7;
                n7 = stringArray[n6].indexOf(9, n7 + 1);
            }
            if (nArray[n2] < stringArray[n6].length() - n) {
                nArray[n2] = stringArray[n6].length() - n;
            }
            ++n6;
        }
        n2 = 0;
        n = 0;
        while (n < n3) {
            n2 += nArray[n] + 1;
            ++n;
        }
        CharacterPlate characterPlate = new CharacterPlate(--n2, stringArray.length);
        int n8 = 0;
        while (n8 < stringArray.length) {
            String string2;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = stringArray[n8].indexOf(9);
            while (n12 != -1) {
                string2 = stringArray[n8].substring(n11, n12);
                characterPlate.paste(string2, n10, n8);
                n10 += nArray[n9] + 1;
                ++n9;
                n11 = n12 + 1;
                n12 = stringArray[n8].indexOf(9, n11);
            }
            string2 = stringArray[n8].substring(n11);
            characterPlate.paste(string2, n10, n8);
            ++n8;
        }
        return characterPlate;
    }

    public boolean isEmpty(char c) {
        return this.isEmpty(0, 0, this.width - 1, this.height - 1, c);
    }

    public boolean isEmpty() {
        return this.isEmpty(0, 0, this.width - 1, this.height - 1, ' ');
    }

    public boolean isEmpty(int n, int n2, int n3, int n4) {
        return this.isEmpty(n, n2, n3, n4, ' ');
    }

    public boolean isEmpty(int n, int n2, int n3, int n4, char c) {
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                if (this.chars[n6][n5] != c) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    public int getNonEmptyCharCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.width) {
            int n3 = 0;
            while (n3 < this.height) {
                if (this.chars[n3][n2] != ' ') {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public Insets getEmptyInsets() {
        return this.getEmptyInsets(' ');
    }

    public Insets getEmptyInsets(char c) {
        int n = 0;
        while (n < this.height && this.isEmpty(0, n, this.width - 1, n, c)) {
            ++n;
        }
        int n2 = 0;
        while (n2 < this.height && this.isEmpty(0, this.height - n2 - 1, this.width - 1, this.height - n2 - 1, c)) {
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.width && this.isEmpty(n3, 0, n3, this.height - 1, c)) {
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.width && this.isEmpty(this.width - n4 - 1, 0, this.width - n4 - 1, this.height - 1, c)) {
            ++n4;
        }
        return new Insets(n, n3, n2, n4);
    }

    public void setContent(char[][] cArray) {
        this.chars = cArray;
        this.height = this.chars.length;
        this.width = this.chars[0].length;
    }

    public void setSize(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return;
        }
        char[][] cArray = this.chars;
        this.chars = new char[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.chars[n3][n4] = n3 < this.height && n4 < this.width ? cArray[n3][n4] : 32;
                ++n4;
            }
            ++n3;
        }
        this.width = n;
        this.height = n2;
    }

    public void removeColumnsLeft(int n) {
        char[][] cArray = this.chars;
        this.chars = new char[this.height][this.width - n];
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width - n) {
                this.chars[n2][n3] = cArray[n2][n3 + n];
                ++n3;
            }
            ++n2;
        }
        this.width -= n;
    }

    public void removeColumnsRight(int n) {
        char[][] cArray = this.chars;
        this.chars = new char[this.height][this.width - n];
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width - n) {
                this.chars[n2][n3] = cArray[n2][n3];
                ++n3;
            }
            ++n2;
        }
        this.width -= n;
    }

    public void removeLinesBottom(int n) {
        char[][] cArray = this.chars;
        this.height -= n;
        this.chars = new char[this.height][this.width];
        int n2 = 0;
        while (n2 < this.height) {
            this.chars[n2] = cArray[n2];
            ++n2;
        }
    }

    public void removeLinesTop(int n) {
        char[][] cArray = this.chars;
        this.height -= n;
        this.chars = new char[this.height][this.width];
        int n2 = 0;
        while (n2 < this.height) {
            this.chars[n2] = cArray[n2 + n];
            ++n2;
        }
    }

    public void addLinesBottom(int n) {
        int n2;
        char[][] cArray = this.chars;
        this.chars = new char[this.height + n][this.width];
        int n3 = 0;
        while (n3 < this.height) {
            n2 = 0;
            while (n2 < this.width) {
                this.chars[n3][n2] = cArray[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < n) {
            int n4 = 0;
            while (n4 < this.width) {
                this.chars[n2 + this.height][n4] = 32;
                ++n4;
            }
            ++n2;
        }
        this.height += n;
    }

    public void addLinesTop(int n) {
        int n2;
        char[][] cArray = this.chars;
        this.chars = new char[this.height + n][this.width];
        int n3 = 0;
        while (n3 < this.height) {
            n2 = 0;
            while (n2 < this.width) {
                this.chars[n3 + n][n2] = cArray[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < n) {
            int n4 = 0;
            while (n4 < this.width) {
                this.chars[n2][n4] = 32;
                ++n4;
            }
            ++n2;
        }
        this.height += n;
    }

    public void addColumnsRight(int n) {
        int n2;
        char[][] cArray = this.chars;
        this.chars = new char[this.height][this.width + n];
        int n3 = 0;
        while (n3 < this.height) {
            n2 = 0;
            while (n2 < this.width) {
                this.chars[n3][n2] = cArray[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.height) {
            int n4 = 0;
            while (n4 < n) {
                this.chars[n2][n4 + this.width] = 32;
                ++n4;
            }
            ++n2;
        }
        this.width += n;
    }

    public void addColumnsLeft(int n) {
        int n2;
        char[][] cArray = this.chars;
        this.chars = new char[this.height][this.width + n];
        int n3 = 0;
        while (n3 < this.height) {
            n2 = 0;
            while (n2 < this.width) {
                this.chars[n3][n2 + n] = cArray[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.height) {
            int n4 = 0;
            while (n4 < n) {
                this.chars[n2][n4] = 32;
                ++n4;
            }
            ++n2;
        }
        this.width += n;
    }

    public void insertLine(int n) {
        char[][] cArray = this.chars;
        this.chars = new char[this.height + 1][this.width];
        int n2 = 0;
        while (n2 < n) {
            this.chars[n2] = cArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.width) {
            this.chars[n][n3] = 32;
            ++n3;
        }
        int n4 = n;
        while (n4 < this.height) {
            this.chars[n4 + 1] = cArray[n4];
            ++n4;
        }
        ++this.height;
    }

    public void insertLine(int n, String string) {
        char[][] cArray = this.chars;
        this.chars = new char[this.height + 1][this.width];
        int n2 = 0;
        while (n2 < n) {
            this.chars[n2] = cArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.width) {
            this.chars[n][n3] = n3 < string.length() ? string.charAt(n3) : (char)32;
            ++n3;
        }
        int n4 = n;
        while (n4 < this.height) {
            this.chars[n4 + 1] = cArray[n4];
            ++n4;
        }
        ++this.height;
    }

    public void removeLine(int n) {
        char[][] cArray = this.chars;
        this.chars = new char[this.height - 1][this.width];
        int n2 = 0;
        while (n2 < n) {
            this.chars[n2] = cArray[n2];
            ++n2;
        }
        int n3 = n + 1;
        while (n3 < this.height) {
            this.chars[n3 - 1] = cArray[n3];
            ++n3;
        }
        --this.height;
    }

    public String getLine(int n) {
        return this.getLine(n, 0);
    }

    public String getLine(int n, int n2) {
        if (n2 == 0) {
            return new String(this.chars[n]);
        }
        return new String(this.chars[n], n2, this.width - n2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharacterPlate)) {
            return false;
        }
        CharacterPlate characterPlate = (CharacterPlate)object;
        if (characterPlate.getWidth() != this.getWidth()) {
            return false;
        }
        if (characterPlate.getHeight() != this.getHeight()) {
            return false;
        }
        int n = 0;
        while (n < this.width) {
            int n2 = 0;
            while (n2 < this.height) {
                if (this.chars[n2][n] != characterPlate.chars[n2][n]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public void delete(int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 <= n3) {
            this.chars[n2][n5] = 32;
            ++n5;
        }
        int n6 = n2 + 1;
        while (n6 <= n4) {
            System.arraycopy(this.chars[n2], n, this.chars[n6], n, n3 - n + 1);
            ++n6;
        }
    }

    public void paste(String string, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        while (stringTokenizer.hasMoreElements()) {
            char[] cArray = stringTokenizer.nextToken().toCharArray();
            System.arraycopy(cArray, 0, this.chars[n2], n, cArray.length);
            ++n2;
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return TextTools.toString(this.chars);
    }

    public String[] toStringArray() {
        return TextTools.toStringArray(this.chars);
    }

    public void pasteInto(CharacterPlate characterPlate, int n, int n2) {
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if (this.chars[n3][n4] != ' ') {
                    characterPlate.set(n4 + n, n3 + n2, this.chars[n3][n4]);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void pasteIntoForce(CharacterPlate characterPlate, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n < 0) {
            n4 = -n;
        }
        if (n2 < 0) {
            n3 = -n2;
        }
        int n5 = this.height;
        int n6 = this.width;
        if (n + n6 > characterPlate.width) {
            n6 = characterPlate.width - n;
        }
        if (n2 + n5 > characterPlate.height) {
            n5 = characterPlate.height - n2;
        }
        int n7 = n3;
        while (n7 < n5) {
            System.arraycopy(this.chars[n7], n4, characterPlate.chars[n7 + n2], n + n4, n6 - n4);
            ++n7;
        }
    }

    public void paste(char[][] cArray, int n, int n2) {
        int n3 = cArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = cArray[0].length;
        if (n4 == 0) {
            return;
        }
        this.paste(cArray, n, n2, n4, n3);
    }

    public void paste(CharacterPlate characterPlate, int n, int n2, int n3, int n4) {
        this.paste(characterPlate.getContent(), n, n2, n3, n4);
    }

    public void paste(char[][] cArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                this.chars[n2 + n5][n + n6] = cArray[n5][n6];
                ++n6;
            }
            ++n5;
        }
    }

    public boolean isOverwrite() {
        return !this.mix;
    }

    public boolean isMix() {
        return this.mix;
    }

    public void setMix(boolean bl) {
        this.mix = bl;
    }

    public void setDefaultConfiguration() {
        mixRuleA = DEFAULT_MIX_RULE_A.toCharArray();
        mixRuleB = DEFAULT_MIX_RULE_B.toCharArray();
        mixRuleC = DEFAULT_MIX_RULE_C.toCharArray();
    }

    public void loadConfiguration(File file) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() != 3) continue;
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            char c3 = string.charAt(2);
            stringBuffer.append(c);
            stringBuffer2.append(c2);
            stringBuffer3.append(c3);
        }
        bufferedReader.close();
        int n = stringBuffer.length();
        mixRuleA = new char[n];
        mixRuleB = new char[n];
        mixRuleC = new char[n];
        stringBuffer.getChars(0, n, mixRuleA, 0);
        stringBuffer2.getChars(0, n, mixRuleB, 0);
        stringBuffer3.getChars(0, n, mixRuleC, 0);
    }

    public char get(int n, int n2) {
        return this.chars[n2][n];
    }

    public void setForce(int n, int n2, char c) {
        if (c == '\u0001') {
            char[] cArray = this.chars[n2];
            int n3 = n;
            cArray[n3] = (char)(cArray[n3] % 255);
            char[] cArray2 = this.chars[n2];
            int n4 = n;
            cArray2[n4] = (char)(cArray2[n4] + 255);
            return;
        }
        this.chars[n2][n] = c;
    }

    public void fill(int n, int n2, int n3, int n4, char c) {
        int n5 = n2;
        while (n5 < n2 + n4) {
            int n6 = n;
            while (n6 < n + n3) {
                this.setForce(n6, n5, c);
                ++n6;
            }
            ++n5;
        }
    }

    public void set(int n, int n2, char c) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        if (c == '\u0001') {
            char[] cArray = this.chars[n2];
            int n3 = n;
            cArray[n3] = (char)(cArray[n3] % 255);
            char[] cArray2 = this.chars[n2];
            int n4 = n;
            cArray2[n4] = (char)(cArray2[n4] + 255);
            return;
        }
        if (this.chars[n2][n] == c) {
            return;
        }
        if (this.mix && c == ' ') {
            return;
        }
        if (!this.mix || c == ' ') {
            this.chars[n2][n] = c;
            return;
        }
        int n5 = 0;
        while (n5 < mixRuleA.length) {
            if (mixRuleA[n5] == this.chars[n2][n] && mixRuleB[n5] == c || mixRuleB[n5] == this.chars[n2][n] && mixRuleA[n5] == c) {
                this.chars[n2][n] = mixRuleC[n5];
                return;
            }
            ++n5;
        }
        this.chars[n2][n] = c;
    }

    public char getPasteResult(char c, int n, int n2) {
        if (!this.mix || c == ' ') {
            return c;
        }
        int n3 = 0;
        while (n3 < mixRuleA.length) {
            if (mixRuleA[n3] == this.chars[n2][n] && mixRuleB[n3] == c || mixRuleB[n3] == this.chars[n2][n] && mixRuleA[n3] == c) {
                return mixRuleC[n3];
            }
            ++n3;
        }
        return c;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void clear() {
        if (this.height == 0) {
            return;
        }
        int n = 0;
        while (n < this.width) {
            this.chars[0][n] = 32;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.height) {
            System.arraycopy(this.chars[0], 0, this.chars[n2], 0, this.width);
            ++n2;
        }
    }

    public void replace(char c, char c2) {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.chars[n][n2] == c) {
                    this.chars[n][n2] = c2;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void panLeft() {
        int n = 0;
        while (n < this.height) {
            char c = this.chars[n][0];
            System.arraycopy(this.chars[n], 1, this.chars[n], 0, this.width - 1);
            this.chars[n][this.width - 1] = c;
            ++n;
        }
    }

    protected void panRight() {
        int n = 0;
        while (n < this.height) {
            char c = this.chars[n][this.width - 1];
            System.arraycopy(this.chars[n], 0, this.chars[n], 1, this.width - 1);
            this.chars[n][0] = c;
            ++n;
        }
    }

    protected void panUp() {
        char[] cArray = new char[this.width];
        System.arraycopy(this.chars[0], 0, cArray, 0, this.width);
        int n = 1;
        while (n < this.height) {
            System.arraycopy(this.chars[n], 0, this.chars[n - 1], 0, this.width);
            ++n;
        }
        System.arraycopy(cArray, 0, this.chars[this.height - 1], 0, this.width);
    }

    protected void panDown() {
        char[] cArray = new char[this.width];
        System.arraycopy(this.chars[this.height - 1], 0, cArray, 0, this.width);
        int n = this.height - 1;
        while (n > 0) {
            System.arraycopy(this.chars[n - 1], 0, this.chars[n], 0, this.width);
            --n;
        }
        System.arraycopy(cArray, 0, this.chars[0], 0, this.width);
    }

    static {
        initialized = false;
    }
}

