/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gui.GChoice;
import de.jave.gui.GChoiceTextField;
import de.jave.gui.VFlowLayout;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class Image2AsciiAlgorithm4
extends Image2AsciiAlgorithm
implements ItemListener,
TextListener {
    protected Checkbox cbOptimize;
    protected GChoiceTextField tfNotUse;
    protected GChoice chTable;
    protected GChoice chQuality;
    protected Panel panel;
    protected static final String[] NOT_USE = new String[]{"<>_()[]{}/~-", "<>_()[]{}/~-[]\\@|#", ""};

    public Component getAdjustmentComponent() {
        if (this.panel == null) {
            this.cbOptimize = new Checkbox("Optimize line distance", true);
            this.cbOptimize.addItemListener(this);
            this.tfNotUse = new GChoiceTextField("Do not use:", NOT_USE[0], 18);
            int n = 0;
            while (n < NOT_USE.length) {
                this.tfNotUse.add(NOT_USE[n]);
                ++n;
            }
            this.tfNotUse.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            this.tfNotUse.addTextListener(this);
            if (!AsciiGreyscaleTable.isInitialized()) {
                AsciiGreyscaleTable.init();
            }
            this.chTable = AsciiGreyscaleTable.createComponent();
            this.panel = new Panel();
            this.panel.setLayout(new VFlowLayout());
            this.panel.add(this.chTable);
            this.panel.add(this.tfNotUse);
            this.panel.add(this.cbOptimize);
            this.chTable.addItemListener(this);
        }
        return this.panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.adjustmentChanged();
    }

    public String getAlgorithmName() {
        return "4 Pixels per Character";
    }

    public int getVerticalPixelsPerChar() {
        if (this.isOptimized()) {
            return 8;
        }
        return 2;
    }

    public int getHorizontalPixelsPerChar() {
        return 2;
    }

    public boolean requiresBWImage() {
        return false;
    }

    protected boolean isOptimized() {
        if (this.cbOptimize == null) {
            return true;
        }
        return this.cbOptimize.getState();
    }

    protected String getNotUse() {
        if (this.tfNotUse == null) {
            if (this.specialCharacters != null) {
                return this.specialCharacters;
            }
            return "";
        }
        return this.tfNotUse.getText();
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        AsciiGreyscaleTable asciiGreyscaleTable = AsciiGreyscaleTable.getDefaultTable();
        asciiGreyscaleTable = this.chTable != null ? AsciiGreyscaleTable.getTable(this.chTable.getSelectedItem()) : AsciiGreyscaleTable.getDefaultTable();
        int n = valueRaster.getWidth();
        int n2 = valueRaster.getHeight();
        CharacterPlate characterPlate = null;
        String string = this.getNotUse();
        asciiGreyscaleTable.setDoNotUse4(string);
        if (this.isOptimized()) {
            characterPlate = new CharacterPlate(n /= 2, n2 /= 8);
            int n3 = 0;
            while (n3 < n2) {
                Thread.yield();
                if (this.shallStop) {
                    return null;
                }
                int n4 = n3 * 8;
                int n5 = 0;
                while (n5 < n) {
                    int n6 = n5 * 2;
                    int n7 = (0 * valueRaster.getValueAt(n6, n4) + 1 * valueRaster.getValueAt(n6, n4 + 1) + 1 * valueRaster.getValueAt(n6, n4 + 2) + 1 * valueRaster.getValueAt(n6, n4 + 3)) / 3;
                    int n8 = (1 * valueRaster.getValueAt(n6, n4 + 4) + 1 * valueRaster.getValueAt(n6, n4 + 5) + 1 * valueRaster.getValueAt(n6, n4 + 6) + 0 * valueRaster.getValueAt(n6, n4 + 7)) / 3;
                    int n9 = (0 * valueRaster.getValueAt(n6 + 1, n4) + 1 * valueRaster.getValueAt(n6 + 1, n4 + 1) + 1 * valueRaster.getValueAt(n6 + 1, n4 + 2) + 1 * valueRaster.getValueAt(n6 + 1, n4 + 3)) / 3;
                    int n10 = (1 * valueRaster.getValueAt(n6 + 1, n4 + 4) + 1 * valueRaster.getValueAt(n6 + 1, n4 + 5) + 1 * valueRaster.getValueAt(n6 + 1, n4 + 6) + 0 * valueRaster.getValueAt(n6 + 1, n4 + 7)) / 3;
                    characterPlate.setForce(n5, n3, asciiGreyscaleTable.getCharForBrightness(n7, n9, n8, n10));
                    ++n5;
                }
                this.progress(0.3 + 0.7 * (double)n3 / (double)n2);
                ++n3;
            }
        } else {
            characterPlate = new CharacterPlate(n /= 2, n2 /= 2);
            int n11 = 0;
            while (n11 < n2) {
                Thread.yield();
                if (this.shallStop) {
                    System.err.println("Thread unterbrochen vor Zeile " + n11);
                    return null;
                }
                int n12 = 0;
                while (n12 < n) {
                    characterPlate.setForce(n12, n11, asciiGreyscaleTable.getCharForBrightness(valueRaster.getValueAt(n12 * 2, n11 * 2), valueRaster.getValueAt(n12 * 2 + 1, n11 * 2), valueRaster.getValueAt(n12 * 2, n11 * 2 + 1), valueRaster.getValueAt(n12 * 2 + 1, n11 * 2 + 1)));
                    ++n12;
                }
                this.progress(0.3 + 0.7 * (double)n11 / (double)n2);
                ++n11;
            }
        }
        return characterPlate;
    }
}

