/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.TextEditWindowResultListener;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TextEditWindow
extends Window
implements FocusListener,
ActionListener,
KeyListener {
    protected TextField textField;
    protected String originalText;
    protected TextEditWindowResultListener listener;
    protected Object userObject;
    protected static final int MIN_WIDTH = 50;

    public TextEditWindow(TextEditWindowResultListener textEditWindowResultListener, Frame frame, Object object, String string, Rectangle rectangle) {
        this(textEditWindowResultListener, frame, object, string, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public TextEditWindow(TextEditWindowResultListener textEditWindowResultListener, Frame frame, Object object, String string, int n, int n2, int n3, int n4) {
        super(frame);
        this.listener = textEditWindowResultListener;
        this.userObject = object;
        this.originalText = string;
        this.setLayout(new GridLayout(0, 1));
        this.textField = new TextField(string);
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
        this.pack();
        if (n3 < 50) {
            n3 = 50;
        }
        this.setBounds(n, n2, n3, n4);
        this.show();
        this.textField.selectAll();
        this.textField.requestFocus();
    }

    public void done() {
        if (this.originalText.equals(this.textField.getText())) {
            this.cancel();
        } else {
            this.dispose();
            this.listener.textEditWindowFinished(this.userObject, this.textField.getText());
        }
    }

    public void cancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.done();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.done();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.cancel();
        }
    }
}

