/*
 * Decompiled with CFR 0.152.
 */
package de.jave.calculus;

import de.jave.calculus.Calculus;
import de.jave.calculus.CalculusVisitor;
import de.jave.calculus.ParseException;
import de.jave.calculus.SimpleNode;

public class ASTFunctionNode
extends SimpleNode {
    protected int type;
    protected static final String[] NAMES = new String[]{"sin", "cos", "tan", "log", "min", "max", "abs", "floor", "ceil", "sqr", "sqrt", "sgn"};
    protected static final int[] ARGUMENTLENGTHS = new int[]{1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1};
    protected static final int SIN = 0;
    protected static final int COS = 1;
    protected static final int TAN = 2;
    protected static final int LOG = 3;
    protected static final int MIN = 4;
    protected static final int MAX = 5;
    protected static final int ABS = 6;
    protected static final int FLOOR = 7;
    protected static final int CEIL = 8;
    protected static final int SQR = 9;
    protected static final int SQRT = 10;
    protected static final int SGN = 11;

    public ASTFunctionNode(int n) {
        super(n);
    }

    public ASTFunctionNode(Calculus calculus, int n) {
        super(calculus, n);
    }

    public Object jjtAccept(CalculusVisitor calculusVisitor, Object object) {
        return calculusVisitor.visit(this, object);
    }

    public void setFunctionName(String string) throws ParseException {
        int n = 0;
        while (n < NAMES.length) {
            if (string.equalsIgnoreCase(NAMES[n])) {
                this.type = n;
                return;
            }
            ++n;
        }
        throw new ParseException("No such function: '" + string + "'");
    }

    public int getCorrectArgumentCount() {
        return ARGUMENTLENGTHS[this.type];
    }

    public double evaluate(double d) throws Exception {
        switch (this.type) {
            case 0: {
                return Math.sin(this.jjtGetChild(0).evaluate(d));
            }
            case 1: {
                return Math.cos(this.jjtGetChild(0).evaluate(d));
            }
            case 2: {
                return Math.tan(this.jjtGetChild(0).evaluate(d));
            }
            case 3: {
                return Math.log(this.jjtGetChild(0).evaluate(d));
            }
            case 4: {
                return Math.min(this.jjtGetChild(0).evaluate(d), this.jjtGetChild(1).evaluate(d));
            }
            case 5: {
                return Math.max(this.jjtGetChild(0).evaluate(d), this.jjtGetChild(1).evaluate(d));
            }
            case 6: {
                return Math.abs(this.jjtGetChild(0).evaluate(d));
            }
            case 7: {
                return Math.floor(this.jjtGetChild(0).evaluate(d));
            }
            case 8: {
                return Math.ceil(this.jjtGetChild(0).evaluate(d));
            }
            case 9: {
                return Math.sqrt(this.jjtGetChild(0).evaluate(d));
            }
            case 10: {
                return Math.sqrt(this.jjtGetChild(0).evaluate(d));
            }
            case 11: {
                return this.jjtGetChild(0).evaluate(d) >= 0.0 ? 1.0 : -1.0;
            }
        }
        throw new Exception("Illegal function type!");
    }
}

