/*
 * Decompiled with CFR 0.152.
 */
package gebhard.uielements;

import de.jave.util.UpDownAble;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import java.awt.Font;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public abstract class NumberTextField
extends TextField
implements KeyListener,
TextListener,
UpDownAble {
    private Vector numberListeners;
    private boolean originalFont = true;

    NumberTextField(String string) {
        super(string);
        this.addKeyListener(this);
        this.addTextListener(this);
        this.numberListeners = new Vector(2, 2);
        this.enableEvents(1005L);
    }

    public void setFont(Font font) {
        this.originalFont = false;
        super.setFont(font);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.ensureRange();
        super.processFocusEvent(focusEvent);
    }

    public void addNumberListener(NumberListener numberListener) {
        this.numberListeners.addElement(numberListener);
    }

    public void removeNumberListener(NumberListener numberListener) {
        if (!this.numberListeners.removeElement(numberListener)) {
            throw new RuntimeException("Attempt to remove Numberlistener " + numberListener + "that is not attached to this NumberTextField!");
        }
    }

    private void processNumberEvent(NumberEvent numberEvent) {
        int n = 0;
        while (n < this.numberListeners.size()) {
            ((NumberListener)this.numberListeners.elementAt(n)).numberChanged(numberEvent);
            if (numberEvent.isConsumed()) {
                return;
            }
            ++n;
        }
    }

    protected abstract void ensureRange();

    protected abstract void incValue();

    public void up() {
        this.incValue();
    }

    public void down() {
        this.decValue();
    }

    protected abstract void decValue();

    protected abstract char mapInputChar(char var1);

    protected abstract boolean isValidInput(char var1);

    protected abstract boolean isTextValid();

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.decValue();
            keyEvent.consume();
            return;
        }
        if (keyEvent.getKeyCode() == 38) {
            this.incValue();
            keyEvent.consume();
            return;
        }
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 10) {
            this.ensureRange();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (n != 127 && n != 8 && c != '\b' && !this.isValidInput(c)) {
            keyEvent.consume();
        }
        keyEvent.setKeyChar(this.mapInputChar(c));
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.isTextValid()) {
            return;
        }
        this.processNumberEvent(new NumberEvent(this));
    }
}

