/*
 * Decompiled with CFR 0.152.
 */
package de.jave.text;

import java.awt.Dimension;

public class TextTools {
    private TextTools() {
    }

    public static final int count(String string, char c) {
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            ++n;
            n2 = string.indexOf(c, n2 + 1);
        }
        return n;
    }

    public static final String fillFront(String string, char c, int n) {
        while (string.length() < n) {
            string = c + string;
        }
        return string;
    }

    public static final String firstLetterUp(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        int n = 0;
        while (n < cArray.length - 1) {
            if (cArray[n] == ' ') {
                cArray[n + 1] = Character.toUpperCase(cArray[n + 1]);
            }
            ++n;
        }
        return new String(cArray);
    }

    public static final String[] toStringArray(char[][] cArray) {
        int n = cArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = TextTools.trimRight(new String(cArray[n2]));
            ++n2;
        }
        return stringArray;
    }

    public static String trimRight(String string) {
        int n = string.length() - 1;
        while (n >= 0 && string.charAt(n) <= ' ') {
            --n;
        }
        return string.substring(0, n + 1);
    }

    public static final String toString(char[][] cArray) {
        int n = cArray.length;
        int n2 = cArray[0].length;
        StringBuffer stringBuffer = new StringBuffer(n * n2 + n);
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(TextTools.trimRight(new String(cArray[n3])));
            if (n3 < n - 1) {
                stringBuffer.append('\n');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final Dimension getDimensionOf(String string) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            if (string.charAt(n4) == '\n') {
                if (n3 > n2) {
                    n2 = n3;
                }
                n3 = 0;
                ++n;
            } else {
                ++n3;
            }
            ++n4;
        }
        if (n3 > n2) {
            n2 = n3;
        }
        return new Dimension(n2, n);
    }

    public static final char[][] toCharField(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (stringArray[n3].length() > n2) {
                n2 = stringArray[n3].length();
            }
            ++n3;
        }
        char[][] cArray = new char[n][n2];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < stringArray[n4].length()) {
                cArray[n4][n5] = stringArray[n4].charAt(n5);
                ++n5;
            }
            int n6 = stringArray[n4].length();
            while (n6 < n2) {
                cArray[n4][n6] = 32;
                ++n6;
            }
            ++n4;
        }
        return cArray;
    }

    public static final char[][] toCharField(String string) {
        int n;
        Dimension dimension = TextTools.getDimensionOf(string);
        if (dimension.width == 0 && dimension.height > 0) {
            dimension.width = 1;
        } else if (dimension.height == 0 && dimension.width > 0) {
            dimension.height = 1;
        }
        char[][] cArray = new char[dimension.height][dimension.width];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            if (string.charAt(n4) == '\n') {
                n = n3;
                while (n < dimension.width) {
                    cArray[n2][n] = 32;
                    ++n;
                }
                n3 = 0;
                ++n2;
            } else {
                cArray[n2][n3] = string.charAt(n4);
                ++n3;
            }
            ++n4;
        }
        n = n3;
        while (n < dimension.width) {
            cArray[n2][n] = 32;
            ++n;
        }
        return cArray;
    }

    /*
     * Unable to fully structure code
     */
    public static final String[] toStringArray(String var0) {
        var1_1 = TextTools.getDimensionOf(var0);
        if (var1_1.height <= 1) {
            return new String[]{var0};
        }
        var2_2 = new String[var1_1.height];
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = var0.length();
        ** GOTO lbl16
        {
            ++var5_5;
            do {
                if (var5_5 < var6_6 && var0.charAt(var5_5) != '\n') continue block0;
                var2_2[var3_3++] = var0.substring(var4_4, var5_5);
                var4_4 = var5_5 + 1;
                ++var5_5;
lbl16:
                // 2 sources

            } while (var3_3 < var1_1.height);
        }
        return var2_2;
    }

    public static String center(String string, int n) {
        int n2 = n - string.length();
        int n3 = n2 / 2;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(' ');
            ++n4;
        }
        stringBuffer.append(string);
        int n5 = n3;
        while (n5 < n2) {
            stringBuffer.append(' ');
            ++n5;
        }
        return stringBuffer.toString();
    }

    public static void print(int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                System.out.print(nArray[n][n2] + "\t");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public static void print(double[][] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                System.out.print(dArray[n][n2] + "\t");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public static int editDistance(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int[][] nArray = new int[n + 1][n2 + 1];
        int n3 = 0;
        while (n3 <= n2) {
            nArray[0][n3] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n) {
            nArray[n4][0] = n4;
            ++n4;
        }
        int n5 = 1;
        while (n5 <= n) {
            int n6 = 1;
            while (n6 <= n2) {
                int n7 = nArray[n5 - 1][n6] + 1;
                int n8 = nArray[n5][n6 - 1] + 1;
                int n9 = nArray[n5 - 1][n6 - 1];
                if (string.charAt(n5 - 1) != string2.charAt(n6 - 1)) {
                    ++n9;
                }
                n9 = n9 <= n8 ? n9 : n8;
                nArray[n5][n6] = n9 <= n7 ? n9 : n7;
                ++n6;
            }
            ++n5;
        }
        return nArray[n][n2];
    }

    public static int editDistance(String string, String string2, int n) {
        int n2;
        int n3 = string.length();
        if (n3 - (n2 = string2.length()) > n || n2 - n3 > n) {
            return n;
        }
        int[][] nArray = new int[n3 + 1][n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            nArray[0][n4] = n4;
            ++n4;
        }
        int n5 = 0;
        while (n5 <= n3) {
            nArray[n5][0] = n5;
            ++n5;
        }
        int n6 = 1;
        while (n6 <= n3) {
            int n7 = 1;
            while (n7 <= n2) {
                int n8 = nArray[n6 - 1][n7] + 1;
                int n9 = nArray[n6][n7 - 1] + 1;
                int n10 = nArray[n6 - 1][n7 - 1];
                if (string.charAt(n6 - 1) != string2.charAt(n7 - 1)) {
                    ++n10;
                }
                n10 = n10 <= n9 ? n10 : n9;
                nArray[n6][n7] = n10 <= n8 ? n10 : n8;
                ++n7;
            }
            ++n6;
        }
        return nArray[n3][n2];
    }

    public static int editDistanceGebhard(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int[][] nArray = new int[n + 1][n2 + 1];
        int n3 = 0;
        while (n3 <= n2) {
            nArray[0][n3] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n) {
            nArray[n4][0] = n4;
            ++n4;
        }
        int n5 = 1;
        while (n5 <= n) {
            int n6 = 1;
            while (n6 <= n2) {
                int n7 = nArray[n5 - 1][n6] + 1;
                int n8 = nArray[n5][n6 - 1] + 1;
                int n9 = nArray[n5 - 1][n6 - 1];
                if (string.charAt(n5 - 1) != string2.charAt(n6 - 1)) {
                    n9 = Character.toLowerCase(string.charAt(n5 - 1)) == Character.toLowerCase(string2.charAt(n6 - 1)) ? ++n9 : (n9 += 2);
                }
                n9 = n9 <= n8 ? n9 : n8;
                nArray[n5][n6] = n9 <= n7 ? n9 : n7;
                ++n6;
            }
            ++n5;
        }
        return nArray[n][n2];
    }

    public static double levenshteinDistance(String string, String string2, double d, double d2, double d3, double d4) {
        int n = string.length();
        int n2 = string2.length();
        double[][] dArray = new double[n + 1][n2 + 1];
        int n3 = 0;
        while (n3 <= n2) {
            dArray[0][n3] = (double)n3 * d;
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n) {
            dArray[n4][0] = (double)n4 * d2;
            ++n4;
        }
        int n5 = 1;
        while (n5 <= n) {
            int n6 = 1;
            while (n6 <= n2) {
                char c;
                double d5 = dArray[n5 - 1][n6] + d2;
                double d6 = dArray[n5][n6 - 1] + d;
                double d7 = dArray[n5 - 1][n6 - 1];
                char c2 = string.charAt(n5 - 1);
                if (c2 != (c = string2.charAt(n6 - 1))) {
                    d7 = Character.toUpperCase(c2) == Character.toUpperCase(c) ? (d7 += d3) : (d7 += d4);
                }
                d7 = d7 <= d6 ? d7 : d6;
                dArray[n5][n6] = d7 <= d5 ? d7 : d5;
                ++n6;
            }
            ++n5;
        }
        TextTools.print(dArray);
        return dArray[n][n2];
    }

    public static void main(String[] stringArray) {
        String string = "\n\n2\n";
        String[] stringArray2 = TextTools.toStringArray(string);
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(n + "\t:" + stringArray2[n]);
            ++n;
        }
    }
}

