/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GButton;
import de.jave.gui.GButtonGroup;
import de.jave.gui.GCheckbox;
import de.jave.gui.GHLine;
import de.jave.gui.Gap;
import de.jave.gui.VFlowLayout;
import de.jave.jave.ArcToolGeneric;
import de.jave.jave.AuxiliaryLinesTool;
import de.jave.jave.BezierToolGeneric;
import de.jave.jave.BrushTool;
import de.jave.jave.CloneTool;
import de.jave.jave.EllipseToolAlgorithmic;
import de.jave.jave.EllipseToolGeneric;
import de.jave.jave.EraserTool;
import de.jave.jave.FIGletTool;
import de.jave.jave.FillTool;
import de.jave.jave.FreehandSelectionTool;
import de.jave.jave.FreehandToolAlgorithmic;
import de.jave.jave.FreehandToolGeneric;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.LineToolAlgorithmic;
import de.jave.jave.LineToolGeneric;
import de.jave.jave.PanTool;
import de.jave.jave.Plate;
import de.jave.jave.RectangleToolAlgorithmic;
import de.jave.jave.RectangleToolGeneric;
import de.jave.jave.SelectionTool;
import de.jave.jave.TextTool;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkPainter;
import de.jave.jave.WatermarkTool;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ToolBar
extends Panel
implements ItemListener {
    public static final int BRUSH_TOOL_INDEX = 14;
    public static final int DEFAULT_TOOL_INDEX = 0;
    public static final int SELECTION_TOOL_INDEX = 12;
    public static final int TEXT_TOOL_INDEX = 10;
    public static final int AUXILIARY_LINES_TOOL_INDEX = 20;
    public static final int WATERMARK_TOOL_INDEX = 19;
    public static final int TOOL_COUNT = 21;
    protected Jave jave;
    protected GButtonGroup buttonGroup;
    protected GCheckbox cbPure;
    protected GCheckbox cbGrid;
    protected GCheckbox cbPixel;
    protected GCheckbox cbWatermark;
    protected GCheckbox cbAuxLines;
    protected Tool[] tools;

    public ToolBar(Jave jave) {
        this.jave = jave;
        this.createTools();
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2, 0, 0));
        int n = 0;
        while (n < 10) {
            if (n == 9) {
                panel.add(new Gap());
            }
            panel.add(this.buttonGroup.getButton(n));
            ++n;
        }
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 2, 0, 0));
        int n2 = 10;
        while (n2 < 14) {
            panel2.add(this.buttonGroup.getButton(n2));
            ++n2;
        }
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 2, 0, 0));
        int n3 = 14;
        while (n3 < 19) {
            panel3.add(this.buttonGroup.getButton(n3));
            ++n3;
        }
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(0, 2, 0, 0));
        this.cbWatermark = new GCheckbox(false);
        this.cbWatermark.setLayout(new GridLayout(0, 1, 0, 0));
        this.cbWatermark.addItemListener(this);
        panel4.add(this.cbWatermark);
        panel4.add(this.buttonGroup.getButton(19));
        this.cbAuxLines = new GCheckbox(false);
        this.cbAuxLines.setLayout(new GridLayout(0, 1, 0, 0));
        this.cbAuxLines.addItemListener(this);
        panel4.add(this.cbAuxLines);
        panel4.add(this.buttonGroup.getButton(20));
        this.cbGrid = new GCheckbox(true);
        this.cbGrid.add(JaveImages.getImageCanvas("grid_toggle"));
        this.cbGrid.addItemListener(this);
        this.cbPure = new GCheckbox(true);
        this.cbPure.add(JaveImages.getImageCanvas("pure_toggle"));
        this.cbPure.addItemListener(this);
        this.cbPixel = new GCheckbox(false);
        this.cbPixel.add(JaveImages.getImageCanvas("pixel_toggle"));
        this.cbPixel.addItemListener(this);
        this.setLayout(new VFlowLayout(0, 0, 0));
        this.add(new GHLine(44, 14));
        this.add(panel);
        this.add(new GHLine(44, 14));
        this.add(panel2);
        this.add(new GHLine(44, 14));
        this.add(panel3);
        this.add(new GHLine(44, 14));
        this.add(panel4);
        this.add(new Gap(3, 3));
        this.add(new GHLine(44, 3));
        this.add(new GHLine(44, 3));
        this.add(this.cbGrid);
        this.add(this.cbPure);
        this.add(this.cbPixel);
        this.add(new GHLine(44, 6));
    }

    public void addTooltips() {
        JaveGlobalRessources.tooltips.add((Component)this.cbGrid, "Show / Hide Grid");
        JaveGlobalRessources.tooltips.add((Component)this.cbPixel, "Toggle ASCII/Pixel View");
        JaveGlobalRessources.tooltips.add((Component)this.cbPure, "Mark Characters not belonging to the current character set");
        JaveGlobalRessources.tooltips.add((Component)this.cbWatermark, "Show / Hide Watermark");
        JaveGlobalRessources.tooltips.add((Component)this.cbAuxLines, "Show / Hide Auxiliary Lines");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.buttonGroup) {
            this.jave.setTool(this.buttonGroup.getSelectedIndex());
        } else if (object == this.cbGrid) {
            this.jave.plate.setGrid(this.cbGrid.getState());
        } else if (object == this.cbWatermark) {
            ((WatermarkPainter)((Object)this.tools[19])).setEnabled(this.cbWatermark.getState());
            this.jave.plate.repaint();
        } else if (object == this.cbPixel) {
            this.jave.plate.setPixelView(this.cbPixel.getState());
        } else if (object == this.cbPure) {
            this.jave.plate.setMarkIllegalChars(this.cbPure.getState());
        }
        if (object == this.cbAuxLines) {
            ((WatermarkPainter)((Object)this.tools[20])).setEnabled(this.cbAuxLines.getState());
            this.jave.plate.repaint();
        }
        this.jave.plate.requestFocus();
    }

    public void setWatermarkVisible(boolean bl) {
        ((WatermarkPainter)((Object)this.tools[19])).setEnabled(bl);
        this.cbWatermark.setState(bl);
    }

    public void setAuxiliaryLinesVisible(boolean bl) {
        ((WatermarkPainter)((Object)this.tools[20])).setEnabled(bl);
        this.cbAuxLines.setState(bl);
    }

    public void toggleGridVisible() {
        this.cbGrid.toggle();
        this.jave.plate.setGrid(this.cbGrid.getState());
    }

    public boolean isGridVisible() {
        return this.cbGrid.getState();
    }

    public void setGridVisible(boolean bl) {
        this.cbGrid.setState(bl);
        this.jave.plate.setGrid(this.cbGrid.getState());
    }

    public boolean isPixelView() {
        return this.cbPixel.getState();
    }

    public void selectToolButton(int n) {
        this.buttonGroup.selectButton(n);
    }

    protected void createTools() {
        Plate plate = this.jave.plate;
        this.tools = new Tool[21];
        this.tools[0] = new FreehandToolGeneric(plate, this.jave);
        this.tools[2] = new LineToolGeneric(plate, this.jave);
        this.tools[4] = new RectangleToolGeneric(plate, this.jave);
        this.tools[6] = new EllipseToolGeneric(plate, this.jave);
        this.tools[8] = new BezierToolGeneric(plate, this.jave);
        this.tools[9] = new ArcToolGeneric(plate, this.jave);
        this.tools[1] = new FreehandToolAlgorithmic(plate, this.jave);
        this.tools[3] = new LineToolAlgorithmic(plate, this.jave);
        this.tools[5] = new RectangleToolAlgorithmic(plate, this.jave);
        this.tools[7] = new EllipseToolAlgorithmic(plate, this.jave);
        this.tools[10] = new TextTool(plate, this.jave);
        this.tools[11] = new FIGletTool(plate, this.jave);
        this.tools[12] = new SelectionTool(plate, this.jave);
        this.tools[13] = new FreehandSelectionTool(plate, this.jave);
        this.tools[14] = new BrushTool(plate, this.jave);
        this.tools[15] = new EraserTool(plate, this.jave);
        this.tools[16] = new FillTool(plate, this.jave);
        this.tools[17] = new CloneTool(plate, this.jave);
        this.tools[18] = new PanTool(plate, this.jave);
        this.tools[19] = new WatermarkTool(plate, this.jave);
        this.tools[20] = new AuxiliaryLinesTool(plate, this.jave);
        plate.setTools(this.tools);
        plate.setCurrentTool(this.tools[0]);
        this.buttonGroup = new GButtonGroup();
        int n = 0;
        while (n < 21) {
            GButton gButton = JaveImages.createButton(this.tools[n].getIconName());
            gButton.set3DMode(1);
            this.buttonGroup.add(gButton);
            JaveGlobalRessources.tooltips.add((Component)gButton, this.tools[n].getName());
            ++n;
        }
        this.buttonGroup.addItemListener(this);
    }
}

