/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.BooleanPlate;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveClipboardSelection;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveSelection;
import de.jave.jave.Plate;
import de.jave.jave.TextboxDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class Selection {
    protected Rectangle region;
    protected CharacterPlate content;
    protected BooleanPlate mask;
    protected CharacterPlate originalContent;
    protected int originalContentX;
    protected int originalContentY;
    protected Plate plate;
    protected int textboxStyle;
    protected int blinkOffset;
    protected int layer = 1;
    protected boolean d3View = true;
    public static final int LAYER_BACKGROUND = 0;
    public static final int LAYER_NORMAL = 1;
    public static final int LAYER_FOREGROUND = 2;
    public static final int LAYER_DIFFERENCE = 3;
    public static final int LAYER_DEFAULT = 1;
    public static final String[] STR_LAYER = new String[]{"Background", "Normal", "Foreground", "Difference"};
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int NORTH = 2;
    public static final int WEST = 3;
    public static final int SOUTH = 4;
    public static final int EAST = 5;
    public static final int NORTHEAST = 6;
    public static final int NORTHWEST = 7;
    public static final int SOUTHEAST = 8;
    public static final int SOUTHWEST = 9;

    public void setPlate(Plate plate) {
        this.plate = plate;
    }

    public boolean isTextbox() {
        if (this.textboxStyle == -1) {
            this.textboxStyle = TextboxDialog.getTextboxStyle(this.content.getContent());
        }
        return this.textboxStyle != -1;
    }

    public int getTextboxStyle() {
        if (this.textboxStyle == -1) {
            this.textboxStyle = TextboxDialog.getTextboxStyle(this.content.getContent());
        }
        return this.textboxStyle;
    }

    public boolean hasSelection() {
        return this.region != null && this.content != null;
    }

    public Point getLocation() {
        return this.region.getLocation();
    }

    public boolean contains(Point point) {
        if (this.region == null || point == null) {
            return false;
        }
        if (this.mask == null) {
            return this.region.contains(point);
        }
        return this.region.contains(point) && this.mask.isSet(point.x - this.region.x, point.y - this.region.y);
    }

    public int getPlace(Point point) {
        Point point2 = this.plate.getScreenPointFor(this.region.x, this.region.y);
        Point point3 = this.plate.getScreenPointFor(this.region.x + this.region.width, this.region.y + this.region.height);
        if (point2.x > point.x || point2.y > point.y || point3.x < point.x || point3.y < point.y) {
            return 0;
        }
        if (!this.isTextbox()) {
            return 1;
        }
        int n = point2.x;
        int n2 = point2.y;
        int n3 = point3.x + 2;
        int n4 = point3.y + 2;
        if (Selection.contains((n + n3 - 7) / 2, n2, 7, 7, point.x, point.y)) {
            return 2;
        }
        if (Selection.contains((n + n3 - 7) / 2, n4 - 7, 7, 7, point.x, point.y)) {
            return 4;
        }
        if (Selection.contains(n, (n2 + n4 - 7) / 2, 7, 7, point.x, point.y)) {
            return 3;
        }
        if (Selection.contains(n3 - 7, (n2 + n4 - 7) / 2, 7, 7, point.x, point.y)) {
            return 5;
        }
        if (Selection.contains(n, n4 - 7, 7, 7, point.x, point.y)) {
            return 9;
        }
        if (Selection.contains(n3 - 7, n4 - 7, 7, 7, point.x, point.y)) {
            return 8;
        }
        if (Selection.contains(n, n2, 7, 7, point.x, point.y)) {
            return 7;
        }
        if (Selection.contains(n3 - 7, n2, 7, 7, point.x, point.y)) {
            return 6;
        }
        return 1;
    }

    protected static final boolean contains(int n, int n2, int n3, int n4, int n5, int n6) {
        return n <= n5 && n2 <= n6 && n + n3 >= n5 && n2 + n4 >= n6;
    }

    public void delete() {
        this.region = null;
        this.content = null;
        this.mask = null;
    }

    public CharacterPlate getContent() {
        return this.content;
    }

    public CharacterPlate getContentClone() {
        return this.content.getClone();
    }

    public BooleanPlate getMask() {
        return this.mask;
    }

    public JaveSelection getJaveSelection() {
        return new JaveSelection(this.content, this.mask);
    }

    public Rectangle getRegion() {
        return this.region;
    }

    public int getWidth() {
        return this.region.width;
    }

    public int getHeight() {
        return this.region.height;
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        if (this.region == null) {
            return;
        }
        this.region.x = n;
        this.region.y = n2;
    }

    public void set(Rectangle rectangle, char[][] cArray) {
        this.set(rectangle, new CharacterPlate(cArray));
    }

    public void resizeByCursorN_UP() {
        this.content.addLinesTop(1);
        --this.region.y;
        ++this.region.height;
        CharacterPlate characterPlate = this.plate.cut(new Rectangle(this.region.x, this.region.y, this.region.width, 1));
        this.content.paste(characterPlate, 0, 0, this.region.width, 1);
        if (this.mask != null) {
            this.mask.addLinesTop(1, true);
        }
    }

    public void resizeByCursorS_DOWN() {
        this.content.addLinesBottom(1);
        ++this.region.height;
        CharacterPlate characterPlate = this.plate.cut(new Rectangle(this.region.x, this.region.y + this.region.height - 1, this.region.width, 1));
        this.content.paste(characterPlate, 0, this.region.height - 1, this.region.width, 1);
        if (this.mask != null) {
            this.mask.addLinesBottom(1, true);
        }
    }

    public void resizeByCursorS_UP() {
        char[][] cArray = this.content.getCopy(0, this.region.height - 1, this.region.width, 1).getContent();
        try {
            this.plate.getContent().paste(cArray, this.region.x, this.region.y + this.region.height - 1, this.region.width, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content.setSize(this.content.getWidth(), this.content.getHeight() - 1);
        --this.region.height;
        if (this.mask != null) {
            this.mask.removeLinesBottom(1);
        }
    }

    public void resizeByCursorN_DOWN() {
        char[][] cArray = this.content.getCopy(0, 0, this.region.width, 1).getContent();
        try {
            this.plate.getContent().paste(cArray, this.region.x, this.region.y, this.region.width, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content.removeLinesTop(1);
        --this.region.height;
        ++this.region.y;
        if (this.mask != null) {
            this.mask.removeLinesTop(1);
        }
    }

    public void resizeByCursorW_LEFT() {
        this.content.addColumnsLeft(1);
        --this.region.x;
        ++this.region.width;
        CharacterPlate characterPlate = this.plate.cut(new Rectangle(this.region.x, this.region.y, 1, this.region.height));
        this.content.paste(characterPlate, 0, 0, 1, this.region.height);
        if (this.mask != null) {
            this.mask.addColumnsLeft(1, true);
        }
    }

    public void resizeByCursorE_RIGHT() {
        this.content.addColumnsRight(1);
        ++this.region.width;
        CharacterPlate characterPlate = this.plate.cut(new Rectangle(this.region.x + this.region.width - 1, this.region.y, 1, this.region.height));
        this.content.paste(characterPlate, this.region.width - 1, 0, 1, this.region.height);
        if (this.mask != null) {
            this.mask.addColumnsRight(1, true);
        }
    }

    public void resizeByCursorE_LEFT() {
        char[][] cArray = this.content.getCopy(this.region.width - 1, 0, 1, this.region.height).getContent();
        try {
            this.plate.getContent().paste(cArray, this.region.x + this.region.width - 1, this.region.y, 1, this.region.width);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content.removeColumnsRight(1);
        --this.region.width;
        if (this.mask != null) {
            this.mask.removeColumnsRight(1);
        }
    }

    public void resizeByCursorW_RIGHT() {
        char[][] cArray = this.content.getCopy(0, 0, 1, this.region.height).getContent();
        try {
            this.plate.getContent().paste(cArray, this.region.x, this.region.y, 1, this.region.height);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content.removeColumnsLeft(1);
        --this.region.width;
        ++this.region.x;
        if (this.mask != null) {
            this.mask.removeColumnsLeft(1);
        }
    }

    public void set(Rectangle rectangle, CharacterPlate characterPlate) {
        this.set(rectangle, characterPlate, (BooleanPlate)null);
    }

    public void set(Rectangle rectangle, BooleanPlate booleanPlate) {
        CharacterPlate characterPlate = new CharacterPlate(rectangle.width, rectangle.height);
        int n = 0;
        while (n < rectangle.height) {
            int n2 = 0;
            while (n2 < rectangle.width) {
                if (booleanPlate.isSet(n2, n) && this.plate.getContent().contains(rectangle.x + n2, rectangle.y + n)) {
                    characterPlate.set(n2, n, this.plate.getChar(rectangle.x + n2, rectangle.y + n));
                    this.plate.setCharForce(rectangle.x + n2, rectangle.y + n, ' ');
                }
                ++n2;
            }
            ++n;
        }
        this.set(rectangle, characterPlate, booleanPlate);
        this.optimizeSelectionRegion();
    }

    public void set(Rectangle rectangle, JaveSelection javeSelection) {
        this.set(rectangle, javeSelection.getContent(), javeSelection.getMask());
    }

    public void set(Rectangle rectangle, CharacterPlate characterPlate, BooleanPlate booleanPlate) {
        this.mask = booleanPlate;
        this.region = rectangle;
        this.content = characterPlate;
        this.textboxStyle = -1;
        this.originalContentX = 0;
        this.originalContentY = 0;
        this.originalContent = characterPlate.getClone();
    }

    public void set(Point point, char[][] cArray, BooleanPlate booleanPlate) {
        if (point == null || cArray == null) {
            this.region = null;
            this.content = null;
            this.mask = null;
            this.textboxStyle = -1;
            return;
        }
        this.set(new Rectangle(point.x, point.y, cArray[0].length, cArray.length), new CharacterPlate(cArray), booleanPlate);
    }

    public void set(Point point, CharacterPlate characterPlate) {
        if (point == null || characterPlate == null) {
            this.region = null;
            this.mask = null;
            this.content = null;
            this.textboxStyle = -1;
            return;
        }
        this.set(new Rectangle(point.x, point.y, characterPlate.getWidth(), characterPlate.getHeight()), characterPlate);
    }

    public void set(Point point, JaveClipboardSelection javeClipboardSelection) {
        if (point == null || javeClipboardSelection == null) {
            this.region = null;
            this.mask = null;
            this.content = null;
            this.textboxStyle = -1;
            return;
        }
        this.set(new Rectangle(point.x, point.y, javeClipboardSelection.content.getWidth(), javeClipboardSelection.content.getHeight()), javeClipboardSelection.content, javeClipboardSelection.mask);
    }

    public boolean add(Rectangle rectangle) {
        return this.add(rectangle, null);
    }

    public boolean add(Rectangle rectangle, BooleanPlate booleanPlate) {
        int n;
        int n2;
        int n3;
        int n4;
        CharacterPlate characterPlate = new CharacterPlate(rectangle.width, rectangle.height);
        int n5 = 0;
        while (n5 < rectangle.height) {
            n4 = 0;
            while (n4 < rectangle.width) {
                if ((booleanPlate == null || booleanPlate.isSet(n4, n5)) && this.plate.contains(rectangle.x + n4, rectangle.y + n5)) {
                    characterPlate.set(n4, n5, this.plate.getChar(rectangle.x + n4, rectangle.y + n5));
                    this.plate.setCharForce(rectangle.x + n4, rectangle.y + n5, ' ');
                }
                ++n4;
            }
            ++n5;
        }
        n4 = this.region.y - rectangle.y;
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = this.region.x - rectangle.x) < 0) {
            n3 = 0;
        }
        if ((n2 = rectangle.x + rectangle.width - (this.region.x + this.region.width)) < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + rectangle.height - (this.region.y + this.region.height)) < 0) {
            n = 0;
        }
        if (n4 > 0 || n > 0 || n2 > 0 || n3 > 0) {
            if (this.mask == null) {
                this.mask = new BooleanPlate(this.region.width, this.region.height);
                this.mask.setAll(true);
            }
            if (n4 > 0) {
                this.content.addLinesTop(n4);
                this.mask.addLinesTop(n4, false);
                this.region.y -= n4;
                this.region.height += n4;
            }
            if (n > 0) {
                this.content.addLinesBottom(n);
                this.mask.addLinesBottom(n, false);
                this.region.height += n;
            }
            if (n3 > 0) {
                this.content.addColumnsLeft(n3);
                this.mask.addColumnsLeft(n3, false);
                this.region.x -= n3;
                this.region.width += n3;
            }
            if (n2 > 0) {
                this.content.addColumnsRight(n2);
                this.mask.addColumnsRight(n2, false);
                this.region.width += n2;
            }
        }
        if (this.mask == null) {
            return false;
        }
        boolean bl = false;
        int n6 = 0;
        while (n6 < rectangle.height) {
            int n7 = 0;
            while (n7 < rectangle.width) {
                int n8 = rectangle.x - this.region.x + n7;
                int n9 = rectangle.y - this.region.y + n6;
                if (!this.mask.isSet(n8, n9) && (booleanPlate == null || booleanPlate.isSet(n7, n6))) {
                    this.mask.set(n8, n9, true);
                    this.content.setForce(n8, n9, characterPlate.get(n7, n6));
                    bl = true;
                }
                ++n7;
            }
            ++n6;
        }
        if (bl && this.mask.isAllSet()) {
            this.mask = null;
        }
        return bl;
    }

    public boolean remove(Rectangle rectangle) {
        return this.remove(rectangle, null);
    }

    public boolean remove(Rectangle rectangle, BooleanPlate booleanPlate) {
        if (rectangle.y > this.region.y + this.region.height - 1 || rectangle.x > this.region.x + this.region.width - 1 || rectangle.y + rectangle.height - 1 < this.region.y || rectangle.x + rectangle.width - 1 < this.region.x) {
            return false;
        }
        if (this.mask == null) {
            this.mask = new BooleanPlate(this.region.width, this.region.height);
            this.mask.setAll(true);
        }
        int n = 0;
        int n2 = 0;
        int n3 = rectangle.x + rectangle.width - (this.region.x + this.region.width);
        if (n3 > 0) {
            rectangle.width -= n3;
        }
        if ((n3 = rectangle.y + rectangle.height - (this.region.y + this.region.height)) > 0) {
            rectangle.height -= n3;
        }
        if ((n3 = this.region.x - rectangle.x) > 0) {
            rectangle.x += n3;
            rectangle.width -= n3;
            n = n3;
        }
        if ((n3 = this.region.y - rectangle.y) > 0) {
            rectangle.y += n3;
            rectangle.height -= n3;
            n2 = n3;
        }
        boolean bl = false;
        int n4 = 0;
        while (n4 < rectangle.height) {
            int n5 = 0;
            while (n5 < rectangle.width) {
                int n6 = rectangle.x - this.region.x + n5;
                int n7 = rectangle.y - this.region.y + n4;
                if (this.mask.isSet(n6, n7) && (booleanPlate == null || booleanPlate.isSet(n5 + n, n4 + n2))) {
                    this.mask.set(n6, n7, false);
                    char c = this.content.get(n6, n7);
                    this.content.setForce(n6, n7, ' ');
                    this.plate.setCharForce(rectangle.x + n5, rectangle.y + n4, c);
                    bl = true;
                }
                ++n5;
            }
            ++n4;
        }
        this.optimizeSelectionRegion();
        return bl;
    }

    protected void optimizeSelectionRegion() {
        if (this.mask == null) {
            return;
        }
        if (this.mask.isEmpty()) {
            this.mask = null;
            this.content = null;
            this.region = null;
        } else {
            Insets insets = this.mask.getEmptyInsets(false);
            if (insets.top > 0) {
                this.content.removeLinesTop(insets.top);
                this.mask.removeLinesTop(insets.top);
                this.region.y += insets.top;
                this.region.height -= insets.top;
            }
            if (insets.left > 0) {
                this.content.removeColumnsLeft(insets.left);
                this.mask.removeColumnsLeft(insets.left);
                this.region.x += insets.left;
                this.region.width -= insets.left;
            }
            if (insets.right > 0) {
                this.content.removeColumnsRight(insets.right);
                this.mask.removeColumnsRight(insets.right);
                this.region.width -= insets.right;
            }
            if (insets.bottom > 0) {
                this.content.removeLinesBottom(insets.bottom);
                this.mask.removeLinesBottom(insets.bottom);
                this.region.height -= insets.bottom;
            }
        }
    }

    public void paste() {
        switch (this.getLayer()) {
            case 1: {
                this.pasteNormal();
                break;
            }
            case 0: {
                this.pasteBackground();
                break;
            }
            case 2: {
                this.pasteForeground();
                break;
            }
            case 3: {
                this.pasteDifference();
            }
        }
    }

    protected void pasteNormal() {
        this.pasteIntoNormal(this.plate.getContent());
        this.plate.repaint();
    }

    public void pasteIntoNormal(CharacterPlate characterPlate) {
        int n = 0;
        while (n < this.region.height) {
            int n2 = 0;
            while (n2 < this.region.width) {
                if (this.mask == null || this.mask.isSet(n2, n)) {
                    characterPlate.set(this.region.x + n2, this.region.y + n, this.content.get(n2, n));
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void pasteForeground() {
        CharacterPlate characterPlate = this.plate.getContent();
        int n = 0;
        while (n < this.region.width) {
            int n2 = 0;
            while (n2 < this.region.height) {
                if ((this.mask == null || this.mask.isSet(n, n2)) && this.content.get(n, n2) != ' ') {
                    characterPlate.set(this.region.x + n, this.region.y + n2, this.content.get(n, n2));
                }
                ++n2;
            }
            ++n;
        }
        this.plate.repaint();
    }

    protected void pasteBackground() {
        CharacterPlate characterPlate = this.plate.getContent();
        int n = 0;
        while (n < this.region.height) {
            int n2 = 0;
            while (n2 < this.region.width) {
                if ((this.mask == null || this.mask.isSet(n2, n)) && this.content.get(n2, n) != ' ' && characterPlate.get(this.region.x + n2, this.region.y + n) == ' ') {
                    characterPlate.set(this.region.x + n2, this.region.y + n, this.content.get(n2, n));
                }
                ++n2;
            }
            ++n;
        }
        this.plate.repaint();
    }

    protected void pasteDifference() {
        CharacterPlate characterPlate = this.plate.getContent();
        int n = 0;
        while (n < this.region.height) {
            int n2 = 0;
            while (n2 < this.region.width) {
                if ((this.mask == null || this.mask.isSet(n2, n)) && this.content.get(n2, n) != ' ') {
                    char c = this.content.get(n2, n);
                    if (c == characterPlate.get(this.region.x + n2, this.region.y + n)) {
                        characterPlate.setForce(this.region.x + n2, this.region.y + n, ' ');
                    } else if (c != ' ') {
                        characterPlate.setForce(this.region.x + n2, this.region.y + n, c);
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.plate.repaint();
    }

    public Point move(int n, int n2) {
        return this.move(n, n2, false);
    }

    public Point move(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (!bl) {
            this.region.x += n;
            this.region.y += n2;
            return new Point(n, n2);
        }
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = true;
        while (n > 0 && bl2) {
            n4 = this.region.x + this.region.width;
            n3 = this.region.y;
            while (n3 < this.region.y + this.region.height) {
                if (this.plate.isInside(n4, n3) && this.plate.getChar(n4, n3) != ' ') {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (!bl2) continue;
            ++this.region.x;
            --n;
            ++n5;
        }
        bl2 = true;
        while (n < 0 && bl2) {
            n4 = this.region.x - 1;
            n3 = this.region.y;
            while (n3 < this.region.y + this.region.height) {
                if (this.plate.isInside(n4, n3) && this.plate.getChar(n4, n3) != ' ') {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (!bl2) continue;
            --this.region.x;
            ++n;
            --n5;
        }
        bl2 = true;
        while (n2 < 0 && bl2) {
            n4 = this.region.y - 1;
            n3 = this.region.x;
            while (n3 < this.region.x + this.region.width) {
                if (this.plate.isInside(n3, n4) && this.plate.getChar(n3, n4) != ' ') {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (!bl2) continue;
            --this.region.y;
            ++n2;
            --n6;
        }
        bl2 = true;
        while (n2 > 0 && bl2) {
            n4 = this.region.y + this.region.height;
            n3 = this.region.x;
            while (n3 < this.region.x + this.region.width) {
                if (this.plate.isInside(n3, n4) && this.plate.getChar(n3, n4) != ' ') {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (!bl2) continue;
            ++this.region.y;
            --n2;
            ++n6;
        }
        return new Point(n5, n6);
    }

    public void paintBorder(Graphics graphics) {
        if (this.region == null) {
            return;
        }
        Point point = this.plate.getScreenPointFor(this.region.x, this.region.y);
        int n = this.region.width * this.plate.charWidth;
        int n2 = this.region.height * this.plate.charHeight;
        if (this.mask == null) {
            GfxTools.drawBrokenRectangle(graphics, Color.white, Color.black, point.x, point.y, n, n2, this.blinkOffset);
            if (this.d3View) {
                if (this.layer == 0) {
                    graphics.setColor(JaveGlobalRessources.colorPlateBackground.darker());
                    graphics.drawLine(point.x + 1, point.y + 1, point.x + n - 1, point.y + 1);
                    graphics.drawLine(point.x + 1, point.y + 1, point.x + 1, point.y + n2 - 1);
                } else if (this.layer == 2) {
                    graphics.setColor(JaveGlobalRessources.colorPlateBackground.darker());
                    graphics.drawLine(point.x + 1, point.y + n2 + 1, point.x + n + 1, point.y + n2 + 1);
                    graphics.drawLine(point.x + n + 1, point.y + 1, point.x + n + 1, point.y + n2 + 1);
                }
            }
        } else {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = 0;
            while (n8 < this.region.width) {
                n7 = 0;
                while (n7 < this.region.height) {
                    if (this.mask.isSet(n8, n7)) {
                        if (n7 == 0 || !this.mask.isSet(n8, n7 - 1)) {
                            n6 = point.x + n8 * this.plate.charWidth;
                            n5 = point.y + n7 * this.plate.charHeight;
                            n4 = n6 + this.plate.charWidth;
                            n3 = n5;
                            graphics.setColor(Color.black);
                            graphics.drawLine(n6, n5, n4, n3);
                            graphics.setColor(Color.white);
                            GfxTools.drawBrokenLine(graphics, n6, n5, n4, n3, 3, this.blinkOffset);
                        }
                        if (n7 == this.region.height - 1 || !this.mask.isSet(n8, n7 + 1)) {
                            n6 = point.x + n8 * this.plate.charWidth;
                            n5 = point.y + (n7 + 1) * this.plate.charHeight;
                            n4 = n6 + this.plate.charWidth;
                            n3 = n5;
                            graphics.setColor(Color.black);
                            graphics.drawLine(n6, n5, n4, n3);
                            graphics.setColor(Color.white);
                            GfxTools.drawBrokenLine(graphics, n6, n5, n4, n3, 3, this.blinkOffset);
                        }
                        if (n8 == this.region.width - 1 || !this.mask.isSet(n8 + 1, n7)) {
                            n6 = point.x + (n8 + 1) * this.plate.charWidth;
                            n5 = point.y + n7 * this.plate.charHeight;
                            n4 = n6;
                            n3 = n5 + this.plate.charHeight;
                            graphics.setColor(Color.black);
                            graphics.drawLine(n6, n5, n4, n3);
                            graphics.setColor(Color.white);
                            GfxTools.drawBrokenLine(graphics, n6, n5, n4, n3, 3, this.blinkOffset);
                        }
                        if (n8 == 0 || !this.mask.isSet(n8 - 1, n7)) {
                            n6 = point.x + n8 * this.plate.charWidth;
                            n5 = point.y + n7 * this.plate.charHeight;
                            n4 = n6;
                            n3 = n5 + this.plate.charHeight;
                            graphics.setColor(Color.black);
                            graphics.drawLine(n6, n5, n4, n3);
                            graphics.setColor(Color.white);
                            GfxTools.drawBrokenLine(graphics, n6, n5, n4, n3, 3, this.blinkOffset);
                        }
                    }
                    ++n7;
                }
                ++n8;
            }
            if (this.d3View) {
                if (this.layer == 0) {
                    graphics.setColor(JaveGlobalRessources.colorPlateBackground.darker());
                    n7 = 0;
                    while (n7 < this.region.width) {
                        int n9 = 0;
                        while (n9 < this.region.height) {
                            if (this.mask.isSet(n7, n9)) {
                                if (n9 == 0 || !this.mask.isSet(n7, n9 - 1)) {
                                    n6 = point.x + n7 * this.plate.charWidth + 1;
                                    n5 = point.y + n9 * this.plate.charHeight + 1;
                                    n4 = n6 + this.plate.charWidth - 1;
                                    n3 = n5;
                                    graphics.drawLine(n6, n5, n4, n3);
                                }
                                if (n7 == 0 || !this.mask.isSet(n7 - 1, n9)) {
                                    n6 = point.x + n7 * this.plate.charWidth + 1;
                                    n5 = point.y + n9 * this.plate.charHeight + 1;
                                    n4 = n6;
                                    n3 = n5 + this.plate.charHeight - 1;
                                    graphics.drawLine(n6, n5, n4, n3);
                                }
                            }
                            ++n9;
                        }
                        ++n7;
                    }
                } else if (this.layer == 2) {
                    graphics.setColor(JaveGlobalRessources.colorPlateBackground.darker());
                    n7 = 0;
                    while (n7 < this.region.width) {
                        int n10 = 0;
                        while (n10 < this.region.height) {
                            if (this.mask.isSet(n7, n10)) {
                                if (n10 == this.region.height - 1 || !this.mask.isSet(n7, n10 + 1)) {
                                    n6 = point.x + n7 * this.plate.charWidth + 1;
                                    n5 = point.y + (n10 + 1) * this.plate.charHeight + 1;
                                    n4 = n6 + this.plate.charWidth - 1;
                                    n3 = n5;
                                    graphics.drawLine(n6, n5, n4, n3);
                                }
                                if (n7 == this.region.width - 1 || !this.mask.isSet(n7 + 1, n10)) {
                                    n6 = point.x + (n7 + 1) * this.plate.charWidth + 1;
                                    n5 = point.y + n10 * this.plate.charHeight + 1;
                                    n4 = n6;
                                    n3 = n5 + this.plate.charHeight - 1;
                                    graphics.drawLine(n6, n5, n4, n3);
                                }
                            }
                            ++n10;
                        }
                        ++n7;
                    }
                }
            }
        }
        ++this.blinkOffset;
        this.blinkOffset %= 6;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.region == null || this.content == null) {
            return;
        }
        Point point = this.plate.getScreenPointFor(this.region.x, this.region.y);
        int n6 = this.region.width * this.plate.charWidth;
        int n7 = this.region.height * this.plate.charHeight;
        if (this.layer == 3) {
            char c;
            int n8;
            int n9;
            n5 = this.content.getWidth();
            n4 = this.content.getHeight();
            n3 = this.plate.getDocumentWidth();
            int n10 = this.plate.getDocumentHeight();
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionBackground);
            } else {
                graphics.setColor(JaveGlobalRessources.colorPlateBackground);
            }
            int n11 = 0;
            while (n11 < n5) {
                n9 = 0;
                while (n9 < n4) {
                    n8 = this.region.x + n11;
                    c = this.region.y + n9;
                    if (n8 < 0 || n8 >= n3 || c < '\u0000' || c >= n10 || this.content.get(n11, n9) != ' ') {
                        graphics.fillRect(point.x + n11 * this.plate.charWidth, point.y + n9 * this.plate.charHeight, this.plate.charWidth + 1, this.plate.charHeight + 1);
                    }
                    ++n9;
                }
                ++n11;
            }
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionText);
            } else {
                graphics.setColor(JaveGlobalRessources.colorText);
            }
            n9 = 0;
            while (n9 < n5) {
                n8 = 0;
                while (n8 < n4) {
                    c = this.content.get(n9, n8);
                    if (c != ' ') {
                        int n12 = this.region.x + n9;
                        int n13 = this.region.y + n8;
                        if (n12 < 0 || n12 >= n3 || n13 < 0 || n13 >= n10 || this.plate.getChar(n12, n13) != c) {
                            n2 = point.x + n9 * this.plate.charWidth;
                            n = point.y + n8 * this.plate.charHeight;
                            graphics.drawString(String.valueOf(c), n2, n + this.plate.fontAscent);
                        }
                    }
                    ++n8;
                }
                ++n9;
            }
        } else if (this.layer == 2) {
            n5 = this.content.getWidth();
            n4 = this.content.getHeight();
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionBackground);
            } else {
                graphics.setColor(JaveGlobalRessources.colorPlateBackground);
            }
            n3 = 0;
            while (n3 < n5) {
                int n14 = 0;
                while (n14 < n4) {
                    if (this.content.get(n3, n14) > ' ') {
                        graphics.fillRect(point.x + n3 * this.plate.charWidth, point.y + n14 * this.plate.charHeight, this.plate.charWidth + 1, this.plate.charHeight + 1);
                    }
                    ++n14;
                }
                ++n3;
            }
            if (this.d3View) {
                Color color = JaveGlobalRessources.colorPlateBackground.darker();
                Color color2 = JaveGlobalRessources.colorPlateBackground.brighter();
                int n15 = 0;
                while (n15 < n5) {
                    int n16 = 0;
                    while (n16 < n4) {
                        if (this.content.get(n15, n16) > ' ') {
                            n2 = point.x + n15 * this.plate.charWidth;
                            n = point.y + n16 * this.plate.charHeight;
                            if (n15 >= n5 - 1 || this.content.get(n15 + 1, n16) == ' ') {
                                graphics.setColor(color);
                                graphics.drawLine(n2 + this.plate.charWidth, n + 1, n2 + this.plate.charWidth, n + this.plate.charHeight);
                            }
                            if (n16 >= n4 - 1 || this.content.get(n15, n16 + 1) == ' ') {
                                graphics.setColor(color);
                                graphics.drawLine(n2 + 1, n + this.plate.charHeight, n2 + this.plate.charWidth, n + this.plate.charHeight);
                            }
                            if (n15 == 0 || this.content.get(n15 - 1, n16) == ' ') {
                                graphics.setColor(color2);
                                graphics.drawLine(n2, n + 1, n2, n + this.plate.charHeight);
                            }
                            if (n16 == 0 || this.content.get(n15, n16 - 1) == ' ') {
                                graphics.setColor(color2);
                                graphics.drawLine(n2, n, n2 + this.plate.charWidth, n);
                            }
                        }
                        ++n16;
                    }
                    ++n15;
                }
            }
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionText);
            } else {
                graphics.setColor(JaveGlobalRessources.colorText);
            }
            int n17 = 0;
            while (n17 < n4) {
                graphics.drawString(String.valueOf(this.content.getContent()[n17]), point.x, point.y + n17 * this.plate.charHeight + this.plate.fontAscent);
                ++n17;
            }
        } else if (this.layer == 1) {
            n2 = this.content.getWidth();
            n = this.content.getHeight();
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionBackground);
            } else {
                graphics.setColor(JaveGlobalRessources.colorPlateBackground);
            }
            if (this.mask == null) {
                graphics.fillRect(point.x, point.y, n6, n7);
            } else {
                n5 = 0;
                while (n5 < n2) {
                    n4 = 0;
                    while (n4 < n) {
                        if (this.mask.isSet(n5, n4)) {
                            graphics.fillRect(point.x + n5 * this.plate.charWidth, point.y + n4 * this.plate.charHeight, this.plate.charWidth + 1, this.plate.charHeight + 1);
                        }
                        ++n4;
                    }
                    ++n5;
                }
            }
            if (this.d3View) {
                graphics.setColor(JaveGlobalRessources.colorSelectionText);
            } else {
                graphics.setColor(JaveGlobalRessources.colorText);
            }
            n5 = 0;
            while (n5 < n) {
                graphics.drawString(String.valueOf(this.content.getContent()[n5]), point.x, point.y + n5 * this.plate.charHeight + this.plate.fontAscent);
                ++n5;
            }
        } else if (this.layer == 0) {
            int n18;
            n5 = this.content.getWidth();
            n4 = this.content.getHeight();
            n3 = this.plate.getDocumentWidth();
            int n19 = this.plate.getDocumentHeight();
            int n20 = 0;
            while (n20 < n5) {
                int n21 = 0;
                while (n21 < n4) {
                    int n22 = this.region.x + n20;
                    n18 = this.region.y + n21;
                    if (n22 < 0 || n22 >= n3 || n18 < 0 || n18 >= n19 || this.plate.getChar(n22, n18) == ' ') {
                        n2 = point.x + n20 * this.plate.charWidth;
                        n = point.y + n21 * this.plate.charHeight;
                        if (this.mask == null || this.mask.isSet(n20, n21)) {
                            if (this.d3View) {
                                graphics.setColor(JaveGlobalRessources.colorSelectionBackground);
                            } else {
                                graphics.setColor(JaveGlobalRessources.colorPlateBackground);
                            }
                            graphics.fillRect(n2, n, this.plate.charWidth + 1, this.plate.charHeight + 1);
                        }
                        if (this.content.get(n20, n21) > ' ') {
                            if (this.d3View) {
                                graphics.setColor(JaveGlobalRessources.colorSelectionText);
                            } else {
                                graphics.setColor(JaveGlobalRessources.colorText);
                            }
                            graphics.drawString(String.valueOf(this.content.get(n20, n21)), n2, n + this.plate.fontAscent);
                        }
                    }
                    ++n21;
                }
                ++n20;
            }
            if (this.d3View) {
                Color color = JaveGlobalRessources.colorPlateBackground.darker();
                Color color3 = JaveGlobalRessources.colorPlateBackground.brighter();
                n18 = 0;
                while (n18 < n5) {
                    int n23 = 0;
                    while (n23 < n4) {
                        int n24 = this.region.x + n18;
                        int n25 = this.region.y + n23;
                        if (n24 >= 0 && n24 < n3 && n25 >= 0 && n25 < n19 && (this.mask == null || this.mask.isSet(n18, n23)) && this.plate.getChar(n24, n25) != ' ') {
                            n2 = point.x + n18 * this.plate.charWidth;
                            n = point.y + n23 * this.plate.charHeight;
                            if (n24 + 1 >= n3 || this.plate.getChar(n24 + 1, n25) == ' ') {
                                graphics.setColor(color);
                                graphics.drawLine(n2 + this.plate.charWidth, n + 1, n2 + this.plate.charWidth, n + this.plate.charHeight);
                            }
                            if (n25 + 1 >= n19 || this.plate.getChar(n24, n25 + 1) == ' ') {
                                graphics.setColor(color);
                                graphics.drawLine(n2 + 1, n + this.plate.charHeight, n2 + this.plate.charWidth, n + this.plate.charHeight);
                            }
                            if (n24 == 0 || this.plate.getChar(n24 - 1, n25) == ' ') {
                                graphics.setColor(color3);
                                graphics.drawLine(n2, n, n2, n + this.plate.charHeight);
                            }
                            if (n25 == 0 || this.plate.getChar(n24, n25 - 1) == ' ') {
                                graphics.setColor(color3);
                                graphics.drawLine(n2, n, n2 + this.plate.charWidth, n);
                            }
                        }
                        ++n23;
                    }
                    ++n18;
                }
            }
        }
        if (this.isTextbox()) {
            graphics.setColor(JaveGlobalRessources.colorToolRegion);
            n2 = point.x + 1;
            n = point.y + 1;
            n5 = point.x + n6;
            n4 = point.y + n7;
            n3 = 5;
            graphics.drawRect(n2, n, n6 - 2, n7 - 2);
            graphics.fillRect(n2, n, n3, n3);
            graphics.fillRect(n2, n4 - n3, n3, n3);
            graphics.fillRect(n5 - n3, n, n3, n3);
            graphics.fillRect(n5 - n3, n4 - n3, n3, n3);
            graphics.fillRect((n2 + n5 - n3) / 2, n, n3, n3);
            graphics.fillRect((n2 + n5 - n3) / 2, n4 - n3, n3, n3);
            graphics.fillRect(n2, (n + n4 - n3) / 2, n3, n3);
            graphics.fillRect(n5 - n3, (n + n4 - n3) / 2, n3, n3);
        }
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void set3dView(boolean bl) {
        this.d3View = bl;
    }

    public synchronized void resizeTextboxE(int n) {
        if (n == 0 || this.region.width + n < 3) {
            return;
        }
        int n2 = this.region.width + n;
        int n3 = this.region.height;
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        if (n > 0) {
            int n4 = 0;
            while (n4 < n2 - n - 1) {
                int n5 = 0;
                while (n5 < n3) {
                    characterPlate.setForce(n4, n5, this.content.get(n4, n5));
                    ++n5;
                }
                ++n4;
            }
            int n6 = 0;
            while (n6 < n3) {
                characterPlate.setForce(n2 - 1, n6, this.content.get(n2 - n - 1, n6));
                ++n6;
            }
            int n7 = n2 - n - 1;
            while (n7 < n2 - 1) {
                int n8 = 1;
                while (n8 < n3 - 1) {
                    char c = this.getOriginalCharAt(n7, n8);
                    if (c == '\u0000') {
                        c = ' ';
                    }
                    characterPlate.setForce(n7, n8, c);
                    ++n8;
                }
                characterPlate.setForce(n7, 0, this.content.get(n2 - n - 2, 0));
                characterPlate.setForce(n7, n3 - 1, this.content.get(n2 - n - 2, n3 - 1));
                ++n7;
            }
        } else {
            int n9 = 0;
            while (n9 < n2 - 1) {
                int n10 = 0;
                while (n10 < n3) {
                    characterPlate.setForce(n9, n10, this.content.get(n9, n10));
                    ++n10;
                }
                ++n9;
            }
            int n11 = 0;
            while (n11 < n3) {
                characterPlate.setForce(n2 - 1, n11, this.content.get(n2 - n - 1, n11));
                ++n11;
            }
        }
        this.content = characterPlate;
        this.region.width = n2;
        this.plate.repaint();
    }

    public synchronized void resizeTextboxW(int n) {
        if (n == 0 || this.region.width - n < 3) {
            return;
        }
        int n2 = this.region.width - n;
        int n3 = this.region.height;
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        if (n > 0) {
            int n4 = 0;
            while (n4 < n3) {
                characterPlate.setForce(0, n4, this.content.get(0, n4));
                ++n4;
            }
            int n5 = 1;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n3) {
                    characterPlate.setForce(n5, n6, this.content.get(n5 + n, n6));
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n7;
            int n8;
            int n9 = 0;
            while (n9 < n3) {
                characterPlate.setForce(0, n9, this.content.get(0, n9));
                ++n9;
            }
            int n10 = 1;
            while (n10 < -n + 1) {
                n8 = 1;
                while (n8 < n3 - 1) {
                    n7 = this.getOriginalCharAt(n10 + n, n8);
                    if (n7 == 0) {
                        n7 = 32;
                    }
                    characterPlate.setForce(n10, n8, (char)n7);
                    ++n8;
                }
                characterPlate.setForce(n10, 0, this.content.get(1, 0));
                characterPlate.setForce(n10, n3 - 1, this.content.get(1, n3 - 1));
                ++n10;
            }
            n8 = -n + 1;
            while (n8 < n2) {
                n7 = 0;
                while (n7 < n3) {
                    characterPlate.setForce(n8, n7, this.content.get(n8 + n, n7));
                    ++n7;
                }
                ++n8;
            }
        }
        this.originalContentX += n;
        this.content = characterPlate;
        this.region.width = n2;
        this.region.x += n;
        this.plate.repaint();
    }

    public synchronized void resizeTextboxN(int n) {
        if (n == 0 || this.region.height - n < 3) {
            return;
        }
        int n2 = this.region.width;
        int n3 = this.region.height - n;
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        if (n > 0) {
            int n4 = 0;
            while (n4 < n2) {
                characterPlate.setForce(n4, 0, this.content.get(n4, 0));
                ++n4;
            }
            int n5 = 1;
            while (n5 < n3) {
                int n6 = 0;
                while (n6 < n2) {
                    characterPlate.setForce(n6, n5, this.content.get(n6, n5 + n));
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n7;
            int n8;
            int n9 = 0;
            while (n9 < n2) {
                characterPlate.setForce(n9, 0, this.content.get(n9, 0));
                ++n9;
            }
            int n10 = 1;
            while (n10 < -n + 1) {
                n8 = 1;
                while (n8 < n2 - 1) {
                    n7 = this.getOriginalCharAt(n8, n10 + n);
                    if (n7 == 0) {
                        n7 = 32;
                    }
                    characterPlate.setForce(n8, n10, (char)n7);
                    ++n8;
                }
                characterPlate.setForce(0, n10, this.content.get(0, 1));
                characterPlate.setForce(n2 - 1, n10, this.content.get(n2 - 1, 1));
                ++n10;
            }
            n8 = -n + 1;
            while (n8 < n3) {
                n7 = 0;
                while (n7 < n2) {
                    characterPlate.setForce(n7, n8, this.content.get(n7, n8 + n));
                    ++n7;
                }
                ++n8;
            }
        }
        this.originalContentY += n;
        this.content = characterPlate;
        this.region.height = n3;
        this.region.y += n;
        this.plate.repaint();
    }

    public synchronized void resizeTextboxS(int n) {
        if (n == 0 || this.region.height + n < 3) {
            return;
        }
        int n2 = this.region.width;
        int n3 = this.region.height + n;
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        if (n > 0) {
            int n4 = 0;
            while (n4 < n3 - n - 1) {
                int n5 = 0;
                while (n5 < n2) {
                    characterPlate.setForce(n5, n4, this.content.get(n5, n4));
                    ++n5;
                }
                ++n4;
            }
            int n6 = 0;
            while (n6 < n2) {
                characterPlate.setForce(n6, n3 - 1, this.content.get(n6, n3 - n - 1));
                ++n6;
            }
            int n7 = n3 - n - 1;
            while (n7 < n3 - 1) {
                int n8 = 1;
                while (n8 < n2 - 1) {
                    char c = this.getOriginalCharAt(n8, n7);
                    if (c == '\u0000') {
                        c = ' ';
                    }
                    characterPlate.setForce(n8, n7, c);
                    ++n8;
                }
                characterPlate.setForce(0, n7, this.content.get(0, n3 - n - 2));
                characterPlate.setForce(n2 - 1, n7, this.content.get(n2 - 1, n3 - n - 2));
                ++n7;
            }
        } else {
            int n9 = 0;
            while (n9 < n3 - 1) {
                int n10 = 0;
                while (n10 < n2) {
                    characterPlate.setForce(n10, n9, this.content.get(n10, n9));
                    ++n10;
                }
                ++n9;
            }
            int n11 = 0;
            while (n11 < n2) {
                characterPlate.setForce(n11, n3 - 1, this.content.get(n11, n3 - n - 1));
                ++n11;
            }
        }
        this.content = characterPlate;
        this.region.height = n3;
        this.plate.repaint();
    }

    protected char getOriginalCharAt(int n, int n2) {
        if ((n += this.originalContentX) < 1 || (n2 += this.originalContentY) < 1 || n >= this.originalContent.getWidth() - 1 || n2 >= this.originalContent.getHeight() - 1) {
            return '\u0000';
        }
        return this.originalContent.get(n, n2);
    }
}

