/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.CharField;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GGridLayout;
import de.jave.gui.GGridLayout2;
import de.jave.jave.CharacterPlate;
import de.jave.jave.GeneralAlgorithm;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import gebhard.uielements.CardPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ReplaceCharacterDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    protected Jave jave;
    protected CardPanel cpOptions;
    protected CharField cfA;
    protected CharField cfB;
    protected TextArea tfA;
    protected TextArea tfB;
    protected Checkbox cbWildcard;
    protected CharField cfWildcard;
    protected Label lWildcard;
    protected Button bClose;
    protected Button bReplace;

    public ReplaceCharacterDialog(Jave jave) {
        this(jave, "Replace Character");
    }

    public ReplaceCharacterDialog(Jave jave, String string) {
        super((Frame)jave, string);
        this.jave = jave;
        this.createOptionsPanel();
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        this.bReplace = new Button("Replace");
        this.bReplace.addActionListener(this);
        Panel panel = new Panel();
        panel.add(this.bReplace);
        panel.add(this.bClose);
        this.setLayout(new BorderLayout());
        this.add((Component)this.cpOptions, "Center");
        this.add((Component)panel, "South");
        this.pack();
        this.addWindowListener(this);
    }

    protected void createOptionsPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout(0, 2, 2, 2));
        panel.add(new Label("Find what:", 2));
        this.cfA = new CharField();
        this.cfA.setFont(JaveGlobalRessources.FONT_DEFAULT);
        panel.add(this.cfA);
        panel.add(new Label("Replace with:", 2));
        this.cfB = new CharField();
        this.cfB.setFont(JaveGlobalRessources.FONT_DEFAULT);
        panel.add(this.cfB);
        Panel panel2 = new Panel();
        this.tfA = new TextArea(4, 20);
        this.tfA.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Find what:", -1);
        gBorderedPanel.setLayout(new GridLayout());
        gBorderedPanel.add(this.tfA);
        this.tfB = new TextArea(4, 20);
        this.tfB.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Replace with:", -1);
        gBorderedPanel2.setLayout(new GridLayout());
        gBorderedPanel2.add(this.tfB);
        this.cbWildcard = new Checkbox("Use wildcard", false);
        this.cbWildcard.addItemListener(this);
        this.lWildcard = new Label("Wildcard character:", 2);
        this.cfWildcard = new CharField('?');
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 2, 2, 2));
        panel3.add(gBorderedPanel);
        panel3.add(gBorderedPanel2);
        Panel panel4 = new Panel();
        panel4.add(this.cbWildcard);
        panel4.add(this.lWildcard);
        panel4.add(this.cfWildcard);
        panel2.setLayout(new GGridLayout2(0, 1, 2, 2));
        panel2.add(panel3);
        panel2.add(panel4);
        this.cpOptions = new CardPanel();
        this.cpOptions.add("Character", panel);
        this.cpOptions.add("Pattern", panel2);
        this.cpOptions.init();
        this.itemStateChanged(null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.cfWildcard.setEnabled(this.cbWildcard.getState());
        this.lWildcard.setEnabled(this.cbWildcard.getState());
    }

    protected void close() {
        this.setVisible(false);
    }

    protected void replace() {
        if (this.cpOptions.getSelectedItem() == 0) {
            char c = this.cfA.getChar();
            char c2 = this.cfB.getChar();
            this.replaceCharacter(c, c2);
        } else {
            CharacterPlate characterPlate = new CharacterPlate(this.tfA.getText());
            CharacterPlate characterPlate2 = new CharacterPlate(this.tfB.getText());
            boolean bl = this.cbWildcard.getState();
            char c = this.cfWildcard.getChar();
            this.replacePattern(characterPlate, characterPlate2, bl, c);
        }
    }

    protected void replaceCharacter(char c, char c2) {
        CharacterPlate characterPlate = this.jave.getContentOfInterest().getContent();
        if (characterPlate == null) {
            return;
        }
        int n = GeneralAlgorithm.replace(characterPlate, c, c2);
        if (n == 0) {
            this.jave.beep();
            this.jave.showStatus("'" + c + "' not found!");
            return;
        }
        if (n == 1) {
            this.jave.showStatus("Replaced 1 occurrence.");
        } else {
            this.jave.showStatus("Replaced " + n + " occurrences.");
        }
        this.jave.plate.repaint();
        this.jave.plate.saveCurrentState("replace character");
    }

    protected void replacePattern(CharacterPlate characterPlate, CharacterPlate characterPlate2, boolean bl, char c) {
        CharacterPlate characterPlate3 = this.jave.getContentOfInterest().getContent();
        if (characterPlate3 == null) {
            return;
        }
        int n = GeneralAlgorithm.replace(characterPlate3, characterPlate, characterPlate2, bl, c);
        if (n == 0) {
            this.jave.beep();
            this.jave.showStatus("Pattern not found!");
            return;
        }
        if (n == 1) {
            this.jave.showStatus("Replaced 1 occurrence.");
        } else {
            this.jave.showStatus("Replaced " + n + " occurrences.");
        }
        this.jave.plate.repaint();
        this.jave.plate.saveCurrentState("replace pattern");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            this.close();
        } else if (object == this.bReplace) {
            this.replace();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

