/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.BooleanPlate;
import de.jave.jave.CharacterPlate;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class JaveClipboardSelection
implements Transferable,
ClipboardOwner {
    protected CharacterPlate content;
    protected BooleanPlate mask;
    private static final int JAVE_SELECTION = 0;
    private static final int STRING = 1;
    private static final int PLAIN_TEXT = 2;
    private static final DataFlavor[] flavors = new DataFlavor[3];

    public JaveClipboardSelection(String string) {
        this.content = new CharacterPlate(string);
        this.mask = null;
    }

    public JaveClipboardSelection(CharacterPlate characterPlate) {
        this(characterPlate, null);
    }

    public JaveClipboardSelection(CharacterPlate characterPlate, BooleanPlate booleanPlate) {
        this.content = characterPlate.getClone();
        if (booleanPlate != null) {
            this.mask = booleanPlate.getClone();
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = 0;
        while (n < flavors.length) {
            if (dataFlavor.equals(flavors[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[0])) {
            return this;
        }
        if (dataFlavor.equals(flavors[1])) {
            return this.content.toString();
        }
        if (dataFlavor.equals(flavors[2])) {
            return new StringReader(this.content.toString());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public CharacterPlate getContent() {
        return this.content;
    }

    public BooleanPlate getMask() {
        return this.mask;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static {
        try {
            JaveClipboardSelection.flavors[0] = new DataFlavor(Class.forName("de.jave.jave.JaveSelection"), "JavE Selection");
        }
        catch (Exception exception) {
            System.err.println("!!! Serious problem in de.jave.jave.JaveSelection.static :" + exception);
        }
        JaveClipboardSelection.flavors[1] = DataFlavor.stringFlavor;
        JaveClipboardSelection.flavors[2] = DataFlavor.plainTextFlavor;
    }
}

