/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.figlet.FIGFileManager;
import de.jave.gui.AboutWindow;
import de.jave.gui.CharField;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GButton;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GHyperlink;
import de.jave.gui.GImageCanvas;
import de.jave.gui.GLabel;
import de.jave.gui.GScrollPanel;
import de.jave.gui.GStatusLabel;
import de.jave.gui.GTextArea;
import de.jave.gui.GUpDownArrangement;
import de.jave.gui.Gap;
import de.jave.gui.GuiTools;
import de.jave.jave.AscTris;
import de.jave.jave.Ascii2GIFDialog;
import de.jave.jave.AsciiGradients;
import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.AsciiRepairAlgorithm;
import de.jave.jave.AsciiReplaceIllegal;
import de.jave.jave.AsciiThumbnailBrowser;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.BooleanPlate;
import de.jave.jave.BraceLocationDialog;
import de.jave.jave.BrushTool;
import de.jave.jave.CamelDialog;
import de.jave.jave.CharacterPlate;
import de.jave.jave.CharacterSets;
import de.jave.jave.ClipartDialog;
import de.jave.jave.ClipartNewEntryDialog;
import de.jave.jave.CommandLineJave;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.Document;
import de.jave.jave.DocumentManager;
import de.jave.jave.FigletDialog;
import de.jave.jave.FigletExportAssistant;
import de.jave.jave.Filter;
import de.jave.jave.Fonts;
import de.jave.jave.FormulaEditor;
import de.jave.jave.FractalTool;
import de.jave.jave.FunctionPlotTool;
import de.jave.jave.GeneralAlgorithm;
import de.jave.jave.Image2AsciiDialog;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveClipboardSelection;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.JaveLogFile;
import de.jave.jave.JaveMenuBar;
import de.jave.jave.JaveMovieEditor;
import de.jave.jave.JaveOptionsAlgorithmDialog;
import de.jave.jave.JaveSelection;
import de.jave.jave.JaveStartSplashFrame;
import de.jave.jave.JaveStatusFile;
import de.jave.jave.Labyrinth;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Render3DTool;
import de.jave.jave.ReplaceCharacterDialog;
import de.jave.jave.ResultDialog;
import de.jave.jave.Selection;
import de.jave.jave.SelectionTool;
import de.jave.jave.SteganogramDecoder;
import de.jave.jave.SystemCapabilities;
import de.jave.jave.TextTool;
import de.jave.jave.TextboxDialog;
import de.jave.jave.Tool;
import de.jave.jave.ToolBar;
import de.jave.jave.ToolOptionsDialog;
import de.jave.jave.WatermarkTool;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.javeplayer.JaveMovieFile;
import de.jave.javeplayer.JaveMovieFrame;
import de.jave.util.RecentFileOpenListener;
import de.jave.util.Toolbox;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.StatusBar;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class Jave
extends Frame
implements ClipboardOwner,
ActionListener,
TextListener,
MouseListener,
WindowListener,
RecentFileOpenListener {
    public static final String JAVE_VERSION = "5.0";
    public static final String JAVE = "JavE 5.0";
    public static final String JAVE_URL = "http://www.jave.de";
    protected static final String TITLE = "JavE 5.0 - Java ASCII Versatile Editor";
    public static final String JAVE_CREATED = "Created using JavE 5.0 - http://www.jave.de";
    protected static final boolean DEFAULT_PURE_ASCII = true;
    protected static final boolean DEFAULT_GRID = true;
    protected static final boolean DEFAULT_PIXEL_VIEW = false;
    Plate plate;
    protected DocumentManager documentManager;
    CharField cfChar1;
    CharField cfChar2;
    Choice chMode;
    protected ToolBar toolBar;
    GButton gbClear;
    GButton gbUndo;
    GButton gbRedo;
    GButton gbOpen;
    GButton gbBrowse;
    GButton gbSave;
    GButton gbZoomPlus;
    GButton gbZoomMinus;
    GButton gbCamel;
    GButton gbMovie;
    GButton gbFiglet;
    GButton gbImage2Ascii;
    GButton gbClipartDialog;
    GButton gbResize;
    GButton gbTextbox;
    GButton gbExport;
    GButton gbFormula;
    GButton gbCut;
    GButton gbCopy;
    GButton gbPaste;
    GButton gbJave;
    GStatusLabel lSize;
    GStatusLabel lInsert;
    protected ToolOptionsDialog optionsDialog;
    protected FigletDialog figletDialog;
    protected Image2AsciiDialog image2AsciiDialog;
    protected ClipartDialog clipartDialog;
    protected TextboxDialog textboxDialog;
    protected CamelDialog camelDialog;
    protected ReplaceCharacterDialog replaceCharacterDialog;
    protected FormulaEditor formulaEditor;
    protected AsciiThumbnailBrowser thumbnailBrowser;
    protected JaveMovieEditor movieEditor;
    protected JaveMenuBar menuBar;
    StatusBar status;
    protected SystemCapabilities systemCapabilities = new SystemCapabilities();
    protected JaveClipboardSelection pseudoClipboard;
    protected FigletExportAssistant figletExportAssistant;

    public Jave() {
        super(TITLE);
        this.status = new StatusBar();
        JaveGlobalRessources.tooltips.setStatusDisplay(this.status);
        this.setIconImage(JaveImages.getIconImage());
        this.documentManager = new DocumentManager();
        this.plate = new Plate(this);
        this.plate.setEnabled(false);
        this.plate.setGrid(true);
        this.plate.setPixelView(false);
        this.plate.setMarkIllegalChars(true);
        this.setLayout(new BorderLayout());
        Panel panel = this.createControlsPanel();
        this.add((Component)panel, "North");
        this.toolBar = new ToolBar(this);
        this.add((Component)this.toolBar, "West");
        GScrollPanel gScrollPanel = new GScrollPanel(this.plate);
        this.plate.setScrollPanel(gScrollPanel);
        this.add((Component)gScrollPanel, "Center");
        Panel panel2 = this.createBottomPanel();
        this.add((Component)panel2, "South");
        this.plate.setStatusDisplay(this.status);
        this.plate.setMouseChar1(this.cfChar1.getChar());
        this.plate.setMouseChar2(this.cfChar2.getChar());
        this.pack();
    }

    public void startupFinish1() {
        Filter.init();
        this.setTool(0);
        this.plate.setFont(Fonts.getDefaultFont());
    }

    public void startupRecovery(Frame frame) {
        this.doRecovery(frame);
        if (this.documentManager.getSize() == 0) {
            this.doNew();
        }
    }

    public void startupMenuBar() {
        this.menuBar = new JaveMenuBar(this);
        this.setMenuBar(this.menuBar);
        this.updateUndoRedo();
        this.updateWindowsMenu();
        this.updateColorMenu();
        this.updateFrameTitle();
        this.updateSelectionMenu();
    }

    public void startupFinish2() {
        this.addWindowListener(this);
        this.setSize(JaveGlobalRessources.getEditorWidth(), JaveGlobalRessources.getEditorHeight());
        this.setLocation(JaveGlobalRessources.getEditorLocationX(), JaveGlobalRessources.getEditorLocationY());
        this.show();
    }

    public void startupFinish3() {
        JaveGlobalRessources.getRecentFileList().setRecentFileOpenListener(this);
        this.plate.setEnabled(true);
        this.plate.requestFocus();
        this.toFront();
    }

    public void startupOptionsDialog() {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        this.optionsDialog = new ToolOptionsDialog(this, this.systemCapabilities.canUseSmallFrame);
        this.optionsDialog.setTool(this.plate.currentTool);
        this.optionsDialog.pack();
        this.optionsDialog.setLocation(JaveGlobalRessources.getOptionsDialogLocationX(), JaveGlobalRessources.getOptionsDialogLocationY());
        this.optionsDialog.show();
        this.optionsDialog.toFront();
    }

    public void startupTooltips() {
        this.toolBar.addTooltips();
        JaveGlobalRessources.tooltips.add((Component)this.cfChar1, "Character on Left Mouse Button");
        JaveGlobalRessources.tooltips.add((Component)this.cfChar2, "Character on Right Mouse Button");
        JaveGlobalRessources.tooltips.add((Component)this.gbClear, "New");
        if (this.gbOpen.isReallyEnabled()) {
            JaveGlobalRessources.tooltips.add((Component)this.gbOpen, "Open an ASCII File");
        } else {
            JaveGlobalRessources.tooltips.add((Component)this.gbOpen, "This feature is disabled in applets");
        }
        JaveGlobalRessources.tooltips.add((Component)this.gbBrowse, "Browse ASCII Files");
        if (this.gbSave.isReallyEnabled()) {
            JaveGlobalRessources.tooltips.add((Component)this.gbSave, "Save as ASCII File");
        } else {
            JaveGlobalRessources.tooltips.add((Component)this.gbSave, "This feature is disabled in applets");
        }
        JaveGlobalRessources.tooltips.add((Component)this.gbCut, "Cut");
        JaveGlobalRessources.tooltips.add((Component)this.gbCopy, "Copy");
        JaveGlobalRessources.tooltips.add((Component)this.gbPaste, "Paste");
        JaveGlobalRessources.tooltips.add((Component)this.gbUndo, "Undo");
        JaveGlobalRessources.tooltips.add((Component)this.gbRedo, "Redo");
        JaveGlobalRessources.tooltips.add((Component)this.gbResize, "Resize");
        if (this.gbFiglet.isReallyEnabled()) {
            JaveGlobalRessources.tooltips.add((Component)this.gbFiglet, "Show / Hide Figlet");
        } else {
            JaveGlobalRessources.tooltips.add((Component)this.gbFiglet, "Figlet - This feature is disabled in applets");
        }
        JaveGlobalRessources.tooltips.add((Component)this.gbCamel, "Camelize (form current text to shape from image file)");
        JaveGlobalRessources.tooltips.add((Component)this.gbMovie, "Open Movie Editor");
        if (this.gbImage2Ascii.isReallyEnabled()) {
            JaveGlobalRessources.tooltips.add((Component)this.gbImage2Ascii, "Show / Hide Image to Ascii-Dialog");
        } else {
            JaveGlobalRessources.tooltips.add((Component)this.gbImage2Ascii, "Image2Ascii - This feature is disabled in applets");
        }
        if (this.gbClipartDialog.isReallyEnabled()) {
            JaveGlobalRessources.tooltips.add((Component)this.gbClipartDialog, "Show / Hide Clipart-Dialog");
        } else {
            JaveGlobalRessources.tooltips.add((Component)this.gbClipartDialog, "Clipart - This feature is disabled in applets");
        }
        JaveGlobalRessources.tooltips.add((Component)this.gbZoomMinus, "Zoom out");
        JaveGlobalRessources.tooltips.add((Component)this.gbZoomPlus, "Zoom in");
        JaveGlobalRessources.tooltips.add((Component)this.gbTextbox, "Insert textbox");
        JaveGlobalRessources.tooltips.add((Component)this.gbExport, "Export Result");
        JaveGlobalRessources.tooltips.add((Component)this.gbFormula, "Insert mathematical expression");
        JaveGlobalRessources.tooltips.add((Component)this.gbJave, "About Jave");
        JaveGlobalRessources.tooltips.add((Component)this.lSize, "Document Size");
        JaveGlobalRessources.tooltips.add((Component)this.lInsert, "Insert / Overwrite");
    }

    public void startupInitConfigFiles(Frame frame) {
        this.initConfigFiles(frame);
    }

    protected void updateColorMenu() {
        if (this.menuBar != null) {
            this.menuBar.updateColorMenu();
        }
    }

    protected void updateWindowsMenu() {
        if (this.menuBar != null) {
            this.menuBar.updateWindowsMenu(this.documentManager);
        }
    }

    protected void updateSelectionMenu() {
        if (this.menuBar != null) {
            this.menuBar.updateSelectionMenu(this.plate.hasSelection());
        }
    }

    protected final void doRecovery(Frame frame) {
        if (!JaveStatusFile.exists()) {
            return;
        }
        String[] stringArray = JaveStatusFile.load();
        if (stringArray == null || stringArray[1].equals("0")) {
            return;
        }
        String string = Integer.parseInt(stringArray[1]) > 1 ? stringArray[1] + " files" : "1 file";
        String string2 = "It seems JavE has crashed somewhen after\n" + stringArray[0] + " with " + string + " open.\n\n" + "Do you want JavE to continue where the interruption occured?";
        GDialog gDialog = new GDialog(frame, "JavE - Crash Recovery", "Crash Recovery", string2, GDialog.YES_NO_CANCEL, 2);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == 2 || n == -1) {
            System.exit(0);
        }
        if (n == 1) {
            return;
        }
        this.switchToSelectonTool();
        Document document = null;
        int n2 = 2;
        while (n2 < stringArray.length) {
            document = this.documentManager.createNew();
            document.setModified(true);
            if (stringArray[n2].length() > 0) {
                document.setFileName(stringArray[n2]);
            }
            CompressedDocumentState[] compressedDocumentStateArray = JaveLogFile.load(new File(stringArray[n2 + 1]));
            this.plate.setDocument(document);
            if (compressedDocumentStateArray != null && compressedDocumentStateArray.length > 0) {
                int n3 = 0;
                while (n3 < compressedDocumentStateArray.length) {
                    document.undoManager.saveCurrentState(compressedDocumentStateArray[n3]);
                    ++n3;
                }
                document.setDocumentState(compressedDocumentStateArray[compressedDocumentStateArray.length - 1]);
            }
            this.plate.setDocument(document);
            n2 += 2;
        }
        JaveGlobalRessources.setColorScheme(document.getColorScheme());
        this.updateStatusFile();
    }

    protected void initConfigFiles() {
        this.initConfigFiles(this);
    }

    protected void initConfigFiles(Frame frame) {
        CharacterSets.init(frame);
        PixelPlate.init(frame);
        CharacterPlate.init(frame);
        GeneralAlgorithm.init(frame);
        AsciiGradients.init(frame);
        AsciiRepairAlgorithm.init(frame);
        Fonts.init(frame);
        AsciiReplaceIllegal.init(frame);
        AsciiGreyscaleTable.init(frame);
        try {
            int n = FIGFileManager.init();
            if (n != 0) {
                String string = "";
                int n2 = 0;
                switch (n) {
                    case 1: {
                        string = "The FIGlet font folder\n'" + FIGFileManager.getBaseDir().getAbsolutePath() + "'\n" + "does not exist.\n\n" + "Please download and install FIGlet fonts from the JavE homepage.";
                        break;
                    }
                    case 2: {
                        string = "The FIGlet font folder\n'" + FIGFileManager.getBaseDir().getAbsolutePath() + "'\n" + "can not be read.\n\n" + "Please download and install FIGlet fonts from the JavE homepage\n" + "and ensure the folder being readable.";
                        break;
                    }
                    case 3: {
                        string = "There are no FIGlet fonts installed in folder\n'" + FIGFileManager.getBaseDir().getAbsolutePath() + "'.\n\n" + "Please download and install FIGlet fonts from the JavE homepage.";
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        string = "The file containing the categories for the FIGlet fonts\n'" + FIGFileManager.getCategoryFile().getAbsolutePath() + "'\n" + "does not exist.\n\n" + "The fonts will not be divided into categories.";
                        break;
                    }
                    case 5: {
                        string = "The file containing the categories for the FIGlet fonts\n'" + FIGFileManager.getCategoryFile().getAbsolutePath() + "'\n" + "has a wrong format.\n\n" + "The fonts will not be divided into categories.\n" + "Please reinstall the FIGlet fonts\n" + "(Available for download on the JavE homepage).";
                    }
                }
                new GDialog(frame, "JavE", string, n2).show();
            }
        }
        catch (Exception exception) {
            new GDialog(frame, "JavE", "Error loading FIGlet fonts:\n" + exception.getMessage(), 0).show();
        }
    }

    protected void updateFrameTitle() {
        String string = this.documentManager.getFrameTitle();
        if (string != null) {
            this.setTitle("JavE 5.0 - Java ASCII Versatile Editor - " + string);
        } else {
            this.setTitle(TITLE);
        }
    }

    private final Panel createBottomPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.status, "Center");
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 5, 0));
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1, 0, 0));
        this.cfChar1 = new CharField('X');
        this.cfChar1.setFont(JaveGlobalRessources.FONT_DEFAULT);
        this.cfChar1.setBackground(JaveGlobalRessources.COLOR_CHARFIELD_BACK);
        this.cfChar1.addTextListener(this);
        panel3.add(this.cfChar1);
        GImageCanvas gImageCanvas = JaveImages.getMouseImage();
        gImageCanvas.addMouseListener(this);
        panel3.add(gImageCanvas);
        this.cfChar2 = new CharField(' ');
        this.cfChar2.setFont(JaveGlobalRessources.FONT_DEFAULT);
        this.cfChar2.setBackground(JaveGlobalRessources.COLOR_CHARFIELD_BACK);
        this.cfChar2.addTextListener(this);
        panel3.add(this.cfChar2);
        panel2.add(panel3);
        this.lSize = new GStatusLabel(this.plate.getDocumentWidth() + " x " + this.plate.getDocumentHeight());
        this.lSize.addActionListener(this);
        panel2.add(this.lSize);
        this.lInsert = new GStatusLabel("OVR");
        this.lInsert.addActionListener(this);
        panel2.add(this.lInsert);
        panel3.doLayout();
        panel.add((Component)panel2, "East");
        return panel;
    }

    public void packOptionsDialog() {
        this.optionsDialog.pack();
    }

    public void dialogClosed(Dialog dialog) {
        if (dialog instanceof TextboxDialog) {
            this.gbTextbox.setLocked(false);
        } else if (dialog instanceof FigletDialog) {
            this.gbFiglet.setLocked(false);
        } else if (dialog instanceof Image2AsciiDialog) {
            this.gbImage2Ascii.setLocked(false);
        } else if (dialog instanceof ClipartDialog) {
            this.gbClipartDialog.setLocked(false);
        } else if (dialog instanceof FormulaEditor) {
            this.gbFormula.setLocked(false);
        }
    }

    public void hideToolOptionsDialog() {
        this.optionsDialog.setVisible(false);
    }

    public void showToolOptionsDialog() {
        this.optionsDialog.setVisible(true);
    }

    public void clipartsChanged() {
        if (this.clipartDialog != null) {
            this.clipartDialog.dispose();
            this.dialogClosed(this.clipartDialog);
            this.clipartDialog = null;
        }
    }

    public void addNewClipart(String string) {
        ClipartNewEntryDialog clipartNewEntryDialog = new ClipartNewEntryDialog(this, string);
        clipartNewEntryDialog.show();
    }

    public SystemCapabilities getSystemCapabilities() {
        return this.systemCapabilities;
    }

    private final Panel createControlsPanel() {
        Panel panel = new Panel();
        FlowLayout flowLayout = new FlowLayout(0, 0, 2);
        panel.setLayout(flowLayout);
        panel.add(new Gap(5, 1));
        this.gbClear = JaveImages.createButton("new");
        this.gbClear.addActionListener(this);
        panel.add(this.gbClear);
        this.gbBrowse = JaveImages.createButton("browse");
        panel.add(this.gbBrowse);
        this.gbBrowse.addActionListener(this);
        this.gbOpen = JaveImages.createButton("open", "open_");
        panel.add(this.gbOpen);
        this.gbOpen.addActionListener(this);
        this.gbSave = JaveImages.createButton("save", "save_");
        panel.add(this.gbSave);
        this.gbSave.addActionListener(this);
        panel.add(new Gap(10, 1));
        this.gbCut = JaveImages.createButton("cut", "cut_");
        this.gbCut.addActionListener(this);
        panel.add(this.gbCut);
        this.gbCopy = JaveImages.createButton("copy", "copy_");
        this.gbCopy.addActionListener(this);
        panel.add(this.gbCopy);
        this.gbPaste = JaveImages.createButton("paste", "paste_");
        this.gbPaste.addActionListener(this);
        panel.add(this.gbPaste);
        panel.add(new Gap(10, 1));
        this.gbUndo = JaveImages.createButton("undo", "undo_");
        this.gbUndo.addActionListener(this);
        panel.add(this.gbUndo);
        this.gbRedo = JaveImages.createButton("redo", "redo_");
        this.gbRedo.addActionListener(this);
        panel.add(this.gbRedo);
        panel.add(new Gap(10, 1));
        this.gbResize = JaveImages.createButton("resize");
        this.gbResize.addActionListener(this);
        panel.add(this.gbResize);
        panel.add(new Gap(10, 1));
        this.gbMovie = JaveImages.createButton("movie");
        this.gbMovie.addActionListener(this);
        panel.add(this.gbMovie);
        this.gbCamel = JaveImages.createButton("camel");
        this.gbCamel.addActionListener(this);
        panel.add(this.gbCamel);
        panel.add(new Gap(10, 1));
        this.gbFiglet = JaveImages.createButton("figlet", "figlet_");
        this.gbFiglet.setToggleButton(true);
        this.gbFiglet.addActionListener(this);
        panel.add(this.gbFiglet);
        this.gbImage2Ascii = JaveImages.createButton("bmp", "bmp_");
        if (this.systemCapabilities.canSave) {
            this.gbImage2Ascii.addActionListener(this);
        } else {
            this.gbImage2Ascii.setEnabled(false);
        }
        this.gbImage2Ascii.setToggleButton(true);
        panel.add(this.gbImage2Ascii);
        this.gbClipartDialog = JaveImages.createButton("clipart", "clipart_");
        if (this.systemCapabilities.canSave) {
            this.gbClipartDialog.addActionListener(this);
        } else {
            this.gbClipartDialog.setEnabled(false);
        }
        this.gbClipartDialog.setToggleButton(true);
        panel.add(this.gbClipartDialog);
        this.gbTextbox = JaveImages.createButton("textbox");
        this.gbTextbox.addActionListener(this);
        panel.add(this.gbTextbox);
        this.gbTextbox.setToggleButton(true);
        this.gbFormula = JaveImages.createButton("formula");
        this.gbFormula.addActionListener(this);
        panel.add(this.gbFormula);
        this.gbFormula.setToggleButton(true);
        panel.add(new Gap(10, 1));
        this.gbZoomMinus = JaveImages.createButton("zoomminus");
        this.gbZoomMinus.addActionListener(this);
        this.gbZoomPlus = JaveImages.createButton("zoomplus");
        this.gbZoomPlus.addActionListener(this);
        panel.add(this.gbZoomMinus);
        panel.add(this.gbZoomPlus);
        panel.add(new Gap(10, 1));
        this.gbExport = JaveImages.createButton("export");
        this.gbExport.addActionListener(this);
        panel.add(this.gbExport);
        panel.add(new Gap(10, 1));
        this.gbJave = JaveImages.createButton("icon");
        this.gbJave.addActionListener(this);
        panel.add(this.gbJave);
        return panel;
    }

    protected void doSelectionDelete() {
        if (!this.plate.hasSelection()) {
            this.plate.selectAll();
        }
        this.plate.getCurrentTool().setCursor(JaveGlobalRessources.cursorSelection);
        this.plate.unselect();
        this.plate.saveCurrentState("delete");
    }

    protected void doSelectionShrink() {
        if (!this.plate.hasSelection()) {
            this.plate.selectAll();
        }
        this.plate.shrinkSelection();
        this.plate.saveCurrentState("shrink selection");
    }

    protected void doSelectionExpand() {
        if (!this.plate.hasSelection()) {
            return;
        }
        this.plate.expandSelection();
        this.plate.saveCurrentState("expand selection");
    }

    protected void doSelectionToClipart() {
        if (!this.plate.hasSelection()) {
            return;
        }
        CharacterPlate characterPlate = this.plate.getSelectionContent();
        String string = JaveAsciiPacker.encode(characterPlate);
        if (string.length() == 0) {
            return;
        }
        this.addNewClipart(string);
    }

    protected void doSelectionToBrush() {
        if (!this.plate.hasSelection()) {
            return;
        }
        CharacterPlate characterPlate = this.getContentOfInterest().getContent();
        if (characterPlate.getWidth() > 10 || characterPlate.getHeight() > 8 || characterPlate.getHeight() * characterPlate.getWidth() > 35) {
            new GDialog((Frame)this, "JavE", "The selection is too big.\nIt can not be used as a brush.", 3).show();
            return;
        }
        this.setTool(14);
        ((BrushTool)this.plate.getCurrentTool()).setBrush(characterPlate);
    }

    public void doReplaceCharacter() {
        if (this.replaceCharacterDialog == null) {
            this.replaceCharacterDialog = new ReplaceCharacterDialog(this);
            GuiTools.centerOnScreen(this.replaceCharacterDialog);
        }
        this.replaceCharacterDialog.show();
    }

    public void showStatus(String string) {
        this.status.showStatus(string);
    }

    public void doRepairIllegalReplace() {
        JaveSelection javeSelection = this.getContentOfInterest();
        if (javeSelection == null) {
            return;
        }
        int[] nArray = AsciiReplaceIllegal.replaceIllegal(javeSelection, this);
        int n = nArray[0];
        int n2 = nArray[1];
        this.plate.repaint();
        this.plate.saveCurrentState("replace illegal characters");
        if (n == 0) {
            new GDialog((Frame)this, "Replace illegal characters", "There are no illegal characters.", 3).show();
        } else if (n2 == 0) {
            new GDialog((Frame)this, "Replace illegal characters", "Unable to find substitutes for " + n + " illegal characters.", 3).show();
        } else if (n2 < n) {
            if (n == 1) {
                new GDialog((Frame)this, "Replace illegal characters", "Replaced 1 illegal character.\nUnable to find substitutes for the remaining " + (n - n2) + ".", 3).show();
            } else {
                new GDialog((Frame)this, "Replace illegal characters", "Replaced " + n2 + " illegal characters.\nUnable to find substitutes for the remaining " + (n - n2) + ".", 3).show();
            }
        } else if (n == 1) {
            this.status.showStatus("Replaced 1 of " + n + " occurence.");
        } else {
            this.status.showStatus("Replaced " + n2 + " of " + n + " occurrences.");
        }
    }

    public void doRepairIllegalRemove() {
        CharacterPlate characterPlate = this.getContentOfInterest().getContent();
        if (characterPlate == null) {
            return;
        }
        int n = 0;
        int n2 = characterPlate.getHeight();
        int n3 = characterPlate.getWidth();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                if (!CharacterSets.isLegal(characterPlate.get(n5, n4))) {
                    characterPlate.setForce(n5, n4, ' ');
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        if (n == 0) {
            new GDialog((Frame)this, "Remove illegal characters", "There are no illegal characters.", 3).show();
        } else if (n == 1) {
            this.status.showStatus("Removed 1 occurence.");
        } else {
            this.status.showStatus("Removed " + n + " occurrences.");
        }
        this.plate.repaint();
        this.plate.saveCurrentState("remove illegal characters");
    }

    public void applyAlgorithm(JaveAlgorithm javeAlgorithm) {
        if (javeAlgorithm instanceof JaveOptionsAlgorithm) {
            this.applyAlgorithm((JaveOptionsAlgorithm)javeAlgorithm);
            return;
        }
        JaveSelection javeSelection = this.getContentOfInterest();
        int n = javeSelection.getWidth();
        int n2 = javeSelection.getHeight();
        javeSelection = javeAlgorithm.apply(javeSelection);
        this.plate.setContentOfInterest(javeSelection);
        if (n != javeSelection.getWidth() || n2 != javeSelection.getHeight()) {
            this.plateSizeChanged();
            this.plate.getScrollPanel().doLayout();
        }
        this.plate.getCurrentTool().checkSize();
        this.plate.repaint();
        this.plate.saveCurrentState(javeAlgorithm.getActionName());
    }

    public void applyAlgorithm(JaveOptionsAlgorithm javeOptionsAlgorithm) {
        JaveOptionsAlgorithmDialog javeOptionsAlgorithmDialog = new JaveOptionsAlgorithmDialog(this, javeOptionsAlgorithm);
        javeOptionsAlgorithmDialog.show();
    }

    public void doExit() {
        Serializable serializable;
        Object object;
        if (this.movieEditor != null && this.movieEditor.isVisible()) {
            this.movieEditor.toFront();
            if (!this.movieEditor.doExit()) {
                return;
            }
        }
        Document document = this.documentManager.getCurrentDocument();
        while (document != null) {
            if (!document.isModified()) {
                this.documentManager.closeCurrentDocument();
                document = this.documentManager.getCurrentDocument();
                this.plate.setDocument(document);
                this.updateUndoRedo();
                this.updateWindowsMenu();
                this.updateFrameTitle();
                continue;
            }
            object = "Document " + document.getTitle() + " has been modified.\n" + "Do you want to save changes?";
            serializable = new GDialog((Frame)this, "JavE", (String)object, GDialog.YES_NO_CANCEL, 2);
            ((Dialog)serializable).show();
            int n = ((GDialog)serializable).getAnswer();
            if (n == -1 || n == 2) {
                return;
            }
            if (n == 0 && (n = document.hasFileName() ? this.doSave() : this.doSaveAs()) == -1) {
                return;
            }
            this.documentManager.closeCurrentDocument();
            document = this.documentManager.getCurrentDocument();
            this.plate.setDocument(document);
            this.updateUndoRedo();
            this.updateWindowsMenu();
            this.updateFrameTitle();
        }
        if (!JaveStatusFile.delete()) {
            System.err.println("Unable to delete Status-File!");
        }
        JaveStatusFile.deleteAllLogFiles();
        object = this.getSize();
        serializable = this.getLocation();
        JaveGlobalRessources.getInifile().put("editor", "width", ((Dimension)object).width);
        JaveGlobalRessources.getInifile().put("editor", "height", ((Dimension)object).height);
        JaveGlobalRessources.getInifile().put("editor", "xpos", ((Point)serializable).x);
        JaveGlobalRessources.getInifile().put("editor", "ypos", ((Point)serializable).y);
        serializable = this.optionsDialog.getLocation();
        JaveGlobalRessources.getInifile().put("editor", "xpos_options", ((Point)serializable).x);
        JaveGlobalRessources.getInifile().put("editor", "ypos_options", ((Point)serializable).y);
        JaveGlobalRessources.saveInifile();
        this.dispose();
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void doNew() {
        Document document = this.documentManager.createNew();
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void updateStatusFile() {
        JaveStatusFile.saveLog(this.documentManager);
    }

    public int doClose() {
        Document document = this.documentManager.getCurrentDocument();
        if (document.isMovieDocument()) {
            new GDialog((Frame)this, "JavE", "You can not close the current document.\nIt belongs to the movie editor.\nClose the movie editor instead.", 3).show();
            return -1;
        }
        if (!document.isModified()) {
            this.documentManager.closeCurrentDocument();
            this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
            this.updateStatusFile();
            return 0;
        }
        String string = "Document " + document.getTitle() + " has been modified.\n" + "Do you want to save changes?";
        GDialog gDialog = new GDialog((Frame)this, "JavE", string, GDialog.YES_NO_CANCEL, 2);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == -1 || n == 2) {
            return -1;
        }
        if (n == 1) {
            document.setModified(false);
            this.doClose();
            return 0;
        }
        if (document.hasFileName()) {
            n = this.doSave();
            if (n == -1) {
                return -1;
            }
            return this.doClose();
        }
        n = this.doSaveAs();
        if (n == -1) {
            return -1;
        }
        return this.doClose();
    }

    public int doCloseAll() {
        Document document = this.documentManager.getCurrentDocument();
        int n = 0;
        while (document != null && n != -1) {
            n = this.doClose();
            document = this.documentManager.getCurrentDocument();
            if (n != -1) continue;
            return -1;
        }
        return n;
    }

    void close(Document document) {
        int n = this.documentManager.getIndexOf(document);
        if (n < 0) {
            return;
        }
        this.documentManager.closeDocument(n);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    protected void doSelectionBraces() {
        if (!this.plate.hasSelection()) {
            return;
        }
        BraceLocationDialog braceLocationDialog = new BraceLocationDialog(this);
        int n = braceLocationDialog.getBraceLocation();
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.plate.getSelectionRegion();
        this.plate.dropSelection();
        switch (n) {
            case 0: {
                this.bracesTop(rectangle);
                break;
            }
            case 2: {
                this.bracesLeft(rectangle);
                break;
            }
            case 3: {
                this.bracesRight(rectangle);
                break;
            }
            case 1: {
                this.bracesBottom(rectangle);
            }
        }
    }

    protected void bracesRight(Rectangle rectangle) {
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y;
        int n3 = 2;
        int n4 = rectangle.height;
        CharacterPlate characterPlate = new CharacterPlate(n3, n4);
        if (n4 == 1) {
            characterPlate.setForce(0, 0, '}');
        } else {
            characterPlate.setForce(0, 0, '\\');
            characterPlate.setForce(0, n4 - 1, '/');
            if (n4 >= 5) {
                int n5 = 1;
                while (n5 < n4 - 1) {
                    characterPlate.setForce(0, n5, '|');
                    ++n5;
                }
            }
            if (n4 == 2) {
                characterPlate.setForce(1, 0, '_');
            } else if (n4 == 3) {
                characterPlate.setForce(1, 1, '>');
            } else if (n4 == 4) {
                characterPlate.setForce(1, 1, '_');
                characterPlate.setForce(0, 1, '|');
                characterPlate.setForce(0, 2, '|');
            } else {
                characterPlate.setForce(1, (n4 - 1) / 2, '>');
                characterPlate.setForce(0, (n4 - 1) / 2, ' ');
            }
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        this.plate.setSelection(rectangle2, characterPlate);
        this.plate.saveCurrentState("brace right");
    }

    protected void bracesLeft(Rectangle rectangle) {
        int n = rectangle.x - 2;
        int n2 = rectangle.y;
        int n3 = 2;
        int n4 = rectangle.height;
        CharacterPlate characterPlate = new CharacterPlate(n3, n4);
        if (n4 == 1) {
            characterPlate.setForce(1, 0, '{');
        } else {
            characterPlate.setForce(1, 0, '/');
            characterPlate.setForce(1, n4 - 1, '\\');
            if (n4 >= 5) {
                int n5 = 1;
                while (n5 < n4 - 1) {
                    characterPlate.setForce(1, n5, '|');
                    ++n5;
                }
            }
            if (n4 == 2) {
                characterPlate.setForce(0, 0, '_');
            } else if (n4 == 3) {
                characterPlate.setForce(0, 1, '<');
            } else if (n4 == 4) {
                characterPlate.setForce(0, 1, '_');
                characterPlate.setForce(1, 1, '|');
                characterPlate.setForce(1, 2, '|');
            } else {
                characterPlate.setForce(0, (n4 - 1) / 2, '<');
                characterPlate.setForce(1, (n4 - 1) / 2, ' ');
            }
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        this.plate.setSelection(rectangle2, characterPlate);
        this.plate.saveCurrentState("brace left");
    }

    protected void bracesTop(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y - 2;
        int n3 = rectangle.width;
        int n4 = 2;
        CharacterPlate characterPlate = new CharacterPlate(n3, n4);
        if (n3 == 1) {
            characterPlate.setForce(0, 1, '^');
        } else {
            characterPlate.setForce(0, 1, '/');
            characterPlate.setForce(n3 - 1, 1, '\\');
            if (n3 > 5) {
                int n5 = 1;
                while (n5 < n3 - 1) {
                    characterPlate.setForce(n5, 0, '_');
                    ++n5;
                }
                characterPlate.setForce(n3 / 2 - 1, 0, '/');
                characterPlate.setForce(n3 / 2, 0, '\\');
            } else if (n3 == 3) {
                characterPlate.setForce(1, 0, '|');
            } else if (n3 == 4) {
                characterPlate.setForce(1, 0, '|');
                characterPlate.setForce(2, 0, '_');
            } else if (n3 == 5) {
                characterPlate.setForce(1, 0, '_');
                characterPlate.setForce(2, 0, '|');
                characterPlate.setForce(3, 0, '_');
            }
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        this.plate.setSelection(rectangle2, characterPlate);
        this.plate.saveCurrentState("brace top");
    }

    protected void bracesBottom(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.width;
        int n4 = 2;
        CharacterPlate characterPlate = new CharacterPlate(n3, n4);
        if (n3 == 1) {
            characterPlate.setForce(0, 0, 'V');
        } else {
            characterPlate.setForce(0, 0, '\\');
            characterPlate.setForce(n3 - 1, 0, '/');
            if (n3 > 5) {
                int n5 = 1;
                while (n5 < n3 - 1) {
                    characterPlate.setForce(n5, 0, '_');
                    ++n5;
                }
                characterPlate.setForce(n3 / 2 - 1, 1, '\\');
                characterPlate.setForce(n3 / 2, 1, '/');
                characterPlate.setForce(n3 / 2 - 1, 0, ' ');
                characterPlate.setForce(n3 / 2, 0, ' ');
            } else if (n3 == 3) {
                characterPlate.setForce(1, 0, '_');
                characterPlate.setForce(1, 1, '|');
            } else if (n3 == 4) {
                characterPlate.setForce(2, 0, '_');
                characterPlate.setForce(1, 0, '_');
                characterPlate.setForce(1, 1, '|');
            } else if (n3 == 5) {
                characterPlate.setForce(1, 0, '_');
                characterPlate.setForce(2, 0, '_');
                characterPlate.setForce(3, 0, '_');
                characterPlate.setForce(2, 1, '|');
            }
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        this.plate.setSelection(rectangle2, characterPlate);
        this.plate.saveCurrentState("brace bottom");
    }

    protected boolean isEmpty() {
        return this.plate.isEmpty();
    }

    protected void doCrop() {
        if (this.plate.hasSelection()) {
            this.plate.crop();
            this.plate.saveCurrentState("crop");
            this.switchToTextTool(0, 0);
        } else {
            if (this.isEmpty()) {
                new GDialog((Frame)this, "JavE", "The current document is empty.\nThe selected action will not be applied.", 3).show();
                return;
            }
            this.plate.crop();
            this.plate.saveCurrentState("crop");
        }
    }

    public boolean openRecentFile(File file) {
        return this.open(file.getParent(), file.getName());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.plate.requestFocus();
        Object object = actionEvent.getSource();
        if (object == this.gbClear) {
            this.doNew();
            return;
        }
        if (object == this.gbExport) {
            this.result();
            return;
        }
        if (object == this.gbBrowse) {
            this.doBrowse();
            return;
        }
        if (object == this.gbUndo) {
            this.doUndo();
            return;
        }
        if (object == this.gbRedo) {
            this.doRedo();
            return;
        }
        if (object == this.gbOpen) {
            this.doOpen();
            return;
        }
        if (object == this.gbSave) {
            this.doSave();
            return;
        }
        if (object == this.gbZoomPlus) {
            this.doZoomPlus();
            return;
        }
        if (object == this.gbZoomMinus) {
            this.doZoomMinus();
            return;
        }
        if (object == this.gbResize || object == this.lSize) {
            this.doResize();
            return;
        }
        if (object == this.gbFiglet) {
            this.setFigletDialogVisible(this.gbFiglet.isLocked());
            return;
        }
        if (object == this.gbCamel) {
            this.doCamel();
            return;
        }
        if (object == this.gbMovie) {
            this.doShowMovieEditor();
            return;
        }
        if (object == this.gbImage2Ascii) {
            this.setImage2AsciiDialogVisible(this.gbImage2Ascii.isLocked());
            return;
        }
        if (object == this.gbClipartDialog) {
            this.setClipartDialogVisible(this.gbClipartDialog.isLocked());
            return;
        }
        if (object == this.gbFormula) {
            this.setFormulaDialogVisible(this.gbFormula.isLocked());
            return;
        }
        if (object == this.lInsert) {
            this.toggleInsert();
        } else if (object == this.gbCut) {
            this.doCut();
        } else if (object == this.gbCopy) {
            this.doCopy();
        } else if (object == this.gbPaste) {
            this.doPaste();
        } else {
            if (object == this.gbTextbox) {
                this.setTextboxDialogVisible(this.gbTextbox.isLocked());
                return;
            }
            if (object == this.gbJave) {
                this.showAboutDialog();
            } else {
                System.err.println("JavE: source unknown in actionPerformed!" + object);
            }
        }
    }

    public void editTextBox(String string, Point point, int n) {
        if (this.textboxDialog == null) {
            this.textboxDialog = new TextboxDialog(this, string, point);
            GuiTools.centerOnScreen(this.textboxDialog);
        } else {
            this.textboxDialog.setContent(string);
            this.textboxDialog.setLocation(point);
        }
        this.textboxDialog.setTextboxStyle(n);
        this.textboxDialog.show();
    }

    public void showAboutDialog() {
        Object object;
        Object object2;
        Label label = new Label(TITLE, 1);
        label.setFont(JaveGlobalRessources.FONT_BOLD);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label("JavE Homepage:", 2));
        panel.add(new GHyperlink(JAVE_URL, 0));
        panel.add(new Label("Author:", 2));
        panel.add(new Label("Markus Gebhard", 0));
        panel.add(new Label("EMail:", 2));
        panel.add(new GHyperlink("mailto:markus@jave.de?subject=jave", "markus@jave.de", 0));
        try {
            object2 = System.getProperty("os.name");
            if (object2 == null) {
                object2 = "n/a";
            }
            panel.add(new Label("Operating System:", 2));
            panel.add(new Label((String)object2, 0));
            object = System.getProperty("java.vendor");
            if (object == null) {
                object = "n/a";
            }
            panel.add(new Label("Java Vendor:", 2));
            panel.add(new Label((String)object, 0));
            String string = System.getProperty("java.version");
            if (string == null) {
                string = "n/a";
            }
            panel.add(new Label("Java Version:", 2));
            panel.add(new Label(string, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        panel.add(new Label("Codebase:", 2));
        panel.add(new Label(JaveGlobalRessources.codeBase, 0));
        object2 = new Panel();
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)panel, "Center");
        ((Container)object2).add((Component)label, "North");
        object = new AboutWindow(this, (Component)object2);
        ((Window)object).show();
    }

    public void doFigletExportAssistant() {
        if (this.figletExportAssistant == null) {
            this.figletExportAssistant = new FigletExportAssistant(this, this.plate);
        }
        this.figletExportAssistant.show();
    }

    protected final JaveClipboardSelection getClipboardContent() {
        if (this.systemCapabilities.canUseSystemClipboard) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                Transferable transferable = clipboard.getContents(this);
                if (transferable == null) {
                    return null;
                }
                if (transferable instanceof JaveClipboardSelection) {
                    return (JaveClipboardSelection)transferable;
                }
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (string.indexOf(9) != -1) {
                    return new JaveClipboardSelection(CharacterPlate.tabelize(string));
                }
                return new JaveClipboardSelection(string);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.pseudoClipboard;
    }

    protected final void setClipboardContent(JaveClipboardSelection javeClipboardSelection) {
        if (this.systemCapabilities.canUseSystemClipboard) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(javeClipboardSelection, this);
        } else {
            this.pseudoClipboard = javeClipboardSelection;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void doPaste() {
        JaveClipboardSelection javeClipboardSelection = this.getClipboardContent();
        if (javeClipboardSelection != null) {
            this.pasteAsNewSelection(javeClipboardSelection);
        }
    }

    public void doPasteAsNewDocument() {
        JaveClipboardSelection javeClipboardSelection = this.getClipboardContent();
        if (javeClipboardSelection != null) {
            this.pasteAsNewDocument(javeClipboardSelection.content);
        }
    }

    public void pasteClipart(String string) {
        this.pasteAsNewSelection(JaveAsciiPacker.decode(string));
    }

    public void doCopy() {
        JaveClipboardSelection javeClipboardSelection = null;
        javeClipboardSelection = this.plate.hasSelection() ? new JaveClipboardSelection(this.plate.getSelection().getContent(), this.plate.getSelection().getMask()) : new JaveClipboardSelection(this.plate.getContent());
        this.setClipboardContent(javeClipboardSelection);
    }

    public void doCut() {
        JaveClipboardSelection javeClipboardSelection = null;
        if (!this.plate.hasSelection()) {
            javeClipboardSelection = new JaveClipboardSelection(this.plate.getContent());
            this.plate.clear();
        } else {
            javeClipboardSelection = new JaveClipboardSelection(this.plate.getSelection().getContent(), this.plate.getSelection().getMask());
            this.plate.unselect();
            this.plate.getCurrentTool().setCursor(JaveGlobalRessources.cursorSelection);
        }
        this.setClipboardContent(javeClipboardSelection);
        this.plate.saveCurrentState("cut");
    }

    public void toggleGridVisible() {
        this.toolBar.toggleGridVisible();
    }

    public boolean isGridVisible() {
        return this.toolBar.isGridVisible();
    }

    public void setGridVisible(boolean bl) {
        this.toolBar.setGridVisible(bl);
    }

    public void updateUndoRedo() {
        boolean bl = this.plate.canUndo();
        boolean bl2 = this.plate.canRedo();
        String string = null;
        String string2 = null;
        if (bl) {
            string = this.plate.getUndoActionName();
        }
        if (bl2) {
            string2 = this.plate.getRedoActionName();
        }
        if (this.menuBar != null) {
            this.menuBar.updateUndoRedoMenu(bl, string, bl2, string2);
        }
        this.gbUndo.setEnabled(bl);
        this.gbRedo.setEnabled(bl2);
    }

    public void doRedo() {
        this.plate.redo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.plate.requestFocus();
    }

    public void doUndo() {
        this.plate.undo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.plate.requestFocus();
    }

    public void doDebugFonts() {
        String string = Fonts.debugLinux();
        GTextArea gTextArea = new GTextArea(string);
        gTextArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        new GDialog((Frame)this, "JavE", "Debug information", gTextArea).show();
    }

    public void doDebugCrash() {
        GDialog gDialog = new GDialog((Frame)this, "JavE", "Crashing is not fun!!", "Do you really want the program\nto crash now?", GDialog.YES_NO_CANCEL, 5);
        gDialog.show();
        if (gDialog.getAnswer() != 0) {
            return;
        }
        System.err.println("===============================================");
        System.err.println("By your personal demand:");
        System.err.println("JavE is now crashing w/o doing all the cleanup!");
        System.err.println(" - Good bye.");
        System.err.println("===============================================");
        System.exit(1);
    }

    public void doDecodeSteganogram() {
        SteganogramDecoder steganogramDecoder = new SteganogramDecoder(this);
        steganogramDecoder.show();
    }

    public void doDoc2Watermark() {
        if (this.plate.hasSelection()) {
            this.plate.dropSelection();
        }
        CharacterPlate characterPlate = this.getContentOfInterest().getContent();
        Font font = this.plate.getFont();
        Image image = AsciiToThumbnailConverter.convert(characterPlate, font.getSize(), font, JaveGlobalRessources.colorPlateBackground, JaveGlobalRessources.colorText, this.isPixelView());
        characterPlate.clear();
        this.setContentOfInterest(characterPlate);
        this.plate.saveCurrentState("clear content");
        this.setWatermarkImage(image, "");
    }

    public void setWatermarkImage(Image image) {
        this.setWatermarkImage(image, "");
    }

    public void setWatermarkImage(Image image, String string) {
        this.setTool(19);
        WatermarkTool watermarkTool = (WatermarkTool)this.plate.getTool(19);
        watermarkTool.setImage(image, string);
        watermarkTool.fit();
        this.toolBar.setWatermarkVisible(true);
    }

    public boolean isPixelView() {
        return this.toolBar.isPixelView();
    }

    public void plateSizeChanged() {
        if (this.lSize == null) {
            return;
        }
        Document document = this.plate.getDocument();
        if (document == null) {
            this.lSize.setText("");
        } else {
            this.lSize.setText(this.plate.getDocumentWidth() + "x" + this.plate.getDocumentHeight());
        }
    }

    protected void doResize() {
        if (!this.plate.hasDocument()) {
            return;
        }
        GBorderedPanel gBorderedPanel = new GBorderedPanel("New size");
        gBorderedPanel.setLayout(new GridLayout(2, 0, 2, 2));
        gBorderedPanel.add(new GLabel("Width:", 2));
        IntegerTextField integerTextField = new IntegerTextField(this.plate.getDocumentWidth());
        gBorderedPanel.add(new GUpDownArrangement(integerTextField));
        gBorderedPanel.add(new GLabel("Height:", 2));
        IntegerTextField integerTextField2 = new IntegerTextField(this.plate.getDocumentHeight());
        gBorderedPanel.add(new GUpDownArrangement(integerTextField2));
        GDialog gDialog = new GDialog((Frame)this, "Resize plate", (Component)gBorderedPanel, GDialog.OK_CANCEL);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n != 0) {
            return;
        }
        int n2 = integerTextField.getValue();
        int n3 = integerTextField2.getValue();
        if (n2 == this.plate.getDocumentWidth() && n3 == this.plate.getDocumentHeight()) {
            return;
        }
        this.plate.setPlateSize(n2, n3);
        this.plate.saveCurrentState("resize plate");
    }

    protected void result() {
        String string = "";
        string = this.plate.hasSelection() ? this.plate.getSelectionContent().toString() : this.plate.getContent().toString();
        ResultDialog resultDialog = new ResultDialog(this, string, JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
    }

    protected int doSaveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save ASCII File", 1);
        String string = this.documentManager.getCurrentDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.setFile("*.txt");
        fileDialog.show();
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 == null) {
            return -1;
        }
        this.documentManager.setCurrentDirectory(string3);
        Document document = this.documentManager.getCurrentDocument();
        document.setFileName(string3 + string2);
        int n = this.doSave();
        if (n == 0) {
            this.menuBar.setRevertEnabled(true);
        } else {
            document.setFileName(null);
        }
        return n;
    }

    protected int doSave() {
        Document document = this.plate.getDocument();
        if (!document.hasFileName()) {
            return this.doSaveAs();
        }
        this.plate.getCurrentTool().prepareForSave();
        try {
            document.save();
            this.updateFrameTitle();
            this.status.showStatus("File saved.");
            return 0;
        }
        catch (IOException iOException) {
            new GDialog((Frame)this, "JavE", "Error saving file", "Unable to save file:\n" + iOException.toString(), 0).show();
            return -1;
        }
    }

    protected void doSaveAll() {
        int n = this.documentManager.getSize();
        int n2 = this.documentManager.getCurrentDocumentIndex();
        int n3 = 0;
        while (n3 < n) {
            Document document = this.documentManager.getDocument(n3);
            if (document.isModified() && document.hasFileName()) {
                this.setCurrentDocument(n3);
                this.plate.getCurrentTool().prepareForSave();
                try {
                    document.save();
                }
                catch (IOException iOException) {
                    new GDialog((Frame)this, "JavE", "Error saving file", "Unable to save file:\n" + iOException.toString(), 0).show();
                    return;
                }
            }
            ++n3;
        }
        this.setCurrentDocument(n2);
        this.updateFrameTitle();
        this.status.showStatus("Files saved.");
    }

    public void doShowMovieEditor() {
        if (this.movieEditor != null) {
            this.movieEditor.setVisible(true);
            this.movieEditor.toFront();
            return;
        }
        if (this.plate.getDocument() == null) {
            this.doNew();
        }
        this.movieEditor = new JaveMovieEditor(this, this.plate.getDocument());
        this.movieEditor.setVisible(true);
        this.movieEditor.toFront();
    }

    public void doBrowse() {
        if (this.thumbnailBrowser != null) {
            this.thumbnailBrowser.setVisible(true);
        } else {
            this.thumbnailBrowser = new AsciiThumbnailBrowser(this);
            this.thumbnailBrowser.show();
        }
    }

    protected void doExportToMovie() {
        Object object;
        Document document = this.documentManager.getCurrentDocument();
        if (!document.isLogging()) {
            return;
        }
        String string = document.getLogFileName();
        if (!new File(string).exists()) {
            new GDialog((Frame)this, "JavE - Export 'making of'", "The current document has not been edited.", 3).show();
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Export to JavE Movie File", 1);
        String string2 = this.documentManager.getCurrentDirectory();
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.setFile(this.plate.getDocument().getTitle() + ".jmov");
        fileDialog.show();
        String string3 = fileDialog.getFile();
        String string4 = fileDialog.getDirectory();
        if (string3 == null) {
            return;
        }
        String string5 = string4 + string3;
        CompressedDocumentState[] compressedDocumentStateArray = JaveLogFile.load(new File(string));
        if (compressedDocumentStateArray == null) {
            new GErrorDialog((Frame)this, "JavE", "Error exporting to 'making of'.", "Error reading logfile.").show();
            return;
        }
        JaveMovieFile javeMovieFile = new JaveMovieFile(string5);
        javeMovieFile.setAuthor(JaveGlobalRessources.getInifile().getString("Personal", "name", ""));
        javeMovieFile.setEMail(JaveGlobalRessources.getInifile().getString("Personal", "mail", ""));
        javeMovieFile.setDate(Toolbox.getDateString());
        javeMovieFile.setTitle(string3);
        javeMovieFile.setSoftware("JavE 5.0 - Making of");
        int n = 0;
        while (n < compressedDocumentStateArray.length) {
            object = new JaveMovieFrame();
            if (compressedDocumentStateArray[n].hasSelection()) {
                Object object2;
                Object object3;
                Object object4;
                CharacterPlate characterPlate = new CharacterPlate(compressedDocumentStateArray[n].getContent());
                if (compressedDocumentStateArray[n].hasSelectionMask()) {
                    object4 = compressedDocumentStateArray[n].getSelectionMask();
                    object3 = compressedDocumentStateArray[n].getSelectionContent();
                    object2 = compressedDocumentStateArray[n].getSelectionLocation();
                    Selection selection = new Selection();
                    selection.set((Point)object2, (char[][])object3, (BooleanPlate)object4);
                    selection.pasteIntoNormal(characterPlate);
                } else {
                    object4 = compressedDocumentStateArray[n].getSelectionContent();
                    object3 = compressedDocumentStateArray[n].getSelectionLocation();
                    object2 = new Selection();
                    ((Selection)object2).set((Point)object3, new CharacterPlate((char[][])object4));
                    ((Selection)object2).pasteIntoNormal(characterPlate);
                }
                ((JaveMovieFrame)object).setContent(JaveAsciiPacker.encodeOptimized(characterPlate));
            } else {
                ((JaveMovieFrame)object).setContent(compressedDocumentStateArray[n].getPackedContent());
            }
            if (n + 1 < compressedDocumentStateArray.length) {
                ((JaveMovieFrame)object).setDuration(compressedDocumentStateArray[n + 1].getDuration());
            }
            ((JaveMovieFrame)object).setScrollX(compressedDocumentStateArray[n].getScrollX());
            ((JaveMovieFrame)object).setScrollY(compressedDocumentStateArray[n].getScrollY());
            ((JaveMovieFrame)object).setCursorX(compressedDocumentStateArray[n].getCursorX());
            ((JaveMovieFrame)object).setCursorY(compressedDocumentStateArray[n].getCursorY());
            ((JaveMovieFrame)object).setTool(compressedDocumentStateArray[n].getToolName());
            ((JaveMovieFrame)object).setAction(compressedDocumentStateArray[n].getAction());
            ((JaveMovieFrame)object).setForeground(JaveGlobalRessources.COLOR_TEXT[compressedDocumentStateArray[n].getColorScheme()]);
            ((JaveMovieFrame)object).setBackground(JaveGlobalRessources.COLOR_PLATE_BACKGROUND[compressedDocumentStateArray[n].getColorScheme()]);
            javeMovieFile.add((JaveMovieFrame)object);
            ++n;
        }
        try {
            javeMovieFile.save();
        }
        catch (Exception exception) {
            new GErrorDialog((Frame)this, "JavE", "Error exporting to 'making of'.", exception).show();
            return;
        }
        object = new GDialog((Frame)this, "JavE", "JavE Movie saved", "Do you want to open the saved\nfile in the movie editor?", GDialog.YES_NO_CANCEL, 1);
        ((Dialog)object).show();
        if (((GDialog)object).getAnswer() == 0) {
            this.open(string4, string3);
        }
    }

    protected void doZoomPlus() {
        this.plate.zoomIn();
    }

    protected void doZoomMinus() {
        this.plate.zoomOut();
    }

    protected void doRevert() {
        Document document = this.documentManager.getCurrentDocument();
        GDialog gDialog = new GDialog((Frame)this, "JavE", "Lose all changes since your last save?", GDialog.OK_CANCEL, 1);
        gDialog.show();
        if (gDialog.getAnswer() == 0) {
            document.setModified(false);
            File file = new File(document.getFileName());
            this.doClose();
            String string = file.getParent();
            String string2 = file.getName();
            this.open(string, string2);
        }
    }

    protected void doOpen() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open ASCII File / GIF / JPG / BMP / JMOV-animation", 0);
        String string = this.documentManager.getCurrentDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 == null) {
            return;
        }
        this.open(string3, string2);
    }

    public boolean open(String string, String string2) {
        String string3 = string2.toLowerCase();
        if (string3.endsWith(".jmov") || string3.endsWith(".zip")) {
            if (this.movieEditor != null && !this.movieEditor.doExit()) {
                return false;
            }
            this.movieEditor = new JaveMovieEditor(this);
            boolean bl = this.movieEditor.open(string, string2);
            this.movieEditor.setVisible(true);
            this.movieEditor.toFront();
            return bl;
        }
        if (string3.endsWith(".bmp") || string3.endsWith(".gif") || string3.endsWith(".jpg") || string3.endsWith(".jpeg")) {
            boolean bl;
            if (this.image2AsciiDialog == null) {
                this.image2AsciiDialog = new Image2AsciiDialog(this);
                this.image2AsciiDialog.pack();
                GuiTools.centerOnScreen(this.image2AsciiDialog);
            }
            if (bl = this.image2AsciiDialog.open(string, string2)) {
                this.image2AsciiDialog.show();
            }
            return bl;
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (this.documentManager.isAlreadyOpen(string, string2)) {
            new GDialog((Frame)this, "JavE", "The selected file is already loaded.", 3).show();
            return true;
        }
        try {
            Document document = this.documentManager.load(string, string2);
            this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
            document.undoManager.getLogFile().append(this.plate.getDocumentState(null));
            this.updateStatusFile();
            this.status.showStatus("File loaded.");
            return true;
        }
        catch (IOException iOException) {
            new GErrorDialog((Frame)this, "JavE", "Error loading file:\n" + iOException.toString(), iOException).show();
            this.status.showStatus("Error loading File: " + iOException);
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            new GErrorDialog((Frame)this, "JavE", "Error loading file", "The file is either to big\nor there is not enough memory.").show();
            this.status.showStatus("Error loading File: " + outOfMemoryError);
            return false;
        }
    }

    protected JaveSelection getContentOfInterest() {
        return this.plate.getContentOfInterest();
    }

    protected void setContentOfInterest(CharacterPlate characterPlate) {
        if (this.plate.hasSelection()) {
            this.plate.setSelectionContent(characterPlate);
        } else {
            this.plate.setContent(characterPlate);
        }
        this.plate.getCurrentTool().checkSize();
    }

    protected void setContentOfInterest(JaveSelection javeSelection) {
        this.plate.setContentOfInterest(javeSelection);
        this.plate.getCurrentTool().checkSize();
    }

    protected void doRepairShaked() {
        CharacterPlate characterPlate = this.getContentOfInterest().getContent();
        Dialog dialog = new Dialog(this, "JavE", false);
        dialog.setLayout(new FlowLayout());
        dialog.add(new Label("Please Wait..."));
        dialog.pack();
        GuiTools.centerOnScreen(dialog);
        dialog.show();
        CharacterPlate characterPlate2 = AsciiRepairAlgorithm.repairShaked(characterPlate);
        dialog.dispose();
        if (characterPlate2 == null) {
            return;
        }
        this.setContentOfInterest(characterPlate2);
        this.plate.repaint();
        this.plate.saveCurrentState("repair");
    }

    protected void doFractal() {
        FractalTool fractalTool = new FractalTool(this, this.plate);
        fractalTool.show();
    }

    protected void doRender3D() {
        Render3DTool render3DTool = new Render3DTool(this, this.plate);
        render3DTool.show();
    }

    protected void doFunctionPlotter() {
        FunctionPlotTool functionPlotTool = new FunctionPlotTool(this, this.plate);
        functionPlotTool.show();
    }

    protected void doAscTris() {
        AscTris ascTris = new AscTris(this);
    }

    protected void doLabyrinth() {
        Labyrinth labyrinth = new Labyrinth(this);
    }

    protected void doAscii2Gif() {
        Document document = this.plate.getDocument();
        if (document == null) {
            return;
        }
        Ascii2GIFDialog ascii2GIFDialog = new Ascii2GIFDialog(this, document, JaveGlobalRessources.getColorScheme());
        ascii2GIFDialog.pack();
        ascii2GIFDialog.show();
    }

    protected void doCamel() {
        CharacterPlate characterPlate = this.getContentOfInterest().getContent();
        if (characterPlate.getNonEmptyCharCount() < 12) {
            new GDialog((Frame)this, "JavE", "The current document does not contain enough text.\nThe Camelizer can not be applied.", 3).show();
            return;
        }
        if (this.camelDialog == null) {
            this.camelDialog = new CamelDialog(this);
        }
        this.camelDialog.setSourceText(characterPlate);
        this.camelDialog.show();
    }

    public void setColorScheme(int n) {
        int n2;
        if (n == JaveGlobalRessources.getColorScheme()) {
            this.menuBar.updateColorMenu();
            return;
        }
        JaveGlobalRessources.setColorScheme(n);
        Document document = this.plate.getDocument();
        if (document != null && (n2 = document.getColorScheme()) != n) {
            document.setColorScheme(n);
            this.plate.saveCurrentState("change color");
        }
        this.plate.repaint();
        this.menuBar.updateColorMenu();
    }

    public final void beep() {
        this.getToolkit().beep();
    }

    public void doPreviousDocument() {
        int n = this.documentManager.getCurrentDocumentIndex() - 1;
        if (n < 0) {
            n = this.documentManager.getSize() - 1;
        }
        this.setCurrentDocument(n);
    }

    public void doNextDocument() {
        int n = this.documentManager.getCurrentDocumentIndex() + 1;
        if (n >= this.documentManager.getSize()) {
            n = 0;
        }
        this.setCurrentDocument(n);
    }

    public void setCurrentDocument(int n) {
        Document document = this.plate.getDocument();
        if (document != null) {
            document.documentHiding();
        }
        if (n < 0 || n >= this.documentManager.getSize()) {
            this.plate.setDocument(null);
            this.updateUndoRedo();
            this.updateWindowsMenu();
            this.updateFrameTitle();
            return;
        }
        this.documentManager.setCurrentDocument(n);
        Document document2 = this.documentManager.getCurrentDocument();
        this.plate.setDocument(document2);
        JaveGlobalRessources.setColorScheme(document2.getColorScheme());
        this.updateFrameTitle();
        this.updateWindowsMenu();
        this.updateColorMenu();
        this.updateUndoRedo();
        this.plate.repaint();
        document2.documentShowing();
    }

    public void selectAll() {
        this.plate.selectAll();
        this.switchToSelectonTool();
        this.plate.saveCurrentState("select all");
    }

    public void switchToSelectonTool() {
        this.setTool(12);
        ((SelectionTool)this.plate.getCurrentTool()).synchronizeToSelection();
    }

    public void switchToTextTool(int n, int n2) {
        this.setTool(10);
        ((TextTool)this.plate.getCurrentTool()).setCursorLocation(n, n2);
    }

    public void switchToTextTool(char c, int n, int n2) {
        this.setTool(10);
        TextTool textTool = (TextTool)this.plate.getCurrentTool();
        textTool.setCursorLocation(n, n2);
        textTool.checkSize();
        textTool.charEntered(c);
    }

    public void switchToTextTool() {
        this.setTool(10);
    }

    public SelectionTool getSelectionTool() {
        return (SelectionTool)this.plate.getTool(12);
    }

    public void setTool(int n) {
        if (this.plate.getCurrentToolIndex() == n) {
            return;
        }
        Tool tool = this.plate.getTool(n);
        if (this.optionsDialog != null) {
            this.optionsDialog.setTool(tool);
        }
        this.toolBar.selectToolButton(n);
        this.plate.setCurrentTool(tool);
        this.updateSelectionMenu();
    }

    public char getMouseChar1() {
        return this.cfChar1.getChar();
    }

    public char getMouseChar2() {
        return this.cfChar2.getChar();
    }

    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.cfChar1) {
            this.plate.setMouseChar1(this.cfChar1.getChar());
            return;
        }
        if (object == this.cfChar2) {
            this.plate.setMouseChar2(this.cfChar2.getChar());
            return;
        }
    }

    public Document pasteAsNewDocument(CharacterPlate characterPlate) {
        return this.pasteAsNewDocument(characterPlate, null);
    }

    public Document pasteAsNewDocument(CharacterPlate characterPlate, String string) {
        Document document = this.documentManager.createNew();
        if (string != null) {
            document.setStopgapName(string);
        }
        document.setContent(characterPlate);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
        return document;
    }

    public void pasteAsNewSelection(CharacterPlate characterPlate, int n, int n2) {
        this.pasteAsNewSelection(characterPlate, new Point(n, n2));
    }

    public void pasteAsNewSelection(CharacterPlate characterPlate, Point point) {
        if (this.plate.getDocument() == null) {
            this.pasteAsNewDocument(characterPlate);
            return;
        }
        this.plate.pasteAsNewSelection(characterPlate, point);
        this.switchToSelectonTool();
        this.updateSelectionMenu();
        this.plate.saveCurrentState("paste");
    }

    public void pasteAsNewSelection(JaveClipboardSelection javeClipboardSelection, Point point) {
        if (this.plate.getDocument() == null) {
            this.pasteAsNewDocument(javeClipboardSelection.content);
            return;
        }
        this.plate.pasteAsNewSelection(javeClipboardSelection, point);
        this.switchToSelectonTool();
        this.updateSelectionMenu();
        this.plate.saveCurrentState("paste");
    }

    public void setAsSelection(String string) {
        if (!this.plate.hasSelection()) {
            this.pasteAsNewSelection(string);
            return;
        }
        this.plate.setSelectionContent(new CharacterPlate(string));
        this.switchToSelectonTool();
    }

    public void pasteAsNewSelection(JaveClipboardSelection javeClipboardSelection) {
        this.pasteAsNewSelection(javeClipboardSelection, this.plate.getPasteLocation());
    }

    public void pasteAsNewSelection(CharacterPlate characterPlate) {
        this.pasteAsNewSelection(characterPlate, this.plate.getPasteLocation());
    }

    public void pasteAsNewSelection(char[][] cArray) {
        this.pasteAsNewSelection(new CharacterPlate(cArray));
    }

    public void pasteAsNewSelection(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.pasteAsNewSelection(new CharacterPlate(string));
    }

    protected void toggleInsert() {
        boolean bl = !Tool.isInsert();
        this.lInsert.setText(bl ? "INS" : "OVR");
        this.plate.getCurrentTool().setInsert(bl);
        this.plate.repaintCursor();
    }

    public void toggleTextboxDialog() {
        this.gbTextbox.setLocked(!this.gbTextbox.isLocked());
        this.setTextboxDialogVisible(this.gbTextbox.isLocked());
    }

    protected void setTextboxDialogVisible(boolean bl) {
        if (bl) {
            if (this.textboxDialog == null) {
                this.textboxDialog = new TextboxDialog(this);
                GuiTools.centerOnScreen(this.textboxDialog);
            }
            this.textboxDialog.show();
        } else {
            this.textboxDialog.setVisible(false);
        }
    }

    public void toggleFigletDialog() {
        this.gbFiglet.setLocked(!this.gbFiglet.isLocked());
        this.setFigletDialogVisible(this.gbFiglet.isLocked());
    }

    protected void setFigletDialogVisible(boolean bl) {
        if (bl) {
            if (this.figletDialog == null) {
                this.figletDialog = new FigletDialog(this);
                GuiTools.centerOnScreen(this.figletDialog);
            }
            this.figletDialog.show();
        } else {
            this.figletDialog.setVisible(false);
        }
    }

    public void toggleClipartDialog() {
        this.gbClipartDialog.setLocked(!this.gbClipartDialog.isLocked());
        this.setClipartDialogVisible(this.gbClipartDialog.isLocked());
    }

    protected void setClipartDialogVisible(boolean bl) {
        if (bl) {
            if (this.clipartDialog == null) {
                this.clipartDialog = new ClipartDialog(this);
                GuiTools.centerOnScreen(this.clipartDialog);
            }
            this.clipartDialog.show();
        } else {
            this.clipartDialog.setVisible(false);
        }
    }

    public void toggleFormulaDialog() {
        this.gbFormula.setLocked(!this.gbFormula.isLocked());
        this.setFormulaDialogVisible(this.gbFormula.isLocked());
    }

    protected void setFormulaDialogVisible(boolean bl) {
        if (bl) {
            if (this.formulaEditor == null) {
                new GDialog((Frame)this, "Mathematical Expression Editor", "This is only a test version", "For the syntax have a look at the documentation\ncontained in the 'docs' folder.", 3).show();
                this.formulaEditor = new FormulaEditor(this);
                GuiTools.centerOnScreen(this.formulaEditor);
            }
            this.formulaEditor.show();
        } else {
            this.formulaEditor.setVisible(false);
        }
    }

    public void toggleImage2AsciiDialog() {
        this.gbImage2Ascii.setLocked(!this.gbImage2Ascii.isLocked());
        this.setImage2AsciiDialogVisible(this.gbImage2Ascii.isLocked());
    }

    protected void setImage2AsciiDialogVisible(boolean bl) {
        if (bl) {
            if (this.image2AsciiDialog == null) {
                this.image2AsciiDialog = new Image2AsciiDialog(this);
                this.image2AsciiDialog.pack();
                GuiTools.centerOnScreen(this.image2AsciiDialog);
            }
            this.image2AsciiDialog.show();
        } else {
            this.image2AsciiDialog.setVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        char c = this.cfChar1.getChar();
        char c2 = this.cfChar2.getChar();
        this.cfChar1.setChar(c2);
        this.cfChar2.setChar(c);
        this.plate.setMouseChar1(c2);
        this.plate.setMouseChar2(c);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray != null && stringArray.length > 0 && ((CommandLineJave)(object = new CommandLineJave(stringArray))).doIt()) {
            System.exit(0);
            return;
        }
        object = new JaveStartSplashFrame();
        ((Window)object).show();
        ((JaveStartSplashFrame)object).start();
    }
}

