/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.FillAlgorithm;
import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class EllipseToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;
    protected Checkbox cbFill;

    public EllipseToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Ellipse Generic";
    }

    public String getIconName() {
        return "ellipse_generic";
    }

    public Component getAdditionalOptionsComponent() {
        if (this.cbFill != null) {
            return this.cbFill;
        }
        this.cbFill = new Checkbox("Fill", false);
        return this.cbFill;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.markPlate == null || this.point1 == null || this.point2 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawOval(this.point1.x - 1, this.point1.y - 1, 2, 2);
        Point point = Tool.getQuadraticPointFor(this.point1, this.point2, Tool.shiftDown);
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(point);
        double d = point2d2.x - point2d.x;
        double d2 = point2d2.y - point2d.y;
        this.markPlate.clear();
        d = d < 0.0 ? -d : d;
        d2 = d2 < 0.0 ? -d2 : d2;
        boolean bl = this.cbFill.getState();
        this.markPlate.clear();
        if (bl && !this.isLineMode()) {
            this.markPlate.fillEllipse(point2d.x, point2d.y, d, d2);
        } else {
            this.markPlate.drawEllipse(point2d.x, point2d.y, d, d2);
        }
        this.markPlate.convert();
        if (bl && this.isLineMode() && d >= 1.0 && d2 >= 1.0) {
            FillAlgorithm.fillSolid(this.markPlate.plate, (int)point2d.x - this.markPlate.getOriginX(), (int)point2d.y - this.markPlate.getOriginY(), '\u00a0', 0);
        }
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.getMixMode());
        this.markPlate.pasteResultInto(this.plate.getContent());
        this.point1 = null;
        this.point2 = null;
        this.markPlate = null;
        this.saveCurrentState("draw ellipse");
        this.repaintAll();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null || this.markPlate == null) {
            return;
        }
        if (point.equals(this.point2)) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.markPlate == null) {
            return;
        }
        if (n == 27 && this.markPlate != null) {
            this.markPlate = null;
            this.point1 = null;
            this.point2 = null;
            this.repaintCursor();
        }
    }
}

