/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.CharField;
import de.jave.jave.AbstractPencilTool;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class BrushTool
extends AbstractPencilTool
implements TextListener {
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;
    protected Panel brushPanel;
    protected CharField[] brushCharFields;
    protected int brushHeight = 4;
    protected int brushWidth = 4;
    protected static final char[][] DEFAULT_BRUSH = new char[][]{{' ', '_', '_', ' '}, {'d', '8', '8', 'b'}, {'Y', '8', '8', 'P'}, {' ', ' ', ' ', ' '}};

    public BrushTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Brush";
    }

    public String getIconName() {
        return "brush";
    }

    protected String getUndoRedoActionName() {
        return "brush";
    }

    public Component createOptionsComponent() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.brushPanel = new Panel();
        this.setBrush(DEFAULT_BRUSH);
        panel.add((Component)this.brushPanel, "Center");
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        panel.add((Component)this.cbMix, "South");
        return panel;
    }

    protected void paint(int n, int n2) {
        int n3 = this.brush.length;
        int n4 = this.brush[0].length;
        int n5 = (n4 - 1) / 2;
        int n6 = (n3 - 1) / 2;
        if (this.isMouseRightButton()) {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    char c = this.brush[n8][n7];
                    if (c != ' ') {
                        this.plate.setCharForce(n - n5 + n7, n2 - n6 + n8, ' ');
                    }
                    ++n8;
                }
                ++n7;
            }
        } else {
            this.setMixMode(this.cbMix.getState());
            int n9 = 0;
            while (n9 < n4) {
                int n10 = 0;
                while (n10 < n3) {
                    char c = this.brush[n10][n9];
                    if (c == '\u00a0') {
                        this.plate.setCharForce(n - n5 + n9, n2 - n6 + n10, ' ');
                    } else if (c != ' ') {
                        this.plate.setChar(n - n5 + n9, n2 - n6 + n10, c);
                    }
                    ++n10;
                }
                ++n9;
            }
        }
        this.plate.repaint(50L);
    }

    public void setBrush(CharacterPlate characterPlate) {
        this.setBrush(characterPlate.getContent());
    }

    public void setBrush(char[][] cArray) {
        this.brush = cArray;
        this.brushHeight = cArray.length;
        this.brushWidth = cArray[0].length;
        this.brushPanel.removeAll();
        this.brushPanel.setLayout(new GridLayout(0, this.brushWidth, 0, 0));
        this.brushCharFields = new CharField[this.brushWidth * this.brushHeight];
        int n = 0;
        int n2 = 0;
        while (n2 < this.brushHeight) {
            int n3 = 0;
            while (n3 < this.brushWidth) {
                this.brushCharFields[n] = new CharField(cArray[n2][n3]);
                this.brushCharFields[n].addTextListener(this);
                this.brushCharFields[n].setFont(JaveGlobalRessources.FONT_DEFAULT);
                this.brushPanel.add(this.brushCharFields[n++]);
                ++n3;
            }
            ++n2;
        }
        this.brushPanel.validate();
        this.packOptionsDialog();
        this.repaintCursor();
    }

    public char[][] getBrush() {
        char[][] cArray = new char[this.brushHeight][this.brushWidth];
        int n = 0;
        int n2 = 0;
        while (n2 < this.brushHeight) {
            int n3 = 0;
            while (n3 < this.brushWidth) {
                cArray[n2][n3] = this.brushCharFields[n++].getChar();
                ++n3;
            }
            ++n2;
        }
        return cArray;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.brush = this.getBrush();
        this.repaintCursor();
    }
}

