/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GScrollPanel;
import de.jave.gui.GScrollable;
import de.jave.jave.ImageDia;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class AsciiThumbnailPanel
extends Canvas
implements MouseListener,
GScrollable {
    protected Vector thumbnails = new Vector();
    protected GScrollPanel scrollPanel;
    protected static final Dimension thumbnailSize = new Dimension(110, 120);
    protected String status;
    protected String[] statusLines;

    public AsciiThumbnailPanel() {
        this.addMouseListener(this);
    }

    public void scrollPositionChanged(GScrollPanel gScrollPanel) {
        this.repaint();
    }

    public void setScrollPanel(GScrollPanel gScrollPanel) {
        this.scrollPanel = gScrollPanel;
        gScrollPanel.setVerticalIncrement(AsciiThumbnailPanel.thumbnailSize.width);
        gScrollPanel.setHorizontalIncrement(AsciiThumbnailPanel.thumbnailSize.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        int n = this.thumbnails.size();
        int n2 = AsciiThumbnailPanel.thumbnailSize.width + 2;
        int n3 = AsciiThumbnailPanel.thumbnailSize.height + 2;
        int n4 = dimension.width / n2;
        if (n4 <= 0) {
            n4 = 1;
        }
        int n5 = (int)Math.ceil((double)this.thumbnails.size() / (double)n4);
        int n6 = n2 * n4;
        int n7 = n3 * n5;
        int n8 = this.getFontMetrics(this.getFont()).getHeight();
        if (this.status != null) {
            n7 += n8 + 2;
        }
        if (this.statusLines != null) {
            n7 += n8 * this.statusLines.length;
        }
        if (n6 < 300) {
            n6 = 300;
        }
        if (n7 < 300) {
            n7 = 300;
        }
        return new Dimension(n6, n7);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setStatus(String string) {
        this.status = string;
        this.scrollPanel.doLayout();
        this.repaint();
    }

    public void setStatusLines(String[] stringArray) {
        this.statusLines = stringArray;
        this.scrollPanel.doLayout();
        this.repaint();
    }

    public void setStatusLines(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        this.setStatusLines(stringArray);
    }

    public void setThumbNails(Vector vector) {
        this.thumbnails = vector;
        this.validate();
        this.scrollPanel.doLayout();
        this.repaint();
    }

    public void removeAll() {
        this.thumbnails.removeAllElements();
        this.validate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        int n2 = this.thumbnails.size();
        int n3 = AsciiThumbnailPanel.thumbnailSize.width + 2;
        int n4 = AsciiThumbnailPanel.thumbnailSize.height + 2;
        int n5 = dimension.width / n3;
        if (n5 <= 0) {
            n5 = 1;
        }
        int n6 = (int)Math.ceil((double)this.thumbnails.size() / (double)n5);
        Point point = this.scrollPanel.getScrollLocation();
        int n7 = point.y;
        int n8 = this.getFontMetrics(this.getFont()).getHeight();
        int n9 = (n6 - n7) * n4;
        if (this.statusLines != null) {
            n = 0;
            while (n < this.statusLines.length) {
                graphics.drawString(this.statusLines[n], 2, n9 + n8);
                n9 += n8;
                ++n;
            }
        }
        if (this.status != null) {
            graphics.drawLine(2, n9 + 4, 200, n9 + 4);
            graphics.drawString(this.status, 2, n9 + n8 + 2);
            n9 += n8;
        }
        if (n2 == 0) {
            return;
        }
        n = 0;
        int n10 = 0;
        n10 = n7 * n5;
        while (n10 < n2 && n < dimension.height) {
            ImageDia imageDia = (ImageDia)this.thumbnails.elementAt(n10);
            imageDia.setSize(thumbnailSize);
            imageDia.paint(graphics, this);
            graphics.translate(n3, 0);
            if ((n10 + 1) % n5 == 0) {
                graphics.translate(-n3 * n5, n4);
                n += n4;
            }
            ++n10;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = AsciiThumbnailPanel.thumbnailSize.width + 2;
        int n4 = AsciiThumbnailPanel.thumbnailSize.height + 2;
        int n5 = this.getSize().width / n3;
        if (n5 <= 0) {
            n5 = 1;
        }
        if (n < 0 || n > n5 * n3) {
            return;
        }
        int n6 = n2 / n4;
        int n7 = n / n3;
        Point point = this.scrollPanel.getScrollLocation();
        int n8 = point.y;
        int n9 = (n6 += n8) * n5 + n7;
        if (n9 >= this.thumbnails.size()) {
            return;
        }
        ((ImageDia)this.thumbnails.elementAt(n9)).mouseClicked(mouseEvent);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

