/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GProgressDialog;
import de.jave.gui.GScrollPanel;
import de.jave.gui.GTree;
import de.jave.gui.GTreeEntry;
import de.jave.gui.Gap;
import de.jave.jave.AsciiThumbnailPanel;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.ImageDia;
import de.jave.jave.ImageDiaMovie;
import de.jave.jave.Jave;
import de.jave.util.CancelAble;
import de.jave.util.Toolbox;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

public class AsciiThumbnailBrowser
extends Dialog
implements ItemListener,
WindowListener,
ActionListener,
Runnable,
CancelAble {
    protected static final String TITLE = "JavE Thumbnail Browser";
    protected Choice chDrive;
    protected GTree tree;
    protected AsciiThumbnailPanel thumbnailPanel2;
    protected static final int DEFAULT_WIDTH = 600;
    protected static final int DEFAULT_HEIGHT = 400;
    protected Button bClose;
    protected Button bOpen;
    protected Button bRefresh;
    protected Button bPath;
    protected Jave asciiPainter;
    protected Frame parent;
    protected Vector thumbNails;
    protected Thread loadThread;
    protected File currentDir;
    protected boolean shallStop;
    protected GProgressDialog progressDialog;

    public AsciiThumbnailBrowser(Frame frame) {
        super(frame, TITLE);
        this.parent = frame;
        if (frame instanceof Jave) {
            this.asciiPainter = (Jave)frame;
        }
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(2, 2));
        Panel panel = this.createDirectoryPanel();
        this.add((Component)panel, "West");
        this.thumbnailPanel2 = new AsciiThumbnailPanel();
        GScrollPanel gScrollPanel = new GScrollPanel(this.thumbnailPanel2);
        this.thumbnailPanel2.setScrollPanel(gScrollPanel);
        this.bClose = new Button("Close Browser");
        this.bClose.addActionListener(this);
        this.bOpen = new Button("Open selected File(s)");
        this.bOpen.addActionListener(this);
        this.bPath = new Button("Path...");
        this.bPath.addActionListener(this);
        this.bRefresh = new Button("Refresh thumbnails");
        this.bRefresh.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.add(this.bPath);
        panel2.add(new Gap());
        panel2.add(this.bRefresh);
        panel2.add(this.bOpen);
        panel2.add(this.bClose);
        this.add((Component)gScrollPanel, "Center");
        this.add((Component)panel2, "South");
        this.setDrive(this.chDrive.getSelectedItem());
        this.setDirectory(new File(this.chDrive.getSelectedItem()));
        this.pack();
        this.setSize(600, 400);
    }

    public void run() {
        this.shallStop = false;
        Thread.currentThread().setPriority(2);
        Thread.currentThread();
        Thread.yield();
        if (this.thumbNails == null) {
            this.thumbNails = new Vector();
        } else {
            this.thumbNails.removeAllElements();
        }
        this.thumbnailPanel2.removeAll();
        this.thumbnailPanel2.setStatus("loading...");
        this.thumbnailPanel2.setStatusLines((String[])null);
        Thread.currentThread();
        Thread.yield();
        String[] stringArray = this.currentDir.list();
        Toolbox.quickSortIgnoreCase(stringArray);
        Thread.currentThread();
        Thread.yield();
        int n = 0;
        Vector<String> vector = new Vector<String>(stringArray.length);
        n = 0;
        while (n < stringArray.length && !this.shallStop) {
            File file = new File(this.currentDir, stringArray[n]);
            if (file.exists() && !file.isDirectory()) {
                ImageDia imageDia;
                Image image;
                Dimension dimension;
                int[] nArray;
                if (file.canRead() && stringArray[n].toLowerCase().endsWith(".txt")) {
                    try {
                        nArray = new int[2];
                        dimension = ImageDia.getPreferredImageSize();
                        image = this.createImage(AsciiToThumbnailConverter.convertFile(file, dimension.width, dimension.height, nArray, false));
                        imageDia = new ImageDia(image, file, stringArray[n], nArray[0], nArray[1]);
                        imageDia.addActionListener(this);
                        this.thumbNails.addElement(imageDia);
                    }
                    catch (Exception exception) {
                        System.err.println("Error reading file '" + file.getAbsolutePath() + "': " + exception);
                    }
                } else if (file.canRead() && stringArray[n].toLowerCase().endsWith(".jmov")) {
                    try {
                        nArray = new int[2];
                        dimension = ImageDia.getPreferredImageSize();
                        image = this.createImage(AsciiToThumbnailConverter.convertMovieFile(file, dimension.width, dimension.height, nArray));
                        imageDia = new ImageDiaMovie(image, file, stringArray[n], nArray[0], nArray[1]);
                        imageDia.addActionListener(this);
                        this.thumbNails.addElement(imageDia);
                    }
                    catch (Exception exception) {
                        System.err.println("Error reading file '" + file.getAbsolutePath() + "': " + exception);
                    }
                } else {
                    vector.addElement(stringArray[n]);
                }
                Thread.currentThread();
                Thread.yield();
                this.progressDialog.toFront();
                this.progressDialog.setProgress((double)n / (double)stringArray.length);
                Thread.currentThread();
                Thread.yield();
            }
            ++n;
        }
        this.thumbnailPanel2.setThumbNails(this.thumbNails);
        if (stringArray.length == 0) {
            this.thumbnailPanel2.setStatus("Folder is empty.");
        } else if (n < stringArray.length) {
            this.thumbnailPanel2.setStatus("* loading was canceled - click refresh to see all thumbnails *");
        } else {
            this.thumbnailPanel2.setStatus(this.thumbNails.size() + " files displayed as thumbnail.");
            this.thumbnailPanel2.setStatusLines(vector);
        }
        this.progressDialog.dispose();
    }

    public Panel createDirectoryPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        String[] stringArray = AsciiThumbnailBrowser.getSystemDrives();
        this.chDrive = new Choice();
        int n = 0;
        while (n < stringArray.length) {
            this.chDrive.add(stringArray[n]);
            ++n;
        }
        panel.add((Component)this.chDrive, "South");
        this.chDrive.addItemListener(this);
        GTreeEntry gTreeEntry = new GTreeEntry("Drives:", -1);
        this.tree = new GTree(gTreeEntry);
        this.tree.setLabelsEditable(false);
        this.tree.addItemListener(this);
        panel.add((Component)this.tree, "West");
        return panel;
    }

    public void setDrive(String string) {
        GTreeEntry gTreeEntry = new GTreeEntry(string, new File(string), 2);
        this.navigate(gTreeEntry, new File(string), 3);
        this.tree.setRoot(gTreeEntry);
    }

    public void navigate(GTreeEntry gTreeEntry, File file, int n) {
        if (!(file.exists() && file.isDirectory() && file.canRead())) {
            return;
        }
        if (--n == 0) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        Toolbox.quickSortIgnoreCase(stringArray);
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory() && file2.exists() && file2.canRead()) {
                GTreeEntry gTreeEntry2 = new GTreeEntry(stringArray[n2], file2, 0);
                gTreeEntry.add(gTreeEntry2);
                this.navigate(gTreeEntry2, file2, n);
            }
            ++n2;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chDrive) {
            this.setDrive(this.chDrive.getSelectedItem());
        } else if (itemEvent.getSource() == this.tree) {
            GTreeEntry gTreeEntry = this.tree.getSelectedEntry();
            this.setDirectory((File)gTreeEntry.getUserObject());
            this.tree.removeAll(gTreeEntry);
            this.navigate(gTreeEntry, (File)gTreeEntry.getUserObject(), 3);
            this.tree.repaintAll();
        }
    }

    public void setDirectory(File file) {
        this.setTitle("JavE Thumbnail Browser - " + file.getAbsolutePath());
        this.currentDir = file;
        if (this.loadThread != null) {
            this.loadThread = null;
        }
        this.progressDialog = new GProgressDialog((Frame)this.asciiPainter, "JavE", "Reading directory... Please wait.", true);
        this.progressDialog.addCancelListener(this);
        this.loadThread = new Thread(this);
        this.loadThread.start();
        this.progressDialog.show();
    }

    public void doCancel() {
        this.shallStop = true;
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void doPath() {
        Panel panel = new Panel();
        panel.add(new Label("Path:", 2));
        TextField textField = new TextField(30);
        panel.add(textField);
        GDialog gDialog = new GDialog(this.parent, "JavE Browser", (Component)panel, GDialog.OK_CANCEL);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == -1 || n == 1) {
            return;
        }
        String string = textField.getText();
        if (string == null || string.trim().length() == 0) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            String string2 = "The directory\n\t'" + file.getAbsolutePath() + "'\n" + "does not exist.";
            new GErrorDialog(this.parent, "JavE", string2).show();
            return;
        }
        if (!file.canRead()) {
            String string3 = "The directory\n\t'" + file.getAbsolutePath() + "'\n" + "can not be read.";
            new GErrorDialog(this.parent, "JavE", string3).show();
            return;
        }
        boolean bl = false;
        int n2 = this.chDrive.getItemCount() - 1;
        while (n2 >= 0) {
            if (this.chDrive.getItem(n2).equals(string)) {
                bl = true;
                break;
            }
            --n2;
        }
        if (!bl) {
            this.chDrive.addItem(string);
        }
        this.chDrive.select(string);
        this.setDrive(string);
        this.setDirectory(file);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GTreeEntry gTreeEntry;
        Object object = actionEvent.getSource();
        if (object instanceof ImageDia) {
            File file = ((ImageDia)object).getFile();
            String string = file.getParent();
            String string2 = file.getName();
            if (this.asciiPainter != null) {
                this.asciiPainter.open(string, string2);
                this.asciiPainter.toFront();
            }
            this.doClose();
            return;
        }
        if (object == this.bClose) {
            this.doClose();
            return;
        }
        if (object == this.bOpen) {
            if (this.asciiPainter == null || this.thumbNails == null) {
                return;
            }
            int n = 0;
            while (n < this.thumbNails.size()) {
                ImageDia imageDia = (ImageDia)this.thumbNails.elementAt(n);
                if (imageDia.isSelected()) {
                    File file = imageDia.getFile();
                    String string = file.getParent();
                    String string3 = file.getName();
                    this.asciiPainter.open(string, string3);
                }
                ++n;
            }
            this.asciiPainter.toFront();
            return;
        }
        if (object == this.bPath) {
            this.doPath();
            return;
        }
        if (object == this.bRefresh && (gTreeEntry = this.tree.getSelectedEntry()) != null) {
            this.setDirectory((File)gTreeEntry.getUserObject());
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.pack();
        frame.show();
        AsciiThumbnailBrowser asciiThumbnailBrowser = new AsciiThumbnailBrowser(frame);
        asciiThumbnailBrowser.show();
    }

    public static String[] getSystemDrives() {
        Object object;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = new String[]{"E:\\", "D:\\", "C:\\", "B:\\", "F:\\", "G:\\", "H:\\", "I:\\", "J:\\", "K:\\", "L:\\", "M:\\", "N:\\", "O:\\", "P:\\", "Q:\\", "R:\\", "S:\\", "T:\\", "U:\\", "V:\\", "W:\\", "X:\\", "Y:\\", "Z:\\", "/home", "/usr", "/root", "/bin", "/var", "/etc", "/dev", "/lib", "/mnt", "/proc", "/bin"};
        int n = 0;
        while (n < stringArray.length) {
            object = new File(stringArray[n]);
            if (((File)object).exists()) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        object = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            object[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return object;
    }
}

